/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.op;

import gnu.getopt.Getopt;
import java.beans.PropertyEditor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.mobicents.tools.twiddle.AbstractSleeCommand;

public abstract class AbstractOperation {
    public static final String CID_SEPARATOR = ";";
    protected Object operationResult;
    protected AbstractSleeCommand sleeCommand;
    protected String operationName;
    protected ArrayList<Object> opArguments = new ArrayList();
    protected ArrayList<String> opSignature = new ArrayList();
    protected CommandContext context;
    protected Logger log;

    protected AbstractOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
        this.context = context;
        this.log = log;
        this.sleeCommand = sleeCommand;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ArrayList<Object> getOpArguments() {
        return this.opArguments;
    }

    public ArrayList<String> getOpSignature() {
        return this.opSignature;
    }

    public abstract void buildOperation(Getopt var1, String[] var2) throws CommandException;

    public void displayResult() {
        if (!this.context.isQuiet()) {
            String resultText = this.prepareResultText();
            PrintWriter out = this.context.getWriter();
            out.println(resultText);
            out.flush();
        }
    }

    protected String prepareResultText() {
        String resultText = null;
        if (this.operationResult != null) {
            try {
                if (this.operationResult instanceof Collection) {
                    Object[] arrayO;
                    Collection c = (Collection)this.operationResult;
                    this.operationResult = arrayO = c.toArray();
                }
                if (this.operationResult.getClass().isArray()) {
                    if (!this.operationResult.getClass().getComponentType().isPrimitive()) {
                        Object resultArray = (Object[])this.operationResult;
                        Class<?> memberClass = resultArray.getClass().getComponentType();
                        PropertyEditor editor = PropertyEditors.getEditor(memberClass);
                        resultText = this.unfoldArray("", (Object[])resultArray, editor);
                    } else {
                        switch (this.operationResult.getClass().getComponentType().getCanonicalName()) {
                            case "byte": {
                                resultText = Arrays.toString((byte[])this.operationResult);
                                break;
                            }
                            case "short": {
                                resultText = Arrays.toString((short[])this.operationResult);
                                break;
                            }
                            case "int": {
                                resultText = Arrays.toString((int[])this.operationResult);
                                break;
                            }
                            case "long": {
                                resultText = Arrays.toString((long[])this.operationResult);
                                break;
                            }
                            case "float": {
                                resultText = Arrays.toString((float[])this.operationResult);
                                break;
                            }
                            case "double": {
                                resultText = Arrays.toString((double[])this.operationResult);
                                break;
                            }
                            case "boolean": {
                                resultText = Arrays.toString((boolean[])this.operationResult);
                                break;
                            }
                            case "char": {
                                resultText = Arrays.toString((char[])this.operationResult);
                                break;
                            }
                            default: {
                                resultText = "'failed'";
                                break;
                            }
                        }
                    }
                } else {
                    PropertyEditor editor = PropertyEditors.getEditor(this.operationResult.getClass());
                    editor.setValue(this.operationResult);
                    resultText = editor.getAsText();
                }
            }
            catch (RuntimeException e) {
                this.log.debug((Object)"No editor found: ", (Throwable)e);
                if (this.operationResult.getClass().isArray()) {
                    Object[] arrayResult = (Object[])this.operationResult;
                    resultText = this.unfoldArray("", arrayResult, null);
                }
                resultText = this.operationResult.toString();
            }
            this.log.debug((Object)("Converted result: " + resultText));
        } else {
            resultText = "'success'";
        }
        return resultText;
    }

    protected String unfoldArray(String prefix, Object[] array, PropertyEditor editor) {
        StringBuffer sb = new StringBuffer("[");
        for (int index = 0; index < array.length; ++index) {
            if (editor != null) {
                editor.setValue(array[index]);
                sb.append(editor.getAsText());
            } else {
                sb.append(array[index].toString());
            }
            if (index >= array.length - 1) continue;
            sb.append(CID_SEPARATOR);
        }
        sb.append("]");
        return sb.toString();
    }

    protected void addArg(Object arg, Class<? extends Object> argClass, boolean usPE) throws CommandException {
        if (usPE) {
            PropertyEditor pe = PropertyEditors.getEditor(argClass);
            if (pe == null) {
                throw new CommandException("There is no property editor for: " + argClass);
            }
            pe.setAsText((String)arg);
            this.opArguments.add(pe.getValue());
        } else {
            this.opArguments.add(arg);
        }
        this.opSignature.add(argClass.getName());
    }

    protected void addArg(Object arg, String argClass, boolean usPE) throws CommandException {
        if (usPE) {
            try {
                PropertyEditor pe = PropertyEditors.getEditor((String)argClass);
                if (pe == null) {
                    throw new CommandException("There is no property editor for: " + argClass);
                }
                if (arg != null) {
                    pe.setAsText((String)arg);
                    this.opArguments.add(pe.getValue());
                }
                this.opArguments.add(null);
            }
            catch (ClassNotFoundException cnfe) {
                throw new CommandException("Failed to locate class.", (Throwable)cnfe);
            }
        } else {
            this.opArguments.add(arg);
        }
        this.opSignature.add(argClass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke() throws CommandException {
        try {
            ObjectName on = this.sleeCommand.getBeanOName();
            MBeanServerConnection conn = this.context.getServer();
            Object[] parms = this.getOpArguments().toArray();
            String[] sig = new String[this.getOpSignature().size()];
            sig = this.getOpSignature().toArray(sig);
            MBeanInfo mbeanInfo = conn.getMBeanInfo(on);
            if (this.isOperation(mbeanInfo, this.operationName)) {
                this.operationResult = conn.invoke(on, this.operationName, parms, sig);
            } else if (this.operationName.substring(0, 3).equals("set")) {
                String attributeName = this.operationName.substring(3);
                if (!this.isAttribute(mbeanInfo, attributeName)) throw new CommandException("Failed to invoke \"" + this.operationName + "\"." + " Attribute \"" + attributeName + "\" is not existing.");
                Attribute attr = new Attribute(attributeName, this.opArguments.get(0));
                conn.setAttribute(on, attr);
                this.operationResult = null;
            } else {
                if (!this.operationName.substring(0, 3).equals("get")) throw new CommandException("Failed to invoke \"" + this.operationName + "\"." + " It is not MBean operation or attribute.");
                String attributeName = this.operationName.substring(3);
                if (!this.isAttribute(mbeanInfo, attributeName)) throw new CommandException("Failed to invoke \"" + this.operationName + "\"." + " Attribute \"" + attributeName + "\" is not existing.");
                this.operationResult = conn.getAttribute(on, this.operationName.substring(3));
            }
            this.displayResult();
            return;
        }
        catch (Exception e) {
            throw new CommandException("Failed to invoke \"" + this.operationName + "\" due to: ", (Throwable)e);
        }
    }

    private boolean isAttribute(MBeanInfo mbeanInfo, String attrName) {
        for (MBeanAttributeInfo attrInfo : mbeanInfo.getAttributes()) {
            if (!attrInfo.getName().equals(attrName)) continue;
            return true;
        }
        return false;
    }

    private boolean isOperation(MBeanInfo mbeanInfo, String operName) {
        for (MBeanOperationInfo operInfo : mbeanInfo.getOperations()) {
            if (!operInfo.getName().equals(operName)) continue;
            return true;
        }
        return false;
    }
}

