/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.ServiceID;
import javax.slee.management.DeployableUnitID;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class DeployCommand
extends AbstractSleeCommand {
    public DeployCommand() {
        super("deploy", "This command performs operations on JSLEE DeploymentMBean.");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -l, --list                     Lists deployed components based on passed option:");
        out.println("            --sbbs                 Lists sbbs, if ServiceID is present as argument,");
        out.println("                                   sbbs are listed for given service.");
        out.println("            --services             Lists services, does not take argument.");
        out.println("            --libraries            Lists libraries, does not take argument.");
        out.println("            --events               Lists event types, does not take argument.");
        out.println("            --ra-types             Lists RA types, does not take argument.");
        out.println("            --ras                  Lists RAs, does not take argument.");
        out.println("            --dus                  Lists DUs, does not take argument.");
        out.println("            --profile-spec         Lists profile specifications, does not take argument.");
        out.println("    -y, --installed                Checks if SLEE component is installed. It accepts following options:");
        out.println("            --duid                 Indicates check based on DeployableUnit ID. ");
        out.println("                                   It expects DeployableUnit ID as argument. It excludes \"--cid\".");
        out.println("            --cid                  Indicates check based on Component ID. ");
        out.println("                                   It expects Component ID as argument. It excludes \"--duid\".");
        out.println("    -i, --install                  Install DU which is identified by given path. ");
        out.println("                                   It expects path as argument.");
        out.println("    -u, --un-install               Un-install DU which is identified by given DeployableUnit ID. ");
        out.println("                                   It expects DeployableUnit ID as argument.");
        out.println("    -d, --desc                     Fetches descriptors for given SLEE component. It supports following options:");
        out.println("            --duid                 Operation fetches descriptors based on DeployableUnit ID passed as arg. Accepts array argument.");
        out.println("                                   It expects DeployableUnit ID(single or array) as argument.");
        out.println("            --cid                  Operation fetches descriptors based on Component ID passed as arg.");
        out.println("    -r, --ref                      Fetches IDs of referring components. Expects ComponentID as argument. Accepts array argument.");
        out.println("arg:");
        out.println("");
        out.println("    ComponentID:             Is any valid component id, for instance ServiceID[name=xxx,vendor=uuu,version=123.0.00]");
        out.println("    ComponentID Array:       ServiceID[name=xxx,vendor=uuu,version=123.0.00];ServiceID[name=xxx,vendor=uuu,version=123.0.00]");
        out.println("");
        out.println("Examples: ");
        out.println("");
        out.println("     1. List all installed SBBs:");
        out.println("" + this.name + " -l --sbbs");
        out.println("");
        out.println("     2. List intalled SBBs that are part of specific service:");
        out.println("" + this.name + " -l --sbbs=ServiceID[name=xxx,vendor=uuu,version=123.0.00]");
        out.println("");
        out.println("     3. Get DeployableUnitID based on deploy path:");
        out.println("" + this.name + " -d/core/dev/container/deploy/xxx/ServiceDU.jar-1351q616/");
        out.println("");
        out.println("     4. List all referencing components:");
        out.println("" + this.name + " -rProfileSpecificationID[name=ResourceInfoProfileSpec,vendor=javax.slee,version=1.0]");
        out.println("");
        out.println("     5. ");
        out.println("" + this.name + " --install=g:/workspace/jslee/resource/SecretLab-DU.jar");
        out.println("");
        out.println("     6. Get descriptors of components:");
        out.println("" + this.name + " -s --cid=ProfileSpecificationID[name=ResourceInfoProfileSpec,vendor=javax.slee,version=1.0];SbbID[name=SipRegistrarSbb,vendor=org.mobicents,version=1.2]");
        out.flush();
    }

    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":lyi:u:dr:";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("list", 0, null, 108), new LongOpt("sbbs", 2, null, 113), new LongOpt("services", 0, null, 99), new LongOpt("libraries", 0, null, 116), new LongOpt("events", 0, null, 97), new LongOpt("ra-types", 0, null, 119), new LongOpt("ras", 0, null, 101), new LongOpt("dus", 0, null, 104), new LongOpt("profile-spec", 0, null, 103), new LongOpt("installed", 0, null, 121), new LongOpt("cid", 1, null, 109), new LongOpt("duid", 1, null, 110), new LongOpt("install", 1, null, 105), new LongOpt("un-install", 1, null, 117), new LongOpt("desc", 0, null, 100), new LongOpt("ref", 1, null, 114)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block10: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 108: {
                    this.operation = new ListOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 121: {
                    this.operation = new IsInstalledOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 105: {
                    this.operation = new InstallOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 117: {
                    this.operation = new UninstallOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 100: {
                    this.operation = new GetDescriptorsOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 114: {
                    this.operation = new GetReferringComponentsOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("javax.slee.management:name=Deployment");
    }

    private class ListOperation
    extends AbstractOperation {
        public static final char sbbs = 'q';
        public static final char ra_types = 'w';
        public static final char ras = 'e';
        public static final char services = 'c';
        public static final char libraries = 't';
        public static final char events = 'a';
        public static final char dus = 'h';
        public static final char profile_specs = 'g';
        private static final String OPERATION_getSbbs = "getSbbs";
        private static final String OPERATION_getResourceAdaptorTypes = "getResourceAdaptorTypes";
        private static final String OPERATION_getResourceAdaptors = "getResourceAdaptors";
        private static final String OPERATION_getServices = "getServices";
        private static final String OPERATION_getLibraries = "getLibraries";
        private static final String OPERATION_getEventTypes = "getEventTypes";
        private static final String OPERATION_getDeployableUnits = "getDeployableUnits";
        private static final String OPERATION_getProfileSpecifications = "getProfileSpecifications";
        private String stringServiceID;

        public ListOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block14: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 113: {
                        this.operationName = OPERATION_getSbbs;
                        this.stringServiceID = opts.getOptarg();
                        if (this.stringServiceID == null) continue block14;
                        try {
                            this.addArg((Object)this.stringServiceID, ServiceID.class, true);
                            continue block14;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse ServiceID: \"" + this.stringServiceID + "\"", (Throwable)e);
                        }
                    }
                    case 119: {
                        this.operationName = OPERATION_getResourceAdaptorTypes;
                        continue block14;
                    }
                    case 101: {
                        this.operationName = OPERATION_getResourceAdaptors;
                        continue block14;
                    }
                    case 99: {
                        this.operationName = OPERATION_getServices;
                        continue block14;
                    }
                    case 116: {
                        this.operationName = OPERATION_getLibraries;
                        continue block14;
                    }
                    case 97: {
                        this.operationName = OPERATION_getEventTypes;
                        continue block14;
                    }
                    case 104: {
                        this.operationName = OPERATION_getDeployableUnits;
                        continue block14;
                    }
                    case 103: {
                        this.operationName = OPERATION_getProfileSpecifications;
                        continue block14;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.operationName == null) {
                throw new CommandException(this.sleeCommand.getName() + " command requires option to be passed.");
            }
        }
    }

    private class IsInstalledOperation
    extends AbstractOperation {
        public static final char duid = 'n';
        public static final char cid = 'm';
        private static final String OPERATION_isInstalled = "isInstalled";
        private String stringDUID;
        private String stringCID;

        public IsInstalledOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_isInstalled;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block10: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 110: {
                        this.stringDUID = opts.getOptarg();
                        continue block10;
                    }
                    case 109: {
                        this.stringCID = opts.getOptarg();
                        continue block10;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringCID == null && this.stringDUID == null || this.stringDUID != null && this.stringCID != null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--duid\" or \"--cid\" to be present");
            }
            if (this.stringCID != null) {
                if (this.stringCID.contains(";")) {
                    throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
                }
                try {
                    this.addArg((Object)this.stringCID, ComponentID.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse ComponentID: \"" + this.stringCID + "\"", (Throwable)e);
                }
            }
            if (this.stringDUID.contains(";")) {
                throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
            }
            try {
                this.addArg((Object)this.stringDUID, DeployableUnitID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse DeployableUnitID: \"" + this.stringDUID + "\"", (Throwable)e);
            }
        }

        protected String prepareResultText() {
            Boolean b = (Boolean)this.operationResult;
            if (b.booleanValue()) {
                return "Is installed.";
            }
            return "Is not installed.";
        }
    }

    private class InstallOperation
    extends AbstractOperation {
        private static final String OPERATION_install = "install";

        public InstallOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_install;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            this.addArg((Object)opts.getOptarg(), String.class, false);
        }
    }

    private class UninstallOperation
    extends AbstractOperation {
        private static final String OPERATION_uninstall = "uninstall";

        public UninstallOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_uninstall;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
            }
            try {
                this.addArg((Object)optArg, DeployableUnitID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ComponentID: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class DeployableUnitIDOperation
    extends AbstractOperation {
        private static final String OPERATION_getDeployableUnit = "getDeployableUnit";

        public DeployableUnitIDOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getDeployableUnit;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            this.addArg((Object)opts.getOptarg(), String.class, false);
        }
    }

    private class GetDescriptorsOperation
    extends AbstractOperation {
        private static final String OPERATION_getDescriptors = "getDescriptors";
        private static final String OPERATION_getDescriptor = "getDescriptor";
        private String stringDUID;
        private String stringCID;

        public GetDescriptorsOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block10: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 110: {
                        this.stringDUID = opts.getOptarg();
                        continue block10;
                    }
                    case 109: {
                        this.stringCID = opts.getOptarg();
                        continue block10;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringCID == null && this.stringDUID == null || this.stringDUID != null && this.stringCID != null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--duid\" or \"--cid\" to be present");
            }
            if (this.stringCID != null) {
                this.operationName = this.stringCID.contains(";") ? OPERATION_getDescriptors : OPERATION_getDescriptor;
                try {
                    this.addArg((Object)this.stringCID, ComponentID.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse ComponentID: \"" + this.stringCID + "\"", (Throwable)e);
                }
            }
            this.operationName = this.stringDUID.contains(";") ? OPERATION_getDescriptors : OPERATION_getDescriptor;
            try {
                this.addArg((Object)this.stringDUID, DeployableUnitID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse DeployableUnitID: \"" + this.stringDUID + "\"", (Throwable)e);
            }
        }
    }

    private class GetReferringComponentsOperation
    extends AbstractOperation {
        public static final String OPERATION_getReferringComponents = "getReferringComponents";

        public GetReferringComponentsOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getReferringComponents;
        }

        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Array parameter is not supported by: " + args[opts.getOptind() - 1]);
            }
            try {
                this.addArg((Object)optArg, ComponentID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ComponentID: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }
}

