/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.ServiceID;
import javax.slee.management.ServiceState;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class ServiceCommand
extends AbstractSleeCommand {
    public ServiceCommand() {
        super("service", "This command performs operations on JSLEE ServiceManagementMBean.");
    }

    @Override
    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -a, --activate                 Activates service('s) with matching ServiceID.");
        out.println("                                   Accepts array argument.");
        out.println("    -d, --deactivate               Deactivates service('s) with matching ServiceID");
        out.println("                                   Accepts array argument.");
        out.println("    -c, --deactivate-and-activate  Deactivates and activates service('s) with matching ServiceID(s)");
        out.println("                                   Supports two sub options(mandatory):");
        out.println("                       --ta        Indicates services to be activated in this operation. Accepts array argument.");
        out.println("                       --td        Indicates services to be deactivated in this operation. Accepts array argument.");
        out.println("    -i, --services                 Returns list of services in given state");
        out.println("                                   Requires ServiceState as argument.");
        out.println("    -o, --state                    Returns state of service");
        out.println("                                   Requires ServiceID as argument. Does not accept array argument.");
        out.println();
        out.println("arg:");
        out.println("");
        out.println("    ServiceID:             ServiceID[name=xxx,vendor=uuu,version=123.0.00]");
        out.println("    ServiceID Array:       ServiceID[name=xxx,vendor=uuu,version=123.0.00];ServiceID[name=xxx,vendor=uuu,version=123.0.00]");
        out.println("    ServiceState:          [Active|Inactive|Stopping]  ");
        out.println("");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Activate two services:");
        out.println("" + this.name + " -aServiceID[name=xxx,vendor=uuu,version=123.0.00];ServiceID[name=YYY,vendor=uuu,version=123.0.00]");
        out.println("");
        out.println("     2. Deactivate and activate services:");
        out.println("" + this.name + " -c --td=ServiceID[name=xxx,vendor=uuu,version=123.0.00];ServiceID[name=YYY,vendor=uuu,version=123.0.00] --taServiceID[name=xxx,vendor=uuu,version=123.0.00];ServiceID[name=YYY,vendor=uuu,version=123.0.00]");
        out.println("");
        out.println("     3. Check which services are inactive:");
        out.println("" + this.name + " -iInactive");
        out.flush();
    }

    @Override
    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("javax.slee.management:name=ServiceManagement");
    }

    @Override
    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":a:d:i:o:c";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("activate", 1, null, 97), new LongOpt("deactivate", 1, null, 100), new LongOpt("services", 1, null, 105), new LongOpt("state", 1, null, 111), new LongOpt("deactivate-and-activate", 0, null, 99), new LongOpt("ta", 1, null, 122), new LongOpt("td", 1, null, 120)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        block10: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 97: {
                    this.operation = new ActivateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 100: {
                    this.operation = new DeactivateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 99: {
                    this.operation = new DeactivateAndActivateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 117: {
                    this.operation = new GetServiceUsageMBeanOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 105: {
                    this.operation = new GetServicesOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
                case 111: {
                    this.operation = new GetStateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block10;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    private class DeactivateAndActivateOperation
    extends AbstractOperation {
        public static final char ta = 'z';
        public static final char td = 'x';
        private static final String OPERATION_deactivateAndActivate = "deactivateAndActivate";
        private String toActivate;
        private String toDeactivate;

        public DeactivateAndActivateOperation(CommandContext context, Logger log, ServiceCommand serviceCommand2) {
            super(context, log, serviceCommand2);
            this.operationName = OPERATION_deactivateAndActivate;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block10: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1] + " --> " + opts.getOptopt());
                    }
                    case 122: {
                        this.toActivate = opts.getOptarg();
                        continue block10;
                    }
                    case 120: {
                        this.toDeactivate = opts.getOptarg();
                        continue block10;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.toActivate == null || this.toDeactivate == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", requires set of sub options!");
            }
            Class<ServiceID> argClass = ServiceID.class;
            if (this.toActivate.contains(";") || this.toDeactivate.contains(";")) {
                argClass = ServiceID[].class;
            }
            try {
                this.addArg((Object)this.toDeactivate, argClass, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse service IDs to deactivate: \"" + this.toDeactivate + "\"", (Throwable)e);
            }
            try {
                this.addArg((Object)this.toActivate, argClass, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse service IDs to activate: \"" + this.toActivate + "\"", (Throwable)e);
            }
        }
    }

    private class GetStateOperation
    extends AbstractOperation {
        private static final String OPERATION_getState = "getState";

        public GetStateOperation(CommandContext context, Logger log, ServiceCommand serviceCommand2) {
            super(context, log, serviceCommand2);
            this.operationName = OPERATION_getState;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Option does not support array argument.");
            }
            try {
                this.addArg((Object)optArg, ServiceID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ServiceID: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class GetServicesOperation
    extends AbstractOperation {
        private static final String OPERATION_getServices = "getServices";

        public GetServicesOperation(CommandContext context, Logger log, ServiceCommand serviceCommand2) {
            super(context, log, serviceCommand2);
            this.operationName = OPERATION_getServices;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Option does not support array argument.");
            }
            try {
                this.addArg((Object)optArg, ServiceState.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ServiceState: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class GetServiceUsageMBeanOperation
    extends AbstractOperation {
        private static final String OPERATION_getServiceUsageMBean = "getServiceUsageMBean";

        public GetServiceUsageMBeanOperation(CommandContext context, Logger log, ServiceCommand serviceCommand2) {
            super(context, log, serviceCommand2);
            this.operationName = OPERATION_getServiceUsageMBean;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Option does not support array argument.");
            }
            try {
                this.addArg((Object)optArg, ServiceID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ServiceID: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class DeactivateOperation
    extends AbstractOperation {
        private static final String OPERATION_deactivate = "deactivate";

        public DeactivateOperation(CommandContext context, Logger log, ServiceCommand serviceCommand2) {
            super(context, log, serviceCommand2);
            this.operationName = OPERATION_deactivate;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            try {
                if (optArg.contains(";")) {
                    this.addArg((Object)optArg, ServiceID[].class, true);
                } else {
                    this.addArg((Object)optArg, ServiceID.class, true);
                }
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ServiceID: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class ActivateOperation
    extends AbstractOperation {
        private static final String OPERATION_activate = "activate";

        public ActivateOperation(CommandContext context, Logger log, ServiceCommand serviceCommand2) {
            super(context, log, serviceCommand2);
            this.operationName = OPERATION_activate;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            try {
                if (optArg.contains(";")) {
                    this.addArg((Object)optArg, ServiceID[].class, true);
                } else {
                    this.addArg((Object)optArg, ServiceID.class, true);
                }
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ServiceID: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }
}

