/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.ComponentID;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceLevel;
import javax.slee.management.NotificationSource;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class TraceCommand
extends AbstractSleeCommand {
    public TraceCommand() {
        super("trace", "This command performs operations on JSLEE TraceMBean.");
    }

    @Override
    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -a, --tracers-used             Lists tracer names for which Tracer objects have been requested by the");
        out.println("                                   notification source identified by the NotificationSource argument.");
        out.println("                                   Requires notification source as argument.");
        out.println("    -f, --tracers-set              List tracer names for which a trace filter level has been");
        out.println("                                   set for the notification source identified by the NotificationSource parameter.");
        out.println("                                   Requires notification source as argument.");
        out.println("    -s, --set-level                Sets Tracer or Trace level. Depending on options:");
        out.println("                                   --set-level supports following options:");
        out.println("               --cid               Determines SLEE 1.0 component ID. This option excludes \"--nsrc\". It MUST be used in conjunction with --level.");
        out.println("               --nsrc              Determines SLEE 1.1 NotificationSource of tracer affected. This option excludes \"--cid\". It MUST be used in conjunction with --level.");
        out.println("               --name              Determines SLEE 1.1 Tracer name affected. It MUST be used in conjunction wtih --nsrc.");
        out.println("               --level             Determines level of trace (or tracer). It MUST be used with either \"--nsrc\" or \"--cid\"");
        out.println("    -u, --un-set-level             Unsets Tracer level. Depending on options. Option \"--cid\" excludes \"--nsrc\".");
        out.println("               --nsrc              Determines SLEE 1.1 NotificationSource of tracer affected. It MUST be used in conjunction with --name.");
        out.println("               --name              Determines SLEE 1.1 Tracer name affected. It MUST be used in conjunction with --nsrc.");
        out.println("    -g, --get-level                Gets Trace or Tracer level. Depending on options. Option \"--cid\"  excludes \"--nsrc\".");
        out.println("               --cid               Determines SLEE 1.0 component ID. This option excludes \"--nsrc\".");
        out.println("               --nsrc              Determines SLEE 1.1 NotificationSource of tracer affected. It MUST be used in conjunction with --name.");
        out.println("               --name              Determines SLEE 1.1 Tracer name affected. It MUST be used in conjunction wtih --nsrc.");
        out.println("");
        out.println("arg:");
        out.println("");
        out.println("    NotificationSource:    ProfileTableNotification[table=xxx]");
        out.println("    Level             :    [SEVERE|WARNING|INFO|CONFIG|FINE|FINER|FINEST]");
        out.println("");
        out.println("Examples: ");
        out.println("");
        out.println("     1. List used tracers:");
        out.println("" + this.name + " -aProfileTableNotification[table=xxx]");
        out.println("");
        out.println("     2. Set level of tracer:");
        out.println("" + this.name + " -s --cid=SbbID[name=LocationSbb,vendor=org.mobicents,version=1.2] --level=SEVERE");
        out.println("");
        out.println("     3. Set level of tracer:");
        out.println("" + this.name + " -s --nsrc=SbbNotification[service=ServiceID[name=SIP Registrar Service,vendor=org.mobicents,version=1.2],sbb=SbbID[name=LocationSbb,vendor=org.mobicents,version=1.2]] --level=SEVERE --name=error.tracer");
        out.flush();
    }

    @Override
    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("javax.slee.management:name=Trace");
    }

    @Override
    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":a:f:sug";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("tracers-used", 1, null, 97), new LongOpt("tracers-set", 1, null, 102), new LongOpt("set-level", 0, null, 115), new LongOpt("cid", 1, null, 122), new LongOpt("nsrc", 1, null, 120), new LongOpt("name", 1, null, 118), new LongOpt("level", 1, null, 98), new LongOpt("un-set-level", 0, null, 117), new LongOpt("nsrc", 1, null, 120), new LongOpt("name", 1, null, 118), new LongOpt("get-level", 0, null, 103), new LongOpt("cid", 1, null, 122), new LongOpt("nsrc", 1, null, 120), new LongOpt("name", 1, null, 118)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        block9: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 97: {
                    this.operation = new GetTracersUsedOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 102: {
                    this.operation = new GetTracersSetOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 115: {
                    this.operation = new SetLevelOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 117: {
                    this.operation = new UnsetLevelOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
                case 103: {
                    this.operation = new GetLevelOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block9;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    private class UnsetLevelOperation
    extends AbstractOperation {
        public static final char nsrc = 'x';
        public static final char name = 'v';
        private String stringNSRC;
        private String stringName;
        private static final String OPERATION_unsetTraceLevel = "unsetTraceLevel";

        public UnsetLevelOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_unsetTraceLevel;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block10: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 120: {
                        this.stringNSRC = opts.getOptarg();
                        continue block10;
                    }
                    case 118: {
                        this.stringName = opts.getOptarg();
                        continue block10;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringNSRC == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects \"--nsrc\" to be present");
            }
            if (this.stringName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects \"--name\" to be present");
            }
            try {
                this.addArg((Object)this.stringNSRC, NotificationSource.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse NotificationSource: \"" + this.stringNSRC + "\"", (Throwable)e);
            }
            try {
                this.addArg((Object)this.stringName, String.class, false);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse Name: \"" + this.stringName + "\"", (Throwable)e);
            }
        }
    }

    private class GetLevelOperation
    extends AbstractOperation {
        public static final char cid = 'z';
        public static final char nsrc = 'x';
        public static final char name = 'v';
        private static final String OPERATION_getTraceLevel = "getTraceLevel";
        private String stringCID;
        private String stringNSRC;
        private String stringName;

        public GetLevelOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getTraceLevel;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block13: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 122: {
                        this.stringCID = opts.getOptarg();
                        continue block13;
                    }
                    case 120: {
                        this.stringNSRC = opts.getOptarg();
                        continue block13;
                    }
                    case 118: {
                        this.stringName = opts.getOptarg();
                        continue block13;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringCID == null && this.stringNSRC == null || this.stringNSRC != null && this.stringCID != null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--nsrc\" or \"--cid\" to be present");
            }
            if (this.stringCID != null) {
                try {
                    this.addArg((Object)this.stringCID, ComponentID.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse ComponentID: \"" + this.stringCID + "\"", (Throwable)e);
                }
            }
            if (this.stringName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects  \"--name\" to be present");
            }
            try {
                this.addArg((Object)this.stringNSRC, NotificationSource.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse NotificationSource: \"" + this.stringNSRC + "\"", (Throwable)e);
            }
            try {
                this.addArg((Object)this.stringName, String.class, false);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse Name: \"" + this.stringName + "\"", (Throwable)e);
            }
        }
    }

    private class SetLevelOperation
    extends AbstractOperation {
        public static final char cid = 'z';
        public static final char nsrc = 'x';
        public static final char name = 'v';
        public static final char level = 'b';
        private static final String OPERATION_setTraceLevel = "setTraceLevel";
        private String stringCID;
        private String stringNSRC;
        private String stringName;
        private String stringLevel;

        public SetLevelOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_setTraceLevel;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block18: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 122: {
                        this.stringCID = opts.getOptarg();
                        continue block18;
                    }
                    case 120: {
                        this.stringNSRC = opts.getOptarg();
                        continue block18;
                    }
                    case 118: {
                        this.stringName = opts.getOptarg();
                        continue block18;
                    }
                    case 98: {
                        this.stringLevel = opts.getOptarg();
                        continue block18;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringCID == null && this.stringNSRC == null || this.stringNSRC != null && this.stringCID != null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects either \"--nsrc\" or \"--cid\" to be present");
            }
            if (this.stringCID != null) {
                if (this.stringLevel == null) {
                    throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects  \"--level\" to be present");
                }
                try {
                    this.addArg((Object)this.stringCID, ComponentID.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse ComponentID: \"" + this.stringCID + "\"", (Throwable)e);
                }
                try {
                    this.addArg((Object)this.stringLevel, Level.class, true);
                }
                catch (Exception e) {
                    throw new CommandException("Failed to parse Level: \"" + this.stringLevel + "\"", (Throwable)e);
                }
            }
            if (this.stringLevel == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects  \"--level\" to be present");
            }
            if (this.stringName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects  \"--name\" to be present");
            }
            try {
                this.addArg((Object)this.stringNSRC, NotificationSource.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse NotificationSource: \"" + this.stringNSRC + "\"", (Throwable)e);
            }
            try {
                this.addArg((Object)this.stringName, String.class, false);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse Name: \"" + this.stringName + "\"", (Throwable)e);
            }
            try {
                this.addArg((Object)this.stringLevel, TraceLevel.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse TraceLevel: \"" + this.stringLevel + "\"", (Throwable)e);
            }
        }
    }

    private class GetTracersSetOperation
    extends AbstractOperation {
        private static final String OPERATION_getTracersSet = "getTracersSet";

        public GetTracersSetOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getTracersSet;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Option does not support array argument: " + args[opts.getOptind() - 1]);
            }
            try {
                this.addArg((Object)optArg, NotificationSource.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse NotificationSource: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }

    private class GetTracersUsedOperation
    extends AbstractOperation {
        private static final String OPERATION_getTracersUsed = "getTracersUsed";

        public GetTracersUsedOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_getTracersUsed;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            String optArg = opts.getOptarg();
            if (optArg.contains(";")) {
                throw new CommandException("Option does not support array argument: " + args[opts.getOptind() - 1]);
            }
            try {
                this.addArg((Object)optArg, NotificationSource.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse NotificationSource: \"" + optArg + "\"", (Throwable)e);
            }
        }
    }
}

