/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.op;

import gnu.getopt.Getopt;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class AccessorOperation
extends AbstractOperation {
    public static final char set = 's';
    public static final char get = 'g';
    protected String beanFieldName;
    protected Class<?> fieldClass;
    protected boolean usJMXEditors;

    public AccessorOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand, String beanFieldName, Class<?> fieldClass, boolean useJMXEditors) {
        super(context, log, sleeCommand);
        this.beanFieldName = beanFieldName;
        if (Character.isLowerCase(this.beanFieldName.charAt(0))) {
            char c = this.beanFieldName.charAt(0);
            c = Character.toUpperCase(c);
            StringBuffer sb = new StringBuffer();
            sb.append(c);
            sb.append(this.beanFieldName.substring(1));
            this.beanFieldName = sb.toString();
        }
        this.fieldClass = fieldClass;
        this.usJMXEditors = useJMXEditors;
    }

    public AccessorOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand, String beanFieldName, Class<?> fieldClass) {
        this(context, log, sleeCommand, beanFieldName, fieldClass, false);
    }

    public AccessorOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand, String beanFieldName) {
        this(context, log, sleeCommand, beanFieldName, null, false);
    }

    protected void makeGetter() {
        this.operationName = this.fieldClass.equals(Boolean.TYPE) || this.fieldClass.equals(Boolean.class) ? "is" + this.beanFieldName : "get" + this.beanFieldName;
    }

    protected void makeSetter() {
        this.operationName = "set" + this.beanFieldName;
    }

    protected Object convert(String optArg) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, CommandException {
        if (this.fieldClass.isPrimitive()) {
            if (this.fieldClass.equals(Integer.TYPE)) {
                return new Integer(optArg);
            }
            if (this.fieldClass.equals(Long.TYPE)) {
                return new Long(optArg);
            }
            if (this.fieldClass.equals(Integer.TYPE)) {
                return new Integer(optArg);
            }
            if (this.fieldClass.equals(Byte.TYPE)) {
                return new Byte(optArg);
            }
            if (this.fieldClass.equals(Short.TYPE)) {
                return new Short(optArg);
            }
            if (this.fieldClass.equals(Float.TYPE)) {
                return new Float(optArg);
            }
            if (this.fieldClass.equals(Double.TYPE)) {
                return new Double(optArg);
            }
            if (this.fieldClass.equals(Boolean.TYPE)) {
                return new Boolean(optArg);
            }
            if (this.fieldClass.equals(Character.TYPE)) {
                return new Character(optArg.charAt(0));
            }
            throw new CommandException("Unpredicted place. Please report.");
        }
        if (this.isClassNumber()) {
            Constructor<?> con = this.fieldClass.getConstructor(String.class);
            return con.newInstance(optArg);
        }
        return optArg;
    }

    private boolean isClassNumber() {
        Class<?>[] all;
        for (Class<?> c : all = this.fieldClass.getClasses()) {
            if (!c.equals(Number.class) && !c.equals(Boolean.class)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void buildOperation(Getopt opts, String[] args) throws CommandException {
        int code;
        block8: while ((code = opts.getopt()) != -1) {
            if (this.operationName != null) {
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
            }
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                }
                case 115: {
                    this.makeSetter();
                    String optArg = opts.getOptarg();
                    try {
                        this.addArg(this.convert(optArg), this.fieldClass, this.usJMXEditors);
                        continue block8;
                    }
                    catch (Exception e) {
                        throw new CommandException("Failed to parse Integer: \"" + optArg + "\"", (Throwable)e);
                    }
                }
                case 103: {
                    this.makeGetter();
                    continue block8;
                }
            }
            throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
        }
        if (this.operationName == null) {
            throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects either \"--set\" or \"--get\"!");
        }
    }
}

