/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jslee;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.slee.management.ResourceAdaptorEntityState;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.ResourceAdaptorID;
import org.jboss.console.twiddle.command.CommandContext;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.logging.Logger;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AbstractOperation;

public class ResourceCommand
extends AbstractSleeCommand {
    public ResourceCommand() {
        super("resource", "This command performs operations on JSLEE ResourceManagementMBean.");
    }

    @Override
    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -b, --bind                     Creates bind between RA entity and link name, supports following options(mandatory):");
        out.println("          --link-name              Specifies link name to be used, requires argument. ");
        out.println("          --entity-name            Specifies RA entity name to be used, requires argument. ");
        out.println("    -u, --unbind                   Unbinds a link name from a RA entity. Requires link name as argument.");
        out.println("    -a, --activate                 Activate a RA entity. Requires entity name as argument.");
        out.println("    -d, --deactivate               Deactivate a RA entity. Requires entity name as argument.");
        out.println("    -c, --create                   Creates a RA entity. Options specify mandatory arguments:");
        out.println("          --entity-name            Specifies RA entity name to be used, requires entity name as argument. ");
        out.println("          --ra-id                  Specifies ResourceAdaptorID to be used, requires argument. ");
        out.println("          --config                 Specifies ConfigurationProperties to be used, requires argument. ");
        out.println("    -r, --remove                   Removes a RA entity. Requires RA entity name as argument.");
        out.println("    -p, --update-config            Update RA entity configuration. Options specify mandatory arguments:");
        out.println("          --entity-name            Specifies RA entity name to be used, requires argument. ");
        out.println("          --config                 Specifies ConfigurationProperties to be used as new set, requires argument. ");
        out.println("    -l, --list                     Lists result. Result content depends on passed options. One option is required, supported:");
        out.println("          --ra-entities            Marks list operation to list entity names. Without argument it will list all entities. If ");
        out.println("                                   ResourceAdaptorID is passed as argument it will list entity names corresponding to argument. ");
        out.println("          --ra-entities-in-state   Marks list operation to list entity names of RAs in given state. Requires argument(ResourceAdaptorEntityState). ");
        out.println("          --ra-entities-by-link    Marks list operation to list entity name(s) of RAs bound to given link name(s). Requires argument which is a single link name or array. ");
        out.println("          --links                  Marks list operation to list link names. Without argument it will list all links. If ");
        out.println("                                   RA entity name is passed as argument it will list only corresponding link names. ");
        out.println("          --sbbs                   Marks list operation to list SbbIDs bound to passed link name. Requires link name as argument ");
        out.println("    -g, --get                      Fetches information from container based on passed option. One option is required, supported options:");
        out.println("          --ra-id                  Retrieves ResourceAdaptorID. Requires entity name as argument, RA ID is fetched for this name. ");
        out.println("          --state                  Retrieves state of RA. Requires entity name as argument. ");
        out.println("          --config-by-id           Retrieves ConfigurationProperties for given ResourceAdaptorID. Requires ResourceAdaptorID as argument.");
        out.println("          --config-by-name         Retrieves ConfigurationProperties for given RA entity name. Requires entity name as argument.");
        out.println("arg:");
        out.println("");
        out.println("NOTE: Config property has general form of: (name:java.type=value) and array has different form, than in components: [(cnf.prop),(cnf.prop)]");
        out.println("     Configuration property array: [(remotePort:java.lang.Integer=40001),(localPort:java.lang.Integer=40000),(localHost:java.lang.String=127.0.0.1),(remoteHost:java.lang.String=127.0.0.1)]");
        out.println("     ResourceAdaptorEntityState: [INACTIVE|STOPPING|ACTIVE]");
        out.println("");
        out.println("Examples: ");
        out.println("");
        out.println("     1. Create RA Entity:");
        out.println("" + this.name + " -c --entity-name=SipRA --ra-id=ResourceAdaptorID[name=JainSipResourceAdaptor,vendor=net.java.slee.sip,version=1.2] --config=[(javax.sip.TRANSPORT:java.lang.String=UDP),(javax.sip.IP_ADDRESS:java.lang.String=),(javax.sip.PORT:java.lang.Integer=5060)]");
        out.println("");
        out.println("     2. Bind RA Entity to Link:");
        out.println("" + this.name + " -b --link-name=SipRALink --entity-name=SipRA");
        out.println("");
        out.println("     3. Get state of RA Entity:");
        out.println("" + this.name + " -g --state=SipRA");
        out.println("");
        out.println("     4 List all RA Entities in container:");
        out.println("" + this.name + " -l --ra-entities");
        out.println("");
        out.println("     5. List all RA Entities created from specific ResourceAdaptorID:");
        out.println("" + this.name + " -l --ra-entities=ResourceAdaptorID[name=JainSipResourceAdaptor,vendor=net.java.slee.sip,version=1.2]");
        out.flush();
    }

    @Override
    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":bu:a:d:cr:plg";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("bind", 0, null, 98), new LongOpt("link-name", 1, null, 118), new LongOpt("entity-name", 1, null, 109), new LongOpt("unbind", 1, null, 117), new LongOpt("activate", 1, null, 97), new LongOpt("deactivate", 1, null, 100), new LongOpt("create", 0, null, 99), new LongOpt("ra-id", 1, null, 106), new LongOpt("config", 1, null, 105), new LongOpt("remove", 1, null, 114), new LongOpt("update-config", 0, null, 112), new LongOpt("list", 0, null, 108), new LongOpt("ra-entities", 2, null, 113), new LongOpt("ra-entities-in-state", 1, null, 120), new LongOpt("ra-entities-by-link", 1, null, 101), new LongOpt("links", 2, null, 107), new LongOpt("sbbs", 1, null, 115), new LongOpt("get", 0, null, 103), new LongOpt("state", 1, null, 111), new LongOpt("config-by-id", 1, null, 109), new LongOpt("config-by-name", 1, null, 110)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        block13: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 98: {
                    this.operation = new BindOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 117: {
                    this.operation = new UnBindOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 97: {
                    this.operation = new ActivateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 100: {
                    this.operation = new DeactivateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 99: {
                    this.operation = new CreateOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 114: {
                    this.operation = new RemoveOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 112: {
                    this.operation = new UpdateConfigOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 108: {
                    this.operation = new ListOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
                case 103: {
                    this.operation = new GetOperation(this.context, this.log, this);
                    this.operation.buildOperation(getopt, args);
                    continue block13;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }

    @Override
    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("javax.slee.management:name=ResourceManagement");
    }

    private class UpdateConfigOperation
    extends AbstractOperation {
        private static final String OPERATION_updateConfigurationProperties = "updateConfigurationProperties";
        private String stringEntityName;
        private String stringConfig;

        public UpdateConfigOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_updateConfigurationProperties;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block8: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 109: {
                        this.stringEntityName = opts.getOptarg();
                        continue block8;
                    }
                    case 105: {
                        this.stringConfig = opts.getOptarg();
                        continue block8;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringEntityName == null || this.stringConfig == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects both \"--config\"  and \"--entity-name\" to be present");
            }
            super.addArg((Object)this.stringEntityName, String.class, false);
            try {
                super.addArg((Object)this.stringConfig, ConfigProperties.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ConfigProperties: \"" + this.stringConfig + "\"", (Throwable)e);
            }
        }
    }

    private class GetOperation
    extends AbstractOperation {
        private static final char usage_mbean = 'z';
        private static final char config_by_name = 'n';
        private static final char config_by_id = 'm';
        private static final char state = 'o';
        private static final String OPERATION_getResourceAdaptor = "getResourceAdaptor";
        private static final String OPERATION_getState = "getState";
        private static final String OPERATION_getConfigurationProperties = "getConfigurationProperties";
        private static final String OPERATION_getResourceUsageMBean = "getResourceUsageMBean";

        public GetOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block11: while ((code = opts.getopt()) != -1) {
                if (this.operationName != null) {
                    throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects only one option!");
                }
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 106: {
                        this.operationName = OPERATION_getResourceAdaptor;
                        String optArg = opts.getOptarg();
                        super.addArg((Object)optArg, String.class, false);
                        continue block11;
                    }
                    case 111: {
                        this.operationName = OPERATION_getState;
                        String optArg = opts.getOptarg();
                        super.addArg((Object)optArg, String.class, false);
                        continue block11;
                    }
                    case 109: {
                        this.operationName = OPERATION_getConfigurationProperties;
                        String optArg = opts.getOptarg();
                        try {
                            super.addArg((Object)optArg, ResourceAdaptorID.class, true);
                            continue block11;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse ResourceAdaptorID: \"" + optArg + "\"", (Throwable)e);
                        }
                    }
                    case 110: {
                        this.operationName = OPERATION_getConfigurationProperties;
                        String optArg = opts.getOptarg();
                        super.addArg((Object)optArg, String.class, false);
                        continue block11;
                    }
                    case 122: {
                        this.operationName = OPERATION_getResourceUsageMBean;
                        String optArg = opts.getOptarg();
                        super.addArg((Object)optArg, String.class, false);
                        continue block11;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.operationName == null) {
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects one option!");
            }
        }
    }

    private class ListOperation
    extends AbstractOperation {
        private static final char sbbs = 's';
        private static final char links = 'k';
        private static final char ra_entities_by_link = 'e';
        private static final char ra_entities_in_state = 'x';
        private static final char ra_entities = 'q';
        private static final String OPERATION_getBoundSbbs = "getBoundSbbs";
        private static final String OPERATION_getLinkNames = "getLinkNames";
        private static final String OPERATION_getResourceAdaptorEntities = "getResourceAdaptorEntities";
        private static final String OPERATION_getResourceAdaptorEntity = "getResourceAdaptorEntity";

        public ListOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block13: while ((code = opts.getopt()) != -1) {
                if (this.operationName != null) {
                    throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects only one option!");
                }
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 115: {
                        this.operationName = OPERATION_getBoundSbbs;
                        String optArg = opts.getOptarg();
                        super.addArg((Object)optArg, String.class, false);
                        continue block13;
                    }
                    case 107: {
                        this.operationName = OPERATION_getLinkNames;
                        String optArg = opts.getOptarg();
                        if (optArg == null) continue block13;
                        super.addArg((Object)optArg, String.class, false);
                        continue block13;
                    }
                    case 113: {
                        this.operationName = OPERATION_getResourceAdaptorEntities;
                        String optArg = opts.getOptarg();
                        if (optArg == null) continue block13;
                        try {
                            super.addArg((Object)optArg, ResourceAdaptorID.class, true);
                            continue block13;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse ResourceAdaptorID: \"" + optArg + "\"", (Throwable)e);
                        }
                    }
                    case 101: {
                        String optArg = opts.getOptarg();
                        if (optArg.contains(";")) {
                            this.operationName = OPERATION_getResourceAdaptorEntities;
                            super.addArg((Object)optArg.split(";"), String[].class, false);
                            continue block13;
                        }
                        this.operationName = OPERATION_getResourceAdaptorEntity;
                        super.addArg((Object)optArg, String.class, false);
                        continue block13;
                    }
                    case 120: {
                        this.operationName = OPERATION_getResourceAdaptorEntities;
                        String optArg = opts.getOptarg();
                        try {
                            super.addArg((Object)optArg, ResourceAdaptorEntityState.class, true);
                            continue block13;
                        }
                        catch (Exception e) {
                            throw new CommandException("Failed to parse ResourceAdaptorEntityState: \"" + optArg + "\"", (Throwable)e);
                        }
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.operationName == null) {
                throw new CommandException("Command: \"" + this.sleeCommand.getName() + "\", expects one option!");
            }
        }
    }

    private class CreateOperation
    extends AbstractOperation {
        private static final char config = 'i';
        private static final char ra_id = 'j';
        private static final String OPERATION_createResourceAdaptorEntity = "createResourceAdaptorEntity";
        private String stringEntityName;
        private String stringConfig;
        private String stringRaID;

        public CreateOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_createResourceAdaptorEntity;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block11: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 109: {
                        this.stringEntityName = opts.getOptarg();
                        continue block11;
                    }
                    case 105: {
                        this.stringConfig = opts.getOptarg();
                        continue block11;
                    }
                    case 106: {
                        this.stringRaID = opts.getOptarg();
                        continue block11;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.stringEntityName == null || this.stringConfig == null || this.stringRaID == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects all \"--config\" ,\"--entity-name\" and \"--ra-id\" to be present");
            }
            try {
                super.addArg((Object)this.stringRaID, ResourceAdaptorID.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ResourceAdaptorID: \"" + this.stringRaID + "\"", (Throwable)e);
            }
            super.addArg((Object)this.stringEntityName, String.class, false);
            try {
                super.addArg((Object)this.stringConfig, ConfigProperties.class, true);
            }
            catch (Exception e) {
                throw new CommandException("Failed to parse ConfigProperties: \"" + this.stringConfig + "\"", (Throwable)e);
            }
        }
    }

    private class RemoveOperation
    extends AbstractOperation {
        private static final String OPERATION_removeResourceAdaptorEntity = "removeResourceAdaptorEntity";

        public RemoveOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_removeResourceAdaptorEntity;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            super.addArg((Object)opts.getOptarg(), String.class, false);
        }
    }

    private class DeactivateOperation
    extends AbstractOperation {
        private static final String OPERATION_deactivateResourceAdaptorEntity = "deactivateResourceAdaptorEntity";

        public DeactivateOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_deactivateResourceAdaptorEntity;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            super.addArg((Object)opts.getOptarg(), String.class, false);
        }
    }

    private class ActivateOperation
    extends AbstractOperation {
        private static final String OPERATION_activateResourceAdaptorEntity = "activateResourceAdaptorEntity";

        public ActivateOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_activateResourceAdaptorEntity;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            super.addArg((Object)opts.getOptarg(), String.class, false);
        }
    }

    private class UnBindOperation
    extends AbstractOperation {
        private static final String OPERATION_unbindLinkName = "unbindLinkName";

        public UnBindOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_unbindLinkName;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            super.addArg((Object)opts.getOptarg(), String.class, false);
        }
    }

    private class BindOperation
    extends AbstractOperation {
        public static final char ra_link_name = 'v';
        public static final char ra_entity_name = 'm';
        private static final String OPERATION_bindLinkName = "bindLinkName";
        private String linkName;
        private String entityName;

        public BindOperation(CommandContext context, Logger log, AbstractSleeCommand sleeCommand) {
            super(context, log, sleeCommand);
            this.operationName = OPERATION_bindLinkName;
        }

        @Override
        public void buildOperation(Getopt opts, String[] args) throws CommandException {
            int code;
            block6: while ((code = opts.getopt()) != -1) {
                switch (code) {
                    case 58: {
                        throw new CommandException("Option requires an argument: " + args[opts.getOptind() - 1]);
                    }
                    case 63: {
                        throw new CommandException("Invalid (or ambiguous) option: " + args[opts.getOptind() - 1]);
                    }
                    case 118: {
                        this.linkName = opts.getOptarg();
                        continue block6;
                    }
                    case 109: {
                        this.entityName = opts.getOptarg();
                        continue block6;
                    }
                }
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", found unexpected opt: " + args[opts.getOptind() - 1]);
            }
            if (this.linkName == null || this.entityName == null) {
                throw new CommandException("Operation \"" + this.operationName + "\" for command: \"" + this.sleeCommand.getName() + "\", expects both \"--link-name\" and \"--entity-name\" to be present");
            }
            super.addArg((Object)this.entityName, String.class, false);
            super.addArg((Object)this.linkName, String.class, false);
        }
    }
}

