/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.tools.twiddle.jsleex;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.PrintWriter;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.mobicents.tools.twiddle.AbstractSleeCommand;
import org.mobicents.tools.twiddle.op.AccessorOperation;

public class RouterCfgCommand
extends AbstractSleeCommand {
    private static final String FIELD_ExecutorMapperClassName = "ExecutorMapperClassName";
    private static final String FIELD_EventRouterThreads = "EventRouterThreads";
    private static final String FIELD_CollectStats = "CollectStats";

    public RouterCfgCommand() {
        super("router.cfg", "This command performs operations on Restcomm EventRouterConfiguration MBean.");
    }

    @Override
    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("usage: " + this.name + " <-operation[[arg] | [--option[=arg]]*]>");
        out.println();
        out.println("operation:");
        out.println("    -m, --mapper                   Performs operation on executor mapper class name. Instance of this class is used to map activity to executor. Exactly one of following options must be present:");
        out.println("            --get                   Returns name of mapper class. Does not require argument.");
        out.println("            --set                   Sets class of mapper, requires argument which FQN of class to be used for mapping.");
        out.println("    -t, --threads                  Performs operation on threads used by executor. Exactly one of following options must be present:");
        out.println("            --get                   Returns number of threads used by executor. Does not require argument.");
        out.println("            --set                   Sets number of threads used by executor, requires integer argument which is greater than zero.");
        out.println("    -x, --stats                    Controls if statistics are enabled(true) or disabled(false). Exactly one of following options must be present:");
        out.println("            --get                   Returns boolean indicating if statistics are being enabled or not. Does not require argument.");
        out.println("            --set                   Sets parameter to enable statistics, requires boolean argument.");
        out.flush();
    }

    @Override
    public ObjectName getBeanOName() throws MalformedObjectNameException, NullPointerException {
        return new ObjectName("org.mobicents.slee:name=EventRouterConfiguration");
    }

    @Override
    protected void processArguments(String[] args) throws CommandException {
        int code;
        String sopts = ":mtx";
        LongOpt[] lopts = new LongOpt[]{new LongOpt("mapper", 0, null, 109), new LongOpt("threads", 0, null, 116), new LongOpt("stats", 0, null, 120), new LongOpt("set", 1, null, 115), new LongOpt("get", 0, null, 103)};
        Getopt getopt = new Getopt(null, args, sopts, lopts);
        getopt.setOpterr(false);
        block7: while ((code = getopt.getopt()) != -1) {
            switch (code) {
                case 58: {
                    throw new CommandException("Option requires an argument: " + args[getopt.getOptind() - 1]);
                }
                case 63: {
                    throw new CommandException("Invalid (or ambiguous) option: " + args[getopt.getOptind() - 1]);
                }
                case 109: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_ExecutorMapperClassName, String.class);
                    this.operation.buildOperation(getopt, args);
                    continue block7;
                }
                case 116: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_EventRouterThreads, Integer.TYPE);
                    this.operation.buildOperation(getopt, args);
                    continue block7;
                }
                case 120: {
                    this.operation = new AccessorOperation(this.context, this.log, this, FIELD_CollectStats, Boolean.TYPE);
                    this.operation.buildOperation(getopt, args);
                    continue block7;
                }
            }
            throw new CommandException("Command: \"" + this.getName() + "\", found unexpected opt: " + args[getopt.getOptind() - 1]);
        }
    }
}

