/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.media.server.impl.dsp.audio.ilbc;

import java.util.Arrays;
import org.mobicents.media.server.impl.dsp.audio.ilbc.BasicFunctions;
import org.mobicents.media.server.impl.dsp.audio.ilbc.CbSearchData;
import org.mobicents.media.server.impl.dsp.audio.ilbc.CbUpdateIndexData;
import org.mobicents.media.server.impl.dsp.audio.ilbc.Constants;
import org.mobicents.media.server.impl.dsp.audio.ilbc.EncoderBits;
import org.mobicents.media.server.impl.dsp.audio.ilbc.EncoderState;
import org.mobicents.media.server.spi.dsp.Codec;
import org.mobicents.media.server.spi.format.Format;
import org.mobicents.media.server.spi.format.FormatFactory;
import org.mobicents.media.server.spi.memory.Frame;
import org.mobicents.media.server.spi.memory.Memory;

public class Encoder
implements Codec {
    private static final Format ilbc = FormatFactory.createAudioFormat((String)"ilbc", (int)8000, (int)16, (int)1);
    private static final Format linear = FormatFactory.createAudioFormat((String)"linear", (int)8000, (int)16, (int)1);
    private short[] signal = new short[160];
    private EncoderState encoderState = new EncoderState();
    private EncoderBits encoderBits = new EncoderBits();
    CbUpdateIndexData updateIndexData = new CbUpdateIndexData();
    CbSearchData searchData = new CbSearchData();
    private int i;
    private int j;
    private int k;
    private int n;
    private int tempL;
    private int temp;
    private int temp2;
    private int temp3;
    private int temp4;
    private int tempShift;
    private int tempIndex1;
    private int tempIndex2;
    private int tempIndex3;
    private int tempIndex4;
    private int tempIndex5;
    private int tempIndex6;
    private int tempIndex7;
    private int tempIndex8;
    private int tempIndex9;
    private int memlGotten;
    private int nFor;
    private int nBack;
    private int index;
    private int b2;
    private int minValue;
    private int sum;
    private int subCount;
    private int subFrame;
    private int stage;
    private int en1;
    private int en2;
    private int foundFreqs;
    private int codedEner;
    private int targetEner;
    private int[] tempLMemory = new int[256];
    private short diff;
    private short startPos;
    private short scale;
    private short scale2;
    private short max;
    private short baseSize;
    private short range;
    private short tempS;
    private short tempS2;
    private short nBits;
    private short alphaExp;
    private short xHi;
    private short xLow;
    private short xMid;
    private short x;
    private short yHi;
    private short yLow;
    private short yMid;
    private short y;
    private short b1Hi;
    private short b1Low;
    private short sInd;
    private short eInd;
    private boolean isStable;
    private short[] weightdenum = new short[66];
    private short[] dataVec = new short[250];
    private short[] memVec = new short[155];
    private short[] residual = new short[160];
    private short[] tempMemory = new short[1350];

    public Frame process(Frame frame) {
        byte[] data = frame.getData();
        this.temp = 10;
        this.i = 0;
        while (this.i < 160) {
            this.dataVec[this.temp++] = (short)(data[this.i * 2 + 1] << 8 | data[this.i * 2] & 0xFF);
            ++this.i;
        }
        this.hpInput(this.dataVec, 10, 160);
        this.lpcEncode(this.memVec, 4, this.weightdenum, 0, this.dataVec, 10);
        System.arraycopy(this.encoderState.getAnaMem(), 0, this.dataVec, 0, 10);
        this.i = 0;
        while (true) {
            if (this.i >= 4) break;
            BasicFunctions.filterMA(this.dataVec, 10 + this.i * 40, this.residual, this.i * 40, this.memVec, 4 + this.i * 11, 11, 40);
            ++this.i;
        }
        System.arraycopy(this.dataVec, 160, this.encoderState.getAnaMem(), 0, 10);
        this.encoderBits.setStartIdx(this.frameClassify(this.residual));
        this.index = (this.encoderBits.getStartIdx() - 1) * 40;
        this.max = 0;
        this.tempIndex1 = this.index;
        this.n = 0;
        while (this.n < 80) {
            this.tempS = this.residual[this.tempIndex1++];
            if (this.tempS < 0) {
                this.tempS = (short)(0 - this.tempS);
            }
            if (this.tempS > this.max) {
                this.max = this.tempS;
            }
            ++this.n;
        }
        this.scale = BasicFunctions.getSize(this.max * this.max);
        this.scale = (short)(this.scale - 25);
        if (this.scale < 0) {
            this.scale = 0;
        }
        this.diff = (short)(80 - 57);
        this.en1 = BasicFunctions.scaleRight(this.residual, this.index, this.residual, this.index, 57, this.scale);
        this.index += this.diff;
        this.en2 = BasicFunctions.scaleRight(this.residual, this.index, this.residual, this.index, 57, this.scale);
        if (this.en1 > this.en2) {
            this.encoderBits.setStateFirst(true);
            this.startPos = (short)((this.encoderBits.getStartIdx() - 1) * 40);
        } else {
            this.encoderBits.setStateFirst(false);
            this.startPos = (short)((this.encoderBits.getStartIdx() - 1) * 40 + this.diff);
        }
        this.stateSearch(this.residual, this.startPos, this.memVec, 4 + (this.encoderBits.getStartIdx() - 1) * 11, this.weightdenum, (this.encoderBits.getStartIdx() - 1) * 11);
        this.stateConstruct(this.memVec, 4 + (this.encoderBits.getStartIdx() - 1) * 11, this.residual, this.startPos);
        if (this.encoderBits.getStateFirst()) {
            this.i = 4;
            while (true) {
                if (this.i >= 151 - 57) break;
                this.memVec[this.i] = 0;
                ++this.i;
            }
            System.arraycopy(this.residual, this.startPos, this.memVec, 151 - 57, 57);
            this.cbSearch(this.residual, this.startPos + 57, this.memVec, 66, 85, this.diff, this.weightdenum, this.encoderBits.getStartIdx() * 11, 0, 0, 0);
            this.cbConstruct(this.residual, this.startPos + 57, this.memVec, 66, (short)85, this.diff, 0, 0);
        } else {
            BasicFunctions.reverseCopy(this.dataVec, this.diff + 9, this.residual, this.encoderBits.getStartIdx() * 40 - 40, this.diff);
            BasicFunctions.reverseCopy(this.memVec, 150, this.residual, this.startPos, 57);
            this.i = 4;
            while (true) {
                if (this.i >= 151 - 57) break;
                this.memVec[this.i] = 0;
                ++this.i;
            }
            this.cbSearch(this.dataVec, 10, this.memVec, 66, 85, this.diff, this.weightdenum, (this.encoderBits.getStartIdx() - 1) * 11, 0, 0, 0);
            this.cbConstruct(this.dataVec, 10, this.memVec, 66, (short)85, this.diff, 0, 0);
            BasicFunctions.reverseCopy(this.residual, this.startPos - 1, this.dataVec, 10, this.diff);
        }
        this.nFor = 4 - this.encoderBits.getStartIdx() - 1;
        this.subCount = 1;
        if (this.nFor > 0) {
            this.i = 4;
            while (this.i < 71) {
                this.memVec[this.i] = 0;
                ++this.i;
            }
            System.arraycopy(this.residual, (this.encoderBits.getStartIdx() - 1) * 40, this.memVec, 71, 80);
            this.subFrame = 0;
            while (this.subFrame < this.nFor) {
                this.cbSearch(this.residual, (this.encoderBits.getStartIdx() + 1 + this.subFrame) * 40, this.memVec, 4, 147, 40, this.weightdenum, (this.encoderBits.getStartIdx() + 1 + this.subFrame) * 11, this.subCount, this.subCount * 3, this.subCount * 3);
                this.cbConstruct(this.residual, (this.encoderBits.getStartIdx() + 1 + this.subFrame) * 40, this.memVec, 4, (short)147, (short)40, this.subCount * 3, this.subCount * 3);
                this.temp = 4;
                this.i = 44;
                while (this.i < 151) {
                    this.memVec[this.temp++] = this.memVec[this.i];
                    ++this.i;
                }
                System.arraycopy(this.residual, (this.encoderBits.getStartIdx() + 1 + this.subFrame) * 40, this.memVec, 111, 40);
                ++this.subCount;
                ++this.subFrame;
            }
        }
        this.nBack = this.encoderBits.getStartIdx() - 1;
        if (this.nBack > 0) {
            BasicFunctions.reverseCopy(this.dataVec, 10 + this.nBack * 40 - 1, this.residual, 0, this.nBack * 40);
            this.memlGotten = 40 * (4 + 1 - this.encoderBits.getStartIdx());
            if (this.memlGotten > 147) {
                this.memlGotten = 147;
            }
            BasicFunctions.reverseCopy(this.memVec, 150, this.residual, this.nBack * 40, this.memlGotten);
            this.i = 4;
            while (this.i < 151 - this.memlGotten) {
                this.memVec[this.i] = 0;
                ++this.i;
            }
            this.subFrame = 0;
            while (this.subFrame < this.nBack) {
                this.cbSearch(this.dataVec, 10 + this.subFrame * 40, this.memVec, 4, 147, 40, this.weightdenum, (this.encoderBits.getStartIdx() - 2 - this.subFrame) * 11, this.subCount, this.subCount * 3, this.subCount * 3);
                this.cbConstruct(this.dataVec, 10 + this.subFrame * 40, this.memVec, 4, (short)147, (short)40, this.subCount * 3, this.subCount * 3);
                this.temp = 4;
                this.i = 44;
                while (this.i < 151) {
                    this.memVec[this.temp++] = this.memVec[this.i];
                    ++this.i;
                }
                System.arraycopy(this.dataVec, 10 + this.subFrame * 40, this.memVec, 111, 40);
                ++this.subCount;
                ++this.subFrame;
            }
            BasicFunctions.reverseCopy(this.residual, 40 * this.nBack - 1, this.dataVec, 10, 40 * this.nBack);
        }
        short[] index = this.encoderBits.getCbIndex();
        this.k = 4;
        while (this.k < 6) {
            if (index[this.k] >= 108 && index[this.k] < 172) {
                int n = this.k;
                index[n] = (short)(index[n] - 64);
            } else if (index[this.k] >= 236) {
                int n = this.k;
                index[n] = (short)(index[n] - 128);
            }
            ++this.k;
        }
        System.out.println("************************************************************");
        System.out.println("PACKED DATA");
        System.out.println("************************************************************");
        System.out.println("START IDX:" + this.encoderBits.getStartIdx() + ",STATE FIRST:" + this.encoderBits.getStateFirst());
        System.out.print("LSF:");
        this.i = 0;
        while (this.i < this.encoderBits.getLSF().length) {
            System.out.print(this.encoderBits.getLSF()[this.i] + ",");
            ++this.i;
        }
        System.out.println();
        System.out.print("IDX VEC:");
        this.i = 0;
        while (this.i < this.encoderBits.getIdxVec().length) {
            System.out.print(this.encoderBits.getIdxVec()[this.i] + ",");
            ++this.i;
        }
        System.out.println();
        System.out.print("CB INDEX:");
        this.i = 0;
        while (this.i < this.encoderBits.getCbIndex().length) {
            System.out.print(this.encoderBits.getCbIndex()[this.i] + ",");
            ++this.i;
        }
        System.out.println();
        System.out.print("GAIN INDEX:");
        this.i = 0;
        while (this.i < this.encoderBits.getGainIndex().length) {
            System.out.print(this.encoderBits.getGainIndex()[this.i] + ",");
            ++this.i;
        }
        System.out.println();
        System.out.println("STATE FIRST:" + this.encoderBits.getStateFirst());
        System.out.println("START IDX:" + this.encoderBits.getStartIdx());
        System.out.println("IDX FOR MAX:" + this.encoderBits.getIdxForMax());
        Frame res = Memory.allocate((int)38);
        this.packBits(res.getData());
        res.setOffset(0);
        res.setLength(38);
        res.setTimestamp(frame.getTimestamp());
        res.setDuration(frame.getDuration());
        res.setSequenceNumber(frame.getSequenceNumber());
        res.setEOM(frame.isEOM());
        res.setFormat(ilbc);
        return res;
    }

    public Format getSupportedInputFormat() {
        return linear;
    }

    public Format getSupportedOutputFormat() {
        return ilbc;
    }

    private void hpInput(short[] data, int startIndex, int length) {
        short[] ba = Constants.HP_IN_COEFICIENTS;
        short[] y = this.encoderState.getHpiMemY();
        short[] x = this.encoderState.getHpiMemX();
        this.temp3 = startIndex + length;
        this.i = startIndex;
        while (this.i < this.temp3) {
            this.temp = y[1] * ba[3];
            this.temp += y[3] * ba[4];
            this.temp >>= 15;
            this.temp += y[0] * ba[3];
            this.temp += y[2] * ba[4];
            this.temp <<= 1;
            this.temp += data[this.i] * ba[0];
            this.temp += x[0] * ba[1];
            this.temp += x[1] * ba[2];
            x[1] = x[0];
            x[0] = data[this.i];
            this.temp2 = this.temp + 4096;
            if (this.temp2 > 0xFFFFFFF) {
                this.temp2 = 0xFFFFFFF;
            } else if (this.temp2 < -268435456) {
                this.temp2 = -268435456;
            }
            data[this.i] = (short)(this.temp2 >> 13);
            y[2] = y[0];
            y[3] = y[1];
            this.temp = this.temp > 0xFFFFFFF ? Integer.MAX_VALUE : (this.temp < -268435456 ? Integer.MIN_VALUE : (this.temp <<= 3));
            y[0] = (short)(this.temp >> 16);
            this.tempShift = y[0] << 16;
            y[1] = (short)(this.temp - this.tempShift >> 1);
            ++this.i;
        }
    }

    private void lpcEncode(short[] synthDenum, int synthDenumIndex, short[] weightDenum, int weightDenumIndex, short[] data, int startIndex) {
        short[] lsf = this.tempMemory;
        short[] lsfDeq = this.tempMemory;
        this.simpleLpcAnalysis(lsf, 0, data, startIndex);
        this.simpleLsfQ(lsfDeq, 20, lsf, 0);
        this.lsfCheck(lsfDeq, 20, 10);
        this.simpleInterpolateLsf(synthDenum, synthDenumIndex, weightDenum, weightDenumIndex, lsf, 0, lsfDeq, 20, 10);
    }

    private void simpleLpcAnalysis(short[] lsf, int lsfIndex, short[] data, int startIndex) {
        short[] A = this.tempMemory;
        short[] windowedData = this.tempMemory;
        short[] rc = this.tempMemory;
        int[] R = this.tempLMemory;
        short[] lpcBuffer = this.encoderState.getLpcBuffer();
        System.arraycopy(data, startIndex, lpcBuffer, 300 - 160, 160);
        this.k = 0;
        while (true) {
            if (this.k >= 1) break;
            if (this.k < 1 - 1) {
                BasicFunctions.multWithRightShift(windowedData, 51, lpcBuffer, 0, Constants.LPC_WIN, 0, 240, 15);
            } else {
                BasicFunctions.multWithRightShift(windowedData, 51, lpcBuffer, 60, Constants.LPC_ASYM_WIN, 0, 240, 15);
            }
            this.autoCorrelation(windowedData, 51, 240, 10, R, 0);
            this.windowMultiply(R, 0, R, 0, Constants.LPC_LAG_WIN, 11);
            this.isStable = this.levinsonDurbin(R, 0, A, 40, rc, 291, 10);
            if (!this.isStable) {
                A[40] = 4096;
                this.j = 41;
                while (this.j < 51) {
                    A[this.j] = 0;
                    ++this.j;
                }
            }
            BasicFunctions.expand(A, 40, A, 40, Constants.LPC_CHIRP_SYNT_DENUM, 11);
            this.poly2Lsf(lsf, lsfIndex + 10 * this.k, A, 40);
            ++this.k;
        }
        System.arraycopy(lpcBuffer, 160, lpcBuffer, 0, 300 - 160);
    }

    private void autoCorrelation(short[] input, int inputIndex, int inputLength, int order, int[] result, int resultIndex) {
        if (order < 0) {
            order = inputLength;
        }
        this.max = 0;
        this.tempIndex2 = inputIndex;
        this.i = 0;
        while (this.i < inputLength) {
            this.tempS = BasicFunctions.abs(input[this.tempIndex2++]);
            if (this.tempS > this.max) {
                this.max = this.tempS;
            }
            ++this.i;
        }
        if (this.max == 0) {
            this.scale = 0;
        } else {
            this.nBits = BasicFunctions.getSize(inputLength);
            this.tempS2 = BasicFunctions.norm(this.max * this.max);
            this.scale = this.tempS2 > this.nBits ? (short)0 : (short)(this.nBits - this.tempS2);
        }
        this.i = 0;
        while (this.i < order + 1) {
            this.sum = 0;
            this.tempIndex2 = inputIndex;
            this.tempIndex3 = inputIndex + this.i;
            this.j = inputLength - this.i;
            while (this.j > 0) {
                this.tempShift = input[this.tempIndex2++] * input[this.tempIndex3++];
                this.sum += this.tempShift >> this.scale;
                --this.j;
            }
            result[resultIndex++] = this.sum;
            ++this.i;
        }
    }

    private void windowMultiply(int[] output, int outputIndex, int[] input, int inputIndex, int[] window, int length) {
        this.nBits = BasicFunctions.norm(input[inputIndex]);
        BasicFunctions.bitShiftLeft(input, inputIndex, input, inputIndex, length, this.nBits);
        this.tempIndex2 = outputIndex;
        this.i = 0;
        while (this.i < length) {
            this.xHi = (short)(input[inputIndex] >> 16);
            this.yHi = (short)(window[this.i] >> 16);
            this.tempShift = this.xHi << 16;
            this.xLow = (short)(input[inputIndex++] - this.tempShift >> 1);
            this.tempShift = this.yHi << 16;
            this.yLow = (short)(window[this.i] - this.tempShift >> 1);
            output[this.tempIndex2] = this.tempShift = this.xHi * this.yHi << 1;
            this.tempShift = this.xHi * this.yLow >> 14;
            int n = this.tempIndex2;
            output[n] = output[n] + this.tempShift;
            this.tempShift = this.xLow * this.yHi >> 14;
            int n2 = this.tempIndex2++;
            output[n2] = output[n2] + this.tempShift;
            ++this.i;
        }
        BasicFunctions.bitShiftRight(output, outputIndex, output, outputIndex, length, this.nBits);
    }

    private boolean levinsonDurbin(int[] R, int rIndex, short[] A, int aIndex, short[] K, int kIndex, int order) {
        short[] rHi = this.tempMemory;
        short[] rLow = this.tempMemory;
        short[] aHi = this.tempMemory;
        short[] aLow = this.tempMemory;
        short[] aUpdHi = this.tempMemory;
        short[] aUpdLow = this.tempMemory;
        this.nBits = BasicFunctions.norm(R[rIndex]);
        this.tempIndex1 = rIndex + order;
        this.tempIndex2 = 301 + order;
        this.tempIndex3 = 322 + order;
        this.i = order;
        while (this.i >= 0) {
            this.temp = R[this.tempIndex1--] << this.nBits;
            rHi[this.tempIndex2] = (short)(this.temp >> 16);
            this.tempShift = rHi[this.tempIndex2--] << 16;
            rLow[this.tempIndex3--] = (short)(this.temp - this.tempShift >> 1);
            --this.i;
        }
        this.temp2 = rHi[302] << 16;
        this.temp3 = rLow[323] << 1;
        this.temp2 += this.temp3;
        this.temp3 = this.temp2 > 0 ? this.temp2 : -this.temp2;
        this.temp = BasicFunctions.div(this.temp3, rHi[301], rLow[322]);
        if (this.temp2 > 0) {
            this.temp = -this.temp;
        }
        this.xHi = (short)(this.temp >> 16);
        this.tempShift = this.xHi << 16;
        this.xLow = (short)(this.temp - this.tempShift >> 1);
        K[kIndex++] = this.xHi;
        this.temp >>= 4;
        aHi[344] = (short)(this.temp >> 16);
        this.tempShift = aHi[344] << 16;
        aLow[365] = (short)(this.temp - this.tempShift >> 1);
        this.temp = this.tempShift = this.xHi * this.xLow >> 14;
        this.tempShift = this.xHi * this.xHi;
        this.temp += this.tempShift;
        this.temp <<= 1;
        if (this.temp < 0) {
            this.temp = 0 - this.temp;
        }
        this.temp = Integer.MAX_VALUE - this.temp;
        this.tempS = (short)(this.temp >> 16);
        this.tempShift = this.tempS << 16;
        this.tempS2 = (short)(this.temp - this.tempShift >> 1);
        this.temp = this.tempShift = rHi[301] * this.tempS;
        this.tempShift = rHi[301] * this.tempS2 >> 15;
        this.temp += this.tempShift;
        this.tempShift = rLow[322] * this.tempS >> 15;
        this.temp += this.tempShift;
        this.temp <<= 1;
        this.alphaExp = BasicFunctions.norm(this.temp);
        this.temp <<= this.alphaExp;
        this.yHi = (short)(this.temp >> 16);
        this.tempShift = this.yHi << 16;
        this.yLow = (short)(this.temp - this.tempShift >> 1);
        this.i = 2;
        while (this.i <= order) {
            this.temp = 0;
            this.tempIndex1 = 302;
            this.tempIndex3 = 323;
            this.tempIndex4 = 363 + this.i;
            this.tempIndex5 = 342 + this.i;
            this.j = 1;
            while (this.j < this.i) {
                this.temp2 = this.tempShift = rHi[this.tempIndex1] * aLow[this.tempIndex4--] >> 15;
                this.tempShift = rLow[this.tempIndex3++] * aHi[this.tempIndex5] >> 15;
                this.temp2 += this.tempShift;
                this.temp += this.temp2 << 1;
                this.tempShift = rHi[this.tempIndex1++] * aHi[this.tempIndex5--] << 1;
                this.temp += this.tempShift;
                ++this.j;
            }
            this.temp <<= 4;
            this.tempShift = rHi[this.tempIndex1] << 16;
            this.temp += this.tempShift;
            this.tempShift = rLow[this.tempIndex3] << 1;
            this.temp += this.tempShift;
            this.temp2 = Math.abs(this.temp);
            this.temp3 = BasicFunctions.div(this.temp2, this.yHi, this.yLow);
            if (this.temp > 0) {
                this.temp3 = -this.temp3;
            }
            this.nBits = BasicFunctions.norm(this.temp3);
            this.temp3 = this.alphaExp <= this.nBits || this.temp3 == 0 ? (this.temp3 <<= this.alphaExp) : (this.temp3 > 0 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
            this.xHi = (short)(this.temp3 >> 16);
            this.tempShift = this.xHi << 16;
            this.xLow = (short)(this.temp3 - this.tempShift >> 1);
            K[kIndex++] = this.xHi;
            if (BasicFunctions.abs(this.xHi) > 32750) {
                return false;
            }
            this.tempIndex4 = 363 + this.i;
            this.tempIndex5 = 342 + this.i;
            this.tempIndex6 = 386;
            this.tempIndex7 = 407;
            this.tempIndex8 = 344;
            this.tempIndex9 = 365;
            this.j = 1;
            while (this.j < this.i) {
                this.temp = this.tempShift = aHi[this.tempIndex8++] << 16;
                this.tempShift = aLow[this.tempIndex9++] << 1;
                this.temp += this.tempShift;
                this.temp2 = this.tempShift = this.xLow * aHi[this.tempIndex5] >> 15;
                this.tempShift = this.xHi * aLow[this.tempIndex4--] >> 15;
                this.temp2 += this.tempShift;
                this.tempShift = this.xHi * aHi[this.tempIndex5--];
                this.temp2 += this.tempShift;
                this.temp += this.temp2 << 1;
                aUpdHi[this.tempIndex6] = (short)(this.temp >> 16);
                this.tempShift = aUpdHi[this.tempIndex6++] << 16;
                aUpdLow[this.tempIndex7++] = (short)(this.temp - this.tempShift >> 1);
                ++this.j;
            }
            this.temp3 >>= 4;
            aUpdHi[this.tempIndex6] = (short)(this.temp3 >> 16);
            this.tempShift = aUpdHi[this.tempIndex6] << 16;
            aUpdLow[this.tempIndex7] = (short)(this.temp3 - this.tempShift >> 1);
            this.tempShift = this.xHi * this.xLow >> 14;
            this.tempShift += this.xHi * this.xHi;
            this.temp = this.tempShift << 1;
            if (this.temp < 0) {
                this.temp = 0 - this.temp;
            }
            this.temp = Integer.MAX_VALUE - this.temp;
            this.tempS = (short)(this.temp >> 16);
            this.tempShift = this.tempS << 16;
            this.tempS2 = (short)(this.temp - this.tempShift >> 1);
            this.temp2 = this.tempShift = this.yHi * this.tempS2 >> 15;
            this.tempShift = this.yLow * this.tempS >> 15;
            this.temp2 += this.tempShift;
            this.tempShift = this.yHi * this.tempS;
            this.temp2 += this.tempShift;
            this.temp = this.temp2 << 1;
            this.nBits = BasicFunctions.norm(this.temp);
            this.temp <<= this.nBits;
            this.yHi = (short)(this.temp >> 16);
            this.tempShift = this.yHi << 16;
            this.yLow = (short)(this.temp - this.tempShift >> 1);
            this.alphaExp = (short)(this.alphaExp + this.nBits);
            this.tempIndex4 = 365;
            this.tempIndex5 = 344;
            this.tempIndex6 = 386;
            this.tempIndex7 = 407;
            this.j = 1;
            while (this.j <= this.i) {
                aHi[this.tempIndex5++] = aUpdHi[this.tempIndex6++];
                aLow[this.tempIndex4++] = aUpdLow[this.tempIndex7++];
                ++this.j;
            }
            ++this.i;
        }
        this.tempIndex1 = aIndex;
        A[this.tempIndex1++] = 4096;
        this.tempIndex5 = 344;
        this.tempIndex4 = 365;
        this.i = 1;
        while (this.i <= order) {
            this.temp = this.tempShift = aHi[this.tempIndex5++] << 16;
            this.tempShift = aLow[this.tempIndex4++] << 1;
            this.temp += this.tempShift;
            this.temp <<= 1;
            this.temp += 32768;
            A[this.tempIndex1++] = (short)(this.temp >> 16);
            ++this.i;
        }
        return true;
    }

    private void poly2Lsf(short[] lsf, int lsfIndex, short[] A, int aIndex) {
        short[] lsp = this.tempMemory;
        this.poly2Lsp(A, aIndex, lsp, 301);
        this.lspToLsf(lsp, 301, lsf, lsfIndex, 10);
    }

    private void poly2Lsp(short[] A, int aIndex, short[] lsp, int lspIndex) {
        short[] f = this.tempMemory;
        this.tempIndex1 = aIndex + 1;
        this.tempIndex2 = aIndex + 10;
        this.tempIndex3 = 311;
        this.tempIndex4 = 317;
        f[this.tempIndex3] = 1024;
        f[this.tempIndex4] = 1024;
        this.i = 0;
        while (this.i < 5) {
            this.tempShift = A[this.tempIndex1] + A[this.tempIndex2];
            this.tempShift >>= 2;
            f[this.tempIndex3 + 1] = (short)(this.tempShift - f[this.tempIndex3]);
            this.tempShift = A[this.tempIndex1] - A[this.tempIndex2];
            this.tempShift >>= 2;
            f[this.tempIndex4 + 1] = (short)(this.tempShift + f[this.tempIndex4]);
            ++this.tempIndex1;
            --this.tempIndex2;
            ++this.tempIndex3;
            ++this.tempIndex4;
            ++this.i;
        }
        this.tempIndex1 = 311;
        this.tempIndex2 = lspIndex;
        this.foundFreqs = 0;
        this.xLow = Constants.COS_GRID[0];
        this.yLow = this.chebushev(this.xLow, f, 311);
        this.j = 1;
        while (this.j < Constants.COS_GRID.length && this.foundFreqs < 10) {
            this.xHi = this.xLow;
            this.yHi = this.yLow;
            this.xLow = Constants.COS_GRID[this.j];
            this.yLow = this.chebushev(this.xLow, f, this.tempIndex1);
            if (this.yLow * this.yHi <= 0) {
                this.i = 0;
                while (this.i < 4) {
                    this.xMid = (short)((this.xLow >> 1) + (this.xHi >> 1));
                    this.yMid = this.chebushev(this.xMid, f, this.tempIndex1);
                    if (this.yLow * this.yMid <= 0) {
                        this.yHi = this.yMid;
                        this.xHi = this.xMid;
                    } else {
                        this.yLow = this.yMid;
                        this.xLow = this.xMid;
                    }
                    ++this.i;
                }
                this.x = (short)(this.xHi - this.xLow);
                this.y = (short)(this.yHi - this.yLow);
                if (this.y == 0) {
                    lsp[this.tempIndex2++] = this.xLow;
                } else {
                    this.temp2 = this.y;
                    this.y = BasicFunctions.abs(this.y);
                    this.nBits = (short)(BasicFunctions.norm(this.y) - 16);
                    this.y = (short)(this.y << this.nBits);
                    this.y = this.y != 0 ? (short)(536838144 / this.y) : (short)-1;
                    this.tempShift = this.x * this.y;
                    this.temp = this.tempShift >> 19 - this.nBits;
                    this.y = (short)(this.temp & 0xFFFF);
                    if (this.temp2 < 0) {
                        this.y = -this.y;
                    }
                    this.temp = this.yLow * this.y >> 10;
                    lsp[this.tempIndex2++] = (short)(this.xLow - this.temp & 0xFFFF);
                }
                ++this.foundFreqs;
                if (this.foundFreqs < 10) {
                    this.xLow = lsp[this.tempIndex2 - 1];
                    this.tempIndex1 = this.tempIndex1 == 311 ? 317 : 311;
                    this.yLow = this.chebushev(this.xLow, f, this.tempIndex1);
                }
            }
            ++this.j;
        }
        if (this.foundFreqs < 10) {
            System.arraycopy(Constants.LSP_MEAN, 0, lsp, lspIndex, 10);
        }
    }

    private void lspToLsf(short[] lsp, int lspIndex, short[] lsf, int lsfIndex, int coefsNumber) {
        this.j = 63;
        this.tempIndex1 = lspIndex + coefsNumber - 1;
        this.tempIndex2 = lsfIndex + coefsNumber - 1;
        this.i = coefsNumber - 1;
        while (this.i >= 0) {
            while (Constants.COS[this.j] < lsp[this.tempIndex1] && this.j > 0) {
                --this.j;
            }
            this.diff = (short)(lsp[this.tempIndex1--] - Constants.COS[this.j]);
            this.tempShift = Constants.ACOS_DERIVATIVE[this.j] * this.diff;
            this.tempS = (short)(this.tempShift >> 11);
            this.tempShift = this.j << 9;
            this.tempS2 = (short)(this.tempShift + this.tempS);
            this.tempShift = this.tempS2 * 25736;
            lsf[this.tempIndex2--] = (short)(this.tempShift >> 15);
            --this.i;
        }
    }

    private short chebushev(short value, short[] coefs, int coefsIndex) {
        this.b2 = 0x1000000;
        this.temp3 = value << 10;
        int n = ++coefsIndex;
        ++coefsIndex;
        this.temp3 += coefs[n] << 14;
        this.n = 2;
        while (this.n < 5) {
            this.temp4 = this.temp3;
            this.b1Hi = (short)(this.temp3 >> 16);
            this.tempShift = this.b1Hi << 16;
            this.b1Low = (short)(this.temp3 - this.tempShift >> 1);
            this.temp3 = this.tempShift = this.b1Low * value >> 15;
            this.tempShift = this.b1Hi * value;
            this.temp3 += this.tempShift;
            this.temp3 <<= 2;
            this.temp3 -= this.b2;
            this.temp3 += coefs[coefsIndex++] << 14;
            this.b2 = this.temp4;
            ++this.n;
        }
        this.b1Hi = (short)(this.temp3 >> 16);
        this.tempShift = this.b1Hi << 16;
        this.b1Low = (short)(this.temp3 - this.tempShift >> 1);
        this.tempShift = this.b1Low * value >> 15;
        this.temp3 = this.tempShift << 1;
        this.tempShift = this.b1Hi * value << 1;
        this.temp3 += this.tempShift;
        this.temp3 -= this.b2;
        this.temp3 += coefs[coefsIndex] << 13;
        if (this.temp3 > 33553408) {
            return Short.MAX_VALUE;
        }
        if (this.temp3 < -33554432) {
            return Short.MIN_VALUE;
        }
        return (short)(this.temp3 >> 10);
    }

    private void simpleLsfQ(short[] lsfdeq, int lsfdeqIndex, short[] lsfArray, int lsfArrrayIndex) {
        this.splitVq(lsfdeq, lsfdeqIndex, this.encoderBits.getLSF(), 0, lsfArray, lsfArrrayIndex);
        if (1 == 2) {
            this.splitVq(lsfdeq, lsfdeqIndex + 10, this.encoderBits.getLSF(), 3, lsfArray, lsfArrrayIndex + 10);
        }
    }

    private void splitVq(short[] qX, int qXIndex, short[] lsf, int lsfIndex, short[] X, int xIndex) {
        this.vq3(qX, qXIndex, lsf, lsfIndex, Constants.LSF_INDEX_CB[0], X, xIndex, Constants.LSF_SIZE_CB[0]);
        this.vq3(qX, qXIndex + Constants.LSF_DIM_CB[0], lsf, lsfIndex + 1, Constants.LSF_INDEX_CB[1], X, xIndex + Constants.LSF_DIM_CB[0], Constants.LSF_SIZE_CB[1]);
        this.vq4(qX, qXIndex + Constants.LSF_DIM_CB[0] + Constants.LSF_DIM_CB[1], lsf, lsfIndex + 2, Constants.LSF_INDEX_CB[2], X, xIndex + Constants.LSF_DIM_CB[0] + Constants.LSF_DIM_CB[1], Constants.LSF_SIZE_CB[2]);
    }

    private void vq3(short[] qX, int qXIndex, short[] lsf, int lsfIndex, int cbIndex, short[] X, int xIndex, int cbSize) {
        this.minValue = Integer.MAX_VALUE;
        this.tempIndex2 = cbIndex;
        this.tempIndex5 = 0;
        this.j = 0;
        while (this.j < cbSize) {
            this.tempIndex3 = xIndex;
            this.tempS = (short)(X[this.tempIndex3++] - Constants.LSF_CB[this.tempIndex2++]);
            this.temp = this.tempS * this.tempS;
            this.tempS = (short)(X[this.tempIndex3++] - Constants.LSF_CB[this.tempIndex2++]);
            this.tempShift = this.tempS * this.tempS;
            this.temp += this.tempShift;
            this.tempS = (short)(X[this.tempIndex3++] - Constants.LSF_CB[this.tempIndex2++]);
            this.tempShift = this.tempS * this.tempS;
            this.temp += this.tempShift;
            if (this.temp < this.minValue) {
                this.minValue = this.temp;
                this.tempIndex5 = this.j;
            }
            ++this.j;
        }
        this.tempIndex1 = qXIndex;
        lsf[lsfIndex] = (short)this.tempIndex5;
        this.tempIndex5 *= 3;
        this.tempIndex5 += cbIndex;
        this.i = 0;
        while (this.i < 3) {
            qX[this.tempIndex1++] = Constants.LSF_CB[this.tempIndex5++];
            ++this.i;
        }
    }

    private void vq4(short[] qX, int qXIndex, short[] lsf, int lsfIndex, int cbIndex, short[] X, int xIndex, int cbSize) {
        this.minValue = Integer.MAX_VALUE;
        this.tempIndex2 = cbIndex;
        this.tempIndex5 = 0;
        this.j = 0;
        while (this.j < cbSize) {
            this.tempIndex3 = xIndex;
            this.tempS = (short)(X[this.tempIndex3++] - Constants.LSF_CB[this.tempIndex2++]);
            this.temp = this.tempS * this.tempS;
            this.i = 1;
            while (this.i < 4) {
                this.tempS = (short)(X[this.tempIndex3++] - Constants.LSF_CB[this.tempIndex2++]);
                this.temp += this.tempS * this.tempS;
                ++this.i;
            }
            if (this.temp < this.minValue) {
                this.minValue = this.temp;
                this.tempIndex5 = this.j;
            }
            ++this.j;
        }
        this.tempIndex1 = qXIndex;
        lsf[lsfIndex] = (short)this.tempIndex5;
        this.tempIndex5 *= 4;
        this.tempIndex5 += cbIndex;
        this.i = 0;
        while (this.i < 4) {
            qX[this.tempIndex1++] = Constants.LSF_CB[this.tempIndex5++];
            ++this.i;
        }
    }

    private void lsfCheck(short[] lsf, int lsfIndex, int lsfSize) {
        this.n = 0;
        while (this.n < 2) {
            this.j = 0;
            while (true) {
                if (this.j >= 1) break;
                this.k = 0;
                while (this.k < lsfSize - 1) {
                    this.tempIndex1 = lsfIndex + this.j * lsfSize + this.k;
                    this.tempIndex2 = this.tempIndex1 + 1;
                    if (lsf[this.tempIndex2] - lsf[this.tempIndex1] < 319) {
                        if (lsf[this.tempIndex2] < lsf[this.tempIndex1]) {
                            lsf[this.tempIndex2] = (short)(lsf[this.tempIndex1] + 160);
                            lsf[this.tempIndex1] = (short)(lsf[this.tempIndex2] - 160);
                        } else {
                            int n = this.tempIndex1;
                            lsf[n] = (short)(lsf[n] - 160);
                            int n2 = this.tempIndex2;
                            lsf[n2] = (short)(lsf[n2] + 160);
                        }
                    }
                    if (lsf[this.tempIndex1] < 82) {
                        lsf[this.tempIndex1] = 82;
                    }
                    if (lsf[this.tempIndex1] > 25723) {
                        lsf[this.tempIndex1] = 25723;
                    }
                    ++this.k;
                }
                ++this.j;
            }
            ++this.n;
        }
    }

    private void simpleInterpolateLsf(short[] synthdenum, int synthDenumIndex, short[] weightDenum, int weightDenumIndex, short[] lsf, int lsfIndex, short[] lsfDeq, int lsfDeqIndex, int length) {
        short[] lsfOld = this.encoderState.getLsfOld();
        short[] lsfDeqOld = this.encoderState.getLsfDeqOld();
        short[] lp = this.tempMemory;
        this.tempIndex1 = lsfIndex + length;
        this.tempIndex2 = lsfDeqIndex + length;
        this.temp = length + 1;
        if (20 == 30) {
            this.lsfInterpolate2PolyEnc(lp, (short)40, lsfDeqOld, 0, lsfDeq, lsfDeqIndex, Constants.LSF_WEIGHT_30MS[0], length);
            System.arraycopy(lp, 40, synthdenum, synthDenumIndex, this.temp);
            this.lsfInterpolate2PolyEnc(lp, (short)40, lsfOld, 0, lsf, lsfIndex, Constants.LSF_WEIGHT_30MS[0], length);
            BasicFunctions.expand(weightDenum, weightDenumIndex, lp, 40, Constants.LPC_CHIRP_WEIGHT_DENUM, this.temp);
            this.index = this.temp;
            this.i = 1;
            while (true) {
                if (this.i >= 4) break;
                this.lsfInterpolate2PolyEnc(lp, (short)40, lsfDeq, lsfDeqIndex, lsfDeq, this.tempIndex2, Constants.LSF_WEIGHT_30MS[this.i], length);
                System.arraycopy(lp, 40, synthdenum, synthDenumIndex + this.index, this.temp);
                this.lsfInterpolate2PolyEnc(lp, (short)40, lsf, lsfIndex, lsf, this.tempIndex1, Constants.LSF_WEIGHT_30MS[this.i], length);
                BasicFunctions.expand(weightDenum, weightDenumIndex + this.index, lp, 40, Constants.LPC_CHIRP_WEIGHT_DENUM, this.temp);
                this.index += this.temp;
                ++this.i;
            }
            System.arraycopy(lsf, this.tempIndex1, lsfOld, 0, length);
            System.arraycopy(lsfDeq, this.tempIndex2, lsfDeqOld, 0, length);
        } else {
            this.index = 0;
            this.i = 0;
            while (true) {
                if (this.i >= 4) break;
                this.lsfInterpolate2PolyEnc(lp, (short)40, lsfDeqOld, 0, lsfDeq, lsfDeqIndex, Constants.LSF_WEIGHT_20MS[this.i], length);
                System.arraycopy(lp, 40, synthdenum, synthDenumIndex + this.index, this.temp);
                this.lsfInterpolate2PolyEnc(lp, (short)40, lsfOld, 0, lsf, lsfIndex, Constants.LSF_WEIGHT_20MS[this.i], length);
                BasicFunctions.expand(weightDenum, weightDenumIndex + this.index, lp, 40, Constants.LPC_CHIRP_WEIGHT_DENUM, this.temp);
                this.index += this.temp;
                ++this.i;
            }
            System.arraycopy(lsf, lsfIndex, lsfOld, 0, length);
            System.arraycopy(lsfDeq, lsfDeqIndex, lsfDeqOld, 0, length);
        }
    }

    private void lsfInterpolate2PolyEnc(short[] a, short aIndex, short[] lsf1, int lsf1Index, short[] lsf2, int lsf2Index, short coef, int length) {
        short[] lsfTemp = this.tempMemory;
        this.interpolate(lsfTemp, 51, lsf1, lsf1Index, lsf2, lsf2Index, coef, length);
        this.lsf2Poly(a, aIndex, lsfTemp, 51);
    }

    private void interpolate(short[] out, int outIndex, short[] in1, int in1Index, short[] in2, int in2Index, short coef, int length) {
        this.tempIndex3 = outIndex;
        this.tempIndex4 = in1Index;
        this.tempIndex5 = in2Index;
        this.tempS = (short)(16384 - coef);
        this.k = 0;
        while (this.k < length) {
            out[this.tempIndex3++] = (short)(coef * in1[this.tempIndex4++] + this.tempS * in2[this.tempIndex5++] + 8192 >> 14);
            ++this.k;
        }
    }

    private void lsf2Poly(short[] a, int aIndex, short[] lsf, int lsfIndex) {
        int[] f = this.tempLMemory;
        this.tempIndex3 = 0;
        this.tempIndex4 = 6;
        short[] lsp = this.tempMemory;
        this.lsf2Lsp(lsf, lsfIndex, lsp, 61, 10);
        this.getLspPoly(lsp, 61, f, 0);
        this.getLspPoly(lsp, 62, f, 6);
        this.tempIndex3 = 5;
        this.tempIndex4 = 11;
        this.k = 5;
        while (this.k > 0) {
            int n = this.tempIndex3;
            f[n] = f[n] + f[this.tempIndex3 - 1];
            int n2 = this.tempIndex4;
            f[n2] = f[n2] - f[this.tempIndex4 - 1];
            --this.tempIndex3;
            --this.tempIndex4;
            --this.k;
        }
        a[aIndex] = 4096;
        this.tempIndex5 = aIndex + 1;
        this.tempIndex6 = aIndex + 10;
        this.tempIndex3 = 1;
        this.tempIndex4 = 7;
        this.k = 5;
        while (this.k > 0) {
            this.temp2 = f[this.tempIndex3] + f[this.tempIndex4];
            a[this.tempIndex5++] = (short)(this.temp2 + 4096 >> 13);
            this.temp2 = f[this.tempIndex3] - f[this.tempIndex4];
            ++this.tempIndex3;
            ++this.tempIndex4;
            a[this.tempIndex6--] = (short)(this.temp2 + 4096 >> 13);
            --this.k;
        }
    }

    private void lsf2Lsp(short[] lsf, int lsfIndex, short[] lsp, int lspIndex, int count) {
        this.tempIndex6 = lspIndex;
        this.j = 0;
        while (this.j < count) {
            this.tempS = (short)(lsf[lsfIndex++] * 20861 >> 15);
            this.tempS2 = (short)(this.tempS >> 8);
            this.tempS = (short)(this.tempS & 0xFF);
            if (this.tempS2 > 63 || this.tempS2 < 0) {
                this.tempS2 = (short)63;
            }
            this.temp2 = Constants.COS_DERIVATIVE[this.tempS2] * this.tempS;
            this.temp2 >>= 12;
            lsp[lspIndex++] = (short)(this.temp2 + Constants.COS[this.tempS2]);
            ++this.j;
        }
    }

    private void getLspPoly(short[] lsp, int lspIndex, int[] f, int fIndex) {
        this.tempIndex5 = lspIndex;
        this.tempIndex6 = fIndex;
        f[this.tempIndex6++] = 0x1000000;
        f[this.tempIndex6++] = lsp[this.tempIndex5] * -1024;
        this.tempIndex5 += 2;
        this.k = 2;
        while (this.k <= 5) {
            f[this.tempIndex6] = f[this.tempIndex6 - 2];
            this.j = this.k;
            while (this.j > 1) {
                this.xHi = (short)(f[this.tempIndex6 - 1] >> 16);
                this.tempShift = this.xHi << 16;
                this.xLow = (short)(f[this.tempIndex6 - 1] - this.tempShift >> 1);
                this.temp2 = this.tempShift = this.xHi * lsp[this.tempIndex5] << 2;
                this.tempShift = this.xLow * lsp[this.tempIndex5] >> 15 << 2;
                this.temp2 += this.tempShift;
                int n = this.tempIndex6;
                f[n] = f[n] + f[this.tempIndex6 - 2];
                int n2 = this.tempIndex6--;
                f[n2] = f[n2] - this.temp2;
                --this.j;
            }
            int n = this.tempIndex6;
            f[n] = f[n] - (lsp[this.tempIndex5] << 10);
            this.tempIndex6 += this.k;
            this.tempIndex5 += 2;
            ++this.k;
        }
    }

    private short frameClassify(short[] residual) {
        int[] ssqEn = this.tempLMemory;
        this.max = 0;
        this.n = 0;
        while (true) {
            if (this.n >= 160) break;
            this.tempS = residual[this.n];
            if (this.tempS < 0) {
                this.tempS = (short)(0 - this.tempS);
            }
            if (this.tempS > this.max) {
                this.max = this.tempS;
            }
            ++this.n;
        }
        this.scale = (short)(BasicFunctions.getSize(this.max * this.max) - 24);
        if (this.scale < 0) {
            this.scale = 0;
        }
        this.tempIndex1 = 2;
        this.tempIndex2 = 0;
        this.n = 4 - 1;
        while (this.n > 0) {
            ssqEn[this.tempIndex2++] = BasicFunctions.scaleRight(residual, this.tempIndex1, residual, this.tempIndex1, 76, this.scale);
            this.tempIndex1 += 40;
            --this.n;
        }
        this.tempIndex2 = 0;
        this.temp2 = ssqEn[this.tempIndex2++];
        this.n = 1;
        while (true) {
            if (this.n >= 4 - 1) break;
            if (ssqEn[this.tempIndex2] > this.temp2) {
                this.temp2 = ssqEn[this.tempIndex2];
            }
            ++this.tempIndex2;
            ++this.n;
        }
        this.scale = (short)(BasicFunctions.getSize(this.temp2) - 20);
        if (this.scale < 0) {
            this.scale = 0;
        }
        this.tempIndex2 = 0;
        this.tempIndex1 = 20 == 20 ? 1 : 0;
        this.n = 4 - 1;
        while (this.n > 0) {
            ssqEn[this.tempIndex2] = (ssqEn[this.tempIndex2] >> this.scale) * Constants.ENG_START_SEQUENCE[this.tempIndex1++];
            ++this.tempIndex2;
            --this.n;
        }
        this.tempIndex1 = 0;
        this.tempIndex2 = 0;
        this.temp2 = ssqEn[this.tempIndex2++];
        this.n = 1;
        while (true) {
            if (this.n >= 4 - 1) break;
            if (ssqEn[this.tempIndex2] > this.temp2) {
                this.tempIndex1 = this.tempIndex2;
                this.temp2 = ssqEn[this.tempIndex2];
            }
            ++this.tempIndex2;
            ++this.n;
        }
        return (short)(this.tempIndex1 + 1);
    }

    private void stateSearch(short[] residual, int residualIndex, short[] syntDenum, int syntIndex, short[] weightDenum, int weightIndex) {
        short[] numerator = this.tempMemory;
        short[] residualLongVec = this.tempMemory;
        short[] sampleMa = this.tempMemory;
        short[] residualLong = this.tempMemory;
        short[] sampleAr = this.tempMemory;
        this.tempIndex1 = residualIndex;
        this.max = 0;
        this.n = 0;
        while (true) {
            if (this.n >= 57) break;
            this.tempS = residual[this.tempIndex1++];
            if (this.tempS < 0) {
                this.tempS = (short)(0 - this.tempS);
            }
            if (this.tempS > this.max) {
                this.max = this.tempS;
            }
            ++this.n;
        }
        this.tempS = (short)(BasicFunctions.getSize(this.max) - 12);
        if (this.tempS < 0) {
            this.tempS = 0;
        }
        this.tempIndex1 = syntIndex + 10;
        this.i = 0;
        while (this.i < 11) {
            numerator[this.i] = (short)(syntDenum[this.tempIndex1--] >> this.tempS);
            ++this.i;
        }
        System.arraycopy(residual, residualIndex, residualLong, 21, 57);
        this.tempIndex1 = 21 + 57;
        this.i = 0;
        while (true) {
            if (this.i >= 57) break;
            residualLong[this.tempIndex1++] = 0;
            ++this.i;
        }
        this.tempIndex1 = 11;
        this.i = 0;
        while (this.i < 10) {
            residualLongVec[this.tempIndex1++] = 0;
            ++this.i;
        }
        BasicFunctions.filterMA(residualLong, 21, sampleMa, 137, numerator, 0, 11, 57 + 10);
        this.tempIndex1 = 137 + 57 + 10;
        this.i = 0;
        while (true) {
            if (this.i >= 57 - 10) break;
            sampleMa[this.tempIndex1++] = 0;
            ++this.i;
        }
        BasicFunctions.filterAR(sampleMa, 137, sampleAr, 21, syntDenum, syntIndex, 11, 2 * 57);
        this.tempIndex1 = 21;
        this.tempIndex2 = 21 + 57;
        this.i = 0;
        while (true) {
            if (this.i >= 57) break;
            int n = this.tempIndex1++;
            sampleAr[n] = (short)(sampleAr[n] + sampleAr[this.tempIndex2++]);
            ++this.i;
        }
        this.max = 0;
        this.tempIndex1 = 21;
        this.n = 0;
        while (true) {
            if (this.n >= 57) break;
            this.tempS2 = sampleAr[this.tempIndex1++];
            if (this.tempS2 < 0) {
                this.tempS2 = (short)(0 - this.tempS2);
            }
            if (this.tempS2 > this.max) {
                this.max = this.tempS2;
            }
            ++this.n;
        }
        this.temp2 = this.max << this.tempS < 23170 ? this.max * this.max << 2 + 2 * this.tempS : Integer.MAX_VALUE;
        this.index = 0;
        this.i = 0;
        while (this.i < 63) {
            if (this.temp2 >= Constants.CHOOSE_FRG_QUANT[this.i]) {
                this.index = this.i + 1;
            } else {
                this.i = 63;
            }
            ++this.i;
        }
        this.encoderBits.setIdxForMax((short)this.index);
        this.scale = Constants.SCALE[this.index];
        this.nBits = this.index < 27 ? (short)4 : (short)9;
        BasicFunctions.scaleVector(sampleAr, 21, sampleAr, 21, this.scale, 57, this.nBits - this.tempS);
        this.absQuant(sampleAr, 21, weightDenum, weightIndex);
    }

    private void absQuant(short[] in, int inIndex, short[] weightDenum, int weightDenumIndex) {
        short[] quantLen = this.tempMemory;
        short[] syntOutBuf = this.tempMemory;
        short[] inWeightedVec = this.tempMemory;
        short[] inWeighted = this.tempMemory;
        this.tempIndex1 = 255;
        this.i = 0;
        while (this.i < 68) {
            syntOutBuf[this.tempIndex1++] = 0;
            ++this.i;
        }
        this.tempIndex1 = 265;
        this.tempIndex2 = 323;
        this.i = 0;
        while (this.i < 10) {
            inWeightedVec[this.tempIndex2++] = 0;
            ++this.i;
        }
        if (this.encoderBits.getStateFirst()) {
            quantLen[253] = 40;
            quantLen[254] = (short)(57 - 40);
        } else {
            quantLen[253] = (short)(57 - 40);
            quantLen[254] = 40;
        }
        BasicFunctions.filterAR(in, inIndex, inWeighted, 333, weightDenum, weightDenumIndex, 11, quantLen[253]);
        BasicFunctions.filterAR(in, inIndex + quantLen[253], inWeighted, 333 + quantLen[253], weightDenum, weightDenumIndex + 11, 11, quantLen[254]);
        this.absQUantLoop(syntOutBuf, this.tempIndex1, inWeighted, 333, weightDenum, weightDenumIndex, quantLen, 253);
    }

    private void absQUantLoop(short[] syntOut, int syntOutIndex, short[] inWeighted, int inWeightedIndex, short[] weightDenum, int weightDenumIndex, short[] quantLen, int quantLenIndex) {
        short[] idxVec = this.encoderBits.getIdxVec();
        int startIndex = 0;
        this.i = 0;
        while (this.i < 2) {
            this.tempIndex3 = quantLenIndex + this.i;
            this.j = 0;
            while (this.j < quantLen[this.tempIndex3]) {
                BasicFunctions.filterAR(syntOut, syntOutIndex, syntOut, syntOutIndex, weightDenum, weightDenumIndex, 11, 1);
                this.temp = inWeighted[inWeightedIndex] - syntOut[syntOutIndex];
                this.temp2 = this.temp << 2;
                if (this.temp2 > Short.MAX_VALUE) {
                    this.temp2 = Short.MAX_VALUE;
                } else if (this.temp2 < Short.MIN_VALUE) {
                    this.temp2 = Short.MIN_VALUE;
                }
                if (this.temp < -7577) {
                    this.index = 0;
                } else if (this.temp > 8151) {
                    this.index = 7;
                } else if (this.temp2 <= Constants.STATE_SQ3[0]) {
                    this.index = 0;
                } else {
                    this.k = 0;
                    while (this.temp2 > Constants.STATE_SQ3[this.k] && this.k < Constants.STATE_SQ3.length - 1) {
                        ++this.k;
                    }
                    this.tempShift = Constants.STATE_SQ3[this.k] + Constants.STATE_SQ3[this.k - 1] + 1;
                    this.index = this.temp2 > this.tempShift >> 1 ? this.k : this.k - 1;
                }
                idxVec[startIndex + this.j] = (short)this.index;
                this.tempShift = Constants.STATE_SQ3[this.index] + 2;
                this.tempS = (short)(this.tempShift >> 2);
                syntOut[syntOutIndex++] = (short)(this.tempS + inWeighted[inWeightedIndex++] - this.temp);
                ++this.j;
            }
            startIndex += quantLen[this.tempIndex3];
            weightDenumIndex += 11;
            ++this.i;
        }
    }

    private void stateConstruct(short[] syntDenum, int syntDenumIndex, short[] outFix, int outFixIndex) {
        short[] numerator = this.tempMemory;
        short[] sampleValVec = this.tempMemory;
        short[] sampleMaVec = this.tempMemory;
        short[] sampleVal = this.tempMemory;
        short[] sampleMa = this.tempMemory;
        short[] sampleAr = this.tempMemory;
        short[] idxVec = this.encoderBits.getIdxVec();
        this.tempIndex1 = 0;
        this.tempIndex2 = syntDenumIndex + 10;
        this.k = 0;
        while (this.k < 11) {
            numerator[this.tempIndex1++] = syntDenum[this.tempIndex2--];
            ++this.k;
        }
        this.max = Constants.FRQ_QUANT_MOD[this.encoderBits.getIdxForMax()];
        this.tempIndex1 = 21;
        this.tempIndex2 = 57 - 1;
        if (this.encoderBits.getIdxForMax() < 37) {
            this.k = 0;
            while (true) {
                if (this.k < 57) {
                    sampleVal[this.tempIndex1++] = (short)(this.max * Constants.STATE_SQ3[idxVec[this.tempIndex2--]] + 0x200000 >> 22);
                    ++this.k;
                    continue;
                }
                break;
            }
        } else if (this.encoderBits.getIdxForMax() < 59) {
            this.k = 0;
            while (true) {
                if (this.k < 57) {
                    sampleVal[this.tempIndex1++] = (short)(this.max * Constants.STATE_SQ3[idxVec[this.tempIndex2--]] + 262144 >> 19);
                    ++this.k;
                    continue;
                }
                break;
            }
        } else {
            this.k = 0;
            while (true) {
                if (this.k >= 57) break;
                sampleVal[this.tempIndex1++] = (short)(this.max * Constants.STATE_SQ3[idxVec[this.tempIndex2--]] + 65536 >> 17);
                ++this.k;
            }
        }
        this.tempIndex1 = 21 + 57;
        this.i = 0;
        while (true) {
            if (this.i >= 57) break;
            sampleVal[this.tempIndex1++] = 0;
            ++this.i;
        }
        this.tempIndex1 = 11;
        this.i = 0;
        while (this.i < 10) {
            sampleValVec[this.tempIndex1++] = 0;
            ++this.i;
        }
        BasicFunctions.filterMA(sampleVal, 21, sampleMa, 147, numerator, 0, 11, 11 + 57);
        this.tempIndex1 = 157 + 57;
        this.i = 0;
        while (true) {
            if (this.i >= 57 - 10) break;
            sampleMa[this.tempIndex1++] = 0;
            ++this.i;
        }
        BasicFunctions.filterAR(sampleMa, 147, sampleAr, 21, syntDenum, syntDenumIndex, 11, 2 * 57);
        this.tempIndex1 = 21 + 57 - 1;
        this.tempIndex2 = 21 + 2 * 57 - 1;
        this.tempIndex3 = outFixIndex;
        this.k = 0;
        while (true) {
            if (this.k >= 57) break;
            outFix[this.tempIndex3++] = (short)(sampleAr[this.tempIndex1--] + sampleAr[this.tempIndex2--]);
            ++this.k;
        }
    }

    private void cbSearch(short[] inTarget, int inTargetIndex, short[] decResidual, int decResidualIndex, int length, int vectorLength, short[] weightDenum, int weightDenumindex, int blockNumber, int cbIndexIndex, int gainIndexIndex) {
        short[] cbIndex = this.encoderBits.getCbIndex();
        short[] gainIndex = this.encoderBits.getGainIndex();
        short[] gains = this.tempMemory;
        short[] cbBuf = this.tempMemory;
        short[] energyShifts = this.tempMemory;
        short[] targetVec = this.tempMemory;
        short[] cbVectors = this.tempMemory;
        short[] codedVec = this.tempMemory;
        short[] interpSamples = this.tempMemory;
        short[] interSamplesFilt = this.tempMemory;
        short[] energy = this.tempMemory;
        short[] augVec = this.tempMemory;
        short[] inverseEnergy = this.tempMemory;
        short[] inverseEnergyShifts = this.tempMemory;
        short[] buf = this.tempMemory;
        short[] target = this.tempMemory;
        int[] cDot = this.tempLMemory;
        int[] crit = this.tempLMemory;
        Arrays.fill(this.tempLMemory, 0, 256, 0);
        Arrays.fill(this.tempMemory, 0, 1330, (short)0);
        this.baseSize = (short)(length - vectorLength + 1);
        if (vectorLength == 40) {
            this.baseSize = (short)(length - 19);
        }
        this.temp = length - Constants.FILTER_RANGE[blockNumber];
        BasicFunctions.filterAR(decResidual, decResidualIndex + this.temp, buf, 14 + this.temp, weightDenum, weightDenumindex, 11, Constants.FILTER_RANGE[blockNumber]);
        System.arraycopy(buf, 4 + length, target, 421, 10);
        BasicFunctions.filterAR(inTarget, inTargetIndex, target, 431, weightDenum, weightDenumindex, 11, vectorLength);
        System.arraycopy(target, 431, codedVec, 618, vectorLength);
        this.tempIndex1 = 14;
        this.tempS = 0;
        this.i = 0;
        while (this.i < length) {
            if (buf[this.tempIndex1] > 0 && buf[this.tempIndex1] > this.tempS) {
                this.tempS = buf[this.tempIndex1];
            } else if (0 - buf[this.tempIndex1] > this.tempS) {
                this.tempS = (short)(0 - buf[this.tempIndex1]);
            }
            ++this.tempIndex1;
            ++this.i;
        }
        this.tempIndex1 = 431;
        this.tempS2 = 0;
        this.i = 0;
        while (this.i < vectorLength) {
            if (target[this.tempIndex1] > 0 && target[this.tempIndex1] > this.tempS2) {
                this.tempS2 = target[this.tempIndex1];
            } else if (0 - target[this.tempIndex1] > this.tempS2) {
                this.tempS2 = (short)(0 - target[this.tempIndex1]);
            }
            ++this.tempIndex1;
            ++this.i;
        }
        if (this.tempS > 0 && this.tempS2 > 0) {
            if (this.tempS2 > this.tempS) {
                this.tempS = this.tempS2;
            }
            this.scale = BasicFunctions.getSize(this.tempS * this.tempS);
        } else {
            this.scale = (short)30;
        }
        this.scale = (short)(this.scale - 25);
        if (this.scale < 0) {
            this.scale = 0;
        }
        this.scale2 = this.scale;
        this.targetEner = BasicFunctions.scaleRight(target, 431, target, 431, vectorLength, this.scale2);
        this.filteredCBVecs(cbVectors, 471, buf, 14, length, Constants.FILTER_RANGE[blockNumber]);
        this.range = Constants.SEARCH_RANGE[blockNumber][0];
        if (vectorLength == 40) {
            this.interpolateSamples(interpSamples, 658, buf, 14, length);
            this.interpolateSamples(interSamplesFilt, 738, cbVectors, 471, length);
            this.cbMemEnergyAugmentation(interpSamples, 658, buf, 14, this.scale2, (short)20, energy, 818, energyShifts, 165);
            this.cbMemEnergyAugmentation(interSamplesFilt, 738, cbVectors, 471, this.scale2, (short)(this.baseSize + 20), energy, 818, energyShifts, 165);
            this.cbMemEnergy(this.range, buf, 14, cbVectors, 471, (short)length, (short)vectorLength, energy, 838, energyShifts, 185, this.scale2, this.baseSize);
        } else {
            this.cbMemEnergy(this.range, buf, 14, cbVectors, 471, (short)length, (short)vectorLength, energy, 818, energyShifts, 165, this.scale2, this.baseSize);
        }
        this.energyInverse(energy, 818, this.baseSize * 2);
        gains[0] = 16384;
        this.stage = 0;
        while (this.stage < 3) {
            this.range = Constants.SEARCH_RANGE[blockNumber][this.stage];
            this.updateIndexData.setCritMax(0);
            this.updateIndexData.setShTotMax((short)-100);
            this.updateIndexData.setBestIndex((short)0);
            this.updateIndexData.setBestGain((short)0);
            this.tempIndex2 = 14 + length - vectorLength;
            if (vectorLength == 40) {
                this.augmentCbCorr(target, 431, buf, 14 + length, interpSamples, 658, cDot, 0, 20, 39, this.scale2);
                this.tempIndex1 = 20;
            } else {
                this.tempIndex1 = 0;
            }
            this.crossCorrelation(cDot, this.tempIndex1, target, 431, buf, this.tempIndex2, (short)vectorLength, this.range, this.scale2, (short)-1);
            this.range = vectorLength == 40 ? (short)(Constants.SEARCH_RANGE[blockNumber][this.stage] + 20) : Constants.SEARCH_RANGE[blockNumber][this.stage];
            this.cbSearchCore(cDot, 0, this.range, (short)this.stage, inverseEnergy, 818, inverseEnergyShifts, 165, crit, 128);
            this.updateBestIndex(this.searchData.getCritNew(), this.searchData.getCritNewSh(), this.searchData.getIndexNew(), cDot[this.searchData.getIndexNew()], inverseEnergy[818 + this.searchData.getIndexNew()], inverseEnergyShifts[165 + this.searchData.getIndexNew()]);
            this.sInd = (short)(this.updateIndexData.getBestIndex() - 17);
            this.eInd = (short)(this.sInd + 34);
            if (this.sInd < 0) {
                this.eInd = (short)(this.eInd - this.sInd);
                this.sInd = 0;
            }
            if (this.eInd >= this.range) {
                this.eInd = (short)(this.range - 1);
                this.sInd = (short)(this.eInd - 34);
            }
            this.range = Constants.SEARCH_RANGE[blockNumber][this.stage];
            if (vectorLength == 40) {
                this.i = this.sInd;
                if (this.sInd < 20) {
                    if (this.eInd + 20 > 39) {
                        this.augmentCbCorr(target, 431, cbVectors, 471 + length, interSamplesFilt, 738, cDot, 0, this.sInd + 20, 39, this.scale2);
                    } else {
                        this.augmentCbCorr(target, 431, cbVectors, 471 + length, interSamplesFilt, 738, cDot, 0, this.sInd + 20, this.eInd + 20, this.scale2);
                    }
                    this.i = 20;
                }
                this.tempIndex1 = 20 - this.sInd > 0 ? 20 - this.sInd : 0;
                this.tempIndex2 = 451 + length - this.i;
                this.crossCorrelation(cDot, this.tempIndex1, target, 431, cbVectors, this.tempIndex2, (short)vectorLength, (short)(this.eInd - this.i + 1), this.scale2, (short)-1);
            } else {
                this.tempIndex1 = 0;
                this.tempIndex2 = 471 + length - vectorLength - this.sInd;
                this.crossCorrelation(cDot, this.tempIndex1, target, 431, cbVectors, this.tempIndex2, (short)vectorLength, (short)(this.eInd - this.sInd + 1), this.scale2, (short)-1);
            }
            this.cbSearchCore(cDot, 0, (short)(this.eInd - this.sInd + 1), (short)this.stage, inverseEnergy, 818 + this.baseSize + this.sInd, inverseEnergyShifts, 165 + this.baseSize + this.sInd, crit, 128);
            this.updateBestIndex(this.searchData.getCritNew(), this.searchData.getCritNewSh(), (short)(this.searchData.getIndexNew() + this.baseSize + this.sInd), cDot[this.searchData.getIndexNew()], inverseEnergy[818 + this.searchData.getIndexNew() + this.baseSize + this.sInd], inverseEnergyShifts[165 + this.searchData.getIndexNew() + this.baseSize + this.sInd]);
            cbIndex[cbIndexIndex + this.stage] = this.updateIndexData.getBestIndex();
            if (gains[this.stage] > 0) {
                this.updateIndexData.setBestGain(this.gainQuant(this.updateIndexData.getBestGain(), gains[this.stage], (short)this.stage, gainIndex, gainIndexIndex + this.stage));
            } else {
                this.updateIndexData.setBestGain(this.gainQuant(this.updateIndexData.getBestGain(), (short)(0 - gains[this.stage]), (short)this.stage, gainIndex, gainIndexIndex + this.stage));
            }
            if (vectorLength == 80 - 57) {
                this.tempIndex3 = cbIndex[cbIndexIndex + this.stage] < this.baseSize ? 14 + length - vectorLength - cbIndex[cbIndexIndex + this.stage] : 471 + length - vectorLength - cbIndex[cbIndexIndex + this.stage] + this.baseSize;
            } else if (cbIndex[cbIndexIndex + this.stage] < this.baseSize) {
                if (cbIndex[cbIndexIndex + this.stage] >= 20) {
                    int n = cbIndexIndex + this.stage;
                    cbIndex[n] = (short)(cbIndex[n] - 20);
                    this.tempIndex3 = 14 + length - vectorLength - cbIndex[cbIndexIndex + this.stage];
                } else {
                    int n = cbIndexIndex + this.stage;
                    cbIndex[n] = (short)(cbIndex[n] + (this.baseSize - 20));
                    this.createAugmentVector((short)(cbIndex[cbIndexIndex + this.stage] - this.baseSize + 40), buf, 14 + length, augVec, 1074);
                    this.tempIndex3 = 1074;
                }
            } else if (cbIndex[cbIndexIndex + this.stage] - this.baseSize >= 20) {
                int n = cbIndexIndex + this.stage;
                cbIndex[n] = (short)(cbIndex[n] - 20);
                this.tempIndex3 = 471 + length - vectorLength - cbIndex[cbIndexIndex + this.stage] + this.baseSize;
            } else {
                int n = cbIndexIndex + this.stage;
                cbIndex[n] = (short)(cbIndex[n] + (this.baseSize - 20));
                this.createAugmentVector((short)(cbIndex[cbIndexIndex + this.stage] - 2 * this.baseSize + 40), cbVectors, 471 + length, augVec, 1074);
                this.tempIndex3 = 1074;
            }
            BasicFunctions.addAffineVectorToVector(target, 431, buf, this.tempIndex3, (short)(0 - this.updateIndexData.getBestGain()), 8192, (short)14, vectorLength);
            gains[this.stage + 1] = this.updateIndexData.getBestGain();
            ++this.stage;
        }
        this.tempIndex1 = 618;
        this.tempIndex2 = 431;
        this.i = 0;
        while (this.i < vectorLength) {
            int n = this.tempIndex1++;
            codedVec[n] = (short)(codedVec[n] - target[this.tempIndex2++]);
            ++this.i;
        }
        this.codedEner = BasicFunctions.scaleRight(codedVec, 618, codedVec, 618, vectorLength, this.scale2);
        this.j = gainIndex[gainIndexIndex + 0];
        this.tempS = BasicFunctions.norm(this.codedEner);
        this.tempS2 = BasicFunctions.norm(this.targetEner);
        this.nBits = this.tempS < this.temp2 ? (short)(16 - this.tempS) : (short)(16 - this.tempS2);
        this.tempShift = gains[1] * gains[1] >> 14;
        this.targetEner = this.nBits < 0 ? (this.targetEner << 0 - this.nBits) * this.tempShift : (this.targetEner >> this.nBits) * this.tempShift;
        this.temp = gains[1] - 1 << 1;
        this.j = gainIndex[gainIndexIndex];
        this.tempS = this.nBits < 0 ? (short)(this.codedEner << -this.nBits) : (short)(this.codedEner >> this.nBits);
        this.i = gainIndex[gainIndexIndex];
        while (this.i < 32) {
            this.temp2 = this.tempS * Constants.GAIN_SQ5_SQ[this.i];
            this.temp2 -= this.targetEner;
            if (this.temp2 < 0 && Constants.GAIN_SQ5[this.j] < this.temp) {
                this.j = this.i;
            }
            ++this.i;
        }
        gainIndex[gainIndexIndex] = (short)this.j;
    }

    private void filteredCBVecs(short[] cbVectors, int cbVectorsIndex, short[] cbMem, int cbMemIndex, int length, int samples) {
        this.tempIndex7 = cbMemIndex + length;
        this.n = 0;
        while (this.n < 4) {
            cbMem[this.tempIndex7++] = 0;
            ++this.n;
        }
        this.tempIndex7 = cbMemIndex - 4;
        this.n = 0;
        while (this.n < 4) {
            cbMem[this.tempIndex7++] = 0;
            ++this.n;
        }
        this.tempIndex7 = cbVectorsIndex;
        this.n = 0;
        while (this.n < length - samples) {
            cbVectors[this.tempIndex7++] = 0;
            ++this.n;
        }
        BasicFunctions.filterMA(cbMem, cbMemIndex + 4 + length - samples, cbVectors, cbVectorsIndex + length - samples, Constants.CB_FILTERS_REV, 0, 8, samples);
    }

    private void energyInverse(short[] energy, int energyIndex, int length) {
        this.tempIndex7 = energyIndex;
        this.n = 0;
        while (this.n < length) {
            if (energy[this.tempIndex7] < 16384) {
                energy[this.tempIndex7++] = 16384;
            }
            ++this.n;
        }
        this.tempIndex7 = energyIndex;
        this.n = 0;
        while (this.n < length) {
            energy[this.tempIndex7] = energy[this.tempIndex7] == 0 ? Short.MAX_VALUE : (short)(0x1FFFFFFF / energy[this.tempIndex7]);
            ++this.tempIndex7;
            ++this.n;
        }
    }

    private void interpolateSamples(short[] interpSamples, int interpSamplesIndex, short[] cbMem, int cbMemIndex, int length) {
        this.n = 0;
        while (this.n < 20) {
            this.tempIndex6 = cbMemIndex + length - 4;
            this.tempIndex7 = cbMemIndex + length - this.n - 24;
            this.temp = this.tempShift = Constants.ALPHA[3] * cbMem[this.tempIndex6++] >> 15;
            this.tempShift = Constants.ALPHA[0] * cbMem[this.tempIndex7++] >> 15;
            this.temp += this.tempShift;
            interpSamples[interpSamplesIndex++] = (short)this.temp;
            this.temp = this.tempShift = Constants.ALPHA[2] * cbMem[this.tempIndex6++] >> 15;
            this.tempShift = Constants.ALPHA[1] * cbMem[this.tempIndex7++] >> 15;
            this.temp += this.tempShift;
            interpSamples[interpSamplesIndex++] = (short)this.temp;
            this.temp = this.tempShift = Constants.ALPHA[1] * cbMem[this.tempIndex6++] >> 15;
            this.tempShift = Constants.ALPHA[2] * cbMem[this.tempIndex7++] >> 15;
            this.temp += this.tempShift;
            interpSamples[interpSamplesIndex++] = (short)this.temp;
            this.temp = this.tempShift = Constants.ALPHA[0] * cbMem[this.tempIndex6++] >> 15;
            this.tempShift = Constants.ALPHA[3] * cbMem[this.tempIndex7++] >> 15;
            this.temp += this.tempShift;
            interpSamples[interpSamplesIndex++] = (short)this.temp;
            ++this.n;
        }
    }

    private void cbMemEnergyAugmentation(short[] interpSamples, int interpSamplesIndex, short[] cbMem, int cbMemIndex, short scale, short baseSize, short[] energy, int energyIndex, short[] energyShifts, int energyShiftsIndex) {
        energyIndex = energyIndex + baseSize - 20;
        energyShiftsIndex = energyShiftsIndex + baseSize - 20;
        this.en1 = BasicFunctions.scaleRight(cbMem, (cbMemIndex += 147) - 19, cbMem, cbMemIndex - 19, 15, scale);
        this.tempIndex7 = cbMemIndex - 20;
        this.n = 20;
        while (this.n <= 39) {
            this.en1 += cbMem[this.tempIndex7] * cbMem[this.tempIndex7] >> scale;
            --this.tempIndex7;
            this.temp2 = this.en1;
            this.temp2 += BasicFunctions.scaleRight(interpSamples, interpSamplesIndex, interpSamples, interpSamplesIndex, 4, scale);
            interpSamplesIndex += 4;
            this.temp2 += BasicFunctions.scaleRight(cbMem, cbMemIndex - this.n, cbMem, cbMemIndex - this.n, 40 - this.n, scale);
            energyShifts[energyShiftsIndex] = BasicFunctions.norm(this.temp2);
            this.temp2 <<= energyShifts[energyShiftsIndex++];
            energy[energyIndex++] = (short)(this.temp2 >> 16);
            ++this.n;
        }
    }

    private void cbMemEnergy(short range, short[] cb, int cbIndex, short[] filteredCB, int filteredCbIndex, short length, short targetLength, short[] energy, int energyIndex, short[] energyShifts, int energyShiftsIndex, short scale, short baseSize) {
        this.temp2 = BasicFunctions.scaleRight(cb, cbIndex + length - targetLength, cb, cbIndex + length - targetLength, targetLength, scale);
        energyShifts[energyShiftsIndex] = BasicFunctions.norm(this.temp2);
        this.temp = this.temp2 << energyShifts[energyShiftsIndex];
        energy[energyIndex] = (short)(this.temp >> 16);
        this.energyCalc(this.temp2, range, cb, cbIndex + length - targetLength - 1, cb, cbIndex + length - 1, energy, energyIndex, energyShifts, energyShiftsIndex, scale, (short)0);
        this.temp2 = BasicFunctions.scaleRight(filteredCB, filteredCbIndex + length - targetLength, filteredCB, filteredCbIndex + length - targetLength, targetLength, scale);
        energyShifts[baseSize + energyShiftsIndex] = BasicFunctions.norm(this.temp2);
        this.temp = this.temp2 << energyShifts[baseSize + energyShiftsIndex];
        energy[baseSize + energyIndex] = (short)(this.temp >> 16);
        this.energyCalc(this.temp2, range, filteredCB, filteredCbIndex + length - targetLength - 1, filteredCB, filteredCbIndex + length - 1, energy, energyIndex, energyShifts, energyShiftsIndex, scale, baseSize);
    }

    private void energyCalc(int energy, short range, short[] ppi, int ppiIndex, short[] ppo, int ppoIndex, short[] energyArray, int energyArrayIndex, short[] energyShifts, int energyShiftsIndex, short scale, short baseSize) {
        energyShiftsIndex += 1 + baseSize;
        energyArrayIndex += 1 + baseSize;
        this.n = 0;
        while (this.n < range - 1) {
            if ((energy += ppi[ppiIndex] * ppi[ppiIndex] - ppo[ppoIndex] * ppo[ppoIndex] >> scale) < 0) {
                energy = 0;
            }
            --ppiIndex;
            --ppoIndex;
            energyShifts[energyShiftsIndex] = BasicFunctions.norm(energy);
            energyArray[energyArrayIndex++] = (short)(energy << energyShifts[energyShiftsIndex] >> 16);
            ++energyShiftsIndex;
            ++this.n;
        }
    }

    private void augmentCbCorr(short[] target, int targetIndex, short[] buf, int bufIndex, short[] interpSamples, int interpSamplesIndex, int[] cDot, int cDotIndex, int low, int high, int scale) {
        this.n = low;
        while (this.n <= high) {
            cDot[cDotIndex] = BasicFunctions.scaleRight(target, targetIndex, buf, bufIndex - this.n, this.n - 4, scale);
            int n = cDotIndex;
            cDot[n] = cDot[n] + BasicFunctions.scaleRight(target, targetIndex + this.n - 4, interpSamples, interpSamplesIndex, 4, scale);
            interpSamplesIndex += 4;
            int n2 = cDotIndex++;
            cDot[n2] = cDot[n2] + BasicFunctions.scaleRight(target, targetIndex + this.n, buf, bufIndex - this.n, 40 - this.n, scale);
            ++this.n;
        }
    }

    private void crossCorrelation(int[] crossCorrelation, int crossCorrelationIndex, short[] seq1, int seq1Index, short[] seq2, int seq2Index, short dimSeq, short dimCrossCorrelation, short rightShifts, short stepSeq2) {
        this.tempIndex7 = crossCorrelationIndex;
        this.i = 0;
        while (this.i < dimCrossCorrelation) {
            this.tempIndex5 = seq2Index + stepSeq2 * this.i;
            this.tempIndex6 = seq1Index;
            crossCorrelation[this.tempIndex7] = 0;
            this.j = 0;
            while (this.j < dimSeq) {
                int n = this.tempIndex7;
                crossCorrelation[n] = crossCorrelation[n] + (seq1[this.tempIndex6++] * seq2[this.tempIndex5++] >> rightShifts);
                ++this.j;
            }
            ++this.tempIndex7;
            ++this.i;
        }
    }

    private void createAugmentVector(short index, short[] buf, int bufIndex, short[] cbVec, int cbVecIndex) {
        short[] cbVecTmp = this.tempMemory;
        this.tempIndex7 = cbVecIndex + index - 4;
        System.arraycopy(buf, bufIndex - index, cbVec, cbVecIndex, index);
        BasicFunctions.multWithRightShift(cbVec, this.tempIndex7, buf, bufIndex - index - 4, Constants.ALPHA, 0, 4, 15);
        BasicFunctions.reverseMultiplyRight(cbVecTmp, 1330, buf, bufIndex - 4, Constants.ALPHA, 3, 4, 15);
        BasicFunctions.addWithRightShift(cbVec, this.tempIndex7, cbVec, this.tempIndex7, cbVecTmp, 1330, 4, 0);
        System.arraycopy(buf, bufIndex - index, cbVec, cbVecIndex + index, 40 - index);
    }

    private short gainQuant(short gain, short maxIn, short stage, short[] index, int indexIndex) {
        this.scale = maxIn > 1638 ? maxIn : (short)1638;
        short[] cb = Constants.GAIN[stage];
        this.temp = gain << 14;
        this.tempIndex7 = 32 >> stage >> 1;
        this.nBits = (short)this.tempIndex7;
        this.n = 4 - stage;
        while (this.n > 0) {
            this.nBits = (short)(this.nBits >> 1);
            this.tempIndex7 = 0 > this.scale * cb[this.tempIndex7] - this.temp ? (this.tempIndex7 += this.nBits) : (this.tempIndex7 -= this.nBits);
            --this.n;
        }
        this.temp2 = this.scale * cb[this.tempIndex7];
        if (this.temp > this.temp2) {
            if (this.scale * cb[this.tempIndex7 + 1] - this.temp < this.temp - this.temp2) {
                ++this.tempIndex7;
            }
        } else if (this.temp - this.scale * cb[this.tempIndex7 - 1] <= this.temp2 - this.temp) {
            --this.tempIndex7;
        }
        this.temp = (32 >> stage) - 1;
        if (this.tempIndex7 > this.temp) {
            this.tempIndex7 = this.temp;
        }
        index[indexIndex] = (short)this.tempIndex7;
        return (short)(this.scale * cb[this.tempIndex7] + 8192 >> 14);
    }

    private short gainDequant(short index, short maxIn, short stage) {
        if (maxIn < 0) {
            maxIn = (short)(0 - maxIn);
        }
        if (maxIn < 1638) {
            maxIn = (short)1638;
        }
        return (short)(maxIn * Constants.GAIN[stage][index] + 8192 >> 14);
    }

    private void updateBestIndex(int critNew, short critNewSh, short indexNew, int cDotNew, short inverseEnergyNew, short energyShiftNew) {
        if (critNewSh > this.updateIndexData.getShTotMax()) {
            this.tempS = 31 < critNewSh - this.updateIndexData.getShTotMax() ? (short)31 : (short)(critNewSh - this.updateIndexData.getShTotMax());
            this.tempS2 = 0;
        } else {
            this.tempS2 = 31 < this.updateIndexData.getShTotMax() - critNewSh ? (short)31 : (short)(this.updateIndexData.getShTotMax() - critNewSh);
            this.tempS = 0;
        }
        if (critNew >> this.tempS2 > this.updateIndexData.getCritMax() >> this.tempS) {
            this.tempS = (short)(16 - BasicFunctions.norm(cDotNew));
            this.tempS2 = (short)(31 - energyShiftNew - this.tempS);
            if (this.tempS2 > 31) {
                this.tempS2 = (short)31;
            }
            this.tempShift = this.tempS < 0 ? cDotNew << -this.tempS : cDotNew >> this.tempS;
            this.temp = this.tempShift * inverseEnergyNew >> this.tempS2;
            if (this.temp > 21299) {
                this.updateIndexData.setBestGain((short)21299);
            } else if (this.temp < -21299) {
                this.updateIndexData.setBestGain((short)-21299);
            } else {
                this.updateIndexData.setBestGain((short)this.temp);
            }
            this.updateIndexData.setCritMax(critNew);
            this.updateIndexData.setShTotMax(critNewSh);
            this.updateIndexData.setBestIndex(indexNew);
        }
    }

    private void cbSearchCore(int[] cDot, int cDotIndex, short range, short stage, short[] inverseEnergy, int inverseEnergyIndex, short[] inverseEnergyShift, int inverseEnergyShiftIndex, int[] crit, int critIndex) {
        if (stage == 0) {
            this.tempIndex7 = cDotIndex;
            this.n = 0;
            while (this.n < range) {
                if (cDot[this.tempIndex7] < 0) {
                    cDot[this.tempIndex7] = 0;
                }
                ++this.tempIndex7;
                ++this.n;
            }
        }
        this.tempIndex7 = cDotIndex;
        this.temp = 0;
        this.n = 0;
        while (this.n < range) {
            if (cDot[this.tempIndex7] > 0 && cDot[this.tempIndex7] > this.temp) {
                this.temp = cDot[this.tempIndex7];
            } else if (0 - cDot[this.tempIndex7] > this.temp) {
                this.temp = 0 - cDot[this.tempIndex7];
            }
            ++this.tempIndex7;
            ++this.n;
        }
        this.nBits = BasicFunctions.norm(this.temp);
        this.tempIndex7 = cDotIndex;
        this.tempIndex6 = critIndex;
        this.tempIndex5 = inverseEnergyShiftIndex;
        this.max = Short.MIN_VALUE;
        this.n = 0;
        while (this.n < range) {
            this.tempShift = cDot[this.tempIndex7++] << this.nBits;
            this.tempS = (short)(this.tempShift >> 16);
            this.tempShift = this.tempS * this.tempS >> 16;
            crit[this.tempIndex6] = this.tempShift * inverseEnergy[inverseEnergyIndex++];
            if (crit[this.tempIndex6] != 0 && inverseEnergyShift[this.tempIndex5] > this.max) {
                this.max = inverseEnergyShift[this.tempIndex5];
            }
            ++this.tempIndex5;
            ++this.tempIndex6;
            ++this.n;
        }
        if (this.max == Short.MIN_VALUE) {
            this.max = 0;
        }
        this.tempIndex6 = critIndex;
        this.tempIndex5 = inverseEnergyShiftIndex;
        this.n = 0;
        while (this.n < range) {
            this.tempS = 16 < this.max - inverseEnergyShift[this.tempIndex5] ? (short)16 : (short)(this.max - inverseEnergyShift[this.tempIndex5]);
            crit[this.tempIndex6] = this.tempS < 0 ? crit[this.tempIndex6] << -this.tempS : crit[this.tempIndex6] >> this.tempS;
            ++this.tempIndex5;
            ++this.tempIndex6;
            ++this.n;
        }
        this.tempIndex6 = critIndex + 1;
        this.temp = crit[critIndex];
        this.searchData.setIndexNew((short)0);
        this.n = 1;
        while (this.n < range) {
            if (crit[this.tempIndex6] > this.temp) {
                this.temp = crit[this.tempIndex6];
                this.searchData.setIndexNew((short)this.n);
            }
            ++this.tempIndex6;
            ++this.n;
        }
        this.searchData.setCritNew(crit[critIndex + this.searchData.getIndexNew()]);
        this.searchData.setCritNewSh((short)(32 - 2 * this.nBits + this.max));
    }

    private void cbConstruct(short[] decVector, int decVectorIndex, short[] mem, int memIndex, short length, short vectorLength, int cbIndexIndex, int gainIndexIndex) {
        short[] cbIndex = this.encoderBits.getCbIndex();
        short[] gainIndex = this.encoderBits.getGainIndex();
        short[] gain = this.tempMemory;
        short[] cbVec0 = this.tempMemory;
        short[] cbVec1 = this.tempMemory;
        short[] cbVec2 = this.tempMemory;
        gain[0] = this.gainDequant(gainIndex[gainIndexIndex], (short)16384, (short)0);
        gain[1] = this.gainDequant(gainIndex[gainIndexIndex + 1], gain[0], (short)1);
        gain[2] = this.gainDequant(gainIndex[gainIndexIndex + 2], gain[1], (short)2);
        this.i = 0;
        while (this.i < 40) {
            cbVec0[3 + this.i] = 0;
            cbVec1[43 + this.i] = 0;
            cbVec2[83 + this.i] = 0;
            ++this.i;
        }
        this.getCbVec(cbVec0, 3, mem, memIndex, cbIndex[cbIndexIndex], length, vectorLength);
        this.getCbVec(cbVec1, 43, mem, memIndex, cbIndex[cbIndexIndex + 1], length, vectorLength);
        this.getCbVec(cbVec2, 83, mem, memIndex, cbIndex[cbIndexIndex + 2], length, vectorLength);
        this.tempIndex5 = 3;
        this.tempIndex6 = 43;
        this.tempIndex7 = 83;
        this.i = 0;
        while (this.i < vectorLength) {
            this.temp = gain[0] * cbVec0[this.tempIndex5++];
            this.temp += gain[1] * cbVec1[this.tempIndex6++];
            this.temp += gain[2] * cbVec2[this.tempIndex7++];
            this.tempShift = this.temp + 8192 >> 14;
            decVector[decVectorIndex++] = (short)this.tempShift;
            ++this.i;
        }
    }

    private void getCbVec(short[] cbVec, int cbVecIndex, short[] mem, int memIndex, short index, int length, int vectorLength) {
        short[] tempbuff2 = this.tempMemory;
        this.baseSize = (short)(length - vectorLength + 1);
        if (vectorLength == 40) {
            this.baseSize = (short)(this.baseSize + (vectorLength >> 1));
        }
        if (index < length - vectorLength + 1) {
            this.k = index + vectorLength;
            System.arraycopy(mem, memIndex + length - this.k, cbVec, cbVecIndex, vectorLength);
        } else if (index < this.baseSize) {
            this.k = 2 * (index - (length - vectorLength + 1)) + vectorLength;
            this.createAugmentVector((short)(this.k >> 1), mem, memIndex + length, cbVec, cbVecIndex);
        } else if (index - this.baseSize < length - vectorLength + 1) {
            this.tempIndex7 = memIndex - 4;
            this.n = 0;
            while (this.n < 4) {
                mem[this.tempIndex7++] = 0;
                ++this.n;
            }
            this.tempIndex7 = memIndex + length;
            this.n = 0;
            while (this.n < 4) {
                mem[this.tempIndex7++] = 0;
                ++this.n;
            }
            BasicFunctions.filterMA(mem, memIndex + length - (index - this.baseSize + vectorLength) + 4, cbVec, cbVecIndex, Constants.CB_FILTERS_REV, 0, 8, vectorLength);
        } else {
            this.tempIndex7 = memIndex + length;
            this.n = 0;
            while (this.n < 4) {
                mem[this.tempIndex7++] = 0;
                ++this.n;
            }
            BasicFunctions.filterMA(mem, memIndex + length - vectorLength - 1, tempbuff2, 123, Constants.CB_FILTERS_REV, 0, 8, vectorLength + 5);
            this.createAugmentVector((short)((vectorLength << 1) - 20 + index - this.baseSize - length - 1), tempbuff2, 168, cbVec, cbVecIndex);
        }
    }

    private void packBits(byte[] result) {
        short[] lsf = this.encoderBits.getLSF();
        short[] cbIndex = this.encoderBits.getCbIndex();
        short[] gainIndex = this.encoderBits.getGainIndex();
        short[] idxVec = this.encoderBits.getIdxVec();
        result[0] = (byte)(lsf[0] << 2 | lsf[1] >> 5 & 3);
        result[1] = (byte)((lsf[1] & 0x1F) << 3 | lsf[2] >> 4 & 7);
        result[2] = (byte)((lsf[2] & 0xF) << 4);
        if (20 == 20) {
            result[2] = this.encoderBits.getStateFirst() ? (byte)(result[2] | ((this.encoderBits.getStartIdx() & 3) << 2 | 2)) : (byte)(result[2] | (this.encoderBits.getStartIdx() & 3) << 2);
            result[2] = (byte)(result[2] | this.encoderBits.getIdxForMax() >> 5 & 1);
            result[3] = (byte)((this.encoderBits.getIdxForMax() & 0x1F) << 3 | cbIndex[0] >> 4 & 7);
            result[4] = (byte)((cbIndex[0] & 0xE) << 4 | gainIndex[0] & 0x18 | (gainIndex[1] & 8) >> 1 | cbIndex[3] >> 6 & 3);
            result[5] = (byte)((cbIndex[3] & 0x3E) << 2 | gainIndex[3] >> 2 & 4 | gainIndex[4] >> 2 & 2 | gainIndex[6] >> 4 & 1);
            this.tempIndex7 = 6;
        } else {
            result[2] = (byte)(result[2] | lsf[3] >> 2 & 0xF);
            result[3] = (byte)((lsf[3] & 3) << 6 | lsf[4] >> 1 & 0x3F);
            result[4] = (byte)((lsf[4] & 1) << 7 | lsf[5] & 0x7F);
            result[5] = this.encoderBits.getStateFirst() ? (byte)(this.encoderBits.getStartIdx() << 5 | 0x10 | this.encoderBits.getIdxForMax() >> 2 & 0xF) : (byte)(this.encoderBits.getStartIdx() << 5 | this.encoderBits.getIdxForMax() >> 2 & 0xF);
            result[6] = (byte)((this.encoderBits.getIdxForMax() & 3) << 6 | (cbIndex[0] & 0x78) >> 1 | (gainIndex[0] & 0x10) >> 3 | (gainIndex[1] & 0x80) >> 3);
            result[7] = (byte)(cbIndex[3] & 0xFC | (gainIndex[3] & 0x10) >> 3 | (gainIndex[4] & 0x80) >> 3);
            this.tempIndex7 = 8;
        }
        this.tempIndex6 = 0;
        this.k = 0;
        while (this.k < 7) {
            result[this.tempIndex7] = 0;
            this.i = 7;
            while (this.i >= 0) {
                int n = this.tempIndex7;
                result[n] = (byte)(result[n] | (idxVec[this.tempIndex6++] & 4) >> 2 << this.i);
                --this.i;
            }
            ++this.tempIndex7;
            ++this.k;
        }
        result[this.tempIndex7] = (byte)((idxVec[this.tempIndex6++] & 4) << 5);
        if (20 == 20) {
            int n = this.tempIndex7;
            result[n] = (byte)(result[n] | (gainIndex[1] & 4) << 4);
            int n2 = this.tempIndex7;
            result[n2] = (byte)(result[n2] | (gainIndex[3] & 0xC) << 2);
            int n3 = this.tempIndex7;
            result[n3] = (byte)(result[n3] | (gainIndex[4] & 4) << 1);
            int n4 = this.tempIndex7;
            result[n4] = (byte)(result[n4] | (gainIndex[6] & 8) >> 1);
            int n5 = this.tempIndex7;
            result[n5] = (byte)(result[n5] | (gainIndex[7] & 0xC) >> 2);
        } else {
            int n = this.tempIndex7;
            result[n] = (byte)(result[n] | (idxVec[this.tempIndex6++] & 4) << 4);
            int n6 = this.tempIndex7;
            result[n6] = (byte)(result[n6] | (cbIndex[0] & 6) << 3);
            int n7 = this.tempIndex7;
            result[n7] = (byte)(result[n7] | gainIndex[0] & 8);
            int n8 = this.tempIndex7;
            result[n8] = (byte)(result[n8] | gainIndex[1] & 4);
            int n9 = this.tempIndex7;
            result[n9] = (byte)(result[n9] | cbIndex[3] & 2);
            int n10 = this.tempIndex7++;
            result[n10] = (byte)(result[n10] | (cbIndex[6] & 0x80) >> 7);
            result[this.tempIndex7] = (byte)((cbIndex[6] & 0x7E) << 1 | (cbIndex[9] & 0xC0) >> 6);
            ++this.tempIndex7;
            result[this.tempIndex7] = (byte)((cbIndex[9] & 0x3E) << 2 | (cbIndex[12] & 0xE0) >> 5);
            ++this.tempIndex7;
            result[this.tempIndex7] = (byte)((cbIndex[12] & 0x1E) << 3 | gainIndex[3] & 0xC | (gainIndex[4] & 6) >> 1);
            ++this.tempIndex7;
            result[this.tempIndex7] = (byte)((gainIndex[6] & 0x18) << 3 | (gainIndex[7] & 0xC) << 2 | (gainIndex[9] & 0x10) >> 1 | (gainIndex[10] & 8) >> 1 | (gainIndex[12] & 0x10) >> 3 | (gainIndex[13] & 8) >> 3);
        }
        this.tempIndex6 = 0;
        ++this.tempIndex7;
        this.k = 0;
        while (this.k < 14) {
            result[this.tempIndex7] = 0;
            this.i = 6;
            while (this.i >= 0) {
                int n = this.tempIndex7;
                result[n] = (byte)(result[n] | (idxVec[this.tempIndex6++] & 3) << this.i);
                this.i -= 2;
            }
            ++this.tempIndex7;
            ++this.k;
        }
        if (20 == 20) {
            result[this.tempIndex7++] = (byte)((idxVec[56] & 3) << 6 | (cbIndex[0] & 1) << 5 | (cbIndex[1] & 0x7C) >> 2);
            result[this.tempIndex7++] = (byte)((cbIndex[1] & 3) << 6 | (cbIndex[2] & 0x7E) >> 1);
            result[this.tempIndex7++] = (byte)((cbIndex[2] & 1) << 7 | (gainIndex[0] & 7) << 4 | (gainIndex[1] & 3) << 2 | (gainIndex[2] & 6) >> 1);
            result[this.tempIndex7++] = (byte)((gainIndex[2] & 1) << 7 | (cbIndex[3] & 1) << 6 | (cbIndex[4] & 0x7E) >> 1);
            result[this.tempIndex7++] = (byte)((cbIndex[4] & 1) << 7 | cbIndex[5] & 0x7F);
            result[this.tempIndex7++] = (byte)(cbIndex[6] & 0xFF);
            result[this.tempIndex7++] = (byte)(cbIndex[7] & 0xFF);
            result[this.tempIndex7++] = (byte)(cbIndex[8] & 0xFF);
            result[this.tempIndex7++] = (byte)((gainIndex[3] & 3) << 6 | (gainIndex[4] & 3) << 4 | (gainIndex[5] & 7) << 1 | (gainIndex[6] & 4) >> 2);
            result[this.tempIndex7++] = (byte)((gainIndex[6] & 3) << 6 | (gainIndex[7] & 3) << 4 | (gainIndex[8] & 7) << 1);
        } else {
            result[this.tempIndex7++] = (byte)((idxVec[56] & 3) << 6 | (idxVec[57] & 3) << 4 | (cbIndex[0] & 1) << 3 | (cbIndex[1] & 0x70) >> 4);
            result[this.tempIndex7++] = (byte)((cbIndex[1] & 0xF) << 4 | (cbIndex[2] & 0x78) >> 3);
            result[this.tempIndex7++] = (byte)((cbIndex[2] & 7) << 5 | (gainIndex[0] & 7) << 2 | gainIndex[1] & 3);
            result[this.tempIndex7++] = (byte)((gainIndex[2] & 7) << 7 | (cbIndex[3] & 1) << 4 | (cbIndex[4] & 0x78) >> 3);
            result[this.tempIndex7++] = (byte)((cbIndex[4] & 7) << 5 | (cbIndex[5] & 0x7C) >> 2);
            result[this.tempIndex7++] = (byte)((cbIndex[5] & 3) << 6 | (cbIndex[6] & 1) << 1 | (cbIndex[7] & 0xF8) >> 3);
            result[this.tempIndex7++] = (byte)((cbIndex[7] & 7) << 5 | (cbIndex[8] & 0xF8) >> 3);
            result[this.tempIndex7++] = (byte)((cbIndex[8] & 7) << 5 | (cbIndex[9] & 1) << 4 | (cbIndex[10] & 0xF0) >> 4);
            result[this.tempIndex7++] = (byte)((cbIndex[10] & 0xF) << 4 | (cbIndex[11] & 0xF0) >> 4);
            result[this.tempIndex7++] = (byte)((cbIndex[11] & 0xF) << 4 | (cbIndex[12] & 1) << 3 | (cbIndex[13] & 0xE0) >> 5);
            result[this.tempIndex7++] = (byte)((cbIndex[13] & 0x1F) << 3 | (cbIndex[14] & 0xE0) >> 5);
            result[this.tempIndex7++] = (byte)((cbIndex[14] & 0x1F) << 3 | (gainIndex[3] & 3) << 1 | gainIndex[4] & 1);
            result[this.tempIndex7++] = (byte)((gainIndex[5] & 7) << 5 | (gainIndex[6] & 7) << 2 | gainIndex[7] & 3);
            result[this.tempIndex7++] = (byte)((gainIndex[8] & 7) << 5 | (gainIndex[9] & 0xF) << 1 | (gainIndex[10] & 4) >> 2);
            result[this.tempIndex7++] = (byte)((gainIndex[10] & 3) << 6 | (gainIndex[11] & 7) << 3 | (gainIndex[12] & 0xE) >> 1);
            result[this.tempIndex7++] = (byte)((gainIndex[12] & 1) << 7 | (gainIndex[13] & 7) << 4 | (gainIndex[14] & 7) << 1);
        }
    }
}

