/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.mobicents.servlet.sip.api;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.mobicents.servlet.sip.startup.SipStandardContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkWrapSipStandardContext
extends SipStandardContext
implements Assignable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(ShrinkWrapSipStandardContext.class.getName());
    private static final String SYSPROP_KEY_TMP_DIR = "java.io.tmpdir";
    private static final String EXPORT_FILE_PREFIX = "export";
    private static final File TMP_DIR = new File(AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty(ShrinkWrapSipStandardContext.SYSPROP_KEY_TMP_DIR);
        }
    }));
    private static final char ROOT = '/';
    private final Archive<?> archive;

    public ShrinkWrapSipStandardContext(Archive<?> archive) throws IllegalArgumentException {
        File exported;
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        String archiveName = archive.getName();
        int extensionOffset = archiveName.lastIndexOf(46);
        String baseName = extensionOffset >= 0 ? archiveName.substring(0, extensionOffset) : archiveName;
        try {
            exported = File.createTempFile(EXPORT_FILE_PREFIX, archiveName, TMP_DIR);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create temporary File in \"" + TMP_DIR + "\" to write exported archive", e);
        }
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(exported, true);
        exported.deleteOnExit();
        log.info("Converged Sip/Web app archive location: " + exported.getAbsolutePath());
        this.setDocBase(exported.getAbsolutePath());
        this.setPath('/' + baseName);
        this.setUnpackWAR(false);
        this.setSaveConfig(false);
        this.setCachingAllowed(false);
        this.archive = archive;
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        return (TYPE)this.archive.as(clazz);
    }

    static {
        if (!TMP_DIR.exists() || !TMP_DIR.isDirectory()) {
            throw new IllegalStateException("Could not obtain temp directory \"" + TMP_DIR.getAbsolutePath() + "\"");
        }
    }
}

