/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.ra.httpclient.nio.ra;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javax.slee.Address;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.impl.nio.client.DefaultHttpAsyncClient;
import org.apache.http.impl.nio.conn.PoolingClientAsyncConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.ClientAsyncConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.util.EntityUtils;
import org.mobicents.slee.ra.httpclient.nio.events.HttpClientNIOEventTypes;
import org.mobicents.slee.ra.httpclient.nio.events.HttpClientNIOResponseEvent;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpAsyncClientFactory;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIORequestActivityHandle;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIORequestActivityImpl;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIOResourceAdaptorSbbInterfaceImpl;
import org.mobicents.slee.ra.httpclient.nio.ratype.HttpClientNIORequestActivity;
import org.mobicents.slee.ra.httpclient.nio.ratype.HttpClientNIOResourceAdaptorSbbInterface;

public class HttpClientNIOResourceAdaptor
implements ResourceAdaptor {
    private static final int EVENT_FLAGS = 128;
    private static final String CFG_PROPERTY_HTTP_CLIENT_FACTORY = "HTTP_CLIENT_FACTORY";
    private static final String CFG_PROPERTY_MAX_CONNECTIONS_TOTAL = "MAX_CONNECTIONS_TOTAL";
    private static final String CFG_PROPERTY_DEFAULT_MAX_CONNECTIONS_PER_ROUTE = "DEFAULT_MAX_CONNECTIONS_PER_ROUTE";
    protected ResourceAdaptorContext resourceAdaptorContext;
    private ConcurrentHashMap<HttpClientNIORequestActivityHandle, HttpClientNIORequestActivity> activities;
    private HttpClientNIOResourceAdaptorSbbInterface sbbInterface;
    private Tracer tracer;
    protected HttpAsyncClient httpclient;
    protected volatile boolean isActive = false;
    private FireableEventType fireableEventType;
    private int maxTotal;
    private int defaultMaxPerRoute;
    private HttpAsyncClientFactory httpClientFactory;

    public void setResourceAdaptorContext(ResourceAdaptorContext arg0) {
        this.resourceAdaptorContext = arg0;
        this.tracer = this.resourceAdaptorContext.getTracer(HttpClientNIOResourceAdaptor.class.getSimpleName());
        try {
            this.fireableEventType = this.resourceAdaptorContext.getEventLookupFacility().getFireableEventType(HttpClientNIOEventTypes.HTTP_CLIENT_NIO_RESPONSE_EVENT_TYPE_ID);
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.sbbInterface = new HttpClientNIOResourceAdaptorSbbInterfaceImpl(this);
    }

    public void raConfigure(ConfigProperties properties) {
        String httpClientFactoryClassName = (String)properties.getProperty(CFG_PROPERTY_HTTP_CLIENT_FACTORY).getValue();
        if (!httpClientFactoryClassName.isEmpty()) {
            try {
                this.httpClientFactory = (HttpAsyncClientFactory)Class.forName(httpClientFactoryClassName).newInstance();
            }
            catch (Exception e) {
                this.tracer.severe("failed to load http client factory class", (Throwable)e);
            }
        } else {
            this.maxTotal = (Integer)properties.getProperty(CFG_PROPERTY_MAX_CONNECTIONS_TOTAL).getValue();
            this.defaultMaxPerRoute = (Integer)properties.getProperty(CFG_PROPERTY_DEFAULT_MAX_CONNECTIONS_PER_ROUTE).getValue();
        }
    }

    public void raActive() {
        this.activities = new ConcurrentHashMap();
        try {
            if (this.httpClientFactory != null) {
                this.httpclient = this.httpClientFactory.newHttpAsyncClient();
            } else {
                DefaultConnectingIOReactor ioreactor = new DefaultConnectingIOReactor();
                PoolingClientAsyncConnectionManager connMgr = new PoolingClientAsyncConnectionManager((ConnectingIOReactor)ioreactor);
                connMgr.setMaxTotal(this.maxTotal);
                connMgr.setDefaultMaxPerRoute(this.defaultMaxPerRoute);
                this.httpclient = new DefaultHttpAsyncClient((ClientAsyncConnectionManager)connMgr);
            }
            this.httpclient.start();
            this.isActive = true;
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info(String.format("HttpClientNIOResourceAdaptor=%s entity activated.", this.resourceAdaptorContext.getEntityName()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void raStopping() {
        this.isActive = false;
    }

    public void raInactive() {
        this.isActive = false;
        this.activities.clear();
        this.activities = null;
        try {
            this.httpclient.getConnectionManager().shutdown();
        }
        catch (IOException e) {
            this.tracer.severe("Failed to complete http client shutdown", (Throwable)e);
        }
        this.httpclient = null;
    }

    public void raUnconfigure() {
    }

    public void unsetResourceAdaptorContext() {
        this.resourceAdaptorContext = null;
        this.tracer = null;
        this.sbbInterface = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        String httpClientFactoryClassName = (String)properties.getProperty(CFG_PROPERTY_HTTP_CLIENT_FACTORY).getValue();
        if (!httpClientFactoryClassName.isEmpty()) {
            try {
                Class<?> c = Class.forName(httpClientFactoryClassName);
                c.newInstance();
            }
            catch (Exception e) {
                this.tracer.severe("failed to load http client factory class", (Throwable)e);
                throw new InvalidConfigurationException("failed to load http client factory class", (Throwable)e);
            }
        }
        try {
            Integer i = (Integer)properties.getProperty(CFG_PROPERTY_MAX_CONNECTIONS_TOTAL).getValue();
            if (i < 1) {
                throw new InvalidConfigurationException("MAX_CONNECTIONS_TOTAL must be > 0");
            }
            Integer j = (Integer)properties.getProperty(CFG_PROPERTY_DEFAULT_MAX_CONNECTIONS_PER_ROUTE).getValue();
            if (j < 1) {
                throw new InvalidConfigurationException("DEFAULT_MAX_CONNECTIONS_PER_ROUTE must be > 0");
            }
        }
        catch (InvalidConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            this.tracer.severe("failure in config validation", (Throwable)e);
            throw new InvalidConfigurationException(e.getMessage());
        }
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public void serviceActive(ReceivableService arg0) {
    }

    public void serviceStopping(ReceivableService arg0) {
    }

    public void serviceInactive(ReceivableService arg0) {
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.sbbInterface;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        HttpClientNIORequestActivityHandle handle;
        if (arg0 instanceof HttpClientNIORequestActivityImpl && this.activities.containsKey(handle = new HttpClientNIORequestActivityHandle(((HttpClientNIORequestActivityImpl)arg0).getId()))) {
            return handle;
        }
        return null;
    }

    public void queryLiveness(ActivityHandle arg0) {
        if (!this.activities.contains(arg0)) {
            this.resourceAdaptorContext.getSleeEndpoint().endActivity(arg0);
        }
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
        HttpClientNIOResponseEvent event;
        HttpResponse response;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(String.format("Event=%s unreferenced", arg2));
        }
        if (arg2 instanceof HttpClientNIOResponseEvent && (response = (event = (HttpClientNIOResponseEvent)arg2).getResponse()) != null) {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                this.tracer.severe("Exception while housekeeping. Event unreferenced", (Throwable)e);
            }
        }
    }

    public void activityEnded(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("activityEnded( handle = " + activityHandle + ")");
        }
        this.activities.remove(activityHandle);
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public ResourceAdaptorContext getResourceAdaptorContext() {
        return this.resourceAdaptorContext;
    }

    public void addActivity(HttpClientNIORequestActivityHandle activityHandle, HttpClientNIORequestActivity activity) {
        this.activities.put(activityHandle, activity);
    }

    public void endActivity(HttpClientNIORequestActivityImpl activity) {
        HttpClientNIORequestActivityHandle ah = new HttpClientNIORequestActivityHandle(activity.getId());
        if (this.activities.containsKey(ah)) {
            this.resourceAdaptorContext.getSleeEndpoint().endActivity((ActivityHandle)ah);
        }
    }

    public void processResponseEvent(HttpClientNIOResponseEvent event, HttpClientNIORequestActivityImpl activity) {
        HttpClientNIORequestActivityHandle ah = new HttpClientNIORequestActivityHandle(activity.getId());
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("==== FIRING ResponseEvent EVENT TO LOCAL SLEE, Event: " + event + " ====");
        }
        try {
            this.resourceAdaptorContext.getSleeEndpoint().fireEvent((ActivityHandle)ah, this.fireableEventType, (Object)event, null, null, 128);
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
    }
}

