/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.ra.httpclient.nio.ra;

import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIOResourceAdaptor;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIOResponseEventImpl;
import org.mobicents.slee.ra.httpclient.nio.ratype.HttpClientNIORequestActivity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientNIORequestActivityImpl
implements HttpClientNIORequestActivity {
    private final String id;
    private final HttpClientNIOResourceAdaptor ra;
    private Future<HttpResponse> future;

    public HttpClientNIORequestActivityImpl(HttpClientNIOResourceAdaptor ra) {
        this.ra = ra;
        this.id = UUID.randomUUID().toString();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    void execute(HttpUriRequest request, HttpContext context, Object applicationData) {
        this.future = this.ra.httpAsyncClient.execute(request, this.processHttpContext(context), this.getFutureCallback(applicationData));
    }

    void execute(HttpHost target, HttpRequest request, HttpContext context, Object applicationData) {
        this.future = this.ra.httpAsyncClient.execute(target, request, this.processHttpContext(context), this.getFutureCallback(applicationData));
    }

    private HttpContext processHttpContext(HttpContext context) {
        if (context == null) {
            context = new BasicHttpContext();
        }
        if (context.getAttribute("http.cookie-store") == null) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            context.setAttribute("http.cookie-store", (Object)cookieStore);
        }
        return context;
    }

    private FutureCallback<HttpResponse> getFutureCallback(final Object applicationData) {
        return new FutureCallback<HttpResponse>(){

            public void failed(Exception exception) {
                HttpClientNIOResponseEventImpl event = new HttpClientNIOResponseEventImpl(null, exception, applicationData);
                HttpClientNIORequestActivityImpl.this.ra.processResponseEvent(event, HttpClientNIORequestActivityImpl.this);
                HttpClientNIORequestActivityImpl.this.ra.endActivity(HttpClientNIORequestActivityImpl.this);
            }

            public void completed(HttpResponse response) {
                HttpClientNIOResponseEventImpl event = new HttpClientNIOResponseEventImpl(response, null, applicationData);
                HttpClientNIORequestActivityImpl.this.ra.processResponseEvent(event, HttpClientNIORequestActivityImpl.this);
                HttpClientNIORequestActivityImpl.this.ra.endActivity(HttpClientNIORequestActivityImpl.this);
            }

            public void cancelled() {
                HttpClientNIORequestActivityImpl.this.ra.endActivity(HttpClientNIORequestActivityImpl.this);
            }
        };
    }

    protected String getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((HttpClientNIORequestActivityImpl)obj).id.equals(this.id);
        }
        return false;
    }
}

