/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.ra.httpclient.nio.ra;

import javax.slee.SLEEException;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.StartActivityException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIORequestActivityHandle;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIORequestActivityImpl;
import org.mobicents.slee.ra.httpclient.nio.ra.HttpClientNIOResourceAdaptor;
import org.mobicents.slee.ra.httpclient.nio.ratype.HttpClientNIORequestActivity;
import org.mobicents.slee.ra.httpclient.nio.ratype.HttpClientNIOResourceAdaptorSbbInterface;

public class HttpClientNIOResourceAdaptorSbbInterfaceImpl
implements HttpClientNIOResourceAdaptorSbbInterface {
    private static final int ACTIVITY_FLAGS = 2;
    private final Tracer tracer;
    private final HttpClientNIOResourceAdaptor ra;

    public HttpClientNIOResourceAdaptorSbbInterfaceImpl(HttpClientNIOResourceAdaptor ra) {
        this.ra = ra;
        this.tracer = ra.getResourceAdaptorContext().getTracer(HttpClientNIOResourceAdaptorSbbInterfaceImpl.class.getName());
    }

    public HttpClientNIORequestActivity execute(HttpHost target, HttpRequest request, HttpContext context, Object applicationData) throws SLEEException, StartActivityException {
        HttpClientNIORequestActivityImpl activity = this.createActivity();
        try {
            activity.execute(target, request, context, applicationData);
            return activity;
        }
        catch (RuntimeException e) {
            this.ra.endActivity(activity);
            throw e;
        }
    }

    public HttpClientNIORequestActivity execute(HttpUriRequest request, HttpContext context, Object applicationData) throws SLEEException, StartActivityException {
        HttpClientNIORequestActivityImpl activity = this.createActivity();
        try {
            activity.execute(request, context, applicationData);
            return activity;
        }
        catch (RuntimeException e) {
            this.ra.endActivity(activity);
            throw e;
        }
    }

    private HttpClientNIORequestActivityImpl createActivity() throws SLEEException, StartActivityException {
        HttpClientNIORequestActivityImpl activity = new HttpClientNIORequestActivityImpl(this.ra);
        HttpClientNIORequestActivityHandle handle = new HttpClientNIORequestActivityHandle(activity.getId());
        this.ra.getResourceAdaptorContext().getSleeEndpoint().startActivitySuspended((ActivityHandle)handle, (Object)activity, 2);
        this.ra.addActivity(handle, activity);
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Started activity " + activity.getId());
        }
        return activity;
    }
}

