/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.charging;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.resource.ResourceAdaptorTypeID;
import javolution.util.FastList;
import net.java.slee.resource.diameter.base.events.avp.DiameterAvp;
import net.java.slee.resource.diameter.base.events.avp.DiameterIdentity;
import net.java.slee.resource.diameter.base.events.avp.Enumerated;
import net.java.slee.resource.diameter.cca.events.avp.CcRequestType;
import net.java.slee.resource.diameter.cca.events.avp.MultipleServicesCreditControlAvp;
import net.java.slee.resource.diameter.cca.events.avp.RequestedActionType;
import net.java.slee.resource.diameter.cca.events.avp.RequestedServiceUnitAvp;
import net.java.slee.resource.diameter.cca.events.avp.SubscriptionIdAvp;
import net.java.slee.resource.diameter.cca.events.avp.SubscriptionIdType;
import net.java.slee.resource.diameter.ro.RoActivityContextInterfaceFactory;
import net.java.slee.resource.diameter.ro.RoAvpFactory;
import net.java.slee.resource.diameter.ro.RoClientSessionActivity;
import net.java.slee.resource.diameter.ro.RoMessageFactory;
import net.java.slee.resource.diameter.ro.RoProvider;
import net.java.slee.resource.diameter.ro.events.RoCreditControlAnswer;
import net.java.slee.resource.diameter.ro.events.RoCreditControlRequest;
import net.java.slee.resource.diameter.ro.events.avp.ServiceInformation;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.smsc.cassandra.DatabaseType;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.CdrGenerator;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageDeliveryResultResponseInterface;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmscProcessingException;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;
import org.mobicents.smsc.slee.services.charging.ChargingData;
import org.mobicents.smsc.slee.services.charging.ChargingMedium;
import org.mobicents.smsc.smpp.GenerateType;

public abstract class ChargingSbb
implements Sbb {
    public static final String SERVICE_CONTEXT_ID_SMSC = "32274@3gpp.org";
    public static final int APPLICATION_ID_OF_THE_DIAMETER_CREDIT_CONTROL_APPLICATION = 4;
    public static final int CCR_TIMEOUT = 15;
    protected static SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    private static final ResourceAdaptorTypeID DIAMETER_ID = new ResourceAdaptorTypeID("Diameter Ro", "java.net", "0.8.1");
    private static final String LINK_DIAM = "DiameterRo";
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final String LINK_PERS = "PersistenceResourceAdaptor";
    private static final ResourceAdaptorTypeID SCHEDULER_ID = new ResourceAdaptorTypeID("SchedulerResourceAdaptorType", "org.mobicents", "1.0");
    private static final String SCHEDULER_LINK = "SchedulerResourceAdaptor";
    private static Charset utf8Charset = Charset.forName("UTF-8");
    protected Tracer logger;
    private SbbContextExt sbbContext;
    private RoProvider roProvider;
    private RoMessageFactory roMessageFactory;
    private RoAvpFactory avpFactory;
    private RoActivityContextInterfaceFactory acif;
    private TimerFacility timerFacility = null;
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private PersistenceRAInterface persistence;
    private SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    protected SchedulerRaSbbInterface scheduler = null;
    private static final TimerOptions defaultTimerOptions = ChargingSbb.createDefaultTimerOptions();
    private NullActivityContextInterfaceFactory nullActivityContextInterfaceFactory;

    private static TimerOptions createDefaultTimerOptions() {
        TimerOptions timerOptions = new TimerOptions();
        timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
        return timerOptions;
    }

    public void sbbActivate() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbActivate invoked.");
        }
    }

    public void sbbCreate() throws CreateException {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbCreate invoked.");
        }
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbExceptionThrown invoked.");
        }
    }

    public void sbbLoad() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbLoad invoked.");
        }
    }

    public void sbbPassivate() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbPassivate invoked.");
        }
    }

    public void sbbPostCreate() throws CreateException {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbPostCreate invoked.");
        }
    }

    public void sbbRemove() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbRemove invoked.");
        }
    }

    public void sbbRolledBack(RolledBackContext arg0) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbRolledBack invoked.");
        }
    }

    public void sbbStore() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("sbbStore invoked.");
        }
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.logger = this.sbbContext.getTracer(this.getClass().getSimpleName());
            if (this.logger.isFineEnabled()) {
                this.logger.fine("setSbbContext invoked.");
            }
            this.roProvider = (RoProvider)this.sbbContext.getResourceAdaptorInterface(DIAMETER_ID, LINK_DIAM);
            this.roMessageFactory = this.roProvider.getRoMessageFactory();
            this.avpFactory = this.roProvider.getRoAvpFactory();
            this.acif = (RoActivityContextInterfaceFactory)ctx.lookup("slee/resources/JDiameterRoResourceAdaptor/java.net/0.8.1/acif");
            this.timerFacility = (TimerFacility)ctx.lookup("slee/facilities/timer");
            this.nullActivityFactory = (NullActivityFactory)ctx.lookup("slee/nullactivity/factory");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)ctx.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, LINK_PERS);
            this.scheduler = (SchedulerRaSbbInterface)this.sbbContext.getResourceAdaptorInterface(SCHEDULER_ID, SCHEDULER_LINK);
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("unsetSbbContext invoked.");
        }
        this.sbbContext = null;
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        this.logger.info(" Activity Ended[" + aci.getActivity() + "]");
    }

    public void setupChargingRequestInterface(ChargingMedium chargingType, Sms sms) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("ChargingSbb: received message for process charging process: chargingType=" + (Object)((Object)chargingType) + ", message=[" + sms + "]");
        }
        ChargingData chargingData = new ChargingData();
        chargingData.setSms(sms);
        chargingData.setChargingType(chargingType);
        this.setChargingData(chargingData);
        String sourceAddress = sms.getSourceAddr();
        int sourceTon = sms.getSourceAddrTon();
        String originatorSccpAddress = sms.getOriginatorSccpAddress();
        String origMoServiceCentreAddressDA = sms.getOrigMoServiceCentreAddressDA();
        if (origMoServiceCentreAddressDA == null) {
            origMoServiceCentreAddressDA = smscPropertiesManagement.getServiceCenterGt(sms.getSmsSet().getNetworkId());
        }
        String recipientAddress = sms.getSmsSet().getDestAddr();
        int destTon = sms.getSmsSet().getDestAddrTon();
        int dataCodingScheme = sms.getDataCoding();
        String interfaceId = Integer.toString(sms.getSmsSet().getNetworkId());
        String interfaceText = sms.getOrigEsmeName();
        try {
            DiameterIdentity destHost = null;
            if (smscPropertiesManagement.getDiameterDestHost() != null && !smscPropertiesManagement.getDiameterDestHost().equals("")) {
                destHost = new DiameterIdentity(smscPropertiesManagement.getDiameterDestHost());
            }
            DiameterIdentity destRealm = new DiameterIdentity(smscPropertiesManagement.getDiameterDestRealm());
            RoClientSessionActivity activity = this.roProvider.createRoClientSessionActivity(destHost, destRealm);
            ActivityContextInterface roACI = this.acif.getActivityContextInterface(activity);
            roACI.attach(this.getSbbContext().getSbbLocalObject());
            RoCreditControlRequest ccr = activity.createRoCreditControlRequest(CcRequestType.EVENT_REQUEST);
            ccr.setServiceContextId(SERVICE_CONTEXT_ID_SMSC);
            ccr.setCcRequestNumber(0L);
            if (smscPropertiesManagement.getDiameterUserName() != null && !smscPropertiesManagement.getDiameterUserName().equals("")) {
                ccr.setUserName(smscPropertiesManagement.getDiameterUserName());
            }
            ccr.setEventTimestamp(Calendar.getInstance().getTime());
            SubscriptionIdAvp subId = this.avpFactory.createSubscriptionId(SubscriptionIdType.END_USER_E164, sourceAddress);
            ccr.setSubscriptionId(subId);
            ccr.setRequestedAction(RequestedActionType.DIRECT_DEBITING);
            int messageCount = 1;
            int serviceIdentifier = 1;
            MultipleServicesCreditControlAvp multipleServicesCreditControl = this.avpFactory.createMultipleServicesCreditControl();
            RequestedServiceUnitAvp requestedServiceUnit = this.avpFactory.createRequestedServiceUnit();
            requestedServiceUnit.setCreditControlServiceSpecificUnits((long)messageCount);
            multipleServicesCreditControl.setRequestedServiceUnit(requestedServiceUnit);
            multipleServicesCreditControl.setServiceIdentifier((long)serviceIdentifier);
            ccr.setMultipleServicesCreditControl(multipleServicesCreditControl);
            ArrayList<DiameterAvp> smsInfoAvpLst = new ArrayList<DiameterAvp>();
            int vendorID = 10415;
            if (originatorSccpAddress != null) {
                byte[] originatorSccpAddressAddrPartByteArr = originatorSccpAddress.getBytes(utf8Charset);
                byte[] originatorSccpAddressByteArr = new byte[2 + originatorSccpAddressAddrPartByteArr.length];
                originatorSccpAddressByteArr[1] = 8;
                System.arraycopy(originatorSccpAddressAddrPartByteArr, 0, originatorSccpAddressByteArr, 2, originatorSccpAddressAddrPartByteArr.length);
                DiameterAvp avpOriginatorSccpAddress = this.avpFactory.getBaseFactory().createAvp(vendorID, 2008, originatorSccpAddressByteArr);
                smsInfoAvpLst.add(avpOriginatorSccpAddress);
            }
            if (origMoServiceCentreAddressDA != null) {
                byte[] origMoServiceCentreAddressDAPartByteArr = origMoServiceCentreAddressDA.getBytes(utf8Charset);
                byte[] origMoServiceCentreAddressDAByteArr = new byte[2 + origMoServiceCentreAddressDAPartByteArr.length];
                origMoServiceCentreAddressDAByteArr[1] = 8;
                System.arraycopy(origMoServiceCentreAddressDAPartByteArr, 0, origMoServiceCentreAddressDAByteArr, 2, origMoServiceCentreAddressDAPartByteArr.length);
                DiameterAvp avpOrigMoServiceCentreAddressDA = this.avpFactory.getBaseFactory().createAvp(vendorID, 2017, origMoServiceCentreAddressDAByteArr);
                smsInfoAvpLst.add(avpOrigMoServiceCentreAddressDA);
            }
            DiameterAvp avpDataCodingScheme = this.avpFactory.getBaseFactory().createAvp(vendorID, 2001, dataCodingScheme);
            smsInfoAvpLst.add(avpDataCodingScheme);
            DiameterAvp avpSmMessageType = this.avpFactory.getBaseFactory().createAvp(vendorID, 2007, SmMessageTypeEnum.SUBMISSION.getValue());
            smsInfoAvpLst.add(avpSmMessageType);
            ArrayList<DiameterAvp> originatorInterfaceAvpLst = new ArrayList<DiameterAvp>();
            DiameterAvp avpInterfaceId = this.avpFactory.getBaseFactory().createAvp(vendorID, 2003, interfaceId);
            originatorInterfaceAvpLst.add(avpInterfaceId);
            if (interfaceText != null) {
                DiameterAvp avpInterfaceText = this.avpFactory.getBaseFactory().createAvp(vendorID, 2005, interfaceText);
                originatorInterfaceAvpLst.add(avpInterfaceText);
            }
            DiameterAvp[] originatorInterfaceAvpArr = new DiameterAvp[originatorInterfaceAvpLst.size()];
            originatorInterfaceAvpLst.toArray(originatorInterfaceAvpArr);
            DiameterAvp avpOriginatorInterface = this.avpFactory.getBaseFactory().createAvp(vendorID, 2009, originatorInterfaceAvpArr);
            smsInfoAvpLst.add(avpOriginatorInterface);
            ArrayList<DiameterAvp> recipientAddressAvpLst = new ArrayList<DiameterAvp>();
            DiameterAvp avpAddressType = destTon == 1 ? this.avpFactory.getBaseFactory().createAvp(vendorID, 899, AddressTypeEnum.Msisdn.getValue()) : this.avpFactory.getBaseFactory().createAvp(vendorID, 899, AddressTypeEnum.Others.getValue());
            recipientAddressAvpLst.add(avpAddressType);
            DiameterAvp avpAddressData = this.avpFactory.getBaseFactory().createAvp(vendorID, 897, recipientAddress);
            recipientAddressAvpLst.add(avpAddressData);
            DiameterAvp[] recipientAddressAvpArr = new DiameterAvp[recipientAddressAvpLst.size()];
            recipientAddressAvpLst.toArray(recipientAddressAvpArr);
            DiameterAvp avpRecipientAddress = this.avpFactory.getBaseFactory().createAvp(vendorID, 1201, recipientAddressAvpArr);
            ArrayList<DiameterAvp> recipientInfoAvpLst = new ArrayList<DiameterAvp>();
            recipientInfoAvpLst.add(avpRecipientAddress);
            DiameterAvp[] recipientInfoAvpArr = new DiameterAvp[recipientInfoAvpLst.size()];
            recipientInfoAvpLst.toArray(recipientInfoAvpArr);
            DiameterAvp avpRecipientInfo = this.avpFactory.getBaseFactory().createAvp(vendorID, 2026, recipientInfoAvpArr);
            smsInfoAvpLst.add(avpRecipientInfo);
            ArrayList<DiameterAvp> originatorReceivedAddressAvpLst = new ArrayList<DiameterAvp>();
            avpAddressType = sourceTon == 1 ? this.avpFactory.getBaseFactory().createAvp(vendorID, 899, AddressTypeEnum.Msisdn.getValue()) : this.avpFactory.getBaseFactory().createAvp(vendorID, 899, AddressTypeEnum.Others.getValue());
            originatorReceivedAddressAvpLst.add(avpAddressType);
            avpAddressData = this.avpFactory.getBaseFactory().createAvp(vendorID, 897, sourceAddress);
            originatorReceivedAddressAvpLst.add(avpAddressData);
            DiameterAvp[] originatorReceivedAddressAvpArr = new DiameterAvp[originatorReceivedAddressAvpLst.size()];
            originatorReceivedAddressAvpLst.toArray(originatorReceivedAddressAvpArr);
            DiameterAvp avpOriginatorReceivedAddress = this.avpFactory.getBaseFactory().createAvp(vendorID, 2027, originatorReceivedAddressAvpArr);
            smsInfoAvpLst.add(avpOriginatorReceivedAddress);
            DiameterAvp[] smsInfoAvpArr = new DiameterAvp[smsInfoAvpLst.size()];
            smsInfoAvpLst.toArray(smsInfoAvpArr);
            DiameterAvp[] smsInfo = new DiameterAvp[]{this.avpFactory.getBaseFactory().createAvp(vendorID, 2000, smsInfoAvpArr)};
            ServiceInformation si = this.avpFactory.createServiceInformation();
            si.setExtensionAvps(smsInfo);
            ccr.setServiceInformation(si);
            activity.sendEventRoCreditControlRequest(ccr);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Sent INITIAL CCR: \n" + ccr);
            }
            this.timerFacility.setTimer(roACI, null, System.currentTimeMillis() + 15000L, defaultTimerOptions);
        }
        catch (Exception e1) {
            this.logger.severe("setupChargingRequestInterface(): error while sending RoCreditControlRequest: " + e1.getMessage(), (Throwable)e1);
        }
    }

    public abstract void setChargingData(ChargingData var1);

    public abstract ChargingData getChargingData();

    public void onRoCreditControlAnswer(RoCreditControlAnswer cca, ActivityContextInterface aci) {
        ChargingData chargingData;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("RoCreditControlAnswer received: " + cca);
        }
        if ((chargingData = this.getChargingData()) == null) {
            this.logger.warning("RoCreditControlAnswer is recieved but chargingData is null");
            return;
        }
        try {
            long resultCode = cca.getResultCode();
            if (resultCode == 2001L) {
                this.acceptSms(chargingData);
            } else {
                this.rejectSmsByDiameter(chargingData, cca);
            }
        }
        catch (Throwable e) {
            this.logger.warning("Exception when processing RoCreditControlAnswer response: " + e.getMessage(), e);
        }
    }

    public void onTimerEvent(TimerEvent timer, ActivityContextInterface aci) {
        ChargingData chargingData = this.getChargingData();
        if (chargingData == null) {
            this.logger.warning("RoCreditControlAnswer is recieved but chargingData is null");
            return;
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Timeout waiting for CCA for: " + chargingData);
        }
        aci.detach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
        try {
            this.rejectSmsByDiameter(chargingData, null);
        }
        catch (Throwable e) {
            this.logger.warning("Exception when processing onTimerEvent response: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptSms(ChargingData chargingData) throws SmscProcessingException {
        Sms sms0 = chargingData.getSms();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ChargingSbb: accessGranted for: chargingType=" + (Object)((Object)chargingData.getChargingType()) + ", message=[" + sms0 + "]");
        }
        try {
            MProcResult mProcResult = MProcManagement.getInstance().applyMProcArrival(sms0);
            if (mProcResult.isMessageRejected()) {
                this.rejectSmsByMproc(chargingData, true);
                return;
            }
            if (mProcResult.isMessageDropped()) {
                this.rejectSmsByMproc(chargingData, false);
                return;
            }
            if (sms0.getMessageDeliveryResultResponse() != null && sms0.getMessageDeliveryResultResponse().isOnlyChargingRequest()) {
                sms0.getMessageDeliveryResultResponse().responseDeliverySuccess();
                sms0.setMessageDeliveryResultResponse(null);
            }
            this.smscStatAggregator.updateMsgInReceivedAll();
            switch (sms0.getOriginationType()) {
                case SMPP: {
                    this.smscStatAggregator.updateMsgInReceivedSmpp();
                    break;
                }
                case SS7_MO: {
                    this.smscStatAggregator.updateMsgInReceivedSs7();
                    this.smscStatAggregator.updateMsgInReceivedSs7Mo();
                    break;
                }
                case SS7_HR: {
                    this.smscStatAggregator.updateMsgInReceivedSs7();
                    this.smscStatAggregator.updateMsgInReceivedSs7Hr();
                    break;
                }
                case SIP: {
                    this.smscStatAggregator.updateMsgInReceivedSip();
                }
            }
            FastList smss = mProcResult.getMessageList();
            FastList.Node n = smss.head();
            FastList.Node end = smss.tail();
            while ((n = n.getNext()) != end) {
                Sms sms = (Sms)n.getValue();
                TargetAddress ta = new TargetAddress(sms.getSmsSet());
                TargetAddress lock = this.persistence.obtainSynchroObject(ta);
                try {
                    TargetAddress targetAddress = lock;
                    synchronized (targetAddress) {
                        boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                        if (!storeAndForwMode) {
                            try {
                                this.scheduler.injectSmsOnFly(sms.getSmsSet());
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 8, 34, null, (Throwable)e);
                            }
                        } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                            try {
                                sms.setStoringAfterFailure(true);
                                this.scheduler.injectSmsOnFly(sms.getSmsSet());
                            }
                            catch (Exception e) {
                                throw new SmscProcessingException("Exception when runnung injectSmsOnFly(): " + e.getMessage(), 8, 34, null, (Throwable)e);
                            }
                        } else {
                            sms.setStored(true);
                            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                                this.persistence.createLiveSms(sms);
                                this.persistence.setNewMessageScheduled(sms.getSmsSet(), MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)smscPropertiesManagement.getFirstDueDelay())));
                            } else {
                                this.scheduler.setDestCluster(sms.getSmsSet());
                                this.persistence.c2_scheduleMessage_ReschedDueSlot(sms, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, false);
                            }
                        }
                    }
                }
                finally {
                    this.persistence.releaseSynchroObject(lock);
                }
            }
        }
        catch (PersistenceException e) {
            throw new SmscProcessingException("PersistenceException when storing LIVE_SMS : " + e.getMessage(), 69, 34, null, (Throwable)e);
        }
    }

    private void rejectSmsByDiameter(ChargingData chargingData, RoCreditControlAnswer evt) throws SmscProcessingException {
        Sms sms = chargingData.getSms();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ChargingSbb: accessRejected for: resultCode =" + (evt != null ? Long.valueOf(evt.getResultCode()) : "timeout") + ", chargingType=" + (Object)((Object)chargingData.getChargingType()) + ", message=[" + sms + "]");
        }
        try {
            MessageDeliveryResultResponseInterface.DeliveryFailureReason delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.invalidDestinationAddress;
            if (sms.getMessageDeliveryResultResponse() != null) {
                sms.getMessageDeliveryResultResponse().responseDeliveryFailure(delReason, null);
                sms.setMessageDeliveryResultResponse(null);
            }
            sms.getSmsSet().setStatus(ErrorCode.OCS_ACCESS_NOT_GRANTED);
            boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
            if (storeAndForwMode) {
                sms.setStored(true);
            }
            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                this.persistence.archiveFailuredSms(sms);
            } else if (MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateArchiveTable())) {
                this.persistence.c2_createRecordArchive(sms);
            }
            this.smscStatAggregator.updateMsgInRejectedAll();
            CdrGenerator.generateCdr((Sms)sms, (String)"ocs_rejected", (String)"", (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
        }
        catch (PersistenceException e) {
            throw new SmscProcessingException("PersistenceException when storing into Archive rejected by OCS message : " + e.getMessage(), 69, 34, null, (Throwable)e);
        }
    }

    private void rejectSmsByMproc(ChargingData chargingData, boolean isRejected) throws SmscProcessingException {
        Sms sms = chargingData.getSms();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("ChargingSbb: incoming message is " + (isRejected ? "rejected" : "dropped") + " by mProc rules, message=[" + sms + "]");
        }
        try {
            MessageDeliveryResultResponseInterface.DeliveryFailureReason delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.invalidDestinationAddress;
            if (sms.getMessageDeliveryResultResponse() != null) {
                if (isRejected) {
                    sms.getMessageDeliveryResultResponse().responseDeliveryFailure(delReason, null);
                    sms.setMessageDeliveryResultResponse(null);
                } else {
                    sms.getMessageDeliveryResultResponse().responseDeliverySuccess();
                    sms.setMessageDeliveryResultResponse(null);
                }
            }
            sms.getSmsSet().setStatus(ErrorCode.MPROC_ACCESS_NOT_GRANTED);
            boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
            if (storeAndForwMode) {
                sms.setStored(true);
            }
            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                this.persistence.archiveFailuredSms(sms);
            } else if (MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateArchiveTable())) {
                this.persistence.c2_createRecordArchive(sms);
            }
            this.smscStatAggregator.updateMsgInRejectedAll();
            CdrGenerator.generateCdr((Sms)sms, (String)(isRejected ? "mproc_rejected" : "mproc_dropped"), (String)"", (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
        }
        catch (PersistenceException e) {
            throw new SmscProcessingException("PersistenceException when storing into Archive rejected by MProc message : " + e.getMessage(), 69, 34, null, (Throwable)e);
        }
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    public static enum SmMessageTypeEnum implements Enumerated
    {
        SUBMISSION(0),
        DELIVERY_REPORT(1),
        SMServiceRequest(2);

        private int code;

        private SmMessageTypeEnum(int code) {
            this.code = code;
        }

        public int getValue() {
            return this.code;
        }
    }

    public static enum AddressTypeEnum implements Enumerated
    {
        Msisdn(1),
        Others(6);

        private int code;

        private AddressTypeEnum(int code) {
            this.code = code;
        }

        public int getValue() {
            return this.code;
        }
    }
}

