/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javolution.util.FastMap;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.map.primitives.ArrayListSerializingBase;
import org.mobicents.smsc.domain.CcMccmnc;
import org.mobicents.smsc.domain.CcMccmncComparator;
import org.mobicents.smsc.domain.CcMccmncImpl;
import org.mobicents.smsc.domain.CcMccmncMap;

public class CcMccmncCollection {
    private static final String CC_MCCMNC = "ccMccmnc";
    private static final String CC_MCCMNC_LIST = "ccMccmncList";
    private CcMccmncMap<String, CcMccmncImpl> ccMccmncMap = new CcMccmncMap();
    private static CcMccmncComparator ccMccmncComparator = new CcMccmncComparator();
    protected static final XMLFormat<CcMccmncCollection> CC_MCCMNC_COLLECTION_XML = new XMLFormat<CcMccmncCollection>(CcMccmncCollection.class){

        public void read(XMLFormat.InputElement xml, CcMccmncCollection ccMccmnsCollection) throws XMLStreamException {
            CcMccmnsCollection_CcMccmns al = (CcMccmnsCollection_CcMccmns)((Object)xml.get(CcMccmncCollection.CC_MCCMNC_LIST, CcMccmnsCollection_CcMccmns.class));
            if (al != null) {
                CcMccmncImpl[] ccMccmncArray = new CcMccmncImpl[al.getData().size()];
                al.getData().toArray(ccMccmncArray);
                Arrays.sort(ccMccmncArray, ccMccmncComparator);
                CcMccmncMap newCcMccmnc = new CcMccmncMap();
                for (int i = 0; i < ccMccmncArray.length; ++i) {
                    CcMccmncImpl ccMccmncTemp = ccMccmncArray[i];
                    newCcMccmnc.put(ccMccmncTemp.getCountryCode(), ccMccmncTemp);
                }
                ccMccmnsCollection.ccMccmncMap = newCcMccmnc;
            }
        }

        public void write(CcMccmncCollection ccMccmnsCollection, XMLFormat.OutputElement xml) throws XMLStreamException {
            ArrayList<CcMccmncImpl> all = new ArrayList<CcMccmncImpl>(ccMccmnsCollection.ccMccmncMap.values());
            CcMccmnsCollection_CcMccmns al = new CcMccmnsCollection_CcMccmns(all);
            xml.add((Object)al, CcMccmncCollection.CC_MCCMNC_LIST, CcMccmnsCollection_CcMccmns.class);
        }
    };

    public CcMccmnc findMccmnc(String countryCode) {
        FastMap.Entry e = this.ccMccmncMap.head();
        FastMap.Entry end = this.ccMccmncMap.tail();
        while ((e = e.getNext()) != end) {
            CcMccmncImpl ccMccmnc = (CcMccmncImpl)e.getValue();
            if (ccMccmnc.getCountryCode().equals("")) {
                return ccMccmnc;
            }
            if (!countryCode.startsWith(ccMccmnc.getCountryCode())) continue;
            return ccMccmnc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCcMccmnc(CcMccmncImpl ccMccmnc) throws Exception {
        if (ccMccmnc == null) {
            throw new Exception(String.format("Argument %s can not be null", CC_MCCMNC));
        }
        if (ccMccmnc.getCountryCode() == null) {
            throw new Exception(String.format("Argument %s can not be null", "ccMccmnc.getCountryCode()"));
        }
        CcMccmncCollection ccMccmncCollection = this;
        synchronized (ccMccmncCollection) {
            if (this.ccMccmncMap.containsKey(ccMccmnc.getCountryCode())) {
                throw new Exception(String.format("ccMccmnc is already present for countrCode: %s", ccMccmnc.getCountryCode()));
            }
            CcMccmncImpl[] ccMccmncArray = new CcMccmncImpl[this.ccMccmncMap.size() + 1];
            int count = 0;
            FastMap.Entry e = this.ccMccmncMap.head();
            FastMap.Entry end = this.ccMccmncMap.tail();
            while ((e = e.getNext()) != end) {
                CcMccmncImpl ccMccmncTemp1 = (CcMccmncImpl)e.getValue();
                ccMccmncArray[count++] = ccMccmncTemp1;
            }
            ccMccmncArray[count++] = ccMccmnc;
            Arrays.sort(ccMccmncArray, ccMccmncComparator);
            CcMccmncMap newCcMccmnc = new CcMccmncMap();
            for (int i = 0; i < ccMccmncArray.length; ++i) {
                CcMccmncImpl ccMccmncTemp = ccMccmncArray[i];
                newCcMccmnc.put(ccMccmncTemp.getCountryCode(), ccMccmncTemp);
            }
            this.ccMccmncMap = newCcMccmnc;
        }
    }

    public Map<String, CcMccmncImpl> getCcMccmncMap() {
        return this.ccMccmncMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCcMccmnc(String countryCode, String mccMnc, String smsc) throws Exception {
        if (countryCode == null) {
            throw new Exception(String.format("Argument %s can not be null", "countryCode"));
        }
        CcMccmncCollection ccMccmncCollection = this;
        synchronized (ccMccmncCollection) {
            CcMccmncImpl el = (CcMccmncImpl)this.ccMccmncMap.get(countryCode);
            if (el == null) {
                throw new Exception(String.format("ccMccmnc is absent for countrCode: %s", countryCode));
            }
            el.setMccMnc(mccMnc);
            el.setSmsc(smsc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCcMccmnc(String countryCode) throws Exception {
        if (countryCode == null) {
            throw new Exception(String.format("Argument %s can not be null", "countryCode"));
        }
        CcMccmncCollection ccMccmncCollection = this;
        synchronized (ccMccmncCollection) {
            if (!this.ccMccmncMap.containsKey(countryCode)) {
                throw new Exception(String.format("ccMccmnc is absent for countrCode: %s", countryCode));
            }
            CcMccmncMap newCcMccmnc = new CcMccmncMap();
            newCcMccmnc.putAll((Map)((Object)this.ccMccmncMap));
            newCcMccmnc.remove(countryCode);
            this.ccMccmncMap = newCcMccmnc;
        }
    }

    public CcMccmnc getCcMccmnc(String countryCode) {
        return (CcMccmnc)this.ccMccmncMap.get(countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CcMccmncCollection=[");
        boolean i1 = false;
        FastMap.Entry e = this.ccMccmncMap.head();
        FastMap.Entry end = this.ccMccmncMap.tail();
        while ((e = e.getNext()) != end) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            CcMccmncImpl ccMccmns = (CcMccmncImpl)e.getValue();
            sb.append(ccMccmns.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public static class CcMccmnsCollection_CcMccmns
    extends ArrayListSerializingBase<CcMccmncImpl> {
        public CcMccmnsCollection_CcMccmns() {
            super(CcMccmncCollection.CC_MCCMNC, CcMccmncImpl.class);
        }

        public CcMccmnsCollection_CcMccmns(ArrayList<CcMccmncImpl> data) {
            super(CcMccmncCollection.CC_MCCMNC, CcMccmncImpl.class, data);
        }
    }
}

