/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.mobicents.smsc.domain.MProcManagementMBean;
import org.mobicents.smsc.domain.SmscManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.library.CorrelationIdValue;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.mproc.MProcMessage;
import org.mobicents.smsc.mproc.MProcRule;
import org.mobicents.smsc.mproc.MProcRuleFactory;
import org.mobicents.smsc.mproc.MProcRuleMBean;
import org.mobicents.smsc.mproc.PostArrivalProcessor;
import org.mobicents.smsc.mproc.PostDeliveryProcessor;
import org.mobicents.smsc.mproc.PostDeliveryTempFailureProcessor;
import org.mobicents.smsc.mproc.PostHrSriProcessor;
import org.mobicents.smsc.mproc.PostImsiProcessor;
import org.mobicents.smsc.mproc.PostPreDeliveryProcessor;
import org.mobicents.smsc.mproc.ProcessingType;
import org.mobicents.smsc.mproc.impl.MProcMessageHrImpl;
import org.mobicents.smsc.mproc.impl.MProcMessageImpl;
import org.mobicents.smsc.mproc.impl.MProcNewMessageImpl;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.mproc.impl.PersistenseCommonInterface;
import org.mobicents.smsc.mproc.impl.PostArrivalProcessorImpl;
import org.mobicents.smsc.mproc.impl.PostDeliveryProcessorImpl;
import org.mobicents.smsc.mproc.impl.PostDeliveryTempFailureProcessorImpl;
import org.mobicents.smsc.mproc.impl.PostHrSriProcessorImpl;
import org.mobicents.smsc.mproc.impl.PostImsiProcessorImpl;
import org.mobicents.smsc.mproc.impl.PostPreDeliveryProcessorImpl;

public class MProcManagement
implements MProcManagementMBean {
    private static final Logger logger = Logger.getLogger(MProcManagement.class);
    private static final String MPROC_LIST = "mprocList";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "mproc.xml";
    private final String name;
    private String persistDir = null;
    protected FastList<MProcRule> mprocs = new FastList();
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private MBeanServer mbeanServer = null;
    private static MProcManagement instance = null;
    private SmscManagement smscManagement = null;
    private SmscPropertiesManagement smscPropertiesManagement = null;

    private MProcManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
    }

    public static MProcManagement getInstance(String name) {
        if (instance == null) {
            instance = new MProcManagement(name);
        }
        return instance;
    }

    public static MProcManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public SmscManagement getSmscManagement() {
        return this.smscManagement;
    }

    public void setSmscManagement(SmscManagement smscManagement) {
        this.smscManagement = smscManagement;
    }

    public FastList<MProcRule> getMProcRules() {
        return this.mprocs;
    }

    @Override
    public MProcRule getMProcRuleById(int id) {
        FastList<MProcRule> cur = this.mprocs;
        FastList.Node n = cur.head();
        FastList.Node end = cur.tail();
        while ((n = n.getNext()) != end) {
            MProcRule rule = (MProcRule)n.getValue();
            if (rule.getId() != id) continue;
            return rule;
        }
        return null;
    }

    private void resortRules(FastList<MProcRule> lst) {
        TreeMap<Integer, MProcRule> cur = new TreeMap<Integer, MProcRule>();
        FastList.Node n = lst.head();
        FastList.Node end = lst.tail();
        while ((n = n.getNext()) != end) {
            MProcRule rule = (MProcRule)n.getValue();
            cur.put(rule.getId(), rule);
        }
        FastList res = new FastList();
        res.addAll(cur.values());
        this.mprocs = res;
    }

    @Override
    public MProcRule createMProcRule(int id, String ruleFactoryName, String parametersString) throws Exception {
        logger.info((Object)("createMProcRule: id=" + id + ", ruleFactoryName=" + ruleFactoryName + ", parametersString=" + parametersString));
        if (ruleFactoryName == null) {
            throw new Exception(String.format("Creation of MProcRule failed. ruleClassName parameter can not be null", new Object[0]));
        }
        MProcRuleFactory ruleClass = null;
        if (this.smscManagement != null) {
            ruleClass = this.smscManagement.getRuleFactory(ruleFactoryName);
        }
        if (ruleClass == null) {
            throw new Exception(String.format("Creation of MProcRule failed. ruleClass is not found for ruleClassName: %s", ruleFactoryName));
        }
        if (this.getMProcRuleById(id) != null) {
            throw new Exception(String.format("Creation of MProcRule failed. Other MProcRule with id=%d already exist", id));
        }
        MProcRule mProcRule = ruleClass.createMProcRuleInstance();
        mProcRule.setId(id);
        mProcRule.setInitialRuleParameters(parametersString);
        FastList lstTag = new FastList(this.mprocs);
        lstTag.add((Object)mProcRule);
        this.resortRules((FastList<MProcRule>)lstTag);
        this.store();
        this.registerMProcRuleMbean((MProcRuleMBean)mProcRule);
        return mProcRule;
    }

    @Override
    public MProcRule modifyMProcRule(int mProcRuleId, String parametersString) throws Exception {
        logger.info((Object)("modifyMProcRule: id=" + mProcRuleId + ", parametersString=" + parametersString));
        MProcRule mProcRule = this.getMProcRuleById(mProcRuleId);
        if (mProcRule == null) {
            throw new Exception(String.format("Modification of MProcRule failed. No MProcRule with id=%d exist", mProcRuleId));
        }
        mProcRule.updateRuleParameters(parametersString);
        this.store();
        return mProcRule;
    }

    @Override
    public MProcRule destroyMProcRule(int mProcRuleId) throws Exception {
        logger.info((Object)("destroyMProcRule: id=" + mProcRuleId));
        MProcRule mProcRule = this.getMProcRuleById(mProcRuleId);
        if (mProcRule == null) {
            throw new Exception(String.format("Destroying of MProcRule failed. No MProcRule with id=%d exist", mProcRuleId));
        }
        FastList lstTag = new FastList(this.mprocs);
        lstTag.remove((Object)mProcRule);
        this.resortRules((FastList<MProcRule>)lstTag);
        this.store();
        this.unregisterMProcRuleMbean(mProcRule.getId());
        return mProcRule;
    }

    public MProcResult applyMProcArrival(Sms sms, PersistenseCommonInterface persistence) {
        MProcResult res;
        FastList res0;
        MProcResult res2;
        if (this.mprocs.size() == 0) {
            FastList res02 = new FastList();
            res02.add((Object)sms);
            MProcResult res3 = new MProcResult();
            res3.setMessageList(res02);
            return res3;
        }
        FastList<MProcRule> cur = this.mprocs;
        PostArrivalProcessorImpl pap = new PostArrivalProcessorImpl(this.smscPropertiesManagement.getDefaultValidityPeriodHours(), this.smscPropertiesManagement.getMaxValidityPeriodHours(), logger);
        MProcMessageImpl message = new MProcMessageImpl(sms, null, persistence);
        try {
            FastList.Node n = cur.head();
            FastList.Node end = cur.tail();
            while ((n = n.getNext()) != end) {
                MProcRule rule = (MProcRule)n.getValue();
                if (!rule.isForPostArrivalState() || !rule.matchesPostArrival((MProcMessage)message)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MRule matches at Arrival phase to a message:\nrule: " + rule + "\nmessage: " + sms));
                }
                rule.onPostArrival((PostArrivalProcessor)pap, (MProcMessage)message);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception when invoking rule.matches(message) or applyMProcArrival: " + e.getMessage()), e);
            MProcResult res4 = new MProcResult();
            res4.setMessageDropped(true);
            return res4;
        }
        if (pap.isNeedDropMessage()) {
            res2 = new MProcResult();
            res2.setMessageDropped(true);
            return res2;
        }
        if (pap.isNeedRejectMessage()) {
            res2 = new MProcResult();
            res2.setMessageRejected(true);
            return res2;
        }
        FastList newMsgs = pap.getPostedMessages();
        if (newMsgs == null || newMsgs.size() == 0) {
            res0 = new FastList();
            res0.add((Object)sms);
            res = new MProcResult();
            res.setMessageList(res0);
            return res;
        }
        res0 = new FastList();
        res0.add((Object)sms);
        FastList.Node n = newMsgs.head();
        FastList.Node end = newMsgs.tail();
        while ((n = n.getNext()) != end) {
            MProcNewMessageImpl newMsg = (MProcNewMessageImpl)n.getValue();
            res0.add((Object)newMsg.getSmsContent());
        }
        res = new MProcResult();
        res.setMessageList(res0);
        return res;
    }

    public MProcResult applyMProcHrSri(CorrelationIdValue correlationIdValue) {
        if (this.mprocs.size() == 0) {
            return new MProcResult();
        }
        FastList<MProcRule> cur = this.mprocs;
        PostHrSriProcessorImpl pap = new PostHrSriProcessorImpl(logger);
        MProcMessageHrImpl message = new MProcMessageHrImpl(correlationIdValue);
        try {
            FastList.Node n = cur.head();
            FastList.Node end = cur.tail();
            while ((n = n.getNext()) != end) {
                MProcRule rule = (MProcRule)n.getValue();
                if (!rule.isForPostHrSriState() || !rule.matchesPostHrSri((MProcMessage)message)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MRule matches at HrSri phase to a message:\nrule: " + rule + "\ncorrelationIdValue: " + correlationIdValue));
                }
                rule.onPostHrSri((PostHrSriProcessor)pap, (MProcMessage)message);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception when invoking rule.matches(message) or onPostHrSri(): " + e.getMessage()), e);
            return new MProcResult();
        }
        MProcResult res = new MProcResult();
        if (pap.isHrByPassed()) {
            res.setHrIsByPassed(true);
        }
        return res;
    }

    public MProcResult applyMProcPreDelivery(Sms sms, ProcessingType processingType) {
        if (this.mprocs.size() == 0) {
            return new MProcResult();
        }
        FastList<MProcRule> cur = this.mprocs;
        PostPreDeliveryProcessorImpl pap = new PostPreDeliveryProcessorImpl(this.smscPropertiesManagement.getDefaultValidityPeriodHours(), this.smscPropertiesManagement.getMaxValidityPeriodHours(), logger);
        MProcMessageImpl message = new MProcMessageImpl(sms, processingType, null);
        try {
            FastList.Node n = cur.head();
            FastList.Node end = cur.tail();
            while ((n = n.getNext()) != end) {
                MProcRule rule = (MProcRule)n.getValue();
                if (!rule.isForPostPreDeliveryState() || !rule.matchesPostPreDelivery((MProcMessage)message)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MRule matches at PreDelivery phase to a message:\nrule: " + rule + "\nmessage: " + sms));
                }
                rule.onPostPreDelivery((PostPreDeliveryProcessor)pap, (MProcMessage)message);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception when invoking rule.matches(message) or onPostPreDelivery(): " + e.getMessage()), e);
            return new MProcResult();
        }
        FastList newMsgs = pap.getPostedMessages();
        MProcResult res = new MProcResult();
        FastList res0 = new FastList();
        FastList.Node n = newMsgs.head();
        FastList.Node end = newMsgs.tail();
        while ((n = n.getNext()) != end) {
            MProcNewMessageImpl newMsg = (MProcNewMessageImpl)n.getValue();
            res0.add((Object)newMsg.getSmsContent());
        }
        res.setMessageList(res0);
        if (pap.isNeedDropMessages()) {
            res.setMessageDropped(true);
        }
        if (pap.isNeedRerouteMessages()) {
            res.setMessageIsRerouted(true);
            res.setNewNetworkId(pap.getNewNetworkId());
        }
        return res;
    }

    public MProcResult applyMProcImsiRequest(Sms sms, String imsi, String nnnDigits, int nnnNumberingPlan, int nnnAddressNature) {
        MProcResult res;
        if (this.mprocs.size() == 0) {
            return new MProcResult();
        }
        FastList<MProcRule> cur = this.mprocs;
        PostImsiProcessorImpl pap = new PostImsiProcessorImpl(logger);
        MProcMessageImpl message = new MProcMessageImpl(sms, ProcessingType.SS7_SRI, null);
        try {
            FastList.Node n = cur.head();
            FastList.Node end = cur.tail();
            while ((n = n.getNext()) != end) {
                MProcRule rule = (MProcRule)n.getValue();
                if (!rule.isForPostImsiRequestState() || !rule.matchesPostImsiRequest((MProcMessage)message)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MRule matches at ImsiRequest phase to a message:\nrule: " + rule + "\nmessage: " + sms));
                }
                rule.onPostImsiRequest((PostImsiProcessor)pap, (MProcMessage)message);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception when invoking rule.matches(message) or applyMProcImsiRequest(): " + e.getMessage()), e);
            return new MProcResult();
        }
        if (pap.isNeedDropMessages()) {
            res = new MProcResult();
            res.setMessageDropped(true);
            return res;
        }
        if (pap.isNeedRerouteMessages()) {
            res = new MProcResult();
            res.setMessageIsRerouted(true);
            res.setNewNetworkId(pap.getNewNetworkId());
            return res;
        }
        return new MProcResult();
    }

    public MProcResult applyMProcDelivery(Sms sms, boolean deliveryFailure, ProcessingType processingType) {
        if (this.mprocs.size() == 0) {
            return new MProcResult();
        }
        FastList<MProcRule> cur = this.mprocs;
        PostDeliveryProcessorImpl pap = new PostDeliveryProcessorImpl(this.smscPropertiesManagement.getDefaultValidityPeriodHours(), this.smscPropertiesManagement.getMaxValidityPeriodHours(), logger, deliveryFailure);
        MProcMessageImpl message = new MProcMessageImpl(sms, processingType, null);
        try {
            FastList.Node n = cur.head();
            FastList.Node end = cur.tail();
            while ((n = n.getNext()) != end) {
                MProcRule rule = (MProcRule)n.getValue();
                if (!rule.isForPostDeliveryState() || !rule.matchesPostDelivery((MProcMessage)message)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MRule matches at Delivery phase to a message:\nrule: " + rule + "\nmessage: " + sms));
                }
                rule.onPostDelivery((PostDeliveryProcessor)pap, (MProcMessage)message);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception when invoking rule.matches(message) or onPostDelivery(): " + e.getMessage()), e);
            return new MProcResult();
        }
        FastList newMsgs = pap.getPostedMessages();
        MProcResult res = new MProcResult();
        FastList res0 = new FastList();
        FastList.Node n = newMsgs.head();
        FastList.Node end = newMsgs.tail();
        while ((n = n.getNext()) != end) {
            MProcNewMessageImpl newMsg = (MProcNewMessageImpl)n.getValue();
            res0.add((Object)newMsg.getSmsContent());
        }
        res.setMessageList(res0);
        if (pap.isNeedRerouteMessages()) {
            res.setMessageIsRerouted(true);
            res.setNewNetworkId(pap.getNewNetworkId());
        }
        return res;
    }

    public MProcResult applyMProcDeliveryTempFailure(Sms sms, ProcessingType processingType) {
        if (this.mprocs.size() == 0) {
            return new MProcResult();
        }
        FastList<MProcRule> cur = this.mprocs;
        PostDeliveryTempFailureProcessorImpl pap = new PostDeliveryTempFailureProcessorImpl(this.smscPropertiesManagement.getDefaultValidityPeriodHours(), this.smscPropertiesManagement.getMaxValidityPeriodHours(), logger);
        MProcMessageImpl message = new MProcMessageImpl(sms, processingType, null);
        try {
            FastList.Node n = cur.head();
            FastList.Node end = cur.tail();
            while ((n = n.getNext()) != end) {
                MProcRule rule = (MProcRule)n.getValue();
                if (!rule.isForPostDeliveryTempFailureState() || !rule.matchesPostDeliveryTempFailure((MProcMessage)message)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("MRule matches at DeliveryTempFailure phase to a message:\nrule: " + rule + "\nmessage: " + sms));
                }
                rule.onPostDeliveryTempFailure((PostDeliveryTempFailureProcessor)pap, (MProcMessage)message);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Exception when invoking rule.matches(message) or onPostDeliveryTempFailure(): " + e.getMessage()), e);
            return new MProcResult();
        }
        FastList newMsgs = pap.getPostedMessages();
        MProcResult res = new MProcResult();
        FastList res0 = new FastList();
        FastList.Node n = newMsgs.head();
        FastList.Node end = newMsgs.tail();
        while ((n = n.getNext()) != end) {
            MProcNewMessageImpl newMsg = (MProcNewMessageImpl)n.getValue();
            res0.add((Object)newMsg.getSmsContent());
        }
        res.setMessageList(res0);
        if (pap.isNeedDropMessages()) {
            res.setMessageDropped(true);
        }
        if (pap.isNeedRerouteMessages()) {
            res.setMessageIsRerouted(true);
            res.setNewNetworkId(pap.getNewNetworkId());
        }
        return res;
    }

    public void start() throws Exception {
        this.smscPropertiesManagement = SmscPropertiesManagement.getInstance();
        if (this.smscManagement != null) {
            for (MProcRuleFactory ruleFactory : this.smscManagement.getMProcRuleFactories2()) {
                this.bindAlias(ruleFactory);
            }
        }
        try {
            this.mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading MProcRule configuration from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the ProcRule configuration file. \n%s", e.getMessage()));
        }
        this.resortRules(this.mprocs);
        this.store();
        for (MProcRule rule : this.mprocs) {
            this.registerMProcRuleMbean((MProcRuleMBean)rule);
        }
    }

    public void stop() throws Exception {
        this.store();
        for (MProcRule rule : this.mprocs) {
            this.unregisterMProcRuleMbean(rule.getId());
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.mprocs, MPROC_LIST, FastList.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the MProcRule state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.mprocs = (FastList)reader.read(MPROC_LIST, FastList.class);
            reader.close();
        }
        catch (XMLStreamException ex) {
            logger.info((Object)"Error while re-creating MProcRule from persisted file", (Throwable)ex);
        }
    }

    private void registerMProcRuleMbean(MProcRuleMBean mProcRule) {
        try {
            ObjectName esmeObjNname = new ObjectName("org.mobicents.smsc:layer=MProcRule,name=" + mProcRule.getId());
            StandardMBean esmeMxBean = new StandardMBean(mProcRule, MProcRuleMBean.class, true);
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(esmeMxBean, esmeObjNname);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error((Object)String.format("Error while registering MBean for MProcRule %d", mProcRule.getId()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while registering MBean for MProcRule %d", mProcRule.getId()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)String.format("Error while registering MBean for MProcRule %d", mProcRule.getId()), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while registering MBean for MProcRule %d", mProcRule.getId()), (Throwable)e);
        }
    }

    private void unregisterMProcRuleMbean(int mProcRuleId) {
        try {
            ObjectName esmeObjNname = new ObjectName("org.mobicents.smsc:layer=MProcRule,name=" + mProcRuleId);
            if (this.mbeanServer != null) {
                this.mbeanServer.unregisterMBean(esmeObjNname);
            }
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while unregistering MBean for MProcRule %d", mProcRuleId), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)String.format("Error while unregistering MBean for MProcRule %d", mProcRuleId), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while unregistering MBean for MProcRule %d", mProcRuleId), (Throwable)e);
        }
    }

    protected void bindAlias(MProcRuleFactory ruleFactory) {
        Class<?> cls = ruleFactory.createMProcRuleInstance().getClass();
        String alias = ruleFactory.getRuleClassName();
        binding.setAlias(cls, alias);
    }
}

