/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import javolution.util.FastMap;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.smsc.domain.MapVersionCacheMBean;
import org.mobicents.smsc.domain.MapVersionNeg;

public class MapVersionCache
implements MapVersionCacheMBean {
    private FastMap<String, MapVersionNeg> cache = new FastMap().shared();
    private final String name;
    private static MapVersionCache instance;

    private MapVersionCache(String name) {
        this.name = name;
    }

    public static MapVersionCache getInstance(String name) {
        if (instance == null) {
            instance = new MapVersionCache(name);
        }
        return instance;
    }

    public static MapVersionCache getInstance() {
        return instance;
    }

    @Override
    public MAPApplicationContextVersion getMAPApplicationContextVersion(String globalTitleDigits) {
        MapVersionNeg neg = (MapVersionNeg)this.cache.get((Object)globalTitleDigits);
        if (neg != null) {
            return neg.getCurVersion();
        }
        return null;
    }

    public void setMAPApplicationContextVersion(String globalTitleDigits, MAPApplicationContextVersion version) {
        MapVersionNeg neg = (MapVersionNeg)this.cache.get((Object)globalTitleDigits);
        if (neg != null) {
            neg.registerCheckedVersion(version);
        } else {
            neg = new MapVersionNeg(globalTitleDigits);
            this.cache.put((Object)globalTitleDigits, (Object)neg);
            neg.registerCheckedVersion(version);
        }
    }

    @Override
    public void forceMAPApplicationContextVersion(String globalTitleDigits, MAPApplicationContextVersion version) {
        MapVersionNeg neg = new MapVersionNeg(globalTitleDigits);
        this.cache.put((Object)globalTitleDigits, (Object)neg);
        neg.registerCheckedVersion(version);
    }

    @Override
    public FastMap<String, MapVersionNeg> getMAPApplicationContextVersionCache() {
        return this.cache;
    }

    @Override
    public void forceClear() {
        this.cache.clear();
    }
}

