/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javolution.util.FastList;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.smsc.cassandra.SmsRoutingRuleType;
import org.mobicents.smsc.domain.ArchiveSms;
import org.mobicents.smsc.domain.CcMccmncImpl;
import org.mobicents.smsc.domain.ChargingType;
import org.mobicents.smsc.domain.DatabaseSmsRoutingRule;
import org.mobicents.smsc.domain.HomeRoutingManagement;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.MapVersionCache;
import org.mobicents.smsc.domain.MapVersionNeg;
import org.mobicents.smsc.domain.MoChargingType;
import org.mobicents.smsc.domain.Sip;
import org.mobicents.smsc.domain.SipManagement;
import org.mobicents.smsc.domain.SmsRoutingRule;
import org.mobicents.smsc.domain.SmscManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatProvider;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.DbSmsRoutingRule;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.mproc.MProcRule;
import org.mobicents.smsc.smpp.SmppEncoding;
import org.mobicents.ss7.management.console.ShellExecutor;

public class SMSCShellExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(SMSCShellExecutor.class);
    private SmscManagement smscManagement;
    private static SmscPropertiesManagement smscPropertiesManagement;
    private static final MapVersionCache mapVersionCache;
    private static final String LINE_SEPARATOR;
    private static final String MAP_CACHE_KEY_VALUE_SEPARATOR = " : ";

    public void start() throws Exception {
        smscPropertiesManagement = SmscPropertiesManagement.getInstance(this.getSmscManagement().getName());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Started SMSCShellExecutor " + this.getSmscManagement().getName()));
        }
    }

    public SmscManagement getSmscManagement() {
        return this.smscManagement;
    }

    public void setSmscManagement(SmscManagement smscManagement) {
        this.smscManagement = smscManagement;
    }

    private String showSip() {
        SipManagement sipManagement = SipManagement.getInstance();
        List<Sip> sips = sipManagement.getSips();
        if (sips.size() == 0) {
            return "No SIP defined yet";
        }
        StringBuffer sb = new StringBuffer();
        for (Sip sip : sips) {
            sb.append("\n");
            sip.show(sb);
        }
        return sb.toString();
    }

    private String modifySip(String[] args) throws Exception {
        String command;
        if (args.length < 6 || args.length > 22) {
            return "Invalid Command";
        }
        String name = args[3];
        if (name == null) {
            return "Invalid Command";
        }
        SipManagement sipManagement = SipManagement.getInstance();
        Sip sip = sipManagement.getSipByName(name);
        if (sip == null) {
            return String.format("No Sip found with given name %s", name);
        }
        int count = 4;
        boolean success = false;
        while (count < args.length - 1 && (command = args[count++]) != null) {
            String value = args[count++];
            if (command.equals("cluster-name")) {
                sip.setClusterName(value);
                success = true;
                continue;
            }
            if (command.equals("host")) {
                sip.setHost(value);
                success = true;
                continue;
            }
            if (command.equals("port")) {
                sip.setPort(Integer.parseInt(value));
                success = true;
                continue;
            }
            if (command.equals("networkid")) {
                sip.setNetworkId(Integer.parseInt(value));
                success = true;
                continue;
            }
            if (command.equals("routing-ton")) {
                sip.setRoutingTon(Integer.parseInt(value));
                success = true;
                continue;
            }
            if (command.equals("routing-npi")) {
                sip.setRoutingNpi(Integer.parseInt(value));
                success = true;
                continue;
            }
            if (command.equals("routing-range")) {
                sip.setRoutingAddressRange(value);
                success = true;
                continue;
            }
            if (command.equals("counters-enabled")) {
                sip.setCountersEnabled(Boolean.parseBoolean(value));
                success = true;
                continue;
            }
            if (command.equals("charging-enabled")) {
                sip.setChargingEnabled(Boolean.parseBoolean(value));
                success = true;
                continue;
            }
            if (!command.equals("networkid")) continue;
            sip.setNetworkId(Integer.parseInt(value));
            success = true;
        }
        if (!success) {
            return "Invalid Command";
        }
        return String.format("Successfully modified SIP name %s", name);
    }

    private String addMProc(String[] args) throws Exception {
        if (args.length < 6 || args.length > 27) {
            return "Invalid Command";
        }
        MProcManagement mProcManagement = MProcManagement.getInstance();
        String factoryName = args[3];
        int id = Integer.parseInt(args[4]);
        MProcRule mProcRule = mProcManagement.getMProcRuleById(id);
        if (mProcRule != null) {
            return String.format("Creation of MProcRule failed. Other MProcRule with id=%d already exist", id);
        }
        String parametersString = this.assembleString(args, 5);
        mProcManagement.createMProcRule(id, factoryName, parametersString);
        return String.format("Successfully created MProcRule id=%d", id);
    }

    private String assembleString(String[] args, int firstArg) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int i1 = firstArg; i1 < args.length; ++i1) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(" ");
            }
            sb.append(args[i1]);
        }
        return sb.toString();
    }

    private String modifyMProc(String[] args) throws Exception {
        if (args.length < 5 || args.length > 26) {
            return "Invalid Command";
        }
        int id = Integer.parseInt(args[3]);
        MProcManagement mProcManagement = MProcManagement.getInstance();
        String parametersString = this.assembleString(args, 4);
        mProcManagement.modifyMProcRule(id, parametersString);
        return String.format("Successfully modified MProcRule id=%d", id);
    }

    private String removeMProc(String[] args) throws Exception {
        if (args.length < 4 || args.length > 4) {
            return "Invalid Command";
        }
        int id = Integer.parseInt(args[3]);
        MProcManagement mProcManagement = MProcManagement.getInstance();
        mProcManagement.destroyMProcRule(id);
        return String.format("Successfully destroyed MProcRule id=%d", id);
    }

    private String showMProc(String[] args) throws Exception {
        if (args.length < 3 || args.length > 4) {
            return "Invalid Command";
        }
        MProcManagement mProcManagement = MProcManagement.getInstance();
        if (args.length == 3) {
            FastList<MProcRule> lst = mProcManagement.getMProcRules();
            StringBuilder sb = new StringBuilder();
            if (lst.size() == 0) {
                sb.append("No MProcRules");
            } else {
                for (MProcRule rule : lst) {
                    sb.append(rule.toString());
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
        int id = Integer.parseInt(args[3]);
        MProcRule rule = mProcManagement.getMProcRuleById(id);
        if (rule == null) {
            return String.format("No MProcRule - id=%d", id);
        }
        return rule.toString();
    }

    private String executeSmsc(String[] args) {
        try {
            if (args.length < 2 || args.length > 50) {
                return "Invalid Command";
            }
            if (args[1] == null) {
                return "Invalid Command";
            }
            if (args[1].equals("sip")) {
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("modify")) {
                    return this.modifySip(args);
                }
                if (rasCmd.equals("show")) {
                    return this.showSip();
                }
                return "Invalid Command";
            }
            if (args[1].equals("mproc")) {
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("add")) {
                    return this.addMProc(args);
                }
                if (rasCmd.equals("modify")) {
                    return this.modifyMProc(args);
                }
                if (rasCmd.equals("remove")) {
                    return this.removeMProc(args);
                }
                if (rasCmd.equals("show")) {
                    return this.showMProc(args);
                }
                return "Invalid Command";
            }
            if (args[1].equals("set")) {
                return this.manageSet(args);
            }
            if (args[1].equals("get")) {
                return this.manageGet(args);
            }
            if (args[1].equals("remove")) {
                return this.manageRemove(args);
            }
            if (args[1].equals("skipunsentmessages")) {
                return this.skipUnsentMessages(args);
            }
            if (args[1].toLowerCase().equals("databaserule")) {
                if (args.length < 3) {
                    return "Invalid Command";
                }
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                SmsRoutingRule smsRoutingRule = this.smscManagement.getSmsRoutingRule();
                if (!(smsRoutingRule instanceof DatabaseSmsRoutingRule)) {
                    return "DatabaseSmsRoutingRule is not used";
                }
                if (rasCmd.equals("update")) {
                    return this.databaseRuleUpdate(args);
                }
                if (rasCmd.equals("delete")) {
                    return this.databaseRuleDelete(args);
                }
                if (rasCmd.equals("get")) {
                    return this.databaseRuleGet(args);
                }
                if (rasCmd.toLowerCase().equals("getrange")) {
                    return this.databaseRuleGetRange(args);
                }
                return "Invalid Command";
            }
            if (args[1].equals("archive")) {
                if (args.length < 3) {
                    return "Invalid Command";
                }
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("generatecdr")) {
                    return this.archiveGenerateCdr(args);
                }
                return "Invalid Command";
            }
            if (args[1].toLowerCase().equals("mapcache")) {
                if (args.length < 3) {
                    return "Invalid Command";
                }
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("get")) {
                    return this.getMapVersionCache(args);
                }
                if (rasCmd.equals("set")) {
                    return this.setMapVersionCache(args);
                }
                if (rasCmd.equals("clear")) {
                    return this.clearMapVersionCache(args);
                }
                return "Invalid Command";
            }
            if (args[1].toLowerCase().equals("stat")) {
                if (args.length < 3) {
                    return "Invalid Command";
                }
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("get")) {
                    return this.getStat(args);
                }
                return "Invalid Command";
            }
            if (args[1].toLowerCase().equals("updateccmccmnstable")) {
                return this.updateCcMccmnstable(args);
            }
            if (args[1].toLowerCase().equals("hrccmccmnc")) {
                return this.ccMccmnsValueUpdate(args);
            }
            return "Invalid Command";
        }
        catch (Throwable e) {
            logger.error((Object)String.format("Error while executing comand %s", Arrays.toString(args)), e);
            return e.toString();
        }
    }

    private String getMapVersionCache(String[] args) throws Exception {
        if (args.length < 3 || args.length > 4) {
            return "Invalid Command";
        }
        if (args.length == 4) {
            String msisdn = args[3];
            MAPApplicationContextVersion mapApplicationContextVersion = mapVersionCache.getMAPApplicationContextVersion(msisdn);
            if (mapApplicationContextVersion != null) {
                return mapApplicationContextVersion.toString();
            }
            return "No map version found in the cache";
        }
        FastMap<String, MapVersionNeg> cache = mapVersionCache.getMAPApplicationContextVersionCache();
        if (cache.size() == 0) {
            return "No map version found in the cache";
        }
        StringBuffer sb = new StringBuffer();
        FastMap.Entry e = cache.head();
        FastMap.Entry end = cache.tail();
        while ((e = e.getNext()) != end) {
            sb.append((String)e.getKey()).append(MAP_CACHE_KEY_VALUE_SEPARATOR).append(((MapVersionNeg)e.getValue()).getCurVersion()).append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String clearMapVersionCache(String[] args) throws Exception {
        if (args.length != 3) {
            return "Invalid Command";
        }
        mapVersionCache.forceClear();
        return "Successfully cleared version cache";
    }

    private String setMapVersionCache(String[] args) throws Exception {
        if (args.length != 5) {
            return "Invalid Command";
        }
        String msisdn = args[3];
        String version = args[4];
        MAPApplicationContextVersion mapApplicationContextVersion = MAPApplicationContextVersion.getInstance((long)Long.parseLong(version));
        if (mapApplicationContextVersion == null || mapApplicationContextVersion == MAPApplicationContextVersion.version4) {
            return "Invalid version passed, valid values are 1,2 or 3";
        }
        mapVersionCache.forceMAPApplicationContextVersion(msisdn, mapApplicationContextVersion);
        return "Successfully set map version cache";
    }

    private String manageSet(String[] options) throws Exception {
        block86: {
            if (options.length < 4) {
                return "Invalid Command";
            }
            String parName = options[2].toLowerCase();
            try {
                if (parName.equals("scgt")) {
                    String gt = options[3];
                    if (options.length >= 6 && options[4].equals("networkid")) {
                        int val = Integer.parseInt(options[5]);
                        smscPropertiesManagement.setServiceCenterGt(val, gt);
                    } else {
                        smscPropertiesManagement.setServiceCenterGt(gt);
                    }
                    break block86;
                }
                if (parName.equals("scssn")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setServiceCenterSsn(val);
                    break block86;
                }
                if (parName.equals("hlrssn")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setHlrSsn(val);
                    break block86;
                }
                if (parName.equals("mscssn")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setMscSsn(val);
                    break block86;
                }
                if (parName.equals("maxmapv")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setMaxMapVersion(val);
                    break block86;
                }
                if (parName.equals("gti")) {
                    String val;
                    switch (val = options[3]) {
                        case "0001": {
                            smscPropertiesManagement.setGlobalTitleIndicator(GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY);
                            break;
                        }
                        case "0010": {
                            smscPropertiesManagement.setGlobalTitleIndicator(GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY);
                            break;
                        }
                        case "0011": {
                            smscPropertiesManagement.setGlobalTitleIndicator(GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME);
                            break;
                        }
                        case "0100": {
                            smscPropertiesManagement.setGlobalTitleIndicator(GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS);
                            break;
                        }
                        default: {
                            return "Value of gti (global title indicator) is bad (possible values: 0001, 0010, 0011, 0010)";
                        }
                    }
                    break block86;
                }
                if (parName.equals("tt")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setTranslationType(val);
                    break block86;
                }
                if (parName.equals("defaultvalidityperiodhours")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setDefaultValidityPeriodHours(val);
                    break block86;
                }
                if (parName.equals("maxvalidityperiodhours")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setMaxValidityPeriodHours(val);
                    break block86;
                }
                if (parName.equals("defaultton")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setDefaultTon(val);
                    break block86;
                }
                if (parName.equals("defaultnpi")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setDefaultNpi(val);
                    break block86;
                }
                if (parName.equals("subscriberbusyduedelay")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setSubscriberBusyDueDelay(val);
                    break block86;
                }
                if (parName.equals("firstduedelay")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setFirstDueDelay(val);
                    break block86;
                }
                if (parName.equals("secondduedelay")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setSecondDueDelay(val);
                    break block86;
                }
                if (parName.equals("maxduedelay")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setMaxDueDelay(val);
                    break block86;
                }
                if (parName.equals("duedelaymultiplicator")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setDueDelayMultiplicator(val);
                    break block86;
                }
                if (parName.equals("maxmessagelengthreducer")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setMaxMessageLengthReducer(val);
                    break block86;
                }
                if (parName.equals("smppencodingforgsm7")) {
                    String s1 = options[3].toLowerCase();
                    if (s1.equals("utf8")) {
                        smscPropertiesManagement.setSmppEncodingForGsm7(SmppEncoding.Utf8);
                        break block86;
                    }
                    if (s1.equals("unicode")) {
                        smscPropertiesManagement.setSmppEncodingForGsm7(SmppEncoding.Unicode);
                        break block86;
                    }
                    if (s1.equals("gsm7")) {
                        smscPropertiesManagement.setSmppEncodingForGsm7(SmppEncoding.Gsm7);
                        break block86;
                    }
                    return String.format("Illegal argument %s: %s", "SmppEncodingForGsm7 value", "UTF8 or UNICODE or GSM7 are possible");
                }
                if (parName.equals("smppencodingforucs2")) {
                    String s1 = options[3].toLowerCase();
                    if (s1.equals("utf8")) {
                        smscPropertiesManagement.setSmppEncodingForUCS2(SmppEncoding.Utf8);
                        break block86;
                    }
                    if (s1.equals("unicode")) {
                        smscPropertiesManagement.setSmppEncodingForUCS2(SmppEncoding.Unicode);
                        break block86;
                    }
                    if (s1.equals("gsm7")) {
                        smscPropertiesManagement.setSmppEncodingForUCS2(SmppEncoding.Gsm7);
                        break block86;
                    }
                    return String.format("Illegal argument %s: %s", "SmppEncodingForUCS2 value", "UTF8 or UNICODE or GSM7 are possible");
                }
                if (parName.equals("dbhosts")) {
                    String val = options[3];
                    smscPropertiesManagement.setDbHosts(val);
                    break block86;
                }
                if (parName.equals("dbport")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setDbPort(val);
                    break block86;
                }
                if (parName.equals("keyspacename")) {
                    String val = options[3];
                    smscPropertiesManagement.setKeyspaceName(val);
                    break block86;
                }
                if (parName.equals("clustername")) {
                    String val = options[3];
                    smscPropertiesManagement.setClusterName(val);
                    break block86;
                }
                if (parName.equals("fetchperiod")) {
                    long val = Long.parseLong(options[3]);
                    smscPropertiesManagement.setFetchPeriod(val);
                    break block86;
                }
                if (parName.equals("fetchmaxrows")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setFetchMaxRows(val);
                    break block86;
                }
                if (parName.equals("maxactivitycount")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setMaxActivityCount(val);
                    break block86;
                }
                if (parName.equals("esmedefaultcluster")) {
                    smscPropertiesManagement.setEsmeDefaultClusterName(options[3]);
                    break block86;
                }
                if (parName.equals("correlationidlivetime")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setCorrelationIdLiveTime(val);
                    break block86;
                }
                if (parName.equals("sriresponselivetime")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setSriResponseLiveTime(val);
                    break block86;
                }
                if (parName.equals("revisesecondsonsmscstart")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setReviseSecondsOnSmscStart(val);
                    break block86;
                }
                if (parName.equals("processingsmssettimeout")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setProcessingSmsSetTimeout(val);
                    break block86;
                }
                if (parName.equals("generatereceiptcdr")) {
                    smscPropertiesManagement.setGenerateReceiptCdr(Boolean.parseBoolean(options[3]));
                    break block86;
                }
                if (parName.equals("receiptsdisabling")) {
                    smscPropertiesManagement.setReceiptsDisabling(Boolean.parseBoolean(options[3]));
                    break block86;
                }
                if (parName.equals("enableintermediatereceipts")) {
                    smscPropertiesManagement.setEnableIntermediateReceipts(Boolean.parseBoolean(options[3]));
                    break block86;
                }
                if (parName.equals("enableintermediatereceipts")) {
                    smscPropertiesManagement.setEnableIntermediateReceipts(Boolean.parseBoolean(options[3]));
                    break block86;
                }
                if (parName.equals("incomereceiptsprocessing")) {
                    smscPropertiesManagement.setIncomeReceiptsProcessing(Boolean.parseBoolean(options[3]));
                    break block86;
                }
                if (parName.equals("orignetworkidforreceipts")) {
                    smscPropertiesManagement.setOrigNetworkIdForReceipts(Boolean.parseBoolean(options[3]));
                    break block86;
                }
                if (parName.equals("generatecdr")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setGenerateCdrInt(val);
                    break block86;
                }
                if (parName.equals("generatearchivetable")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setGenerateArchiveTableInt(val);
                    break block86;
                }
                if (parName.equals("storeandforwordmode")) {
                    smscPropertiesManagement.setStoreAndForwordMode(Enum.valueOf(StoreAndForwordMode.class, options[3]));
                    break block86;
                }
                if (parName.equals("mocharging")) {
                    smscPropertiesManagement.setMoCharging(Enum.valueOf(MoChargingType.class, options[3]));
                    break block86;
                }
                if (parName.equals("hrcharging")) {
                    smscPropertiesManagement.setHrCharging(Enum.valueOf(MoChargingType.class, options[3]));
                    break block86;
                }
                if (parName.equals("txsmppcharging")) {
                    smscPropertiesManagement.setTxSmppChargingType(Enum.valueOf(ChargingType.class, options[3]));
                    break block86;
                }
                if (parName.equals("txsipcharging")) {
                    smscPropertiesManagement.setTxSipChargingType(Enum.valueOf(ChargingType.class, options[3]));
                    break block86;
                }
                if (parName.equals("diameterdestrealm")) {
                    String val = options[3];
                    smscPropertiesManagement.setDiameterDestRealm(val);
                    break block86;
                }
                if (parName.equals("diameterdesthost")) {
                    String val = options[3];
                    smscPropertiesManagement.setDiameterDestHost(val);
                    break block86;
                }
                if (parName.equals("diameterdestport")) {
                    int val = Integer.parseInt(options[3]);
                    smscPropertiesManagement.setDiameterDestPort(val);
                    break block86;
                }
                if (parName.equals("diameterusername")) {
                    String val = options[3];
                    smscPropertiesManagement.setDiameterUserName(val);
                    break block86;
                }
                if (parName.equals("removinglivetablesdays")) {
                    int val = Integer.parseInt(options[3]);
                    if (val == 1 || val == 2 || val < 0) {
                        return "Value of removingLiveTablesDays or removingArcjiveTablesDays must be 0 (disabling of the feature) or >=3";
                    }
                    smscPropertiesManagement.setRemovingLiveTablesDays(val);
                    break block86;
                }
                if (parName.equals("removingarchivetablesdays")) {
                    int val = Integer.parseInt(options[3]);
                    if (val == 1 || val == 2 || val < 0) {
                        return "Value of removingLiveTablesDays or removingArcjiveTablesDays must be 0 (disabling of the feature) or >=3";
                    }
                    smscPropertiesManagement.setRemovingArchiveTablesDays(val);
                    break block86;
                }
                if (parName.equals("hrhlrnumber")) {
                    String hrhlrnumber = options[3];
                    if (options.length >= 6 && options[4].equals("networkid")) {
                        int val = Integer.parseInt(options[5]);
                        smscPropertiesManagement.setHrHlrNumber(val, hrhlrnumber);
                    } else {
                        smscPropertiesManagement.setHrHlrNumber(hrhlrnumber);
                    }
                    break block86;
                }
                if (parName.equals("hrsribypass")) {
                    boolean hrsribypass = Boolean.parseBoolean(options[3]);
                    if (options.length >= 6 && options[4].equals("networkid")) {
                        int val = Integer.parseInt(options[5]);
                        smscPropertiesManagement.setHrSriBypass(val, hrsribypass);
                    } else {
                        smscPropertiesManagement.setHrSriBypass(hrsribypass);
                    }
                    break block86;
                }
                if (parName.equals("nationallanguagesingleshift")) {
                    int val = Integer.parseInt(options[3]);
                    if (val < 0 || val > 13) {
                        return "National language shift shift value must be between 0 and 13";
                    }
                    smscPropertiesManagement.setNationalLanguageSingleShift(val);
                    break block86;
                }
                if (parName.equals("nationallanguagelockingshift")) {
                    int val = Integer.parseInt(options[3]);
                    if (val < 0 || val > 13) {
                        return "National language shift shift value must be between 0 and 13";
                    }
                    smscPropertiesManagement.setNationalLanguageLockingShift(val);
                    break block86;
                }
                if (parName.equals("deliverypause")) {
                    boolean val = Boolean.parseBoolean(options[3]);
                    smscPropertiesManagement.setDeliveryPause(val);
                    break block86;
                }
                return "Invalid Command";
            }
            catch (IllegalArgumentException e) {
                return String.format("Illegal argument %s: %s", parName, e.getMessage());
            }
        }
        return "Parameter has been successfully set";
    }

    private String manageRemove(String[] options) throws Exception {
        block10: {
            if (options.length < 3) {
                return "Invalid Command";
            }
            String parName = options[2].toLowerCase();
            try {
                if (parName.equals("esmedefaultcluster")) {
                    smscPropertiesManagement.setEsmeDefaultClusterName(null);
                    break block10;
                }
                if (parName.equals("hrhlrnumber")) {
                    if (options.length >= 5 && options[3].equals("networkid")) {
                        int val = Integer.parseInt(options[4]);
                        smscPropertiesManagement.setHrHlrNumber(val, null);
                    } else {
                        smscPropertiesManagement.setHrHlrNumber(null);
                    }
                    break block10;
                }
                if (parName.equals("hrsribypass")) {
                    if (options.length >= 5 && options[3].equals("networkid")) {
                        int val = Integer.parseInt(options[4]);
                        smscPropertiesManagement.removeHrSriBypassForNetworkId(val);
                    } else {
                        smscPropertiesManagement.removeHrSriBypassForNetworkId(0);
                    }
                    break block10;
                }
                return "Invalid Command";
            }
            catch (IllegalArgumentException e) {
                return String.format("Illegal argument %s: %s", parName, e.getMessage());
            }
        }
        return "Parameter has been successfully removed";
    }

    private String skipUnsentMessages(String[] options) throws Exception {
        if (options.length < 3) {
            return "Invalid Command";
        }
        int val = Integer.parseInt(options[2]);
        try {
            if (val < 0) {
                return "skip-unsent-messages command accepts only non negative values";
            }
            smscPropertiesManagement.setSkipUnsentMessages(val);
        }
        catch (IllegalArgumentException e) {
            return String.format("Illegal argument %s: %s", options[2], e.getMessage());
        }
        String s = new Date(new Date().getTime() - (long)(val * 1000) - 10000L).toString();
        return String.format("skip-unsent-messages command has been accepted to skip unsent messages till time %s", s);
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length == 3) {
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("scgt")) {
                sb.append("networkId=0 - GT=");
                sb.append(smscPropertiesManagement.getServiceCenterGt());
                for (Integer key : smscPropertiesManagement.getNetworkIdVsServiceCenterGt().keySet()) {
                    sb.append("\nnetworkId=");
                    sb.append(key);
                    sb.append(" - GT=");
                    sb.append(smscPropertiesManagement.getNetworkIdVsServiceCenterGt().get(key));
                }
            } else if (parName.equals("scssn")) {
                sb.append(smscPropertiesManagement.getServiceCenterSsn());
            } else if (parName.equals("hlrssn")) {
                sb.append(smscPropertiesManagement.getHlrSsn());
            } else if (parName.equals("mscssn")) {
                sb.append(smscPropertiesManagement.getMscSsn());
            } else if (parName.equals("maxmapv")) {
                sb.append(smscPropertiesManagement.getMaxMapVersion());
            } else if (parName.equals("gti")) {
                switch (smscPropertiesManagement.getGlobalTitleIndicator()) {
                    case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                        sb.append("0001");
                        break;
                    }
                    case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                        sb.append("0010");
                        break;
                    }
                    case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                        sb.append("0011");
                        break;
                    }
                    case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                        sb.append("0100");
                    }
                }
            } else if (parName.equals("tt")) {
                sb.append(smscPropertiesManagement.getTranslationType());
            } else if (parName.equals("defaultvalidityperiodhours")) {
                sb.append(smscPropertiesManagement.getDefaultValidityPeriodHours());
            } else if (parName.equals("maxvalidityperiodhours")) {
                sb.append(smscPropertiesManagement.getMaxValidityPeriodHours());
            } else if (parName.equals("defaultton")) {
                sb.append(smscPropertiesManagement.getDefaultTon());
            } else if (parName.equals("defaultnpi")) {
                sb.append(smscPropertiesManagement.getDefaultNpi());
            } else if (parName.equals("subscriberbusyduedelay")) {
                sb.append(smscPropertiesManagement.getSubscriberBusyDueDelay());
            } else if (parName.equals("firstduedelay")) {
                sb.append(smscPropertiesManagement.getFirstDueDelay());
            } else if (parName.equals("secondduedelay")) {
                sb.append(smscPropertiesManagement.getSecondDueDelay());
            } else if (parName.equals("maxduedelay")) {
                sb.append(smscPropertiesManagement.getMaxDueDelay());
            } else if (parName.equals("duedelaymultiplicator")) {
                sb.append(smscPropertiesManagement.getDueDelayMultiplicator());
            } else if (parName.equals("maxmessagelengthreducer")) {
                sb.append(smscPropertiesManagement.getMaxMessageLengthReducer());
            } else if (parName.equals("smppencodingforgsm7")) {
                sb.append(smscPropertiesManagement.getSmppEncodingForGsm7());
            } else if (parName.equals("smppencodingforucs2")) {
                sb.append(smscPropertiesManagement.getSmppEncodingForUCS2());
            } else if (parName.equals("dbhosts")) {
                sb.append(smscPropertiesManagement.getDbHosts());
            } else if (parName.equals("dbport")) {
                sb.append(smscPropertiesManagement.getDbPort());
            } else if (parName.equals("keyspacename")) {
                sb.append(smscPropertiesManagement.getKeyspaceName());
            } else if (parName.equals("clustername")) {
                sb.append(smscPropertiesManagement.getClusterName());
            } else if (parName.equals("fetchperiod")) {
                sb.append(smscPropertiesManagement.getFetchPeriod());
            } else if (parName.equals("fetchmaxrows")) {
                sb.append(smscPropertiesManagement.getFetchMaxRows());
            } else if (parName.equals("maxactivitycount")) {
                sb.append(smscPropertiesManagement.getMaxActivityCount());
            } else if (parName.equals("esmedefaultcluster")) {
                sb.append(smscPropertiesManagement.getEsmeDefaultClusterName());
            } else if (parName.equals("correlationidlivetime")) {
                sb.append(smscPropertiesManagement.getCorrelationIdLiveTime());
            } else if (parName.equals("sriresponselivetime")) {
                sb.append(smscPropertiesManagement.getSriResponseLiveTime());
            } else if (parName.equals("revisesecondsonsmscstart")) {
                sb.append(smscPropertiesManagement.getReviseSecondsOnSmscStart());
            } else if (parName.equals("processingsmssettimeout")) {
                sb.append(smscPropertiesManagement.getProcessingSmsSetTimeout());
            } else if (parName.equals("generatereceiptcdr")) {
                sb.append(smscPropertiesManagement.getGenerateReceiptCdr());
            } else if (parName.equals("receiptsdisabling")) {
                sb.append(smscPropertiesManagement.getReceiptsDisabling());
            } else if (parName.equals("enableintermediatereceipts")) {
                sb.append(smscPropertiesManagement.getEnableIntermediateReceipts());
            } else if (parName.equals("orignetworkidforreceipts")) {
                sb.append(smscPropertiesManagement.getOrigNetworkIdForReceipts());
            } else if (parName.equals("incomereceiptsprocessing")) {
                sb.append(smscPropertiesManagement.getIncomeReceiptsProcessing());
            } else if (parName.equals("generatearchivetable")) {
                sb.append(smscPropertiesManagement.getGenerateArchiveTable().getValue());
            } else if (parName.equals("storeandforwordmode")) {
                sb.append((Object)smscPropertiesManagement.getStoreAndForwordMode());
            } else if (parName.equals("mocharging")) {
                sb.append((Object)smscPropertiesManagement.getMoCharging());
            } else if (parName.equals("hrcharging")) {
                sb.append((Object)smscPropertiesManagement.getHrCharging());
            } else if (parName.equals("txsmppcharging")) {
                sb.append((Object)smscPropertiesManagement.getTxSmppChargingType());
            } else if (parName.equals("txsipcharging")) {
                sb.append((Object)smscPropertiesManagement.getTxSipChargingType());
            } else if (parName.equals("diameterdestrealm")) {
                sb.append(smscPropertiesManagement.getDiameterDestRealm());
            } else if (parName.equals("diameterdesthost")) {
                sb.append(smscPropertiesManagement.getDiameterDestHost());
            } else if (parName.equals("diameterdestport")) {
                sb.append(smscPropertiesManagement.getDiameterDestPort());
            } else if (parName.equals("diameterusername")) {
                sb.append(smscPropertiesManagement.getDiameterUserName());
            } else if (parName.equals("removinglivetablesdays")) {
                sb.append(smscPropertiesManagement.getRemovingLiveTablesDays());
            } else if (parName.equals("removingarchivetablesdays")) {
                sb.append(smscPropertiesManagement.getRemovingArchiveTablesDays());
            } else if (parName.equals("hrhlrnumber")) {
                sb.append("networkId=0 - hrhlrnumber=");
                sb.append(smscPropertiesManagement.getHrHlrNumber());
                for (Integer key : smscPropertiesManagement.getNetworkIdVsHrHlrNumber().keySet()) {
                    sb.append("\nnetworkId=");
                    sb.append(key);
                    sb.append(" - hrhlrnumber=");
                    sb.append(smscPropertiesManagement.getNetworkIdVsHrHlrNumber().get(key));
                }
            } else if (parName.equals("hrsribypass")) {
                sb.append("networkId=0 - hrsribypass=");
                sb.append(smscPropertiesManagement.getHrSriBypass());
                for (Integer key : smscPropertiesManagement.getNetworkIdVsHrSriBypass().keySet()) {
                    sb.append("\nnetworkId=");
                    sb.append(key);
                    sb.append(" - hrsribypass=");
                    sb.append(smscPropertiesManagement.getNetworkIdVsHrSriBypass().get(key));
                }
            } else if (parName.equals("nationallanguagesingleshift")) {
                sb.append(smscPropertiesManagement.getNationalLanguageSingleShift());
            } else if (parName.equals("nationallanguagelockingshift")) {
                sb.append(smscPropertiesManagement.getNationalLanguageLockingShift());
            } else if (parName.equals("deliverypause")) {
                sb.append(smscPropertiesManagement.isDeliveryPause());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("scgt : ");
        sb.append("networkId=0 - GT=");
        sb.append(smscPropertiesManagement.getServiceCenterGt());
        for (Integer key : smscPropertiesManagement.getNetworkIdVsServiceCenterGt().keySet()) {
            if (key == null) continue;
            sb.append("\nnetworkId=");
            sb.append(key);
            sb.append(" - GT=");
            sb.append(smscPropertiesManagement.getNetworkIdVsServiceCenterGt().get(key));
        }
        sb.append("\n");
        sb.append("scssn = ");
        sb.append(smscPropertiesManagement.getServiceCenterSsn());
        sb.append("\n");
        sb.append("hlrssn = ");
        sb.append(smscPropertiesManagement.getHlrSsn());
        sb.append("\n");
        sb.append("mscssn = ");
        sb.append(smscPropertiesManagement.getMscSsn());
        sb.append("\n");
        sb.append("maxmapv = ");
        sb.append(smscPropertiesManagement.getMaxMapVersion());
        sb.append("\n");
        sb.append("gti = ");
        switch (smscPropertiesManagement.getGlobalTitleIndicator()) {
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                sb.append("0001");
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                sb.append("0010");
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                sb.append("0011");
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                sb.append("0100");
            }
        }
        sb.append("\n");
        sb.append("tt = ");
        sb.append(smscPropertiesManagement.getTranslationType());
        sb.append("\n");
        sb.append("defaultvalidityperiodhours = ");
        sb.append(smscPropertiesManagement.getDefaultValidityPeriodHours());
        sb.append("\n");
        sb.append("maxvalidityperiodhours = ");
        sb.append(smscPropertiesManagement.getMaxValidityPeriodHours());
        sb.append("\n");
        sb.append("defaultton = ");
        sb.append(smscPropertiesManagement.getDefaultTon());
        sb.append("\n");
        sb.append("defaultnpi = ");
        sb.append(smscPropertiesManagement.getDefaultNpi());
        sb.append("\n");
        sb.append("subscriberbusyduedelay = ");
        sb.append(smscPropertiesManagement.getSubscriberBusyDueDelay());
        sb.append("\n");
        sb.append("firstduedelay = ");
        sb.append(smscPropertiesManagement.getFirstDueDelay());
        sb.append("\n");
        sb.append("secondduedelay = ");
        sb.append(smscPropertiesManagement.getSecondDueDelay());
        sb.append("\n");
        sb.append("maxduedelay = ");
        sb.append(smscPropertiesManagement.getMaxDueDelay());
        sb.append("\n");
        sb.append("duedelaymultiplicator = ");
        sb.append(smscPropertiesManagement.getDueDelayMultiplicator());
        sb.append("\n");
        sb.append("maxmessagelengthreducer = ");
        sb.append(smscPropertiesManagement.getMaxMessageLengthReducer());
        sb.append("\n");
        sb.append("smppencodingforgsm7 = ");
        sb.append(smscPropertiesManagement.getSmppEncodingForGsm7());
        sb.append("\n");
        sb.append("smppencodingforucs2 = ");
        sb.append(smscPropertiesManagement.getSmppEncodingForUCS2());
        sb.append("\n");
        sb.append("dbhosts = ");
        sb.append(smscPropertiesManagement.getDbHosts());
        sb.append("\n");
        sb.append("dbport = ");
        sb.append(smscPropertiesManagement.getDbPort());
        sb.append("\n");
        sb.append("keyspaceName = ");
        sb.append(smscPropertiesManagement.getKeyspaceName());
        sb.append("\n");
        sb.append("maxactivitycount = ");
        sb.append(smscPropertiesManagement.getMaxActivityCount());
        sb.append("\n");
        sb.append("fetchperiod = ");
        sb.append(smscPropertiesManagement.getFetchPeriod());
        sb.append("\n");
        sb.append("fetchmaxrows = ");
        sb.append(smscPropertiesManagement.getFetchMaxRows());
        sb.append("\n");
        sb.append("maxactivitycount = ");
        sb.append(smscPropertiesManagement.getMaxActivityCount());
        sb.append("\n");
        sb.append("esmedefaultcluster = ");
        sb.append(smscPropertiesManagement.getEsmeDefaultClusterName());
        sb.append("\n");
        sb.append("correlationidlivetime = ");
        sb.append(smscPropertiesManagement.getCorrelationIdLiveTime());
        sb.append("\n");
        sb.append("sriresponselivetime = ");
        sb.append(smscPropertiesManagement.getSriResponseLiveTime());
        sb.append("\n");
        sb.append("revisesecondsonsmscstart = ");
        sb.append(smscPropertiesManagement.getReviseSecondsOnSmscStart());
        sb.append("\n");
        sb.append("processingsmssettimeout = ");
        sb.append(smscPropertiesManagement.getProcessingSmsSetTimeout());
        sb.append("\n");
        sb.append("generatereceiptcdr = ");
        sb.append(smscPropertiesManagement.getGenerateReceiptCdr());
        sb.append("\n");
        sb.append("receiptsdisabling = ");
        sb.append(smscPropertiesManagement.getReceiptsDisabling());
        sb.append("\n");
        sb.append("enableintermediatereceipts = ");
        sb.append(smscPropertiesManagement.getEnableIntermediateReceipts());
        sb.append("\n");
        sb.append("incomereceiptsprocessing = ");
        sb.append(smscPropertiesManagement.getIncomeReceiptsProcessing());
        sb.append("\n");
        sb.append("orignetworkidforreceipts = ");
        sb.append(smscPropertiesManagement.getOrigNetworkIdForReceipts());
        sb.append("\n");
        sb.append("generatecdr = ");
        sb.append(smscPropertiesManagement.getGenerateCdr().getValue());
        sb.append("\n");
        sb.append("generatearchivetable = ");
        sb.append(smscPropertiesManagement.getGenerateArchiveTable().getValue());
        sb.append("\n");
        sb.append("storeandforwordmode = ");
        sb.append((Object)smscPropertiesManagement.getStoreAndForwordMode());
        sb.append("\n");
        sb.append("mocharging = ");
        sb.append((Object)smscPropertiesManagement.getMoCharging());
        sb.append("\n");
        sb.append("hrcharging = ");
        sb.append((Object)smscPropertiesManagement.getHrCharging());
        sb.append("\n");
        sb.append("txsmppcharging = ");
        sb.append((Object)smscPropertiesManagement.getTxSmppChargingType());
        sb.append("\n");
        sb.append("txsipcharging = ");
        sb.append((Object)smscPropertiesManagement.getTxSipChargingType());
        sb.append("\n");
        sb.append("diameterdestrealm = ");
        sb.append(smscPropertiesManagement.getDiameterDestRealm());
        sb.append("\n");
        sb.append("diameterdesthost = ");
        sb.append(smscPropertiesManagement.getDiameterDestHost());
        sb.append("\n");
        sb.append("diameterdestport = ");
        sb.append(smscPropertiesManagement.getDiameterDestPort());
        sb.append("\n");
        sb.append("diameterusername = ");
        sb.append(smscPropertiesManagement.getDiameterUserName());
        sb.append("\n");
        sb.append("removinglivetablesdays = ");
        sb.append(smscPropertiesManagement.getRemovingLiveTablesDays());
        sb.append("\n");
        sb.append("removingarchivetablesdays = ");
        sb.append(smscPropertiesManagement.getRemovingArchiveTablesDays());
        sb.append("\n");
        sb.append("hrhlrnumber : ");
        sb.append("networkId=0 - hrhlrnumber=");
        sb.append(smscPropertiesManagement.getHrHlrNumber());
        for (Integer key : smscPropertiesManagement.getNetworkIdVsHrHlrNumber().keySet()) {
            if (key == null) continue;
            sb.append("\nnetworkId=");
            sb.append(key);
            sb.append(" - hrhlrnumber=");
            sb.append(smscPropertiesManagement.getNetworkIdVsHrHlrNumber().get(key));
        }
        sb.append("\n");
        sb.append("hrsribypass : ");
        sb.append("networkId=0 - hrsribypass=");
        sb.append(smscPropertiesManagement.getHrSriBypass());
        for (Integer key : smscPropertiesManagement.getNetworkIdVsHrSriBypass().keySet()) {
            if (key == null) continue;
            sb.append("\nnetworkId=");
            sb.append(key);
            sb.append(" - hrsribypass=");
            sb.append(smscPropertiesManagement.getNetworkIdVsHrSriBypass().get(key));
        }
        sb.append("\n");
        sb.append("nationallanguagesingleshift = ");
        sb.append(smscPropertiesManagement.getNationalLanguageSingleShift());
        sb.append("\n");
        sb.append("nationallanguagelockingshift = ");
        sb.append(smscPropertiesManagement.getNationalLanguageLockingShift());
        sb.append("\n");
        sb.append("deliverypause = ");
        sb.append(smscPropertiesManagement.isDeliveryPause());
        sb.append("\n");
        return sb.toString();
    }

    private String databaseRuleUpdate(String[] args) throws Exception {
        String command;
        DatabaseSmsRoutingRule smsRoutingRule = (DatabaseSmsRoutingRule)this.smscManagement.getSmsRoutingRule();
        if (args.length < 5 || args.length > 8) {
            return "Invalid Command";
        }
        String address = args[3];
        if (address == null) {
            return "Invalid Command";
        }
        String systemId = args[4];
        if (systemId == null) {
            return "Invalid Command";
        }
        int count = 5;
        SmsRoutingRuleType smsRoutingRuleType = SmsRoutingRuleType.SMPP;
        int networkId = 0;
        while (count < args.length && (command = args[count++]) != null) {
            if (command.equals("SMPP") || command.equals("SIP")) {
                smsRoutingRuleType = SmsRoutingRuleType.valueOf((String)command);
                continue;
            }
            if (!command.equals("networkid") || count >= args.length) continue;
            String value = args[count++];
            networkId = Integer.parseInt(value);
        }
        smsRoutingRule.updateDbSmsRoutingRule(smsRoutingRuleType, address, networkId, systemId);
        return String.format("Successfully updated databaseRule %s address=%s networkId=%d", smsRoutingRuleType.toString(), address, networkId);
    }

    private String databaseRuleDelete(String[] args) throws Exception {
        String command;
        DatabaseSmsRoutingRule smsRoutingRule = (DatabaseSmsRoutingRule)this.smscManagement.getSmsRoutingRule();
        if (args.length < 4 || args.length > 7) {
            return "Invalid Command";
        }
        String address = args[3];
        if (address == null) {
            return "Invalid Command";
        }
        int count = 4;
        SmsRoutingRuleType smsRoutingRuleType = SmsRoutingRuleType.SMPP;
        int networkId = 0;
        while (count < args.length && (command = args[count++]) != null) {
            if (command.equals("SMPP") || command.equals("SIP")) {
                smsRoutingRuleType = SmsRoutingRuleType.valueOf((String)command);
                continue;
            }
            if (!command.equals("networkid") || count >= args.length) continue;
            String value = args[count++];
            networkId = Integer.parseInt(value);
        }
        smsRoutingRule.deleteDbSmsRoutingRule(smsRoutingRuleType, address, networkId);
        return String.format("Successfully deleted databaseRule %s address=%s networkId=%d", smsRoutingRuleType.toString(), address, networkId);
    }

    private String databaseRuleGet(String[] args) throws Exception {
        String command;
        DatabaseSmsRoutingRule smsRoutingRule = (DatabaseSmsRoutingRule)this.smscManagement.getSmsRoutingRule();
        if (args.length < 4 || args.length > 7) {
            return "Invalid Command";
        }
        String address = args[3];
        if (address == null) {
            return "Invalid Command";
        }
        int count = 4;
        SmsRoutingRuleType smsRoutingRuleType = SmsRoutingRuleType.SMPP;
        int networkId = 0;
        while (count < args.length && (command = args[count++]) != null) {
            if (command.equals("SMPP") || command.equals("SIP")) {
                smsRoutingRuleType = SmsRoutingRuleType.valueOf((String)command);
                continue;
            }
            if (!command.equals("networkid") || count >= args.length) continue;
            String value = args[count++];
            networkId = Integer.parseInt(value);
        }
        DbSmsRoutingRule res = smsRoutingRule.getSmsRoutingRule(smsRoutingRuleType, address, networkId);
        if (res == null) {
            return String.format("No Routing rule defined yet for %s address %s networkId %d", smsRoutingRuleType.name(), address, networkId);
        }
        return res.toString();
    }

    private String databaseRuleGetRange(String[] args) throws Exception {
        DatabaseSmsRoutingRule smsRoutingRule = (DatabaseSmsRoutingRule)this.smscManagement.getSmsRoutingRule();
        if (args.length < 4 || args.length > 5) {
            return "Invalid Command";
        }
        SmsRoutingRuleType smsRoutingRuleType = SmsRoutingRuleType.valueOf((String)args[3]);
        if (smsRoutingRuleType == null) {
            return "Invalid Command";
        }
        String address = null;
        if (args.length == 5 && (address = args[4]) == null) {
            return "Invalid Command";
        }
        List<DbSmsRoutingRule> res = smsRoutingRule.getSmsRoutingRulesRange(smsRoutingRuleType, address);
        StringBuilder sb = new StringBuilder();
        boolean i1 = false;
        for (DbSmsRoutingRule rr : res) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append("\n");
            }
            sb.append(rr.toString());
        }
        return sb.toString();
    }

    private String archiveGenerateCdr(String[] args) throws Exception {
        if (args.length < 5 || args.length > 5) {
            return "Invalid Command";
        }
        String timeFromS = args[3];
        String timeToS = args[4];
        if (timeFromS == null || timeToS == null) {
            return "Invalid Command";
        }
        SimpleDateFormat df = new SimpleDateFormat();
        Date timeFrom = df.parse(timeFromS);
        if (timeFrom == null) {
            return "Bad formatted dateFrom field";
        }
        Date timeTo = df.parse(timeToS);
        if (timeTo == null) {
            return "Bad formatted dateTo field";
        }
        ArchiveSms.getInstance().makeCdrDatabaseManualExport(timeFrom, timeTo);
        return "Successfully accepted request to generate CDR";
    }

    public String getStat(String[] args) {
        StringBuilder sb = new StringBuilder();
        SmscStatProvider smscStatProvider = SmscStatProvider.getInstance();
        sb.append("Stat: ");
        sb.append("Time: ");
        sb.append(new Date());
        sb.append(", MessageInProcess: ");
        sb.append(smscStatProvider.getMessageInProcess());
        sb.append(", MessageId: ");
        sb.append(smscStatProvider.getCurrentMessageId());
        sb.append(", MessageScheduledTotal: ");
        sb.append(smscStatProvider.getMessageScheduledTotal());
        sb.append(", DueSlotProcessingLag: ");
        sb.append(smscStatProvider.getDueSlotProcessingLag());
        sb.append(", DueSlotProcessingTime: ");
        sb.append(smscStatProvider.getDueSlotProcessingTime());
        sb.append(", Param1: ");
        sb.append(smscStatProvider.getParam1());
        sb.append(", Param2: ");
        sb.append(smscStatProvider.getParam2());
        sb.append(", SmscStartTime: ");
        sb.append(smscStatProvider.getSmscStartTime());
        String s1 = SmsSetCache.getInstance().getLstSmsSetWithBigMessageCountState();
        if (s1 != null) {
            sb.append("\nLstSmsSetWithBigMessageCountState:\n");
            sb.append(s1);
        }
        return sb.toString();
    }

    public String updateCcMccmnstable(String[] args) {
        HomeRoutingManagement homeRoutingManagement = HomeRoutingManagement.getInstance();
        if (homeRoutingManagement != null) {
            homeRoutingManagement.updateCcMccmncTable();
        }
        return "cc_mccmnc correlation table has been loaded";
    }

    public String ccMccmnsValueUpdate(String[] args) throws Exception {
        if (args.length < 3 || args.length > 7) {
            return "Invalid Command";
        }
        HomeRoutingManagement homeRoutingManagement = HomeRoutingManagement.getInstance();
        if (homeRoutingManagement == null) {
            return "HomeRoutingManagement is absent";
        }
        String cmd = args[2];
        String cc = null;
        if (args.length >= 4 && (cc = args[3]) == null) {
            return "Invalid Command";
        }
        if (cmd.equals("add")) {
            if (args.length < 5) {
                return "Invalid Command";
            }
            String mccmnc = args[4];
            String smsc = null;
            if (args.length >= 7 && args[5] != null && args[5].equals("smscgt") && (smsc = args[6]) != null && smsc.equals("-1")) {
                smsc = null;
            }
            homeRoutingManagement.addCcMccmnc(cc, mccmnc, smsc);
            return "CcMccmnc ha successfully added";
        }
        if (cmd.equals("modify")) {
            if (args.length < 5) {
                return "Invalid Command";
            }
            String mccmnc = args[4];
            String smsc = null;
            if (args.length >= 7 && args[5] != null && args[5].equals("smscgt") && (smsc = args[6]) != null && smsc.equals("-1")) {
                smsc = null;
            }
            homeRoutingManagement.modifyCcMccmnc(cc, mccmnc, smsc);
            return "CcMccmnc ha successfully modified";
        }
        if (cmd.equals("remove")) {
            homeRoutingManagement.removeCcMccmnc(cc);
            return "CcMccmnc ha successfully removed";
        }
        if (cmd.equals("show")) {
            if (cc == null) {
                Map<String, CcMccmncImpl> map = homeRoutingManagement.getCcMccmncMap();
                StringBuilder sb = new StringBuilder();
                sb.append("CcMccmnc table: [\n");
                for (CcMccmncImpl val : map.values()) {
                    sb.append(val.toString());
                    sb.append("\n");
                }
                sb.append("]");
                return sb.toString();
            }
            CcMccmncImpl ccMccmnc = (CcMccmncImpl)homeRoutingManagement.getCcMccmnc(cc);
            if (ccMccmnc != null) {
                return ccMccmnc.toString();
            }
            return String.format("CcMccmnc is absent: %s", cc);
        }
        return "Invalid Command";
    }

    public String execute(String[] args) {
        if (args[0].equals("smsc")) {
            return this.executeSmsc(args);
        }
        return "Invalid Command";
    }

    public boolean handles(String command) {
        return "smsc".equals(command);
    }

    public static void main(String[] args) throws Exception {
        String command = "smsc mapcache get 1234567";
        SMSCShellExecutor exec = new SMSCShellExecutor();
        exec.getMapVersionCache(command.split(" "));
    }

    static {
        mapVersionCache = MapVersionCache.getInstance();
        LINE_SEPARATOR = System.getProperty("line.separator");
    }
}

