/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.mobicents.smsc.domain.HttpUser;
import org.mobicents.smsc.domain.HttpUserMBean;
import org.mobicents.smsc.domain.HttpUsersManagementMBean;

public class HttpUsersManagement
implements HttpUsersManagementMBean {
    private static final Logger logger = Logger.getLogger(HttpUsersManagement.class);
    private static final String USER_LIST = "userList";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "httpusers.xml";
    private final String name;
    private String persistDir = null;
    protected FastList<HttpUser> httpUsers = new FastList();
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private MBeanServer mbeanServer = null;
    private static HttpUsersManagement instance = null;

    protected HttpUsersManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(HttpUser.class, "httpUser");
    }

    public static HttpUsersManagement getInstance(String name) {
        if (instance == null) {
            instance = new HttpUsersManagement(name);
        }
        return instance;
    }

    public static HttpUsersManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public FastList<HttpUser> getHttpUsers() {
        return this.httpUsers;
    }

    @Override
    public HttpUser getHttpUserByName(String userName) {
        FastList.Node n = this.httpUsers.head();
        FastList.Node end = this.httpUsers.tail();
        while ((n = n.getNext()) != end) {
            HttpUser httpUser = (HttpUser)n.getValue();
            if (!httpUser.getUserName().equals(userName)) continue;
            return httpUser;
        }
        return null;
    }

    @Override
    public HttpUser createHttpUser(String userName, String password) throws Exception {
        if (userName == null || userName.isEmpty()) {
            throw new Exception("userName must not be null or an empty String");
        }
        FastList.Node n = this.httpUsers.head();
        FastList.Node end = this.httpUsers.tail();
        while ((n = n.getNext()) != end) {
            HttpUser httpUser = (HttpUser)n.getValue();
            if (!httpUser.getUserName().equals(userName)) continue;
            throw new Exception(String.format("Creation of HttpUser failed. Other HttpUser with name=%s already exist", this.name));
        }
        HttpUser httpUser = new HttpUser(userName, password);
        httpUser.httpUsersManagement = this;
        this.httpUsers.add((Object)httpUser);
        this.store();
        this.registerHttpUserMbean(httpUser);
        return httpUser;
    }

    @Override
    public HttpUser destroyHttpUser(String userName) throws Exception {
        HttpUser httpUser = this.getHttpUserByName(userName);
        if (httpUser == null) {
            throw new Exception(String.format("No HttpUser found with given name %s", userName));
        }
        this.httpUsers.remove((Object)httpUser);
        this.store();
        this.unregisterHttpUserMbean(httpUser.getUserName());
        return httpUser;
    }

    public void start() throws Exception {
        logger.info((Object)"Starting of HttpUsersManagement");
        try {
            this.mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading HttpUser configuration from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the HttpUser configuration file. \n%s", e.getMessage()));
        }
        FastList.Node n = this.httpUsers.head();
        FastList.Node end = this.httpUsers.tail();
        while ((n = n.getNext()) != end) {
            HttpUser httpUser = (HttpUser)n.getValue();
            this.registerHttpUserMbean(httpUser);
        }
        logger.info((Object)"Started of HttpUsersManagement");
    }

    public void stop() throws Exception {
        logger.info((Object)"Stopping of HttpUsersManagement");
        this.store();
        FastList.Node n = this.httpUsers.head();
        FastList.Node end = this.httpUsers.tail();
        while ((n = n.getNext()) != end) {
            HttpUser httpUser = (HttpUser)n.getValue();
            this.unregisterHttpUserMbean(httpUser.getUserName());
        }
        logger.info((Object)"Stopped of HttpUsersManagement");
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.httpUsers, USER_LIST, FastList.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting httpUsers state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.httpUsers = (FastList)reader.read(USER_LIST, FastList.class);
            reader.close();
            FastList.Node n = this.httpUsers.head();
            FastList.Node end = this.httpUsers.tail();
            while ((n = n.getNext()) != end) {
                HttpUser httpUser = (HttpUser)n.getValue();
                httpUser.httpUsersManagement = this;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void registerHttpUserMbean(HttpUser httpUser) {
        try {
            ObjectName httpUserObjNname = new ObjectName("org.mobicents.smsc:layer=HttpUser,name=" + httpUser.getUserName());
            StandardMBean httpUserMxBean = new StandardMBean(httpUser, HttpUserMBean.class, true);
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(httpUserMxBean, httpUserObjNname);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error((Object)String.format("Error while registering MBean for HttpUser %s", httpUser.getUserName()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while registering MBean for HttpUser %s", httpUser.getUserName()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)String.format("Error while registering MBean for HttpUser %s", httpUser.getUserName()), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while registering MBean for HttpUser %s", httpUser.getUserName()), (Throwable)e);
        }
    }

    private void unregisterHttpUserMbean(String httpUserName) {
        try {
            ObjectName httpUserObjNname = new ObjectName("org.mobicents.smsc:layer=HttpUser,name=" + httpUserName);
            if (this.mbeanServer != null) {
                this.mbeanServer.unregisterMBean(httpUserObjNname);
            }
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while unregistering MBean for HttpUser %s", httpUserName), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)String.format("Error while unregistering MBean for HttpUser %s", httpUserName), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while unregistering MBean for HttpUser %s", httpUserName), (Throwable)e);
        }
    }
}

