/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;

public class MapVersionNeg {
    public static final int mapV1RetestDownCount = 2;
    public static final int mapV1RetestUpCount = 100;
    public static final int mapV2RetestUpCount = 1000;
    private String msisdn;
    private MAPApplicationContextVersion curVersion;
    private int upVersionTested;
    private int downVersionTested;

    public MapVersionNeg(String msisdn) {
        this.msisdn = msisdn;
    }

    public String getMsisdn() {
        return this.msisdn;
    }

    public MAPApplicationContextVersion getCurVersion() {
        if (this.curVersion == null) {
            return MAPApplicationContextVersion.version3;
        }
        switch (this.curVersion.getVersion()) {
            case 1: {
                if (++this.upVersionTested > 100) {
                    this.upVersionTested = 0;
                    return MAPApplicationContextVersion.version3;
                }
                return this.curVersion;
            }
            case 2: {
                if (++this.upVersionTested > 1000) {
                    this.upVersionTested = 0;
                    return MAPApplicationContextVersion.version3;
                }
                return this.curVersion;
            }
        }
        return this.curVersion;
    }

    public void registerCheckedVersion(MAPApplicationContextVersion newVersion) {
        if (newVersion == MAPApplicationContextVersion.version1 && this.curVersion != MAPApplicationContextVersion.version1) {
            if (++this.downVersionTested >= 2) {
                this.downVersionTested = 0;
                this.curVersion = newVersion;
            }
        } else {
            this.downVersionTested = 0;
            this.curVersion = newVersion;
        }
    }

    public String toString() {
        return "MapVersionNeg [msisdn=" + this.msisdn + ", curVersion=" + this.curVersion + ", upVersionTested=" + this.upVersionTested + ", downVersionTested=" + this.downVersionTested + "]";
    }
}

