/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.mobicents.smsc.domain.Sip;
import org.mobicents.smsc.domain.SipMBean;
import org.mobicents.smsc.domain.SipManagementMBean;
import org.mobicents.smsc.domain.SmscPropertiesManagement;

public class SipManagement
implements SipManagementMBean {
    private static final Logger logger = Logger.getLogger(SipManagement.class);
    private static final String SIP_LIST = "sipList";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "sip.xml";
    public static final String SIP_NAME = "SIP";
    private final String name;
    private String persistDir = null;
    protected FastList<Sip> sips = new FastList();
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private MBeanServer mbeanServer = null;
    private static SipManagement instance = null;
    private final SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();

    private SipManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(Sip.class, "sip");
    }

    protected static SipManagement getInstance(String name) {
        if (instance == null) {
            instance = new SipManagement(name);
        }
        return instance;
    }

    public static SipManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public List<Sip> getSips() {
        return this.sips.unmodifiable();
    }

    @Override
    public Sip getSipByName(String sipName) {
        FastList.Node n = this.sips.head();
        FastList.Node end = this.sips.tail();
        while ((n = n.getNext()) != end) {
            Sip sip = (Sip)n.getValue();
            if (!sip.getName().equals(sipName)) continue;
            return sip;
        }
        return null;
    }

    @Override
    public Sip getSipByClusterName(String sipClusterName) {
        FastList.Node n = this.sips.head();
        FastList.Node end = this.sips.tail();
        while ((n = n.getNext()) != end) {
            Sip sip = (Sip)n.getValue();
            if (!sip.getClusterName().equals(sipClusterName)) continue;
            return sip;
        }
        return null;
    }

    public synchronized Sip createSip(String name, String clusterName, String host, int port, boolean chargingEnabled, byte addressTon, byte addressNpi, String addressRange, boolean countersEnabled, int networkId) throws Exception {
        FastList.Node n = this.sips.head();
        FastList.Node end = this.sips.tail();
        while ((n = n.getNext()) != end) {
            Sip esme = (Sip)n.getValue();
            if (!esme.getName().equals(name)) continue;
            throw new Exception(String.format("Creation of SIP failed. Other SIP with name=%s already exist", name));
        }
        if (clusterName == null) {
            clusterName = name;
        }
        Sip sip = new Sip(name, clusterName, host, port, chargingEnabled, addressTon, addressNpi, addressRange, countersEnabled, networkId);
        sip.sipManagement = this;
        this.sips.add((Object)sip);
        this.store();
        this.registerSipMbean(sip);
        return sip;
    }

    public Sip destroySip(String esmeName) throws Exception {
        Sip esme = this.getSipByName(esmeName);
        if (esme == null) {
            throw new Exception(String.format("No Sip found with given name %s", esmeName));
        }
        this.sips.remove((Object)esme);
        this.store();
        this.unregisterSipMbean(esme.getName());
        return esme;
    }

    public void start() throws Exception {
        try {
            this.mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (Exception e) {
            logger.error((Object)("Exception when obtaining of MBeanServer: " + e.getMessage()), (Throwable)e);
        }
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading SIP configuration from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
        FastList.Node n = this.sips.head();
        FastList.Node end = this.sips.tail();
        while ((n = n.getNext()) != end) {
            Sip sip = (Sip)n.getValue();
            this.registerSipMbean(sip);
        }
        if (this.sips.size() == 0) {
            this.createSip(SIP_NAME, SIP_NAME, "127.0.0.1", 5065, false, (byte)this.smscPropertiesManagement.getDefaultTon(), (byte)this.smscPropertiesManagement.getDefaultNpi(), null, false, 0);
        }
    }

    public void stop() throws Exception {
        this.store();
        FastList.Node n = this.sips.head();
        FastList.Node end = this.sips.tail();
        while ((n = n.getNext()) != end) {
            Sip esme = (Sip)n.getValue();
            this.unregisterSipMbean(esme.getName());
        }
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.sips = (FastList)reader.read(SIP_LIST, FastList.class);
            FastList.Node n = this.sips.head();
            FastList.Node end = this.sips.tail();
            while ((n = n.getNext()) != end) {
                Sip sip = (Sip)n.getValue();
                sip.sipManagement = this;
                String sipClusterName = sip.getClusterName();
            }
            reader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.sips, SIP_LIST, FastList.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the Rule state in file", (Throwable)e);
        }
    }

    private void registerSipMbean(Sip esme) {
        try {
            ObjectName esmeObjNname = new ObjectName("org.mobicents.smsc:layer=Sip,name=" + esme.getName());
            StandardMBean esmeMxBean = new StandardMBean(esme, SipMBean.class, true);
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(esmeMxBean, esmeObjNname);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error((Object)String.format("Error while registering MBean for SIP %s", esme.getName()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while registering MBean for SIP %s", esme.getName()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)String.format("Error while registering MBean for SIP %s", esme.getName()), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while registering MBean for SIP %s", esme.getName()), (Throwable)e);
        }
    }

    private void unregisterSipMbean(String esmeName) {
        try {
            ObjectName esmeObjNname = new ObjectName("org.mobicents.smsc:layer=Sip,name=" + esmeName);
            if (this.mbeanServer != null) {
                this.mbeanServer.unregisterMBean(esmeObjNname);
            }
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while unregistering MBean for ESME %s", esmeName), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)String.format("Error while unregistering MBean for ESME %s", esmeName), (Throwable)e);
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)String.format("Error while unregistering MBean for ESME %s", esmeName), (Throwable)e);
        }
    }
}

