/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import org.apache.log4j.Logger;
import org.mobicents.smsc.domain.SmscManagement;

public class SmscCongestionControl {
    private static final Logger logger = Logger.getLogger(SmscManagement.class);
    private static final SmscCongestionControl instance = new SmscCongestionControl();
    private boolean maxActivityCount1_0;
    private boolean maxActivityCount1_2;
    private boolean maxActivityCount1_4;

    public static SmscCongestionControl getInstance() {
        return instance;
    }

    public void registerMaxActivityCount1_0Threshold() {
        if (!this.maxActivityCount1_0) {
            this.doRegisterMaxActivityCount1_0(true);
        }
    }

    public void registerMaxActivityCount1_0BackToNormal() {
        if (this.maxActivityCount1_0) {
            this.doRegisterMaxActivityCount1_0(false);
        }
    }

    public boolean isMaxActivityCount1_0Threshold() {
        return this.maxActivityCount1_0;
    }

    public void registerMaxActivityCount1_2Threshold() {
        if (!this.maxActivityCount1_2) {
            this.doRegisterMaxActivityCount1_2(true);
        }
    }

    public void registerMaxActivityCount1_2BackToNormal() {
        if (this.maxActivityCount1_2) {
            this.doRegisterMaxActivityCount1_2(false);
        }
    }

    public boolean isMaxActivityCount1_2Threshold() {
        return this.maxActivityCount1_2;
    }

    public void registerMaxActivityCount1_4Threshold() {
        if (!this.maxActivityCount1_4) {
            this.doRegisterMaxActivityCount1_4(true);
        }
    }

    public void registerMaxActivityCount1_4BackToNormal() {
        if (this.maxActivityCount1_4) {
            this.doRegisterMaxActivityCount1_4(false);
        }
    }

    public boolean isMaxActivityCount1_4Threshold() {
        return this.maxActivityCount1_4;
    }

    private synchronized void doRegisterMaxActivityCount1_0(boolean val) {
        if (this.maxActivityCount1_0 != val) {
            this.maxActivityCount1_0 = val;
            this.logMaxActivityCountThreshold(val, "MaxActivityCount level 1.0");
        }
    }

    private synchronized void doRegisterMaxActivityCount1_2(boolean val) {
        if (this.maxActivityCount1_2 != val) {
            this.maxActivityCount1_2 = val;
            this.logMaxActivityCountThreshold(val, "MaxActivityCount level 1.2");
        }
    }

    private synchronized void doRegisterMaxActivityCount1_4(boolean val) {
        if (this.maxActivityCount1_4 != val) {
            this.maxActivityCount1_4 = val;
            this.logMaxActivityCountThreshold(val, "MaxActivityCount level 1.4");
        }
    }

    private void logMaxActivityCountThreshold(boolean exceeded, String tName) {
        if (exceeded) {
            logger.warn((Object)("SMSC congestion control: Threshold " + tName + " is exceeded"));
        } else {
            logger.warn((Object)("SMSC congestion control: Threshold " + tName + " is back to normal"));
        }
    }
}

