/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javolution.text.TextBuilder;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.map.primitives.ArrayListSerializingBase;
import org.mobicents.smsc.domain.ChargingType;
import org.mobicents.smsc.domain.HrHlrNumberNetworkIdElement;
import org.mobicents.smsc.domain.HrSriBypassNetworkIdElement;
import org.mobicents.smsc.domain.HttpEncoding;
import org.mobicents.smsc.domain.MoChargingType;
import org.mobicents.smsc.domain.ServiceCenterGtNetworkIdElement;
import org.mobicents.smsc.domain.SmscPropertiesManagementMBean;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.restcomm.smpp.GenerateType;
import org.restcomm.smpp.SmppEncoding;

public class SmscPropertiesManagement
implements SmscPropertiesManagementMBean {
    private static final Logger logger = Logger.getLogger(SmscPropertiesManagement.class);
    private static final String SC_GT = "scgt";
    private static final String SC_GT_LIST = "scgtList";
    private static final String SC_SSN = "scssn";
    private static final String HLR_SSN = "hlrssn";
    private static final String MSC_SSN = "mscssn";
    private static final String MAX_MAP_VERSION = "maxmapv";
    private static final String DEFAULT_VALIDITY_PERIOD_HOURS = "defaultValidityPeriodHours";
    private static final String MAX_VALIDITY_PERIOD_HOURS = "maxValidityPeriodHours";
    private static final String DEFAULT_TON = "defaultTon";
    private static final String DEFAULT_NPI = "defaultNpi";
    private static final String SUBSCRIBER_BUSY_DUE_DELAY = "subscriberBusyDueDelay";
    private static final String FIRST_DUE_DELAY = "firstDueDelay";
    private static final String SECOND_DUE_DELAY = "secondDueDelay";
    private static final String MAX_DUE_DELAY = "maxDueDelay";
    private static final String DUE_DELAY_MULTIPLICATOR = "dueDelayMultiplicator";
    private static final String MAX_MESSAGE_LENGTH_REDUCER = "maxMessageLengthReducer";
    private static final String HOSTS = "hosts";
    private static final String DB_HOSTS = "dbHosts";
    private static final String DB_PORT = "dbPort";
    private static final String KEYSPACE_NAME = "keyspaceName";
    private static final String CLUSTER_NAME = "clusterName";
    private static final String FETCH_PERIOD = "fetchPeriod";
    private static final String FETCH_MAX_ROWS = "fetchMaxRows";
    private static final String MAX_ACTIVITY_COUNT = "maxActivityCount";
    private static final String DELIVERY_TIMEOUT = "deliveryTimeout";
    private static final String VP_PROLONG = "vpProlong";
    private static final String SMPP_ENCODING_FOR_UCS2 = "smppEncodingForUCS2";
    private static final String SMPP_ENCODING_FOR_GSM7 = "smppEncodingForGsm7";
    private static final String SMS_HOME_ROUTING = "smsHomeRouting";
    private static final String ESME_DEFAULT_CLUSTER_NAME = "esmeDefaultCluster";
    private static final String REVISE_SECONDS_ON_SMSC_START = "reviseSecondsOnSmscStart";
    private static final String PROCESSING_SMS_SET_TIMEOUT = "processingSmsSetTimeout";
    private static final String GENERATE_RECEIPT_CDR = "generateReceiptCdr";
    private static final String RECEIPTS_DISABLING = "receiptsDisabling";
    private static final String INCOME_RECEIPTS_PROCESSING = "incomeReceiptsProcessing";
    private static final String ENABLE_INTERMEDIATE_RECEIPTS = "enableIntermediateReceipts";
    private static final String ORIG_NETWORK_ID_FOR_RECEIPTS = "origNetworkIdForReceipts";
    private static final String MO_DEFAULT_MESSAGING_MODE = "moDefaultMessagingMode";
    private static final String HR_DEFAULT_MESSAGING_MODE = "hrDefaultMessagingMode";
    private static final String SIP_DEFAULT_MESSAGING_MODE = "sipDefaultMessagingMode";
    private static final String GENERATE_CDR = "generateCdr";
    private static final String GENERATE_ARCHIVE_TABLE = "generateArchiveTable";
    private static final String STORE_AND_FORWORD_MODE = "storeAndForwordMode";
    private static final String MO_CHARGING = "moCharging";
    private static final String HR_CHARGING = "hrCharging";
    private static final String TX_SMPP_CHARGING = "txSmppCharging";
    private static final String TX_SIP_CHARGING = "txSipCharging";
    private static final String TX_HTTP_CHARGING = "txHttpCharging";
    private static final String GLOBAL_TITLE_INDICATOR = "globalTitleIndicator";
    private static final String TRANSLATION_TYPE = "translationType";
    private static final String CORRELATION_ID_LIVE_TIME = "correlationIdLiveTime";
    private static final String SRI_RESPONSE_LIVE_TIME = "sriResponseLiveTime";
    private static final String DIAMETER_DEST_REALM = "diameterDestRealm";
    private static final String DIAMETER_DEST_HOST = "diameterDestHost";
    private static final String DIAMETER_DEST_PORT = "diameterDestPort";
    private static final String DIAMETER_USER_NAME = "diameterUserName";
    private static final String REMOVING_LIVE_TABLES_DAYS = "removingLiveTablesDays";
    private static final String REMOVING_ARCHIVE_TABLES_DAYS = "removingArchiveTablesDays";
    private static final String MO_UNKNOWN_TYPE_OF_NUMBER_PREFIX = "moUnknownTypeOfNumberPrefix";
    private static final String HR_HLR_NUMBER = "hrHlrNumber";
    private static final String HR_HLR_NUMBER_LIST = "hrHlrNumberList";
    private static final String HR_SRI_BYPASS = "hrSriBypass";
    private static final String HR_SRI_BYPASS_LIST = "hrSriBypassList";
    private static final String NATIONAL_LANGUAGE_SINGLE_SHIFT = "nationalLanguageSingleShift";
    private static final String NATIONAL_LANGUAGE_LOCKING_SHIFT = "nationalLanguageLockingShift";
    private static final String HTTP_DEFAULT_SOURCE_TON = "httpDefaultSourceTon";
    private static final String HTTP_DEFAULT_SOURCE_NPI = "httpDefaultSourceNpi";
    private static final String HTTP_DEFAULT_DEST_TON = "httpDefaultDestTon";
    private static final String HTTP_DEFAULT_DEST_NPI = "httpDefaultDestNpi";
    private static final String HTTP_DEFAULT_NETWORK_ID = "httpDefaultNetworkId";
    private static final String HTTP_DEFAULT_MESSAGING_MODE = "httpDefaultMessagingMode";
    private static final String HTTP_DEFAULT_RD_DELIVERY_RECEIPT = "httpDefaultRDDeliveryReceipt";
    private static final String HTTP_DEFAULT_RD_INTERMEDIATE_NOTIFICATION = "httpDefaultRDIntermediateNotification";
    private static final String HTTP_DEFAULT_DATA_CODING = "httpDefaultDataCoding";
    private static final String HTTP_ENCODING_FOR_UCS2 = "httpEncodingForUCS2";
    private static final String HTTP_ENCODING_FOR_GSM7 = "httpEncodingForGsm7";
    private static final String MIN_MESSAGE_ID = "minMessageId";
    private static final String MAX_MESSAGE_ID = "maxMessageId";
    private static final String DELIVERY_PAUSE = "deliveryPause";
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String PERSIST_FILE_NAME = "smscproperties.xml";
    private static SmscPropertiesManagement instance;
    private final String name;
    private String persistDir = null;
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private String serviceCenterGt = "0";
    private FastMap<Integer, String> networkIdVsServiceCenterGt = new FastMap();
    private int serviceCenterSsn = -1;
    private int hlrSsn = -1;
    private int mscSsn = -1;
    private int maxMapVersion = 3;
    private int defaultValidityPeriodHours = 72;
    private int maxValidityPeriodHours = 240;
    private int defaultTon = 1;
    private int defaultNpi = 1;
    private int subscriberBusyDueDelay = 120;
    private int firstDueDelay = 20;
    private int secondDueDelay = 300;
    private int maxDueDelay = 86400;
    private int dueDelayMultiplicator = 200;
    private int maxMessageLengthReducer = 6;
    private SmppEncoding smppEncodingForGsm7 = SmppEncoding.Utf8;
    private SmppEncoding smppEncodingForUCS2 = SmppEncoding.Utf8;
    private String dbHosts = "127.0.0.1";
    private int dbPort = 9042;
    private String keyspaceName = "RestCommSMSC";
    private String clusterName = "RestCommSMSC";
    private long fetchPeriod = 200L;
    private int fetchMaxRows = 100;
    private int maxActivityCount = 500;
    private int deliveryTimeout = 120;
    private int vpProlong = 120;
    private String esmeDefaultClusterName;
    private int reviseSecondsOnSmscStart = 60;
    private int processingSmsSetTimeout = 600;
    private boolean generateReceiptCdr = false;
    private boolean receiptsDisabling = false;
    private boolean incomeReceiptsProcessing = false;
    private boolean enableIntermediateReceipts = false;
    private boolean origNetworkIdForReceipts = false;
    private int moDefaultMessagingMode = 3;
    private int hrDefaultMessagingMode = 3;
    private int sipDefaultMessagingMode = 3;
    private GenerateType generateCdr = new GenerateType(true, true, true);
    private GenerateType generateArchiveTable = new GenerateType(true, true, true);
    private StoreAndForwordMode storeAndForwordMode = StoreAndForwordMode.fast;
    private MoChargingType moCharging = MoChargingType.accept;
    private MoChargingType hrCharging = MoChargingType.accept;
    private ChargingType txSmppCharging = ChargingType.None;
    private ChargingType txSipCharging = ChargingType.None;
    private MoChargingType txHttpCharging = MoChargingType.accept;
    private GlobalTitleIndicator globalTitleIndicator = GlobalTitleIndicator.GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS;
    private int translationType = 0;
    private int correlationIdLiveTime = 60;
    private int sriResponseLiveTime = 0;
    private String diameterDestRealm = "telestax.com";
    private String diameterDestHost = "127.0.0.1";
    private int diameterDestPort = 3868;
    private String diameterUserName = "";
    private int removingLiveTablesDays = 3;
    private int removingArchiveTablesDays = 3;
    private String hrHlrNumber = "";
    private FastMap<Integer, String> networkIdVsHrHlrNumber = new FastMap();
    private boolean hrSriBypass = false;
    private FastMap<Integer, Boolean> networkIdVsHrSriBypass = new FastMap();
    private int nationalLanguageSingleShift = 0;
    private int nationalLanguageLockingShift = 0;
    private int httpDefaultSourceTon = -2;
    private int httpDefaultSourceNpi = -2;
    private int httpDefaultDestTon = 1;
    private int httpDefaultDestNpi = 1;
    private int httpDefaultNetworkId = 0;
    private int httpDefaultMessagingMode = 1;
    private int httpDefaultRDDeliveryReceipt = 0;
    private int httpDefaultRDIntermediateNotification = 0;
    private int httpDefaultDataCoding = 0;
    private HttpEncoding httpEncodingForGsm7 = HttpEncoding.Utf8;
    private HttpEncoding httpEncodingForUCS2 = HttpEncoding.Utf8;
    private long minMessageId = 1L;
    private long maxMessageId = 10000000000L;
    private boolean deliveryPause = false;
    private boolean smscStopped = true;
    private int skipUnsentMessages = -1;

    private SmscPropertiesManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
    }

    public static SmscPropertiesManagement getInstance(String name) {
        if (instance == null) {
            instance = new SmscPropertiesManagement(name);
        }
        return instance;
    }

    public static SmscPropertiesManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public String getServiceCenterGt() {
        return this.serviceCenterGt;
    }

    @Override
    public String getServiceCenterGt(int networkId) {
        String res = (String)this.networkIdVsServiceCenterGt.get((Object)networkId);
        if (res != null) {
            return res;
        }
        return this.serviceCenterGt;
    }

    @Override
    public Map<Integer, String> getNetworkIdVsServiceCenterGt() {
        return this.networkIdVsServiceCenterGt;
    }

    @Override
    public void setServiceCenterGt(String serviceCenterGt) {
        this.setServiceCenterGt(0, serviceCenterGt);
    }

    @Override
    public void setServiceCenterGt(int networkId, String serviceCenterGt) {
        if (networkId == 0) {
            this.serviceCenterGt = serviceCenterGt;
        } else if (serviceCenterGt == null || serviceCenterGt.equals("") || serviceCenterGt.equals("0")) {
            this.networkIdVsServiceCenterGt.remove((Object)networkId);
        } else {
            this.networkIdVsServiceCenterGt.put((Object)networkId, (Object)serviceCenterGt);
        }
        this.store();
    }

    @Override
    public int getServiceCenterSsn() {
        return this.serviceCenterSsn;
    }

    @Override
    public void setServiceCenterSsn(int serviceCenterSsn) {
        this.serviceCenterSsn = serviceCenterSsn;
        this.store();
    }

    @Override
    public int getHlrSsn() {
        return this.hlrSsn;
    }

    @Override
    public void setHlrSsn(int hlrSsn) {
        this.hlrSsn = hlrSsn;
        this.store();
    }

    @Override
    public int getMscSsn() {
        return this.mscSsn;
    }

    @Override
    public void setMscSsn(int mscSsn) {
        this.mscSsn = mscSsn;
        this.store();
    }

    @Override
    public int getMaxMapVersion() {
        return this.maxMapVersion;
    }

    @Override
    public void setMaxMapVersion(int maxMapVersion) {
        this.maxMapVersion = maxMapVersion;
        this.store();
    }

    @Override
    public int getDefaultValidityPeriodHours() {
        return this.defaultValidityPeriodHours;
    }

    @Override
    public void setDefaultValidityPeriodHours(int defaultValidityPeriodHours) {
        this.defaultValidityPeriodHours = defaultValidityPeriodHours;
        this.store();
    }

    @Override
    public int getMaxValidityPeriodHours() {
        return this.maxValidityPeriodHours;
    }

    @Override
    public void setMaxValidityPeriodHours(int maxValidityPeriodHours) {
        this.maxValidityPeriodHours = maxValidityPeriodHours;
        this.store();
    }

    @Override
    public int getDefaultTon() {
        return this.defaultTon;
    }

    @Override
    public void setDefaultTon(int defaultTon) {
        this.defaultTon = defaultTon;
        this.store();
    }

    @Override
    public int getDefaultNpi() {
        return this.defaultNpi;
    }

    @Override
    public void setDefaultNpi(int defaultNpi) {
        this.defaultNpi = defaultNpi;
        this.store();
    }

    @Override
    public int getSubscriberBusyDueDelay() {
        return this.subscriberBusyDueDelay;
    }

    @Override
    public void setSubscriberBusyDueDelay(int subscriberBusyDueDelay) {
        this.subscriberBusyDueDelay = subscriberBusyDueDelay;
        this.store();
    }

    @Override
    public int getFirstDueDelay() {
        return this.firstDueDelay;
    }

    @Override
    public void setFirstDueDelay(int firstDueDelay) {
        this.firstDueDelay = firstDueDelay;
        this.store();
    }

    @Override
    public int getSecondDueDelay() {
        return this.secondDueDelay;
    }

    @Override
    public void setSecondDueDelay(int secondDueDelay) {
        this.secondDueDelay = secondDueDelay;
        this.store();
    }

    @Override
    public int getMaxDueDelay() {
        return this.maxDueDelay;
    }

    @Override
    public void setMaxDueDelay(int maxDueDelay) {
        this.maxDueDelay = maxDueDelay;
        this.store();
    }

    @Override
    public int getDueDelayMultiplicator() {
        return this.dueDelayMultiplicator;
    }

    @Override
    public void setDueDelayMultiplicator(int dueDelayMultiplicator) {
        this.dueDelayMultiplicator = dueDelayMultiplicator;
        this.store();
    }

    @Override
    public int getMaxMessageLengthReducer() {
        return this.maxMessageLengthReducer;
    }

    @Override
    public void setMaxMessageLengthReducer(int maxMessageLengReducer) {
        this.maxMessageLengthReducer = maxMessageLengReducer;
        this.store();
    }

    @Override
    public SmppEncoding getSmppEncodingForGsm7() {
        return this.smppEncodingForGsm7;
    }

    @Override
    public void setSmppEncodingForGsm7(SmppEncoding smppEncodingForGsm7) {
        this.smppEncodingForGsm7 = smppEncodingForGsm7;
        this.store();
    }

    @Override
    public SmppEncoding getSmppEncodingForUCS2() {
        return this.smppEncodingForUCS2;
    }

    @Override
    public void setSmppEncodingForUCS2(SmppEncoding smppEncodingForUCS2) {
        this.smppEncodingForUCS2 = smppEncodingForUCS2;
        this.store();
    }

    @Override
    public HttpEncoding getHttpEncodingForGsm7() {
        return this.httpEncodingForGsm7;
    }

    @Override
    public void setHttpEncodingForGsm7(HttpEncoding httpEncodingForGsm7) {
        this.httpEncodingForGsm7 = httpEncodingForGsm7;
        this.store();
    }

    @Override
    public HttpEncoding getHttpEncodingForUCS2() {
        return this.httpEncodingForUCS2;
    }

    @Override
    public void setHttpEncodingForUCS2(HttpEncoding httpEncodingForUCS2) {
        this.httpEncodingForUCS2 = httpEncodingForUCS2;
        this.store();
    }

    @Override
    public long getMinMessageId() {
        return this.minMessageId;
    }

    @Override
    public void setMinMessageId(long minMessageId) throws IllegalArgumentException {
        if (minMessageId < 0L) {
            throw new IllegalArgumentException("minMessageId must be geater or equal 0");
        }
        if (minMessageId > this.maxMessageId) {
            throw new IllegalArgumentException("minMessageId must be less then maxMessageId");
        }
        if (this.maxMessageId - minMessageId < 1000000L) {
            throw new IllegalArgumentException("minMessageId must be less then maxMessageId at least for 1000000");
        }
        this.minMessageId = minMessageId;
        this.store();
    }

    @Override
    public long getMaxMessageId() {
        return this.maxMessageId;
    }

    @Override
    public void setMaxMessageId(long maxMessageId) throws IllegalArgumentException {
        if (maxMessageId < 0L) {
            throw new IllegalArgumentException("maxMessageId must be geater or equal 0");
        }
        if (this.minMessageId > maxMessageId) {
            throw new IllegalArgumentException("maxMessageId must be more then minMessageId");
        }
        if (maxMessageId - this.minMessageId < 1000000L) {
            throw new IllegalArgumentException("minMessageId must be less then maxMessageId at least for 1000000");
        }
        this.maxMessageId = maxMessageId;
        this.store();
    }

    @Override
    public String getDbHosts() {
        return this.dbHosts;
    }

    @Override
    public void setDbHosts(String dbHosts) {
        this.dbHosts = dbHosts;
        this.store();
    }

    @Override
    public int getDbPort() {
        return this.dbPort;
    }

    @Override
    public void setDbPort(int dbPort) {
        this.dbPort = dbPort;
        this.store();
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public void setKeyspaceName(String keyspaceName) {
        this.keyspaceName = keyspaceName;
        this.store();
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
        this.store();
    }

    @Override
    public long getFetchPeriod() {
        return this.fetchPeriod;
    }

    @Override
    public void setFetchPeriod(long fetchPeriod) {
        this.fetchPeriod = fetchPeriod;
        this.store();
    }

    @Override
    public int getFetchMaxRows() {
        return this.fetchMaxRows;
    }

    @Override
    public void setFetchMaxRows(int fetchMaxRows) {
        this.fetchMaxRows = fetchMaxRows;
        this.store();
    }

    @Override
    public int getMaxActivityCount() {
        return this.maxActivityCount;
    }

    @Override
    public void setMaxActivityCount(int maxActivityCount) {
        this.maxActivityCount = maxActivityCount;
        this.store();
    }

    @Override
    public int getDeliveryTimeout() {
        return this.deliveryTimeout;
    }

    @Override
    public void setDeliveryTimeout(int deliveryTimeout) {
        this.deliveryTimeout = deliveryTimeout;
        this.store();
    }

    @Override
    public int getVpProlong() {
        return this.vpProlong;
    }

    @Override
    public void setVpProlong(int vpProlong) {
        this.vpProlong = vpProlong;
        this.store();
    }

    @Override
    public String getEsmeDefaultClusterName() {
        return this.esmeDefaultClusterName;
    }

    @Override
    public void setEsmeDefaultClusterName(String val) {
        this.esmeDefaultClusterName = val;
        this.store();
    }

    @Override
    public int getReviseSecondsOnSmscStart() {
        return this.reviseSecondsOnSmscStart;
    }

    @Override
    public void setReviseSecondsOnSmscStart(int reviseSecondsOnSmscStart) {
        this.reviseSecondsOnSmscStart = reviseSecondsOnSmscStart;
        this.store();
    }

    @Override
    public int getProcessingSmsSetTimeout() {
        return this.processingSmsSetTimeout;
    }

    @Override
    public void setProcessingSmsSetTimeout(int processingSmsSetTimeout) {
        this.processingSmsSetTimeout = processingSmsSetTimeout;
        this.store();
    }

    @Override
    public boolean getGenerateReceiptCdr() {
        return this.generateReceiptCdr;
    }

    @Override
    public void setGenerateReceiptCdr(boolean generateReceiptCdr) {
        this.generateReceiptCdr = generateReceiptCdr;
        this.store();
    }

    @Override
    public boolean getReceiptsDisabling() {
        return this.receiptsDisabling;
    }

    @Override
    public void setReceiptsDisabling(boolean receiptsDisabling) {
        this.receiptsDisabling = receiptsDisabling;
        this.store();
    }

    @Override
    public boolean getEnableIntermediateReceipts() {
        return this.enableIntermediateReceipts;
    }

    @Override
    public void setEnableIntermediateReceipts(boolean enableIntermediateReceipts) {
        this.enableIntermediateReceipts = enableIntermediateReceipts;
        this.store();
    }

    @Override
    public boolean getIncomeReceiptsProcessing() {
        return this.incomeReceiptsProcessing;
    }

    @Override
    public void setIncomeReceiptsProcessing(boolean incomeReceiptsProcessing) {
        this.incomeReceiptsProcessing = incomeReceiptsProcessing;
        this.store();
    }

    @Override
    public boolean getOrigNetworkIdForReceipts() {
        return this.origNetworkIdForReceipts;
    }

    @Override
    public void setOrigNetworkIdForReceipts(boolean origNetworkIdForReceipts) {
        this.origNetworkIdForReceipts = origNetworkIdForReceipts;
        this.store();
    }

    @Override
    public int getMoDefaultMessagingMode() {
        return this.moDefaultMessagingMode;
    }

    @Override
    public void setMoDefaultMessagingMode(int moDefaultMessagingMode) {
        this.moDefaultMessagingMode = moDefaultMessagingMode;
        this.store();
    }

    @Override
    public int getHrDefaultMessagingMode() {
        return this.hrDefaultMessagingMode;
    }

    @Override
    public void setHrDefaultMessagingMode(int hrDefaultMessagingMode) {
        this.hrDefaultMessagingMode = hrDefaultMessagingMode;
        this.store();
    }

    @Override
    public int getSipDefaultMessagingMode() {
        return this.sipDefaultMessagingMode;
    }

    @Override
    public void setSipDefaultMessagingMode(int sipDefaultMessagingMode) {
        this.sipDefaultMessagingMode = sipDefaultMessagingMode;
        this.store();
    }

    @Override
    public MoChargingType getMoCharging() {
        return this.moCharging;
    }

    @Override
    public void setMoCharging(MoChargingType moCharging) {
        this.moCharging = moCharging;
        this.store();
    }

    @Override
    public MoChargingType getHrCharging() {
        return this.hrCharging;
    }

    @Override
    public void setHrCharging(MoChargingType mtCharging) {
        this.hrCharging = mtCharging;
        this.store();
    }

    @Override
    public StoreAndForwordMode getStoreAndForwordMode() {
        return this.storeAndForwordMode;
    }

    @Override
    public void setStoreAndForwordMode(StoreAndForwordMode storeAndForwordMode) {
        this.storeAndForwordMode = storeAndForwordMode;
        this.store();
    }

    @Override
    public ChargingType getTxSmppChargingType() {
        return this.txSmppCharging;
    }

    @Override
    public void setTxSmppChargingType(ChargingType txSmppCharging) {
        this.txSmppCharging = txSmppCharging;
        this.store();
    }

    @Override
    public ChargingType getTxSipChargingType() {
        return this.txSipCharging;
    }

    @Override
    public void setTxSipChargingType(ChargingType txSipCharging) {
        this.txSipCharging = txSipCharging;
        this.store();
    }

    @Override
    public MoChargingType getTxHttpCharging() {
        return this.txHttpCharging;
    }

    @Override
    public void setTxHttpCharging(MoChargingType txHttpCharging) {
        this.txHttpCharging = txHttpCharging;
        this.store();
    }

    @Override
    public GlobalTitleIndicator getGlobalTitleIndicator() {
        return this.globalTitleIndicator;
    }

    @Override
    public void setGlobalTitleIndicator(GlobalTitleIndicator globalTitleIndicator) {
        this.globalTitleIndicator = globalTitleIndicator;
        this.store();
    }

    @Override
    public int getTranslationType() {
        return this.translationType;
    }

    @Override
    public void setTranslationType(int translationType) {
        this.translationType = translationType;
        this.store();
    }

    @Override
    public int getCorrelationIdLiveTime() {
        return this.correlationIdLiveTime;
    }

    @Override
    public void setCorrelationIdLiveTime(int correlationIdLiveTime) {
        this.correlationIdLiveTime = correlationIdLiveTime;
        this.store();
    }

    @Override
    public int getSriResponseLiveTime() {
        return this.sriResponseLiveTime;
    }

    @Override
    public void setSriResponseLiveTime(int sriresponselivetime) {
        this.sriResponseLiveTime = sriresponselivetime;
        this.store();
    }

    @Override
    public String getDiameterDestRealm() {
        return this.diameterDestRealm;
    }

    @Override
    public void setDiameterDestRealm(String diameterDestRealm) {
        this.diameterDestRealm = diameterDestRealm;
        this.store();
    }

    @Override
    public String getDiameterDestHost() {
        return this.diameterDestHost;
    }

    @Override
    public void setDiameterDestHost(String diameterDestHost) {
        this.diameterDestHost = diameterDestHost;
        this.store();
    }

    @Override
    public int getDiameterDestPort() {
        return this.diameterDestPort;
    }

    @Override
    public void setDiameterDestPort(int diameterDestPort) {
        this.diameterDestPort = diameterDestPort;
        this.store();
    }

    @Override
    public String getDiameterUserName() {
        return this.diameterUserName;
    }

    @Override
    public void setDiameterUserName(String diameterUserName) {
        this.diameterUserName = diameterUserName;
        this.store();
    }

    @Override
    public int getRemovingLiveTablesDays() {
        return this.removingLiveTablesDays;
    }

    @Override
    public void setRemovingLiveTablesDays(int removingLiveTablesDays) {
        this.removingLiveTablesDays = removingLiveTablesDays;
        this.store();
    }

    @Override
    public int getRemovingArchiveTablesDays() {
        return this.removingArchiveTablesDays;
    }

    @Override
    public void setRemovingArchiveTablesDays(int removingArchiveTablesDays) {
        this.removingArchiveTablesDays = removingArchiveTablesDays;
        this.store();
    }

    @Override
    public String getHrHlrNumber() {
        return this.hrHlrNumber;
    }

    @Override
    public String getHrHlrNumber(int networkId) {
        if (networkId == 0) {
            return this.hrHlrNumber;
        }
        return (String)this.networkIdVsHrHlrNumber.get((Object)networkId);
    }

    @Override
    public Map<Integer, String> getNetworkIdVsHrHlrNumber() {
        return this.networkIdVsHrHlrNumber;
    }

    @Override
    public void setHrHlrNumber(String hrHlrNumber) {
        this.setHrHlrNumber(0, hrHlrNumber);
    }

    @Override
    public void setHrHlrNumber(int networkId, String hrHlrNumber) {
        if (networkId == 0) {
            this.hrHlrNumber = hrHlrNumber;
        } else if (hrHlrNumber == null || hrHlrNumber.equals("") || hrHlrNumber.equals("0")) {
            this.networkIdVsHrHlrNumber.remove((Object)networkId);
        } else {
            this.networkIdVsHrHlrNumber.put((Object)networkId, (Object)hrHlrNumber);
        }
        this.store();
    }

    @Override
    public boolean getHrSriBypass() {
        return this.hrSriBypass;
    }

    @Override
    public boolean getHrSriBypass(int networkId) {
        Boolean res = (Boolean)this.networkIdVsHrSriBypass.get((Object)networkId);
        if (res != null) {
            return res;
        }
        return this.hrSriBypass;
    }

    @Override
    public Map<Integer, Boolean> getNetworkIdVsHrSriBypass() {
        return this.networkIdVsHrSriBypass;
    }

    @Override
    public void setHrSriBypass(boolean hrSriBypass) {
        this.setHrSriBypass(0, hrSriBypass);
    }

    @Override
    public void setHrSriBypass(int networkId, boolean hrSriBypass) {
        if (networkId == 0) {
            this.hrSriBypass = hrSriBypass;
        } else {
            this.networkIdVsHrSriBypass.put((Object)networkId, (Object)hrSriBypass);
        }
        this.store();
    }

    @Override
    public void removeHrSriBypassForNetworkId(int networkId) {
        this.networkIdVsHrSriBypass.remove((Object)networkId);
        this.store();
    }

    @Override
    public int getNationalLanguageSingleShift() {
        return this.nationalLanguageSingleShift;
    }

    @Override
    public void setNationalLanguageSingleShift(int nationalLanguageSingleShift) {
        this.nationalLanguageSingleShift = nationalLanguageSingleShift;
        this.store();
    }

    @Override
    public int getNationalLanguageLockingShift() {
        return this.nationalLanguageLockingShift;
    }

    @Override
    public void setNationalLanguageLockingShift(int nationalLanguageLockingShift) {
        this.nationalLanguageLockingShift = nationalLanguageLockingShift;
        this.store();
    }

    @Override
    public boolean isDeliveryPause() {
        return this.deliveryPause;
    }

    @Override
    public void setDeliveryPause(boolean deliveryPause) {
        this.deliveryPause = deliveryPause;
        this.store();
    }

    @Override
    public boolean isSmscStopped() {
        return this.smscStopped;
    }

    public void setSmscStopped(boolean smscStopped) {
        this.smscStopped = smscStopped;
    }

    @Override
    public int getSkipUnsentMessages() {
        return this.skipUnsentMessages;
    }

    @Override
    public void setSkipUnsentMessages(int skipUnsentMessages) {
        this.skipUnsentMessages = skipUnsentMessages;
    }

    @Override
    public GenerateType getGenerateCdr() {
        return this.generateCdr;
    }

    @Override
    public void setGenerateCdr(GenerateType generateCdr) {
        this.generateCdr = generateCdr;
        this.store();
    }

    @Override
    public int getGenerateCdrInt() {
        return this.generateCdr.getValue();
    }

    @Override
    public void setGenerateCdrInt(int generateCdr) {
        this.generateCdr = new GenerateType(generateCdr);
        this.store();
    }

    @Override
    public GenerateType getGenerateArchiveTable() {
        return this.generateArchiveTable;
    }

    @Override
    public void setGenerateArchiveTable(GenerateType generateArchiveTable) {
        this.generateArchiveTable = generateArchiveTable;
        this.store();
    }

    @Override
    public int getGenerateArchiveTableInt() {
        return this.generateArchiveTable.getValue();
    }

    @Override
    public void setGenerateArchiveTableInt(int generateArchiveTable) {
        this.generateArchiveTable = new GenerateType(generateArchiveTable);
        this.store();
    }

    @Override
    public int getHttpDefaultSourceTon() {
        return this.httpDefaultSourceTon;
    }

    @Override
    public void setHttpDefaultSourceTon(int httpDefaultSourceTon) {
        this.httpDefaultSourceTon = httpDefaultSourceTon;
        this.store();
    }

    @Override
    public int getHttpDefaultSourceNpi() {
        return this.httpDefaultSourceNpi;
    }

    @Override
    public void setHttpDefaultSourceNpi(int httpDefaultSourceNpi) {
        this.httpDefaultSourceNpi = httpDefaultSourceNpi;
        this.store();
    }

    @Override
    public int getHttpDefaultDestTon() {
        return this.httpDefaultDestTon;
    }

    @Override
    public void setHttpDefaultDestTon(int httpDefaultDestTon) {
        this.httpDefaultDestTon = httpDefaultDestTon;
        this.store();
    }

    @Override
    public int getHttpDefaultDestNpi() {
        return this.httpDefaultDestNpi;
    }

    @Override
    public void setHttpDefaultDestNpi(int httpDefaultDestNpi) {
        this.httpDefaultDestNpi = httpDefaultDestNpi;
        this.store();
    }

    @Override
    public int getHttpDefaultNetworkId() {
        return this.httpDefaultNetworkId;
    }

    @Override
    public void setHttpDefaultNetworkId(int httpDefaultNetworkId) {
        this.httpDefaultNetworkId = httpDefaultNetworkId;
        this.store();
    }

    @Override
    public int getHttpDefaultMessagingMode() {
        return this.httpDefaultMessagingMode;
    }

    @Override
    public void setHttpDefaultMessagingMode(int httpDefaultMessagingMode) {
        this.httpDefaultMessagingMode = httpDefaultMessagingMode;
        this.store();
    }

    @Override
    public int getHttpDefaultRDDeliveryReceipt() {
        return this.httpDefaultRDDeliveryReceipt;
    }

    @Override
    public void setHttpDefaultRDDeliveryReceipt(int httpDefaultRDDeliveryReceipt) {
        this.httpDefaultRDDeliveryReceipt = httpDefaultRDDeliveryReceipt;
        this.store();
    }

    @Override
    public int getHttpDefaultRDIntermediateNotification() {
        return this.httpDefaultRDIntermediateNotification;
    }

    @Override
    public void setHttpDefaultRDIntermediateNotification(int httpDefaultRDIntermediateNotification) {
        this.httpDefaultRDIntermediateNotification = httpDefaultRDIntermediateNotification;
        this.store();
    }

    @Override
    public int getHttpDefaultDataCoding() {
        return this.httpDefaultDataCoding;
    }

    @Override
    public void setHttpDefaultDataCoding(int httpDefaultDataCoding) {
        this.httpDefaultDataCoding = httpDefaultDataCoding;
        this.store();
    }

    public void start() throws Exception {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("Loading SMSC Properties from %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the SMSC configuration file. \n%s", e.getMessage()));
        }
    }

    public void stop() throws Exception {
        this.store();
    }

    public void store() {
        try {
            ArrayListSerializingBase al2;
            Object el;
            ArrayList<ServiceCenterGtNetworkIdElement> al;
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write((Object)this.serviceCenterGt, SC_GT, String.class);
            if (this.networkIdVsServiceCenterGt.size() > 0) {
                al = new ArrayList<ServiceCenterGtNetworkIdElement>();
                for (Map.Entry val : this.networkIdVsServiceCenterGt.entrySet()) {
                    el = new ServiceCenterGtNetworkIdElement();
                    ((ServiceCenterGtNetworkIdElement)el).networkId = (Integer)val.getKey();
                    ((ServiceCenterGtNetworkIdElement)el).serviceCenterGt = (String)val.getValue();
                    al.add((ServiceCenterGtNetworkIdElement)el);
                }
                al2 = new SmscPropertiesManagement_serviceCenterGtNetworkId(al);
                writer.write((Object)al2, SC_GT_LIST, SmscPropertiesManagement_serviceCenterGtNetworkId.class);
            }
            writer.write((Object)this.serviceCenterSsn, SC_SSN, Integer.class);
            writer.write((Object)this.hlrSsn, HLR_SSN, Integer.class);
            writer.write((Object)this.mscSsn, MSC_SSN, Integer.class);
            writer.write((Object)this.maxMapVersion, MAX_MAP_VERSION, Integer.class);
            writer.write((Object)this.defaultValidityPeriodHours, DEFAULT_VALIDITY_PERIOD_HOURS, Integer.class);
            writer.write((Object)this.maxValidityPeriodHours, MAX_VALIDITY_PERIOD_HOURS, Integer.class);
            writer.write((Object)this.defaultTon, DEFAULT_TON, Integer.class);
            writer.write((Object)this.defaultNpi, DEFAULT_NPI, Integer.class);
            writer.write((Object)this.subscriberBusyDueDelay, SUBSCRIBER_BUSY_DUE_DELAY, Integer.class);
            writer.write((Object)this.firstDueDelay, FIRST_DUE_DELAY, Integer.class);
            writer.write((Object)this.secondDueDelay, SECOND_DUE_DELAY, Integer.class);
            writer.write((Object)this.maxDueDelay, MAX_DUE_DELAY, Integer.class);
            writer.write((Object)this.dueDelayMultiplicator, DUE_DELAY_MULTIPLICATOR, Integer.class);
            writer.write((Object)this.maxMessageLengthReducer, MAX_MESSAGE_LENGTH_REDUCER, Integer.class);
            writer.write((Object)this.dbHosts, DB_HOSTS, String.class);
            writer.write((Object)this.dbPort, DB_PORT, Integer.class);
            writer.write((Object)this.keyspaceName, KEYSPACE_NAME, String.class);
            writer.write((Object)this.clusterName, CLUSTER_NAME, String.class);
            writer.write((Object)this.fetchPeriod, FETCH_PERIOD, Long.class);
            writer.write((Object)this.fetchMaxRows, FETCH_MAX_ROWS, Integer.class);
            writer.write((Object)this.deliveryPause, DELIVERY_PAUSE, Boolean.class);
            writer.write((Object)this.removingLiveTablesDays, REMOVING_LIVE_TABLES_DAYS, Integer.class);
            writer.write((Object)this.removingArchiveTablesDays, REMOVING_ARCHIVE_TABLES_DAYS, Integer.class);
            writer.write((Object)this.hrHlrNumber, HR_HLR_NUMBER, String.class);
            if (this.networkIdVsHrHlrNumber.size() > 0) {
                al = new ArrayList();
                for (Map.Entry val : this.networkIdVsHrHlrNumber.entrySet()) {
                    el = new HrHlrNumberNetworkIdElement();
                    ((HrHlrNumberNetworkIdElement)el).networkId = (Integer)val.getKey();
                    ((HrHlrNumberNetworkIdElement)el).hrHlrNumber = (String)val.getValue();
                    al.add((ServiceCenterGtNetworkIdElement)el);
                }
                al2 = new SmscPropertiesManagement_HrHlrNumberNetworkId(al);
                writer.write((Object)al2, HR_HLR_NUMBER_LIST, SmscPropertiesManagement_HrHlrNumberNetworkId.class);
            }
            writer.write((Object)this.hrSriBypass, HR_SRI_BYPASS, Boolean.class);
            if (this.networkIdVsHrSriBypass.size() > 0) {
                al = new ArrayList();
                for (Map.Entry val : this.networkIdVsHrSriBypass.entrySet()) {
                    el = new HrSriBypassNetworkIdElement();
                    ((HrSriBypassNetworkIdElement)el).networkId = (Integer)val.getKey();
                    ((HrSriBypassNetworkIdElement)el).hrSriBypass = (Boolean)val.getValue();
                    al.add((ServiceCenterGtNetworkIdElement)el);
                }
                al2 = new SmscPropertiesManagement_HrSriBypassNetworkId(al);
                writer.write((Object)al2, HR_SRI_BYPASS_LIST, SmscPropertiesManagement_HrSriBypassNetworkId.class);
            }
            writer.write((Object)this.nationalLanguageSingleShift, NATIONAL_LANGUAGE_SINGLE_SHIFT, Integer.class);
            writer.write((Object)this.nationalLanguageLockingShift, NATIONAL_LANGUAGE_LOCKING_SHIFT, Integer.class);
            writer.write((Object)this.esmeDefaultClusterName, ESME_DEFAULT_CLUSTER_NAME, String.class);
            writer.write((Object)this.maxActivityCount, MAX_ACTIVITY_COUNT, Integer.class);
            writer.write((Object)this.deliveryTimeout, DELIVERY_TIMEOUT, Integer.class);
            writer.write((Object)this.vpProlong, VP_PROLONG, Integer.class);
            writer.write((Object)this.smppEncodingForGsm7.toString(), SMPP_ENCODING_FOR_GSM7, String.class);
            writer.write((Object)this.smppEncodingForUCS2.toString(), SMPP_ENCODING_FOR_UCS2, String.class);
            writer.write((Object)this.httpEncodingForGsm7.toString(), HTTP_ENCODING_FOR_GSM7, String.class);
            writer.write((Object)this.httpEncodingForUCS2.toString(), HTTP_ENCODING_FOR_UCS2, String.class);
            writer.write((Object)this.reviseSecondsOnSmscStart, REVISE_SECONDS_ON_SMSC_START, Integer.class);
            writer.write((Object)this.processingSmsSetTimeout, PROCESSING_SMS_SET_TIMEOUT, Integer.class);
            writer.write((Object)this.generateReceiptCdr, GENERATE_RECEIPT_CDR, Boolean.class);
            writer.write((Object)this.receiptsDisabling, RECEIPTS_DISABLING, Boolean.class);
            writer.write((Object)this.incomeReceiptsProcessing, INCOME_RECEIPTS_PROCESSING, Boolean.class);
            writer.write((Object)this.enableIntermediateReceipts, ENABLE_INTERMEDIATE_RECEIPTS, Boolean.class);
            writer.write((Object)this.origNetworkIdForReceipts, ORIG_NETWORK_ID_FOR_RECEIPTS, Boolean.class);
            writer.write((Object)this.moDefaultMessagingMode, MO_DEFAULT_MESSAGING_MODE, Integer.class);
            writer.write((Object)this.hrDefaultMessagingMode, HR_DEFAULT_MESSAGING_MODE, Integer.class);
            writer.write((Object)this.sipDefaultMessagingMode, SIP_DEFAULT_MESSAGING_MODE, Integer.class);
            writer.write((Object)this.generateCdr.getValue(), GENERATE_CDR, Integer.class);
            writer.write((Object)this.generateArchiveTable.getValue(), GENERATE_ARCHIVE_TABLE, Integer.class);
            writer.write((Object)this.storeAndForwordMode.toString(), STORE_AND_FORWORD_MODE, String.class);
            writer.write((Object)this.minMessageId, MIN_MESSAGE_ID, Long.class);
            writer.write((Object)this.maxMessageId, MAX_MESSAGE_ID, Long.class);
            writer.write((Object)this.moCharging.toString(), MO_CHARGING, String.class);
            writer.write((Object)this.hrCharging.toString(), HR_CHARGING, String.class);
            writer.write((Object)this.txSmppCharging.toString(), TX_SMPP_CHARGING, String.class);
            writer.write((Object)this.txSipCharging.toString(), TX_SIP_CHARGING, String.class);
            writer.write((Object)this.txHttpCharging.toString(), TX_HTTP_CHARGING, String.class);
            writer.write((Object)this.globalTitleIndicator.toString(), GLOBAL_TITLE_INDICATOR, String.class);
            writer.write((Object)this.translationType, TRANSLATION_TYPE, Integer.class);
            writer.write((Object)this.correlationIdLiveTime, CORRELATION_ID_LIVE_TIME, Integer.class);
            writer.write((Object)this.sriResponseLiveTime, SRI_RESPONSE_LIVE_TIME, Integer.class);
            writer.write((Object)this.httpDefaultSourceTon, HTTP_DEFAULT_SOURCE_TON, Integer.class);
            writer.write((Object)this.httpDefaultSourceNpi, HTTP_DEFAULT_SOURCE_NPI, Integer.class);
            writer.write((Object)this.httpDefaultDestTon, HTTP_DEFAULT_DEST_TON, Integer.class);
            writer.write((Object)this.httpDefaultDestNpi, HTTP_DEFAULT_DEST_NPI, Integer.class);
            writer.write((Object)this.httpDefaultNetworkId, HTTP_DEFAULT_NETWORK_ID, Integer.class);
            writer.write((Object)this.httpDefaultMessagingMode, HTTP_DEFAULT_MESSAGING_MODE, Integer.class);
            writer.write((Object)this.httpDefaultRDDeliveryReceipt, HTTP_DEFAULT_RD_DELIVERY_RECEIPT, Integer.class);
            writer.write((Object)this.httpDefaultRDIntermediateNotification, HTTP_DEFAULT_RD_INTERMEDIATE_NOTIFICATION, Integer.class);
            writer.write((Object)this.httpDefaultDataCoding, HTTP_DEFAULT_DATA_CODING, Integer.class);
            writer.write((Object)this.diameterDestRealm, DIAMETER_DEST_REALM, String.class);
            writer.write((Object)this.diameterDestHost, DIAMETER_DEST_HOST, String.class);
            writer.write((Object)this.diameterDestPort, DIAMETER_DEST_PORT, Integer.class);
            writer.write((Object)this.diameterUserName, DIAMETER_USER_NAME, String.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the SMSC state in file", (Throwable)e);
        }
    }

    public void load() throws FileNotFoundException {
        XMLObjectReader reader = null;
        try {
            Boolean valB;
            String[] hostsArr;
            String vals;
            Integer val;
            Integer dNpi;
            Integer dTon;
            Integer mvp;
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            reader.setBinding(binding);
            this.serviceCenterGt = (String)reader.read(SC_GT, String.class);
            SmscPropertiesManagement_serviceCenterGtNetworkId al = (SmscPropertiesManagement_serviceCenterGtNetworkId)((Object)reader.read(SC_GT_LIST, SmscPropertiesManagement_serviceCenterGtNetworkId.class));
            this.networkIdVsServiceCenterGt.clear();
            if (al != null) {
                for (ServiceCenterGtNetworkIdElement elem : al.getData()) {
                    this.networkIdVsServiceCenterGt.put((Object)elem.networkId, (Object)elem.serviceCenterGt);
                }
            }
            this.serviceCenterSsn = (Integer)reader.read(SC_SSN, Integer.class);
            this.hlrSsn = (Integer)reader.read(HLR_SSN, Integer.class);
            this.mscSsn = (Integer)reader.read(MSC_SSN, Integer.class);
            this.maxMapVersion = (Integer)reader.read(MAX_MAP_VERSION, Integer.class);
            Integer dvp = (Integer)reader.read(DEFAULT_VALIDITY_PERIOD_HOURS, Integer.class);
            if (dvp != null) {
                this.defaultValidityPeriodHours = dvp;
            }
            if ((mvp = (Integer)reader.read(MAX_VALIDITY_PERIOD_HOURS, Integer.class)) != null) {
                this.maxValidityPeriodHours = mvp;
            }
            if ((dTon = (Integer)reader.read(DEFAULT_TON, Integer.class)) != null) {
                this.defaultTon = dTon;
            }
            if ((dNpi = (Integer)reader.read(DEFAULT_NPI, Integer.class)) != null) {
                this.defaultNpi = dNpi;
            }
            if ((val = (Integer)reader.read(SUBSCRIBER_BUSY_DUE_DELAY, Integer.class)) != null) {
                this.subscriberBusyDueDelay = val;
            }
            if ((val = (Integer)reader.read(FIRST_DUE_DELAY, Integer.class)) != null) {
                this.firstDueDelay = val;
            }
            if ((val = (Integer)reader.read(SECOND_DUE_DELAY, Integer.class)) != null) {
                this.secondDueDelay = val;
            }
            if ((val = (Integer)reader.read(MAX_DUE_DELAY, Integer.class)) != null) {
                this.maxDueDelay = val;
            }
            if ((val = (Integer)reader.read(DUE_DELAY_MULTIPLICATOR, Integer.class)) != null) {
                this.dueDelayMultiplicator = val;
            }
            if ((val = (Integer)reader.read(MAX_MESSAGE_LENGTH_REDUCER, Integer.class)) != null) {
                this.maxMessageLengthReducer = val;
            }
            if ((vals = (String)reader.read(HOSTS, String.class)) != null && (hostsArr = vals.split(":")).length == 2) {
                this.dbHosts = hostsArr[0];
                this.dbPort = Integer.parseInt(hostsArr[1]);
            }
            if ((vals = (String)reader.read(DB_HOSTS, String.class)) != null) {
                this.dbHosts = vals;
            }
            if ((val = (Integer)reader.read(DB_PORT, Integer.class)) != null) {
                this.dbPort = val;
            }
            this.keyspaceName = (String)reader.read(KEYSPACE_NAME, String.class);
            this.clusterName = (String)reader.read(CLUSTER_NAME, String.class);
            Long vall = (Long)reader.read(FETCH_PERIOD, Long.class);
            if (vall != null) {
                this.fetchPeriod = vall;
            }
            if ((val = (Integer)reader.read(FETCH_MAX_ROWS, Integer.class)) != null) {
                this.fetchMaxRows = val;
            }
            if ((valB = (Boolean)reader.read(DELIVERY_PAUSE, Boolean.class)) != null) {
                this.deliveryPause = valB;
            }
            if ((val = (Integer)reader.read(REMOVING_LIVE_TABLES_DAYS, Integer.class)) != null) {
                this.removingLiveTablesDays = val;
            }
            if ((val = (Integer)reader.read(REMOVING_ARCHIVE_TABLES_DAYS, Integer.class)) != null) {
                this.removingArchiveTablesDays = val;
            }
            vals = (String)reader.read(MO_UNKNOWN_TYPE_OF_NUMBER_PREFIX, String.class);
            vals = (String)reader.read(HR_HLR_NUMBER, String.class);
            if (vals != null) {
                this.hrHlrNumber = vals;
            }
            SmscPropertiesManagement_HrHlrNumberNetworkId al2 = (SmscPropertiesManagement_HrHlrNumberNetworkId)((Object)reader.read(HR_HLR_NUMBER_LIST, SmscPropertiesManagement_HrHlrNumberNetworkId.class));
            this.networkIdVsHrHlrNumber.clear();
            if (al2 != null) {
                for (HrHlrNumberNetworkIdElement elem : al2.getData()) {
                    this.networkIdVsHrHlrNumber.put((Object)elem.networkId, (Object)elem.hrHlrNumber);
                }
            }
            if ((valB = (Boolean)reader.read(HR_SRI_BYPASS, Boolean.class)) != null) {
                this.hrSriBypass = valB;
            }
            SmscPropertiesManagement_HrSriBypassNetworkId al3 = (SmscPropertiesManagement_HrSriBypassNetworkId)((Object)reader.read(HR_SRI_BYPASS_LIST, SmscPropertiesManagement_HrSriBypassNetworkId.class));
            this.networkIdVsHrSriBypass.clear();
            if (al3 != null) {
                for (HrSriBypassNetworkIdElement elem : al3.getData()) {
                    this.networkIdVsHrSriBypass.put((Object)elem.networkId, (Object)elem.hrSriBypass);
                }
            }
            if ((val = (Integer)reader.read(NATIONAL_LANGUAGE_SINGLE_SHIFT, Integer.class)) != null) {
                this.nationalLanguageSingleShift = val;
            }
            if ((val = (Integer)reader.read(NATIONAL_LANGUAGE_LOCKING_SHIFT, Integer.class)) != null) {
                this.nationalLanguageLockingShift = val;
            }
            this.esmeDefaultClusterName = (String)reader.read(ESME_DEFAULT_CLUSTER_NAME, String.class);
            val = (Integer)reader.read(MAX_ACTIVITY_COUNT, Integer.class);
            if (val != null) {
                this.maxActivityCount = val;
            }
            if ((val = (Integer)reader.read(DELIVERY_TIMEOUT, Integer.class)) != null) {
                this.deliveryTimeout = val;
            }
            if ((val = (Integer)reader.read(VP_PROLONG, Integer.class)) != null) {
                this.vpProlong = val;
            }
            valB = (Boolean)reader.read(SMS_HOME_ROUTING, Boolean.class);
            vals = (String)reader.read(SMPP_ENCODING_FOR_GSM7, String.class);
            if (vals != null) {
                this.smppEncodingForGsm7 = Enum.valueOf(SmppEncoding.class, vals);
            }
            if ((vals = (String)reader.read(SMPP_ENCODING_FOR_UCS2, String.class)) != null) {
                this.httpEncodingForUCS2 = Enum.valueOf(HttpEncoding.class, vals);
            }
            if ((vals = (String)reader.read(HTTP_ENCODING_FOR_GSM7, String.class)) != null) {
                this.httpEncodingForGsm7 = Enum.valueOf(HttpEncoding.class, vals);
            }
            if ((vals = (String)reader.read(HTTP_ENCODING_FOR_UCS2, String.class)) != null) {
                this.smppEncodingForUCS2 = Enum.valueOf(SmppEncoding.class, vals);
            }
            if ((val = (Integer)reader.read(REVISE_SECONDS_ON_SMSC_START, Integer.class)) != null) {
                this.reviseSecondsOnSmscStart = val;
            }
            if ((val = (Integer)reader.read(PROCESSING_SMS_SET_TIMEOUT, Integer.class)) != null) {
                this.processingSmsSetTimeout = val;
            }
            if ((valB = (Boolean)reader.read(GENERATE_RECEIPT_CDR, Boolean.class)) != null) {
                this.generateReceiptCdr = valB;
            }
            if ((valB = (Boolean)reader.read(RECEIPTS_DISABLING, Boolean.class)) != null) {
                this.receiptsDisabling = valB;
            }
            if ((valB = (Boolean)reader.read(INCOME_RECEIPTS_PROCESSING, Boolean.class)) != null) {
                this.incomeReceiptsProcessing = valB;
            }
            if ((valB = (Boolean)reader.read(ENABLE_INTERMEDIATE_RECEIPTS, Boolean.class)) != null) {
                this.enableIntermediateReceipts = valB;
            }
            if ((valB = (Boolean)reader.read(ORIG_NETWORK_ID_FOR_RECEIPTS, Boolean.class)) != null) {
                this.origNetworkIdForReceipts = valB;
            }
            if ((val = (Integer)reader.read(MO_DEFAULT_MESSAGING_MODE, Integer.class)) != null) {
                this.moDefaultMessagingMode = val;
            }
            if ((val = (Integer)reader.read(HR_DEFAULT_MESSAGING_MODE, Integer.class)) != null) {
                this.hrDefaultMessagingMode = val;
            }
            if ((val = (Integer)reader.read(SIP_DEFAULT_MESSAGING_MODE, Integer.class)) != null) {
                this.sipDefaultMessagingMode = val;
            }
            if ((val = (Integer)reader.read(GENERATE_CDR, Integer.class)) != null) {
                this.generateCdr = new GenerateType(val.intValue());
            }
            if ((val = (Integer)reader.read(GENERATE_ARCHIVE_TABLE, Integer.class)) != null) {
                this.generateArchiveTable = new GenerateType(val.intValue());
            }
            if ((vals = (String)reader.read(STORE_AND_FORWORD_MODE, String.class)) != null) {
                this.storeAndForwordMode = Enum.valueOf(StoreAndForwordMode.class, vals);
            }
            if ((vall = (Long)reader.read(MIN_MESSAGE_ID, Long.class)) != null) {
                this.minMessageId = vall;
            }
            if ((vall = (Long)reader.read(MAX_MESSAGE_ID, Long.class)) != null) {
                this.maxMessageId = vall;
            }
            if ((vals = (String)reader.read(MO_CHARGING, String.class)) != null) {
                this.moCharging = vals.toLowerCase().equals("false") ? MoChargingType.accept : (vals.toLowerCase().equals("true") ? MoChargingType.diameter : Enum.valueOf(MoChargingType.class, vals));
            }
            if ((vals = (String)reader.read(HR_CHARGING, String.class)) != null) {
                this.hrCharging = vals.toLowerCase().equals("false") ? MoChargingType.accept : (vals.toLowerCase().equals("true") ? MoChargingType.diameter : Enum.valueOf(MoChargingType.class, vals));
            }
            if ((vals = (String)reader.read(TX_SMPP_CHARGING, String.class)) != null) {
                this.txSmppCharging = Enum.valueOf(ChargingType.class, vals);
            }
            if ((vals = (String)reader.read(TX_SIP_CHARGING, String.class)) != null) {
                this.txSipCharging = Enum.valueOf(ChargingType.class, vals);
            }
            if ((vals = (String)reader.read(TX_HTTP_CHARGING, String.class)) != null) {
                this.txHttpCharging = vals.toLowerCase().equals("false") ? MoChargingType.accept : (vals.toLowerCase().equals("true") ? MoChargingType.diameter : Enum.valueOf(MoChargingType.class, vals));
            }
            if ((vals = (String)reader.read(GLOBAL_TITLE_INDICATOR, String.class)) != null) {
                this.globalTitleIndicator = Enum.valueOf(GlobalTitleIndicator.class, vals);
            }
            if ((val = (Integer)reader.read(TRANSLATION_TYPE, Integer.class)) != null) {
                this.translationType = val;
            }
            if ((val = (Integer)reader.read(CORRELATION_ID_LIVE_TIME, Integer.class)) != null) {
                this.correlationIdLiveTime = val;
            }
            if ((val = (Integer)reader.read(SRI_RESPONSE_LIVE_TIME, Integer.class)) != null) {
                this.sriResponseLiveTime = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_SOURCE_TON, Integer.class)) != null) {
                this.httpDefaultSourceTon = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_SOURCE_NPI, Integer.class)) != null) {
                this.httpDefaultSourceNpi = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_DEST_TON, Integer.class)) != null) {
                this.httpDefaultDestTon = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_DEST_NPI, Integer.class)) != null) {
                this.httpDefaultDestNpi = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_NETWORK_ID, Integer.class)) != null) {
                this.httpDefaultNetworkId = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_MESSAGING_MODE, Integer.class)) != null) {
                this.httpDefaultMessagingMode = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_RD_DELIVERY_RECEIPT, Integer.class)) != null) {
                this.httpDefaultRDDeliveryReceipt = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_RD_INTERMEDIATE_NOTIFICATION, Integer.class)) != null) {
                this.httpDefaultRDIntermediateNotification = val;
            }
            if ((val = (Integer)reader.read(HTTP_DEFAULT_DATA_CODING, Integer.class)) != null) {
                this.httpDefaultDataCoding = val;
            }
            this.diameterDestRealm = (String)reader.read(DIAMETER_DEST_REALM, String.class);
            this.diameterDestHost = (String)reader.read(DIAMETER_DEST_HOST, String.class);
            val = (Integer)reader.read(DIAMETER_DEST_PORT, Integer.class);
            if (val != null) {
                this.diameterDestPort = val;
            }
            this.diameterUserName = (String)reader.read(DIAMETER_USER_NAME, String.class);
            reader.close();
        }
        catch (XMLStreamException ex) {
            logger.error((Object)"Error while loading the SMSC state from file", (Throwable)ex);
        }
    }

    public static class SmscPropertiesManagement_HrSriBypassNetworkId
    extends ArrayListSerializingBase<HrSriBypassNetworkIdElement> {
        public SmscPropertiesManagement_HrSriBypassNetworkId() {
            super(SmscPropertiesManagement.HR_SRI_BYPASS_LIST, HrSriBypassNetworkIdElement.class);
        }

        public SmscPropertiesManagement_HrSriBypassNetworkId(ArrayList<HrSriBypassNetworkIdElement> data) {
            super(SmscPropertiesManagement.HR_SRI_BYPASS_LIST, HrSriBypassNetworkIdElement.class, data);
        }
    }

    public static class SmscPropertiesManagement_HrHlrNumberNetworkId
    extends ArrayListSerializingBase<HrHlrNumberNetworkIdElement> {
        public SmscPropertiesManagement_HrHlrNumberNetworkId() {
            super(SmscPropertiesManagement.HR_HLR_NUMBER_LIST, HrHlrNumberNetworkIdElement.class);
        }

        public SmscPropertiesManagement_HrHlrNumberNetworkId(ArrayList<HrHlrNumberNetworkIdElement> data) {
            super(SmscPropertiesManagement.HR_HLR_NUMBER_LIST, HrHlrNumberNetworkIdElement.class, data);
        }
    }

    public static class SmscPropertiesManagement_serviceCenterGtNetworkId
    extends ArrayListSerializingBase<ServiceCenterGtNetworkIdElement> {
        public SmscPropertiesManagement_serviceCenterGtNetworkId() {
            super(SmscPropertiesManagement.SC_GT_LIST, ServiceCenterGtNetworkIdElement.class);
        }

        public SmscPropertiesManagement_serviceCenterGtNetworkId(ArrayList<ServiceCenterGtNetworkIdElement> data) {
            super(SmscPropertiesManagement.SC_GT_LIST, ServiceCenterGtNetworkIdElement.class, data);
        }
    }
}

