/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.util.Date;
import org.apache.log4j.Logger;
import org.mobicents.smsc.cassandra.DBOperations;
import org.mobicents.smsc.domain.SmscStatProviderMBean;
import org.mobicents.smsc.library.SmsSetCache;

public class SmscStatProvider
implements SmscStatProviderMBean {
    private static final Logger logger = Logger.getLogger(SmscStatProvider.class);
    private long messageScheduledTotal = 0L;
    private int param1 = 0;
    private int param2 = 0;
    private long currentMessageId = 0L;
    private Date smscStartTime = new Date();
    private static SmscStatProvider instance = new SmscStatProvider();
    private static final SmsSetCache smsSetCashe = SmsSetCache.getInstance();
    private static final DBOperations dbOperations_C2 = DBOperations.getInstance();

    public static SmscStatProvider getInstance() {
        return instance;
    }

    @Override
    public int getMessageInProcess() {
        return smsSetCashe.getProcessingSmsSetSize();
    }

    @Override
    public int getDueSlotProcessingLag() {
        long current = dbOperations_C2.c2_getCurrentDueSlot();
        long inTime = dbOperations_C2.c2_getDueSlotForTime(new Date());
        return (int)(inTime - current);
    }

    public Date getDueSlotProcessingTime() {
        long current = dbOperations_C2.c2_getCurrentDueSlot();
        Date currentDate = dbOperations_C2.c2_getTimeForDueSlot(current);
        return currentDate;
    }

    @Override
    public long getMessageScheduledTotal() {
        return this.messageScheduledTotal;
    }

    public void setMessageScheduledTotal(long messageScheduledTotal) {
        this.messageScheduledTotal = messageScheduledTotal;
    }

    public int getParam1() {
        return this.param1;
    }

    public void setParam1(int param1) {
        this.param1 = param1;
    }

    public int getParam2() {
        return this.param2;
    }

    public void setParam2(int param2) {
        this.param2 = param2;
    }

    @Override
    public long getCurrentMessageId() {
        return this.currentMessageId;
    }

    public void setCurrentMessageId(long currentMessageId) {
        this.currentMessageId = currentMessageId;
    }

    @Override
    public Date getSmscStartTime() {
        return this.smscStartTime;
    }

    public void setSmscStartTime(Date smscStartTime) {
        this.smscStartTime = smscStartTime;
    }
}

