/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.mobicents.smsc.cassandra.DBOperations;
import org.mobicents.smsc.domain.SmscDatabaseManagementMBean;
import org.mobicents.smsc.domain.SmscPropertiesManagement;

public class SmscDatabaseManagement
implements SmscDatabaseManagementMBean,
Runnable {
    private static final Logger logger = Logger.getLogger(SmscDatabaseManagement.class);
    private String name;
    private boolean isStarted;
    private final SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    private DBOperations dbOperations_C2 = null;
    private ScheduledExecutorService executor;
    private Future idleTimerFuture;
    private int dayProcessed = 0;
    private int monthProcessed = 0;
    private static SmscDatabaseManagement instance = null;

    public SmscDatabaseManagement(String name) {
        this.name = name;
    }

    protected static SmscDatabaseManagement getInstance(String name) {
        if (instance == null) {
            instance = new SmscDatabaseManagement(name);
        }
        return instance;
    }

    public static SmscDatabaseManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public void start() throws Exception {
        this.dbOperations_C2 = DBOperations.getInstance();
        this.setUnprocessed();
        this.executor = Executors.newScheduledThreadPool(4);
        if (this.dbOperations_C2.isDatabaseAvailable()) {
            this.idleTimerFuture = this.executor.schedule(this, 30L, TimeUnit.SECONDS);
        }
        this.isStarted = true;
    }

    public void stop() throws Exception {
        this.isStarted = false;
        if (this.idleTimerFuture != null) {
            this.idleTimerFuture.cancel(false);
            this.idleTimerFuture = null;
        }
        this.executor.shutdown();
    }

    @Override
    public void run() {
        block8: {
            boolean processed;
            Date[] dtt;
            Date tagDate;
            Date curDate;
            int archDays;
            block9: {
                if (!this.checkUnprocessed()) break block8;
                int liveDays = this.smscPropertiesManagement.getRemovingLiveTablesDays();
                archDays = this.smscPropertiesManagement.getRemovingArchiveTablesDays();
                curDate = new Date();
                if (liveDays <= 0) break block9;
                tagDate = new Date(curDate.getTime() - (long)(liveDays * 24 * 3600 * 1000));
                dtt = this.getLiveTablesListBeforeDate(tagDate);
                processed = true;
                for (Date dt : dtt) {
                    if (this.dbOperations_C2.c2_deleteLiveTablesForDate(dt)) continue;
                    this.setUnprocessed();
                    processed = false;
                    break;
                }
                if (!processed) break block8;
            }
            if (archDays > 0) {
                tagDate = new Date(curDate.getTime() - (long)(archDays * 24 * 3600 * 1000));
                dtt = this.getArchiveTablesListBeforeDate(tagDate);
                processed = true;
                for (Date dt : dtt) {
                    if (this.dbOperations_C2.c2_deleteArchiveTablesForDate(dt)) continue;
                    this.setUnprocessed();
                    processed = false;
                    break;
                }
                if (!processed) {
                    // empty if block
                }
            }
        }
        if (this.isStarted) {
            this.idleTimerFuture = this.executor.schedule(this, 30L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkUnprocessed() {
        SmscDatabaseManagement smscDatabaseManagement = this;
        synchronized (smscDatabaseManagement) {
            Date cur = new Date();
            int day = cur.getDate();
            int mon = cur.getMonth();
            if (this.dayProcessed != day || this.monthProcessed != mon) {
                this.dayProcessed = day;
                this.monthProcessed = mon;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUnprocessed() {
        SmscDatabaseManagement smscDatabaseManagement = this;
        synchronized (smscDatabaseManagement) {
            this.dayProcessed = 0;
            this.monthProcessed = 0;
        }
    }

    @Override
    public void deleteLiveTablesForDate(Date date) {
        if (date != null) {
            this.dbOperations_C2.c2_deleteLiveTablesForDate(date);
        }
    }

    @Override
    public void deleteArchiveTablesForDate(Date date) {
        if (date != null) {
            this.dbOperations_C2.c2_deleteArchiveTablesForDate(date);
        }
    }

    private Date[] performDateFilter(Date[] dtt, Date maxDate) {
        ArrayList<Date> res = new ArrayList<Date>();
        for (Date dt : dtt) {
            if (dt.getYear() < maxDate.getYear()) {
                res.add(dt);
                continue;
            }
            if (dt.getYear() != maxDate.getYear()) continue;
            if (dt.getMonth() < maxDate.getMonth()) {
                res.add(dt);
                continue;
            }
            if (dt.getMonth() != maxDate.getMonth() || dt.getDate() > maxDate.getDate()) continue;
            res.add(dt);
        }
        Date[] rr = new Date[res.size()];
        res.toArray(rr);
        return rr;
    }

    @Override
    public Date[] getLiveTablesListBeforeDate(Date maxDate) {
        if (maxDate == null) {
            maxDate = new Date(500, 1, 1);
        }
        Date[] dtt = this.dbOperations_C2.c2_getLiveTableList(this.smscPropertiesManagement.getKeyspaceName());
        Date[] dtt2 = this.performDateFilter(dtt, maxDate);
        return dtt2;
    }

    @Override
    public Date[] getArchiveTablesListBeforeDate(Date maxDate) {
        if (maxDate == null) {
            maxDate = new Date(500, 1, 1);
        }
        Date[] dtt = this.dbOperations_C2.c2_getArchiveTableList(this.smscPropertiesManagement.getKeyspaceName());
        Date[] dtt2 = this.performDateFilter(dtt, maxDate);
        return dtt2;
    }
}

