/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSession;
import javolution.util.FastList;
import org.mobicents.smsc.domain.Sip;
import org.mobicents.smsc.domain.SipManagement;
import org.mobicents.smsc.domain.SmsRoutingRule;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.restcomm.smpp.Esme;
import org.restcomm.smpp.EsmeManagement;

public class DefaultSmsRoutingRule
implements SmsRoutingRule {
    private SmscPropertiesManagement smscPropertiesManagement;
    private EsmeManagement esmeManagement;
    private SipManagement sipManagement;

    @Override
    public void setEsmeManagement(EsmeManagement em) {
        this.esmeManagement = em;
    }

    @Override
    public void setSipManagement(SipManagement sm) {
        this.sipManagement = sm;
    }

    @Override
    public void setSmscPropertiesManagement(SmscPropertiesManagement sm) {
        this.smscPropertiesManagement = sm;
    }

    @Override
    public String getEsmeClusterName(int ton, int npi, String address, String name, int networkId) {
        FastList.Node n = this.esmeManagement.getEsmes().head();
        FastList.Node end = this.esmeManagement.getEsmes().tail();
        while ((n = n.getNext()) != end) {
            Esme esme = (Esme)n.getValue();
            SmppBindType sessionBindType = esme.getSmppBindType();
            SmppSession.Type smppSessionType = esme.getSmppSessionType();
            if (sessionBindType != SmppBindType.TRANSCEIVER && (sessionBindType != SmppBindType.RECEIVER || smppSessionType != SmppSession.Type.SERVER) && (sessionBindType != SmppBindType.TRANSMITTER || smppSessionType != SmppSession.Type.CLIENT) || esme.getName().equals(name) || esme.getNetworkId() != networkId || !esme.isRoutingAddressMatching(ton, npi, address)) continue;
            return esme.getClusterName();
        }
        return null;
    }

    @Override
    public String getSipClusterName(int ton, int npi, String address, int networkId) {
        FastList.Node n = this.sipManagement.sips.head();
        FastList.Node end = this.sipManagement.sips.tail();
        while ((n = n.getNext()) != end) {
            Sip sip = (Sip)n.getValue();
            if (sip.getNetworkId() != networkId || !sip.isRoutingAddressMatching(ton, npi, address)) continue;
            return sip.getClusterName();
        }
        return null;
    }
}

