/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.smsc.domain.HttpUserMBean;
import org.mobicents.smsc.domain.HttpUsersManagement;

public class HttpUser
implements HttpUserMBean {
    private static final Logger logger = Logger.getLogger(HttpUser.class);
    private static final String USER_NAME = "userName";
    private static final String PASSWORD = "password";
    private static final String NETWORK_ID = "networkId";
    protected HttpUsersManagement httpUsersManagement;
    private String userName;
    private String password = "";
    private int itsNetworkId = -1;
    protected static final XMLFormat<HttpUser> HTTP_USER_XML = new XMLFormat<HttpUser>(HttpUser.class){

        public void read(XMLFormat.InputElement xml, HttpUser httpUser) throws XMLStreamException {
            httpUser.userName = xml.getAttribute(HttpUser.USER_NAME, "");
            httpUser.password = xml.getAttribute(HttpUser.PASSWORD, "");
            httpUser.setNetworkIdNoStore(xml.getAttribute(HttpUser.NETWORK_ID, -1));
        }

        public void write(HttpUser httpUser, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(HttpUser.USER_NAME, httpUser.userName);
            xml.setAttribute(HttpUser.PASSWORD, httpUser.password);
            xml.setAttribute(HttpUser.NETWORK_ID, httpUser.getNetworkId());
        }
    };

    public HttpUser() {
    }

    public HttpUser(String userName, String password, int aNetworkId) {
        this.userName = userName;
        this.password = password;
        this.itsNetworkId = aNetworkId;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        this.store();
    }

    @Override
    public int getNetworkId() {
        return this.itsNetworkId;
    }

    @Override
    public void setNetworkId(int aNetworkId) {
        this.itsNetworkId = aNetworkId;
        this.store();
    }

    private void setNetworkIdNoStore(int aNetworkId) {
        this.itsNetworkId = aNetworkId;
    }

    public void show(StringBuffer sb) {
        sb.append("HttpUser userName=").append(this.userName).append(" password=").append(this.password).append(" networkId=").append(this.itsNetworkId);
        sb.append("\n");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpUser other = (HttpUser)obj;
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    public void store() {
        this.httpUsersManagement.store();
    }
}

