/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import com.codahale.metrics.Counter;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.mobicents.protocols.ss7.statistics.StatDataCollectionImpl;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollection;
import org.mobicents.protocols.ss7.statistics.api.StatDataCollectorType;
import org.mobicents.protocols.ss7.statistics.api.StatResult;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.UpdateMessagesInProcessListener;

public class SmscStatAggregator
implements UpdateMessagesInProcessListener {
    private static String MIN_MESSAGES_IN_PROCESS = "MinMessagesInProcess";
    private static String MAX_MESSAGES_IN_PROCESS = "MaxMessagesInProcess";
    private static final SmscStatAggregator instance = new SmscStatAggregator();
    private final SmsSetCache smsSetCashe = SmsSetCache.getInstance();
    private StatCollector statCollector = new StatCollector();
    private UUID sessionId = UUID.randomUUID();
    private Counter counterMessages;

    public SmscStatAggregator() {
        SmsSetCache.getInstance().setUpdateMessagesInProcessListener((UpdateMessagesInProcessListener)this);
    }

    public static SmscStatAggregator getInstance() {
        return instance;
    }

    public void setCounterMessages(Counter counterMessages) {
        this.counterMessages = counterMessages;
    }

    public void reset() {
        this.statCollector = new StatCollector();
        this.sessionId = UUID.randomUUID();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public Long getMinMessagesInProcess(String compainName) {
        StatResult res = this.statCollector.statDataCollection.restartAndGet(MIN_MESSAGES_IN_PROCESS, compainName);
        this.statCollector.statDataCollection.updateData(MIN_MESSAGES_IN_PROCESS, (long)this.smsSetCashe.getProcessingSmsSetSize());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMinMessagesInProcess(long newVal) {
        this.statCollector.statDataCollection.updateData(MIN_MESSAGES_IN_PROCESS, newVal);
    }

    public Long getMaxMessagesInProcess(String compainName) {
        StatResult res = this.statCollector.statDataCollection.restartAndGet(MAX_MESSAGES_IN_PROCESS, compainName);
        this.statCollector.statDataCollection.updateData(MAX_MESSAGES_IN_PROCESS, (long)this.smsSetCashe.getProcessingSmsSetSize());
        if (res != null) {
            return res.getLongValue();
        }
        return null;
    }

    public void updateMaxMessagesInProcess(long newVal) {
        this.statCollector.statDataCollection.updateData(MAX_MESSAGES_IN_PROCESS, newVal);
    }

    public long getMsgInReceivedAll() {
        return this.statCollector.msgInReceivedAll.get();
    }

    public void updateMsgInReceivedAll() {
        this.statCollector.msgInReceivedAll.addAndGet(1L);
    }

    public long getMsgInRejectedAll() {
        return this.statCollector.msgInRejectedAll.get();
    }

    public void updateMsgInRejectedAll() {
        this.statCollector.msgInRejectedAll.addAndGet(1L);
    }

    public long getMsgInFailedAll() {
        return this.statCollector.msgInFailedAll.get();
    }

    public void updateMsgInFailedAll() {
        this.statCollector.msgInFailedAll.addAndGet(1L);
    }

    public long getMsgInReceivedSs7() {
        return this.statCollector.msgInReceivedSs7.get();
    }

    public void updateMsgInReceivedSs7() {
        this.statCollector.msgInReceivedSs7.addAndGet(1L);
    }

    public long getMsgInReceivedSs7Mo() {
        return this.statCollector.msgInReceivedSs7Mo.get();
    }

    public void updateMsgInReceivedSs7Mo() {
        this.statCollector.msgInReceivedSs7Mo.addAndGet(1L);
    }

    public long getMsgInReceivedSs7Hr() {
        return this.statCollector.msgInReceivedSs7Hr.get();
    }

    public void updateMsgInReceivedSs7Hr() {
        this.statCollector.msgInReceivedSs7Hr.addAndGet(1L);
    }

    public long getHomeRoutingCorrIdFail() {
        return this.statCollector.homeRoutingCorrIdFail.get();
    }

    public void updateHomeRoutingCorrIdFail() {
        this.statCollector.homeRoutingCorrIdFail.addAndGet(1L);
    }

    public long getSmppSecondRateOverlimitFail() {
        return this.statCollector.smppSecondRateOverlimitFail.get();
    }

    public void updateSmppSecondRateOverlimitFail() {
        this.statCollector.smppSecondRateOverlimitFail.addAndGet(1L);
    }

    public long getSmppMinuteRateOverlimitFail() {
        return this.statCollector.smppMinuteRateOverlimitFail.get();
    }

    public void updateSmppMinuteRateOverlimitFail() {
        this.statCollector.smppMinuteRateOverlimitFail.addAndGet(1L);
    }

    public long getSmppHourRateOverlimitFail() {
        return this.statCollector.smppHourRateOverlimitFail.get();
    }

    public void updateSmppHourRateOverlimitFail() {
        this.statCollector.smppHourRateOverlimitFail.addAndGet(1L);
    }

    public long getSmppDayRateOverlimitFail() {
        return this.statCollector.smppDayRateOverlimitFail.get();
    }

    public void updateSmppDayRateOverlimitFail() {
        this.statCollector.smppDayRateOverlimitFail.addAndGet(1L);
    }

    public long getMsgInReceivedSmpp() {
        return this.statCollector.msgInReceivedSmpp.get();
    }

    public void updateMsgInReceivedSmpp() {
        this.statCollector.msgInReceivedSmpp.addAndGet(1L);
    }

    public long getMsgInReceivedSip() {
        return this.statCollector.msgInReceivedSip.get();
    }

    public void updateMsgInReceivedSip() {
        this.statCollector.msgInReceivedSip.addAndGet(1L);
    }

    public long getMsgInHrSriReq() {
        return this.statCollector.msgInHrSriReq.get();
    }

    public void updateMsgInHrSriReq() {
        this.statCollector.msgInHrSriReq.addAndGet(1L);
    }

    public long getMsgInHrSriPosReq() {
        return this.statCollector.msgInHrSriPosReq.get();
    }

    public void updateMsgInHrSriPosReq() {
        this.statCollector.msgInHrSriPosReq.addAndGet(1L);
    }

    public long getMsgInHrSriHrByPass() {
        return this.statCollector.msgInHrSriHrByPass.get();
    }

    public void updateMsgInHrSriHrByPass() {
        this.statCollector.msgInHrSriHrByPass.addAndGet(1L);
    }

    public long getMsgInHrSriNegReq() {
        return this.statCollector.msgInHrSriNegReq.get();
    }

    public void updateMsgInHrSriNegReq() {
        this.statCollector.msgInHrSriNegReq.addAndGet(1L);
    }

    public long getMsgInReceivedAllCumulative() {
        return this.statCollector.msgInReceivedAll.get();
    }

    public long getMsgOutTryAll() {
        return this.statCollector.msgOutTryAll.get();
    }

    public void updateMsgOutTryAll() {
        this.statCollector.msgOutTryAll.addAndGet(1L);
    }

    public long getMsgOutSentAll() {
        return this.statCollector.msgOutSentAll.get();
    }

    public void updateMsgOutSentAll() {
        this.statCollector.msgOutSentAll.addAndGet(1L);
        if (this.counterMessages != null) {
            this.counterMessages.inc();
        }
    }

    public long getMsgOutTryAllCumulative() {
        return this.statCollector.msgOutTryAll.get();
    }

    public long getMsgOutSentAllCumulative() {
        return this.statCollector.msgOutSentAll.get();
    }

    public long getMsgOutFailedAll() {
        return this.statCollector.msgOutFailedAll.get();
    }

    public void updateMsgOutFailedAll() {
        this.statCollector.msgOutFailedAll.addAndGet(1L);
    }

    public long getMsgOutTrySs7() {
        return this.statCollector.msgOutTrySs7.get();
    }

    public void updateMsgOutTrySs7() {
        this.statCollector.msgOutTrySs7.addAndGet(1L);
    }

    public long getMsgOutSentSs7() {
        return this.statCollector.msgOutSentSs7.get();
    }

    public void updateMsgOutSentSs7() {
        this.statCollector.msgOutSentSs7.addAndGet(1L);
    }

    public long getMsgOutTrySmpp() {
        return this.statCollector.msgOutTrySmpp.get();
    }

    public void updateMsgOutTrySmpp() {
        this.statCollector.msgOutTrySmpp.addAndGet(1L);
    }

    public long getMsgOutSentSmpp() {
        return this.statCollector.msgOutSentSmpp.get();
    }

    public void updateMsgOutSentSmpp() {
        this.statCollector.msgOutSentSmpp.addAndGet(1L);
    }

    public long getMsgOutTrySip() {
        return this.statCollector.msgOutTrySip.get();
    }

    public void updateMsgOutTrySip() {
        this.statCollector.msgOutTrySip.addAndGet(1L);
    }

    public long getMsgOutSentSip() {
        return this.statCollector.msgOutSentSip.get();
    }

    public void updateMsgOutSentSip() {
        this.statCollector.msgOutSentSip.addAndGet(1L);
    }

    public long getSmscDeliveringLag() {
        return this.statCollector.smscDeliveringLag;
    }

    public void updateSmscDeliveringLag(int val) {
        this.statCollector.smscDeliveringLag = val;
    }

    public long getMsgPendingInDbRes() {
        return this.smsSetCashe.getMessagesStoredInDatabase() - this.smsSetCashe.getMessagesSentInDatabase();
    }

    private class StatCollector {
        private StatDataCollection statDataCollection = new StatDataCollectionImpl();
        private AtomicLong msgInReceivedAll = new AtomicLong();
        private AtomicLong msgInRejectedAll = new AtomicLong();
        private AtomicLong msgInFailedAll = new AtomicLong();
        private AtomicLong msgInReceivedSs7 = new AtomicLong();
        private AtomicLong msgInReceivedSs7Mo = new AtomicLong();
        private AtomicLong msgInReceivedSs7Hr = new AtomicLong();
        private AtomicLong homeRoutingCorrIdFail = new AtomicLong();
        private AtomicLong smppSecondRateOverlimitFail = new AtomicLong();
        private AtomicLong smppMinuteRateOverlimitFail = new AtomicLong();
        private AtomicLong smppHourRateOverlimitFail = new AtomicLong();
        private AtomicLong smppDayRateOverlimitFail = new AtomicLong();
        private AtomicLong msgInReceivedSmpp = new AtomicLong();
        private AtomicLong msgInReceivedSip = new AtomicLong();
        private AtomicLong msgInHrSriReq = new AtomicLong();
        private AtomicLong msgInHrSriPosReq = new AtomicLong();
        private AtomicLong msgInHrSriHrByPass = new AtomicLong();
        private AtomicLong msgInHrSriNegReq = new AtomicLong();
        private AtomicLong msgOutTryAll = new AtomicLong();
        private AtomicLong msgOutSentAll = new AtomicLong();
        private AtomicLong msgOutFailedAll = new AtomicLong();
        private AtomicLong msgOutTrySs7 = new AtomicLong();
        private AtomicLong msgOutSentSs7 = new AtomicLong();
        private AtomicLong msgOutTrySmpp = new AtomicLong();
        private AtomicLong msgOutSentSmpp = new AtomicLong();
        private AtomicLong msgOutTrySip = new AtomicLong();
        private AtomicLong msgOutSentSip = new AtomicLong();
        private int smscDeliveringLag = 0;

        public StatCollector() {
            this.statDataCollection.registerStatCounterCollector(MIN_MESSAGES_IN_PROCESS, StatDataCollectorType.MIN);
            this.statDataCollection.registerStatCounterCollector(MAX_MESSAGES_IN_PROCESS, StatDataCollectorType.MAX);
        }
    }
}

