/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanHost;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanLayer;
import org.mobicents.protocols.ss7.oam.common.jmx.MBeanType;
import org.mobicents.protocols.ss7.oam.common.jmxss7.Ss7Layer;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterDefImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.CounterDefSetImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.SourceValueCounterImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.SourceValueObjectImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.SourceValueSetImpl;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterDef;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterDefSet;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterMediator;
import org.mobicents.protocols.ss7.oam.common.statistics.api.CounterType;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueCounter;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueObject;
import org.mobicents.protocols.ss7.oam.common.statistics.api.SourceValueSet;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.SmscStatProviderJmxMBean;
import org.mobicents.smsc.server.bootstrap.Version;
import org.restcomm.commons.statistics.reporter.RestcommStatsReporter;

public class SmscStatProviderJmx
implements SmscStatProviderJmxMBean,
CounterMediator {
    protected final Logger logger;
    private final MBeanHost ss7Management;
    private final SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    private FastMap<String, CounterDefSet> lstCounters = new FastMap();
    protected static final String DEFAULT_STATISTICS_SERVER = "https://statistics.restcomm.com/rest/";
    private RestcommStatsReporter statsReporter = RestcommStatsReporter.getRestcommStatsReporter();
    private MetricRegistry metrics = RestcommStatsReporter.getMetricRegistry();
    private Counter counterMessages = this.metrics.counter("messages");

    public SmscStatProviderJmx(MBeanHost ss7Management) {
        this.ss7Management = ss7Management;
        this.logger = Logger.getLogger((String)(SmscStatProviderJmx.class.getCanonicalName() + "-" + this.getName()));
    }

    public void start() throws Exception {
        this.logger.info((Object)"SmscStatProviderJmx Starting ...");
        this.setupCounterList();
        this.ss7Management.registerMBean((MBeanLayer)Ss7Layer.SMSC_GW, (MBeanType)SmscManagementType.MANAGEMENT, this.getName(), (Object)this);
        String statisticsServer = Version.instance.getStatisticsServer();
        if (statisticsServer == null || !statisticsServer.contains("http")) {
            statisticsServer = DEFAULT_STATISTICS_SERVER;
        }
        this.statsReporter.setRemoteServer(statisticsServer);
        String projectName = System.getProperty("RestcommProjectName", Version.instance.getShortName());
        String projectType = System.getProperty("RestcommProjectType", Version.instance.getProjectType());
        String projectVersion = System.getProperty("RestcommProjectVersion", Version.instance.getProjectVersion());
        this.logger.info((Object)("Restcomm Stats starting: " + projectName + " " + projectType + " " + projectVersion + " " + statisticsServer));
        this.statsReporter.setProjectName(projectName);
        this.statsReporter.setProjectType(projectType);
        this.statsReporter.setVersion(projectVersion);
        this.statsReporter.start(86400L, TimeUnit.SECONDS);
        this.smscStatAggregator.setCounterMessages(this.counterMessages);
        this.logger.info((Object)"SmscStatProviderJmx Started ...");
    }

    public void stop() {
        this.logger.info((Object)"SmscStatProviderJmx Stopping ...");
        this.statsReporter.stop();
        this.logger.info((Object)"SmscStatProviderJmx Stopped ...");
    }

    public String getName() {
        return "SMSC";
    }

    private void setupCounterList() {
        FastMap lst = new FastMap();
        CounterDefSetImpl cds = new CounterDefSetImpl(this.getCounterMediatorName() + "-Main");
        lst.put((Object)cds.getName(), (Object)cds);
        CounterDefImpl cd = new CounterDefImpl(CounterType.Minimal, "MinMessagesInProcess", "A min count of messages that are in progress during a period");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Maximal, "MaxMessagesInProcess", "A max count of messages that are in progress during a period");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInReceivedAll", "Messages received and accepted via all interfaces");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInRejectedAll", "Messages received and rejected because of charging reject via all interfaces");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInFailedAll", "Messages received and failed to process via all interfaces");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInReceivedSs7", "Messages received and accepted via SS7 interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInReceivedSs7Mo", "Messages received and accepted via SS7 interface (mobile originated)");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInReceivedSs7Hr", "Messages received and accepted via SS7 interface (home routing)");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "HomeRoutingCorrIdFail", "Home routing failures because of absent correlationId");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "SmppSecondRateOverlimitFail", "Rejecting of incoming SMPP messages case because of exceeding of a rate limit per a second");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "SmppMinuteRateOverlimitFail", "Rejecting of incoming SMPP messages case because of exceeding of a rate limit per a minute");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "SmppHourRateOverlimitFail", "Rejecting of incoming SMPP messages case because of exceeding of a rate limit per a hour");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "SmppDayRateOverlimitFail", "Rejecting of incoming SMPP messages case because of exceeding of a rate limit per a day");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInReceivedSmpp", "Messages received and accepted via SMPP interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInReceivedSip", "Messages received and accepted via SIP interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MsgInReceivedAllCumulative", "Messages received and accepted via all interfaces cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInHrSriReq", "Home routing SRI messages received");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInHrSriPosReq", "Home routing SRI positive responses");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInHrSriHrByPass", "ByPass HomeRouting procedure after SRI to a local HLR");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgInHrSriNegReq", "Home routing SRI negative responses");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutTryAll", "Messages sending tries via all interfaces");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutSentAll", "Messages sent via all interfaces");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MsgOutTryAllCumulative", "Messages sending tries via all interfaces cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "MsgOutSentAllCumulative", "Messages sent via all interfaces cumulative");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutFailedAll", "Messages failed to send via all interfaces");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Average, "MsgOutTryAllPerSec", "Messages sending tries via all interfaces per second");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Average, "MsgOutSentAllPerSec", "Messages sent via all interfaces per second");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutTrySs7", "Messages sending tries via SS7 interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutSentSs7", "Messages sent via SS7 interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutTrySmpp", "Messages sending tries via SMPP interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutSentSmpp", "Messages sent via SMPP interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutTrySip", "Messages sending tries via SIP interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary, "MsgOutSentSip", "Messages sent via SIP interface");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Summary_Cumulative, "SmscDeliveringLag", "Lag of delivering messages by Smsc (in seconds)");
        cds.addCounterDef((CounterDef)cd);
        cd = new CounterDefImpl(CounterType.Maximal, "MsgPendingInDb", "Messages stored in database which are to be delivered yet");
        cds.addCounterDef((CounterDef)cd);
        this.lstCounters = lst;
    }

    public CounterDefSet getCounterDefSet(String counterDefSetName) {
        return (CounterDefSet)this.lstCounters.get((Object)counterDefSetName);
    }

    public String[] getCounterDefSetList() {
        String[] res = new String[this.lstCounters.size()];
        this.lstCounters.keySet().toArray(res);
        return res;
    }

    public String getCounterMediatorName() {
        return "SMSC GW-" + this.getName();
    }

    public SourceValueSet getSourceValueSet(String counterDefSetName, String campaignName, int durationInSeconds) {
        SourceValueSetImpl svs;
        if (durationInSeconds >= 60) {
            this.logger.info((Object)("getSourceValueSet() - starting - campaignName=" + campaignName));
        } else {
            this.logger.debug((Object)("getSourceValueSet() - starting - campaignName=" + campaignName));
        }
        long curTimeSeconds = new Date().getTime() / 1000L;
        try {
            String[] csl = this.getCounterDefSetList();
            if (!csl[0].equals(counterDefSetName)) {
                return null;
            }
            svs = new SourceValueSetImpl(this.smscStatAggregator.getSessionId());
            CounterDefSet cds = this.getCounterDefSet(counterDefSetName);
            for (CounterDef cd : cds.getCounterDefs()) {
                SourceValueCounterImpl scs = new SourceValueCounterImpl(cd);
                SourceValueObjectImpl svo = null;
                if (cd.getCounterName().equals("MsgInReceivedAll")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInReceivedAll());
                } else if (cd.getCounterName().equals("MsgInRejectedAll")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInRejectedAll());
                } else if (cd.getCounterName().equals("MsgInFailedAll")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInFailedAll());
                } else if (cd.getCounterName().equals("MsgInReceivedSs7")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInReceivedSs7());
                } else if (cd.getCounterName().equals("MsgInReceivedSs7Mo")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInReceivedSs7Mo());
                } else if (cd.getCounterName().equals("MsgInReceivedSs7Hr")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInReceivedSs7Hr());
                } else if (cd.getCounterName().equals("HomeRoutingCorrIdFail")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getHomeRoutingCorrIdFail());
                } else if (cd.getCounterName().equals("SmppSecondRateOverlimitFail")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getSmppSecondRateOverlimitFail());
                } else if (cd.getCounterName().equals("SmppMinuteRateOverlimitFail")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getSmppMinuteRateOverlimitFail());
                } else if (cd.getCounterName().equals("SmppHourRateOverlimitFail")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getSmppHourRateOverlimitFail());
                } else if (cd.getCounterName().equals("SmppDayRateOverlimitFail")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getSmppDayRateOverlimitFail());
                } else if (cd.getCounterName().equals("MsgInReceivedSmpp")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInReceivedSmpp());
                } else if (cd.getCounterName().equals("MsgInReceivedSip")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInReceivedSip());
                } else if (cd.getCounterName().equals("MsgInReceivedAllCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInReceivedAllCumulative());
                } else if (cd.getCounterName().equals("MsgInHrSriReq")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInHrSriReq());
                } else if (cd.getCounterName().equals("MsgInHrSriPosReq")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInHrSriPosReq());
                } else if (cd.getCounterName().equals("MsgInHrSriHrByPass")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInHrSriHrByPass());
                } else if (cd.getCounterName().equals("MsgInHrSriNegReq")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgInHrSriNegReq());
                } else if (cd.getCounterName().equals("MsgOutTryAll")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutTryAll());
                } else if (cd.getCounterName().equals("MsgOutSentAll")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutSentAll());
                } else if (cd.getCounterName().equals("MsgOutTryAllCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutTryAllCumulative());
                } else if (cd.getCounterName().equals("MsgOutSentAllCumulative")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutSentAllCumulative());
                } else if (cd.getCounterName().equals("MsgOutFailedAll")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutFailedAll());
                } else if (cd.getCounterName().equals("MsgOutTryAllPerSec")) {
                    long cnt = this.smscStatAggregator.getMsgOutTryAll();
                    svo = new SourceValueObjectImpl(this.getName(), 0L);
                    svo.setValueA((double)cnt);
                    svo.setValueB((double)curTimeSeconds);
                } else if (cd.getCounterName().equals("MsgOutSentAllPerSec")) {
                    long cnt = this.smscStatAggregator.getMsgOutSentAll();
                    svo = new SourceValueObjectImpl(this.getName(), 0L);
                    svo.setValueA((double)cnt);
                    svo.setValueB((double)curTimeSeconds);
                } else if (cd.getCounterName().equals("MsgOutTrySs7")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutTrySs7());
                } else if (cd.getCounterName().equals("MsgOutSentSs7")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutSentSs7());
                } else if (cd.getCounterName().equals("MsgOutTrySmpp")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutTrySmpp());
                } else if (cd.getCounterName().equals("MsgOutSentSmpp")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutSentSmpp());
                } else if (cd.getCounterName().equals("MsgOutTrySip")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutTrySip());
                } else if (cd.getCounterName().equals("MsgOutSentSip")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgOutSentSip());
                } else if (cd.getCounterName().equals("MinMessagesInProcess")) {
                    Long res = this.smscStatAggregator.getMinMessagesInProcess(campaignName);
                    if (res != null) {
                        svo = new SourceValueObjectImpl(this.getName(), res.longValue());
                    }
                } else if (cd.getCounterName().equals("MaxMessagesInProcess")) {
                    Long res = this.smscStatAggregator.getMaxMessagesInProcess(campaignName);
                    if (res != null) {
                        svo = new SourceValueObjectImpl(this.getName(), res.longValue());
                    }
                } else if (cd.getCounterName().equals("SmscDeliveringLag")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getSmscDeliveringLag());
                } else if (cd.getCounterName().equals("MsgPendingInDb")) {
                    svo = new SourceValueObjectImpl(this.getName(), this.smscStatAggregator.getMsgPendingInDbRes());
                }
                if (svo != null) {
                    scs.addObject((SourceValueObject)svo);
                }
                svs.addCounter((SourceValueCounter)scs);
            }
        }
        catch (Throwable e) {
            this.logger.info((Object)("Exception when getSourceValueSet() - campaignName=" + campaignName + " - " + e.getMessage()), e);
            return null;
        }
        if (durationInSeconds >= 60) {
            this.logger.info((Object)("getSourceValueSet() - return value - campaignName=" + campaignName));
        } else {
            this.logger.debug((Object)("getSourceValueSet() - return value - campaignName=" + campaignName));
        }
        return svs;
    }

    public static enum SmscManagementType implements MBeanType
    {
        MANAGEMENT("Management");

        private final String name;
        public static final String NAME_MANAGEMENT = "Management";

        private SmscManagementType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static SmscManagementType getInstance(String name) {
            if (NAME_MANAGEMENT.equals(name)) {
                return MANAGEMENT;
            }
            return null;
        }
    }
}

