/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javolution.text.TextBuilder;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.smsc.domain.CcMccmnc;
import org.mobicents.smsc.domain.CcMccmncCollection;
import org.mobicents.smsc.domain.CcMccmncImpl;
import org.mobicents.smsc.domain.HomeRoutingManagementMBean;
import org.mobicents.smsc.domain.NextCorrelationIdResult;

public class HomeRoutingManagement
implements HomeRoutingManagementMBean {
    private static final Logger logger = Logger.getLogger(HomeRoutingManagement.class);
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private static final XMLBinding binding = new XMLBinding();
    private static final String CC_MCCMNC_PERSIST_FILE_NAME = "cc_mccmnc.xml";
    private static final String CORR_ID_FILE_NAME = "corrid.xml";
    private static final String CC_MCCMNS_COLLECTION = "CcMccmncCollection";
    private static final String CC_CORR_ID = "CorrId";
    private static final long MAX_CORRELATION_ID = 10000000000L;
    private static final long CORR_ID_LAG = 1000L;
    private static HomeRoutingManagement instance;
    private final String name;
    private String persistDir = null;
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private final TextBuilder persistFileCorrId = TextBuilder.newInstance();
    private CcMccmncCollection ccMccmncCollection;
    private long correlationId = 0L;
    private long loadedCorrelationId = -1L;

    private HomeRoutingManagement(String name) {
        this.name = name;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
    }

    public static HomeRoutingManagement getInstance(String name) {
        if (instance == null) {
            instance = new HomeRoutingManagement(name);
        }
        return instance;
    }

    public static HomeRoutingManagement getInstance() {
        return instance;
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    @Override
    public synchronized NextCorrelationIdResult getNextCorrelationId(String msisdn) {
        String mccmnc;
        long corrId = this.doGetNextCorrelationId();
        CcMccmnc ccMccmncValue = this.getCcMccmncValue(msisdn);
        if (ccMccmncValue == null) {
            logger.warn((Object)("Found no entry in CcMccmncCollection for msisdn: " + msisdn));
            mccmnc = "";
        } else {
            mccmnc = ccMccmncValue.getMccMnc();
        }
        String corrIdS = String.valueOf(corrId);
        StringBuilder sb = new StringBuilder();
        int len = mccmnc.length() + corrIdS.length();
        if (len <= 15) {
            sb.append(mccmnc);
            for (int i1 = len; i1 < 15; ++i1) {
                sb.append("0");
            }
            sb.append(corrIdS);
        } else {
            sb.append(mccmnc);
            sb.append(corrIdS.substring(corrIdS.length() - (15 - mccmnc.length())));
        }
        NextCorrelationIdResult res = new NextCorrelationIdResult();
        res.setCorrelationId(sb.toString());
        if (ccMccmncValue != null) {
            res.setSmscAddress(ccMccmncValue.getSmsc());
        }
        return res;
    }

    @Override
    public void updateCcMccmncTable() {
        this.load();
    }

    protected synchronized long doGetNextCorrelationId() {
        ++this.correlationId;
        if (this.correlationId >= 10000000000L) {
            this.correlationId = 1L;
        }
        if (this.correlationId - this.loadedCorrelationId >= 1000L || this.correlationId < this.loadedCorrelationId || this.loadedCorrelationId < 0L) {
            this.storeCorrId();
        }
        return this.correlationId;
    }

    protected CcMccmnc getCcMccmncValue(String countryCode) {
        this.checkCcMccmncTable();
        return this.ccMccmncCollection.findMccmnc(countryCode);
    }

    protected void checkCcMccmncTable() {
    }

    @Override
    public void addCcMccmnc(String countryCode, String mccMnc, String smsc) throws Exception {
        CcMccmncImpl ccMccmnc = new CcMccmncImpl(countryCode, mccMnc, smsc);
        this.ccMccmncCollection.addCcMccmnc(ccMccmnc);
        this.store();
    }

    @Override
    public void modifyCcMccmnc(String countryCode, String mccMnc, String smsc) throws Exception {
        this.ccMccmncCollection.modifyCcMccmnc(countryCode, mccMnc, smsc);
        this.store();
    }

    @Override
    public void removeCcMccmnc(String countryCode) throws Exception {
        this.ccMccmncCollection.removeCcMccmnc(countryCode);
        this.store();
    }

    @Override
    public CcMccmnc getCcMccmnc(String countryCode) {
        return this.ccMccmncCollection.getCcMccmnc(countryCode);
    }

    @Override
    public Map<String, CcMccmncImpl> getCcMccmncMap() {
        return this.ccMccmncCollection.getCcMccmncMap();
    }

    public void start() throws Exception {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(CC_MCCMNC_PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(CC_MCCMNC_PERSIST_FILE_NAME);
        }
        this.persistFileCorrId.clear();
        if (this.persistDir != null) {
            this.persistFileCorrId.append(this.persistDir).append(File.separator).append(this.name).append("_").append(CORR_ID_FILE_NAME);
        } else {
            this.persistFileCorrId.append(System.getProperty("smsc.persist.dir", System.getProperty("user.dir"))).append(File.separator).append(this.name).append("_").append(CORR_ID_FILE_NAME);
        }
        logger.info((Object)String.format("Loading home routing properties from %s", this.persistFile.toString()));
        this.load();
        logger.info((Object)String.format("Loading home routing corrId from %s", this.persistFileCorrId.toString()));
        this.loadCorrId();
    }

    public void stop() throws Exception {
        if (this.loadedCorrelationId != -1L && this.correlationId != this.loadedCorrelationId) {
            this.storeCorrId();
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write((Object)this.ccMccmncCollection, CC_MCCMNS_COLLECTION, CcMccmncCollection.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the ccMccmncCollection in file", (Throwable)e);
        }
    }

    public void storeCorrId() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)new FileOutputStream(this.persistFileCorrId.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write((Object)this.correlationId, CC_CORR_ID, Long.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error((Object)"Error while persisting the home routing corrId value in file", (Throwable)e);
        }
        this.loadedCorrelationId = this.correlationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void load() {
        this.ccMccmncCollection = new CcMccmncCollection();
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFile.toString()));
            try {
                reader.setBinding(binding);
                this.ccMccmncCollection = (CcMccmncCollection)reader.read(CC_MCCMNS_COLLECTION, CcMccmncCollection.class);
                logger.info((Object)("Successfully loaded CcMccmnsCollection: " + this.persistFile));
            }
            finally {
                reader.close();
            }
        }
        catch (FileNotFoundException ex) {
            logger.warn((Object)("CcMccmnsCollection: file not found: " + this.persistFile.toString()));
            try {
                this.store();
            }
            catch (Exception exception) {}
        }
        catch (XMLStreamException ex) {
            logger.error((Object)("Error while loading CcMccmnsCollection from file" + this.persistFile.toString()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadCorrId() {
        XMLObjectReader reader = null;
        try {
            reader = XMLObjectReader.newInstance((InputStream)new FileInputStream(this.persistFileCorrId.toString()));
            try {
                reader.setBinding(binding);
                this.correlationId = (Long)reader.read(CC_CORR_ID, Long.class);
                this.correlationId += 1000L;
                this.loadedCorrelationId = -1L;
                logger.info((Object)("Successfully loaded home routing corrId: " + this.persistFile));
            }
            finally {
                reader.close();
            }
        }
        catch (FileNotFoundException ex) {
            logger.warn((Object)("home routing corrId value: file not found: " + this.persistFile.toString()));
            logger.warn((Object)("CcMccmnsCollection: file not found: " + this.persistFile.toString()));
            try {
                this.storeCorrId();
            }
            catch (Exception exception) {}
        }
        catch (XMLStreamException ex) {
            logger.error((Object)("Error while loading home routing corrId value from file" + this.persistFile.toString()), (Throwable)ex);
        }
    }
}

