/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.smsc.domain.SipMBean;
import org.mobicents.smsc.domain.SipManagement;

public class Sip
implements SipMBean {
    private static final String SIP_NAME = "name";
    private static final String SIP_CLUSTER_NAME = "clusterName";
    private static final String REMOTE_HOST_IP = "host";
    private static final String REMOTE_HOST_PORT = "port";
    private static final String NETWORK_ID = "networkId";
    private static final String ROUTING_TON = "routingTon";
    private static final String ROUTING_NPI = "routingNpi";
    private static final String ROUTING_ADDRESS_RANGE = "routingAddressRange";
    private static final String CHARGING_ENABLED = "chargingEnabled";
    private static final String COUNTERS_ENABLED = "countersEnabled";
    private static final String STARTED = "started";
    private String name;
    private String clusterName;
    private String host;
    private int port;
    private int networkId;
    private int routingTon = -1;
    private int routingNpi = -1;
    private String routingAddressRange;
    private Pattern routingAddressRangePattern;
    private boolean countersEnabled = true;
    private boolean chargingEnabled = false;
    private boolean isStarted = true;
    private String sipAddress = null;
    protected transient SipManagement sipManagement = null;
    protected static final XMLFormat<Sip> SIP_XML = new XMLFormat<Sip>(Sip.class){

        public void read(XMLFormat.InputElement xml, Sip sip) throws XMLStreamException {
            sip.name = xml.getAttribute(Sip.SIP_NAME, "");
            sip.clusterName = xml.getAttribute(Sip.SIP_CLUSTER_NAME, "");
            sip.host = xml.getAttribute(Sip.REMOTE_HOST_IP, "");
            sip.port = xml.getAttribute(Sip.REMOTE_HOST_PORT, -1);
            sip.networkId = xml.getAttribute(Sip.NETWORK_ID, 0);
            sip.resetSipAddress();
            sip.isStarted = xml.getAttribute(Sip.STARTED, false);
            sip.routingTon = xml.getAttribute(Sip.ROUTING_TON, -1);
            sip.routingNpi = xml.getAttribute(Sip.ROUTING_NPI, -1);
            sip.routingAddressRange = xml.getAttribute(Sip.ROUTING_ADDRESS_RANGE, null);
            sip.resetPattern();
            sip.countersEnabled = xml.getAttribute(Sip.COUNTERS_ENABLED, true);
            sip.chargingEnabled = xml.getAttribute(Sip.CHARGING_ENABLED, false);
        }

        public void write(Sip sip, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(Sip.SIP_NAME, sip.name);
            xml.setAttribute(Sip.SIP_CLUSTER_NAME, sip.clusterName);
            xml.setAttribute(Sip.REMOTE_HOST_IP, sip.host);
            xml.setAttribute(Sip.REMOTE_HOST_PORT, sip.port);
            xml.setAttribute(Sip.NETWORK_ID, sip.networkId);
            xml.setAttribute(Sip.STARTED, sip.isStarted);
            xml.setAttribute(Sip.ROUTING_TON, sip.routingTon);
            xml.setAttribute(Sip.ROUTING_NPI, sip.routingNpi);
            xml.setAttribute(Sip.ROUTING_ADDRESS_RANGE, sip.routingAddressRange);
            xml.setAttribute(Sip.COUNTERS_ENABLED, sip.countersEnabled);
            xml.setAttribute(Sip.CHARGING_ENABLED, sip.chargingEnabled);
        }
    };

    public Sip() {
    }

    public Sip(String name, String clusterName, String host, int port, boolean chargingEnabled, byte addressTon, byte addressNpi, String addressRange, boolean countersEnabled, int networkId) {
        this.name = name;
        this.clusterName = clusterName;
        this.host = host;
        this.port = port;
        this.resetSipAddress();
        this.chargingEnabled = chargingEnabled;
        this.countersEnabled = countersEnabled;
        this.routingTon = addressTon;
        this.routingNpi = addressNpi;
        this.routingAddressRange = addressRange;
        this.networkId = networkId;
        this.resetPattern();
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
        this.store();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
        this.resetSipAddress();
        this.store();
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
        this.resetSipAddress();
        this.store();
    }

    @Override
    public int getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(int networkId) {
        this.networkId = networkId;
        this.store();
    }

    @Override
    public int getRoutingNpi() {
        return this.routingNpi;
    }

    @Override
    public int getRoutingTon() {
        return this.routingTon;
    }

    @Override
    public String getRoutingAddressRange() {
        return this.routingAddressRange;
    }

    @Override
    public void setRoutingNpi(int npi) {
        this.routingNpi = npi;
        this.store();
    }

    @Override
    public void setRoutingTon(int ton) {
        this.routingTon = ton;
        this.store();
    }

    @Override
    public void setRoutingAddressRange(String range) {
        this.routingAddressRange = range;
        this.resetPattern();
        this.store();
    }

    @Override
    public boolean isCountersEnabled() {
        return this.countersEnabled;
    }

    @Override
    public void setCountersEnabled(boolean countersEnabled) {
        this.countersEnabled = countersEnabled;
    }

    @Override
    public boolean isChargingEnabled() {
        return this.chargingEnabled;
    }

    @Override
    public void setChargingEnabled(boolean chargingEnabled) {
        this.chargingEnabled = chargingEnabled;
    }

    public String getSipAddress() {
        return this.sipAddress;
    }

    protected boolean isRoutingAddressMatching(int destTon, int destNpi, String destAddress) {
        if (this.routingTon != -1 && this.routingTon != destTon) {
            return false;
        }
        if (this.routingNpi != -1 && this.routingNpi != destNpi) {
            return false;
        }
        if (this.routingAddressRangePattern == null) {
            return false;
        }
        Matcher m = this.routingAddressRangePattern.matcher(destAddress);
        return m.matches();
    }

    public void show(StringBuffer sb) {
        sb.append("SIP name=").append(this.name).append(" clusterName=").append(this.clusterName).append(" host=").append(this.host).append(" port=").append(this.port).append(" networkId=").append(this.networkId).append(" started=").append(this.isStarted).append(" routingTon=").append(this.routingTon).append(" routingNpi=").append(this.routingNpi).append(" routingAddress=").append(this.routingAddressRange).append(" countersEnabled").append(this.countersEnabled).append(" chargingEnabled=").append(this.chargingEnabled);
        sb.append("\n");
    }

    private void resetSipAddress() {
        this.sipAddress = this.host + ":" + this.port;
    }

    private void resetPattern() {
        if (this.routingAddressRange != null) {
            this.routingAddressRangePattern = Pattern.compile(this.routingAddressRange);
        }
    }

    private void store() {
        this.sipManagement.store();
    }
}

