/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.domain;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javolution.text.TextBuilder;
import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.mobicents.smsc.cassandra.DBOperations;
import org.mobicents.smsc.domain.ArchiveSms;
import org.mobicents.smsc.domain.ArchiveSmsMBean;
import org.mobicents.smsc.domain.DatabaseSmsRoutingRule;
import org.mobicents.smsc.domain.DatabaseSmsRoutingRuleMBean;
import org.mobicents.smsc.domain.DefaultSmsRoutingRule;
import org.mobicents.smsc.domain.HomeRoutingManagement;
import org.mobicents.smsc.domain.HomeRoutingManagementMBean;
import org.mobicents.smsc.domain.HttpUsersManagement;
import org.mobicents.smsc.domain.HttpUsersManagementMBean;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.MProcManagementMBean;
import org.mobicents.smsc.domain.MapVersionCache;
import org.mobicents.smsc.domain.MapVersionCacheMBean;
import org.mobicents.smsc.domain.SipManagement;
import org.mobicents.smsc.domain.SipManagementMBean;
import org.mobicents.smsc.domain.SmsRouteManagement;
import org.mobicents.smsc.domain.SmsRoutingRule;
import org.mobicents.smsc.domain.SmscDatabaseManagement;
import org.mobicents.smsc.domain.SmscManagementMBean;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagementMBean;
import org.mobicents.smsc.domain.SmscStatProvider;
import org.mobicents.smsc.domain.SmscStatProviderMBean;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.mproc.MProcRuleFactory;
import org.restcomm.smpp.SmppManagement;

public class SmscManagement
implements SmscManagementMBean {
    private static final Logger logger = Logger.getLogger(SmscManagement.class);
    public static final String JMX_DOMAIN = "org.mobicents.smsc";
    public static final String JMX_LAYER_SMSC_MANAGEMENT = "SmscManagement";
    public static final String JMX_LAYER_SIP_MANAGEMENT = "SipManagement";
    public static final String JMX_LAYER_MPROC_MANAGEMENT = "MProcManagement";
    public static final String JMX_LAYER_ARCHIVE_SMS = "ArchiveSms";
    public static final String JMX_LAYER_MAP_VERSION_CACHE = "MapVersionCache";
    public static final String JMX_LAYER_SMSC_STATS = "SmscStats";
    public static final String JMX_LAYER_SMSC_PROPERTIES_MANAGEMENT = "SmscPropertiesManagement";
    public static final String JMX_LAYER_SMSC_DATABASE_MANAGEMENT = "SmscDatabaseManagement";
    public static final String JMX_LAYER_HOME_ROUTING_MANAGEMENT = "HomeRoutingManagement";
    public static final String JMX_LAYER_HTTPUSER_MANAGEMENT = "HttpUserManagement";
    public static final String JMX_LAYER_DATABASE_SMS_ROUTING_RULE = "DatabaseSmsRoutingRule";
    public static final String SMSC_PERSIST_DIR_KEY = "smsc.persist.dir";
    public static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "smsc.xml";
    private final TextBuilder persistFile = TextBuilder.newInstance();
    private final String name;
    private String persistDir = null;
    private SmppManagement smppManagement;
    private SipManagement sipManagement = null;
    private MProcManagement mProcManagement = null;
    private SmscPropertiesManagement smscPropertiesManagement = null;
    private HomeRoutingManagement homeRoutingManagement = null;
    private HttpUsersManagement httpUsersManagement = null;
    private SmscDatabaseManagement smscDatabaseManagement = null;
    private ArchiveSms archiveSms;
    private MapVersionCache mapVersionCache;
    private MBeanServer mbeanServer = null;
    private String smsRoutingRuleClass;
    private boolean isStarted = false;
    private static SmscManagement instance = null;
    private static SmscStatProvider smscStatProvider = null;
    private SmsRoutingRule smsRoutingRule = null;
    private FastList<MProcRuleFactory> mprocFactories = new FastList();

    private SmscManagement(String name) {
        this.name = name;
    }

    public static SmscManagement getInstance(String name) {
        if (instance == null) {
            instance = new SmscManagement(name);
        }
        return instance;
    }

    public static SmscManagement getInstance() {
        return instance;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPersistDir() {
        return this.persistDir;
    }

    @Override
    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public SmppManagement getSmppManagement() {
        return this.smppManagement;
    }

    public void setSmppManagement(SmppManagement smppManagement) {
        this.smppManagement = smppManagement;
    }

    public SmsRoutingRule getSmsRoutingRule() {
        return this.smsRoutingRule;
    }

    public ArchiveSms getArchiveSms() {
        return this.archiveSms;
    }

    public String getSmsRoutingRuleClass() {
        return this.smsRoutingRuleClass;
    }

    public void setSmsRoutingRuleClass(String smsRoutingRuleClass) {
        this.smsRoutingRuleClass = smsRoutingRuleClass;
    }

    public List getMProcRuleFactories() {
        return this.mprocFactories;
    }

    public List<MProcRuleFactory> getMProcRuleFactories2() {
        return this.mprocFactories;
    }

    public void setMProcRuleFactories(List ruleFactories) {
        this.mprocFactories = new FastList();
        for (Object obj : ruleFactories) {
            if (obj == null || !(obj instanceof MProcRuleFactory)) continue;
            MProcRuleFactory ruleFactory = (MProcRuleFactory)obj;
            this.mprocFactories.add((Object)ruleFactory);
            if (this.mProcManagement == null) continue;
            this.mProcManagement.bindAlias(ruleFactory);
        }
    }

    public void registerRuleFactory(MProcRuleFactory ruleFactory) {
        this.mprocFactories.add((Object)ruleFactory);
        if (this.mProcManagement != null) {
            this.mProcManagement.bindAlias(ruleFactory);
        }
    }

    public void deregisterRuleFactory(String ruleFactoryName) {
        for (MProcRuleFactory rc : this.mprocFactories) {
            if (!ruleFactoryName.equals(rc.getRuleClassName())) continue;
            this.mprocFactories.remove((Object)rc);
            return;
        }
    }

    public MProcRuleFactory getRuleFactory(String ruleFactoryName) {
        MProcRuleFactory ruleClass = null;
        for (MProcRuleFactory rc : this.mprocFactories) {
            if (!ruleFactoryName.equals(rc.getRuleClassName())) continue;
            ruleClass = rc;
            break;
        }
        return ruleClass;
    }

    public void start() throws Exception {
        logger.warn((Object)("Starting SmscManagemet " + this.name));
        SmscStatProvider.getInstance().setSmscStartTime(new Date());
        SmsSetCache.getInstance().clearProcessingSmsSet();
        try {
            this.mbeanServer = MBeanServerLocator.locateJBoss();
        }
        catch (Exception e) {
            logger.error((Object)("Exception when obtaining of MBeanServer: " + e.getMessage()), (Throwable)e);
        }
        this.smscPropertiesManagement = SmscPropertiesManagement.getInstance(this.name);
        this.smscPropertiesManagement.setPersistDir(this.persistDir);
        this.smscPropertiesManagement.start();
        ObjectName smscObjNname = new ObjectName("org.mobicents.smsc:layer=SmscPropertiesManagement,name=" + this.getName());
        this.registerMBean(this.smscPropertiesManagement, SmscPropertiesManagementMBean.class, true, smscObjNname);
        this.homeRoutingManagement = HomeRoutingManagement.getInstance(this.name);
        this.homeRoutingManagement.setPersistDir(this.persistDir);
        this.homeRoutingManagement.start();
        ObjectName hrObjNname = new ObjectName("org.mobicents.smsc:layer=HomeRoutingManagement,name=" + this.getName());
        this.registerMBean(this.homeRoutingManagement, HomeRoutingManagementMBean.class, true, hrObjNname);
        this.httpUsersManagement = HttpUsersManagement.getInstance(this.name);
        this.httpUsersManagement.setPersistDir(this.persistDir);
        this.httpUsersManagement.start();
        ObjectName httpUsersObjNname = new ObjectName("org.mobicents.smsc:layer=HttpUserManagement,name=" + this.getName());
        this.registerMBean(this.httpUsersManagement, HttpUsersManagementMBean.class, true, httpUsersObjNname);
        String hosts = this.smscPropertiesManagement.getDbHosts();
        int port = this.smscPropertiesManagement.getDbPort();
        DBOperations.getInstance().start(hosts, port, this.smscPropertiesManagement.getKeyspaceName(), this.smscPropertiesManagement.getCassandraUser(), this.smscPropertiesManagement.getCassandraPass(), this.smscPropertiesManagement.getFirstDueDelay(), this.smscPropertiesManagement.getReviseSecondsOnSmscStart(), this.smscPropertiesManagement.getProcessingSmsSetTimeout(), this.smscPropertiesManagement.getMinMessageId(), this.smscPropertiesManagement.getMaxMessageId());
        SmsSetCache.start((int)this.smscPropertiesManagement.getCorrelationIdLiveTime(), (int)this.smscPropertiesManagement.getSriResponseLiveTime(), (int)30);
        this.archiveSms = ArchiveSms.getInstance(this.name);
        this.archiveSms.start();
        ObjectName arhiveObjNname = new ObjectName("org.mobicents.smsc:layer=ArchiveSms,name=" + this.getName());
        this.registerMBean(this.archiveSms, ArchiveSmsMBean.class, false, arhiveObjNname);
        this.mapVersionCache = MapVersionCache.getInstance(this.name);
        ObjectName mapVersionCacheObjNname = new ObjectName("org.mobicents.smsc:layer=MapVersionCache,name=" + this.getName());
        this.registerMBean(this.mapVersionCache, MapVersionCacheMBean.class, false, mapVersionCacheObjNname);
        smscStatProvider = SmscStatProvider.getInstance();
        ObjectName smscStatProviderObjNname = new ObjectName("org.mobicents.smsc:layer=SmscStats,name=" + this.getName());
        this.registerMBean(smscStatProvider, SmscStatProviderMBean.class, false, smscStatProviderObjNname);
        this.sipManagement = SipManagement.getInstance(this.name);
        this.sipManagement.setPersistDir(this.persistDir);
        this.sipManagement.start();
        ObjectName sipObjNname = new ObjectName("org.mobicents.smsc:layer=SipManagement,name=" + this.getName());
        this.registerMBean(this.sipManagement, SipManagementMBean.class, false, sipObjNname);
        this.mProcManagement = MProcManagement.getInstance(this.name);
        this.mProcManagement.setPersistDir(this.persistDir);
        this.mProcManagement.setSmscManagement(this);
        this.mProcManagement.start();
        ObjectName mProcObjNname = new ObjectName("org.mobicents.smsc:layer=MProcManagement,name=" + this.getName());
        this.registerMBean(this.mProcManagement, MProcManagementMBean.class, false, mProcObjNname);
        if (this.smsRoutingRuleClass != null) {
            this.smsRoutingRule = (SmsRoutingRule)Class.forName(this.smsRoutingRuleClass).newInstance();
            if (this.smsRoutingRule instanceof DatabaseSmsRoutingRule) {
                ObjectName dbSmsRoutingRuleObjName = new ObjectName("org.mobicents.smsc:layer=DatabaseSmsRoutingRule,name=" + this.getName());
                this.registerMBean((DatabaseSmsRoutingRule)this.smsRoutingRule, DatabaseSmsRoutingRuleMBean.class, true, dbSmsRoutingRuleObjName);
            }
        } else {
            this.smsRoutingRule = new DefaultSmsRoutingRule();
        }
        this.smsRoutingRule.setEsmeManagement(this.smppManagement.getEsmeManagement());
        this.smsRoutingRule.setSipManagement(this.sipManagement);
        this.smsRoutingRule.setSmscPropertiesManagement(this.smscPropertiesManagement);
        SmsRouteManagement.getInstance().setSmsRoutingRule(this.smsRoutingRule);
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(SMSC_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info((Object)String.format("SMSC configuration file path %s", this.persistFile.toString()));
        try {
            this.load();
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
        logger.warn((Object)("Started SmscManagemet " + this.name));
        this.smscDatabaseManagement = SmscDatabaseManagement.getInstance(this.name);
        this.smscDatabaseManagement.start();
        ObjectName smscDatabaseManagementObjName = new ObjectName("org.mobicents.smsc:layer=SmscDatabaseManagement,name=" + this.getName());
        this.registerMBean(this.smscDatabaseManagement, SmscDatabaseManagement.class, true, smscDatabaseManagementObjName);
    }

    public void stop() throws Exception {
        logger.info((Object)("Stopping SmscManagemet " + this.name));
        this.smscPropertiesManagement.stop();
        ObjectName smscObjNname = new ObjectName("org.mobicents.smsc:layer=SmscPropertiesManagement,name=" + this.getName());
        this.unregisterMbean(smscObjNname);
        this.homeRoutingManagement.stop();
        ObjectName hrObjNname = new ObjectName("org.mobicents.smsc:layer=HomeRoutingManagement,name=" + this.getName());
        this.unregisterMbean(hrObjNname);
        this.httpUsersManagement.stop();
        ObjectName httpUsersObjNname = new ObjectName("org.mobicents.smsc:layer=HttpUserManagement,name=" + this.getName());
        this.unregisterMbean(httpUsersObjNname);
        DBOperations.getInstance().stop();
        this.archiveSms.stop();
        ObjectName arhiveObjNname = new ObjectName("org.mobicents.smsc:layer=ArchiveSms,name=" + this.getName());
        this.unregisterMbean(arhiveObjNname);
        ObjectName mapVersionCacheObjNname = new ObjectName("org.mobicents.smsc:layer=MapVersionCache,name=" + this.getName());
        this.unregisterMbean(mapVersionCacheObjNname);
        ObjectName smscStatProviderObjNname = new ObjectName("org.mobicents.smsc:layer=SmscStats,name=" + this.getName());
        this.unregisterMbean(smscStatProviderObjNname);
        if (this.smsRoutingRule instanceof DatabaseSmsRoutingRule) {
            ObjectName dbSmsRoutingRuleObjName = new ObjectName("org.mobicents.smsc:layer=DatabaseSmsRoutingRule,name=" + this.getName());
            this.unregisterMbean(dbSmsRoutingRuleObjName);
        }
        this.mProcManagement.stop();
        ObjectName mProcObjNname = new ObjectName("org.mobicents.smsc:layer=MProcManagement,name=" + this.getName());
        this.unregisterMbean(mProcObjNname);
        this.sipManagement.stop();
        ObjectName sipObjNname = new ObjectName("org.mobicents.smsc:layer=SipManagement,name=" + this.getName());
        this.unregisterMbean(sipObjNname);
        this.smscDatabaseManagement.stop();
        ObjectName smscDatabaseManagementObjName = new ObjectName("org.mobicents.smsc:layer=SmscDatabaseManagement,name=" + this.getName());
        this.unregisterMbean(smscDatabaseManagementObjName);
        SmsSetCache.stop();
        this.isStarted = false;
        this.store();
        logger.info((Object)("Stopped SmscManagemet " + this.name));
    }

    public void store() {
    }

    public void load() throws FileNotFoundException {
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    protected <T> void registerMBean(T implementation, Class<T> mbeanInterface, boolean isMXBean, ObjectName name) {
        try {
            if (this.mbeanServer != null) {
                this.mbeanServer.registerMBean(implementation, name);
            }
        }
        catch (InstanceAlreadyExistsException e) {
            logger.error((Object)String.format("Error while registering MBean %s", mbeanInterface.getName()), (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while registering MBean %s", mbeanInterface.getName()), (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            logger.error((Object)String.format("Error while registering MBean %s", mbeanInterface.getName()), (Throwable)e);
        }
    }

    protected void unregisterMbean(ObjectName name) {
        try {
            if (this.mbeanServer != null) {
                this.mbeanServer.unregisterMBean(name);
            }
        }
        catch (MBeanRegistrationException e) {
            logger.error((Object)String.format("Error while unregistering MBean %s", name), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)String.format("Error while unregistering MBean %s", name), (Throwable)e);
        }
    }
}

