/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.hr;

import javax.slee.ActivityContextInterface;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriber;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MWStatus;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.slee.resource.map.events.DialogClose;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogNotice;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogRequest;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.RejectComponent;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.library.CorrelationIdValue;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.slee.services.hr.HomeRoutingCommonSbb;
import org.mobicents.smsc.slee.services.hr.HrSriClientSbbLocalObject;
import org.mobicents.smsc.slee.services.hr.HrSriForwardInterface;
import org.mobicents.smsc.slee.services.hr.HrSriResultInterface;

public abstract class HrSriClientSbb
extends HomeRoutingCommonSbb
implements HrSriForwardInterface {
    protected MAPApplicationContextVersion maxMAPApplicationContextVersion = null;
    private static final String className = HrSriClientSbb.class.getSimpleName();

    public HrSriClientSbb() {
        super(className);
    }

    @Override
    public void onDialogRequest(DialogRequest evt, ActivityContextInterface aci) {
        super.onDialogRequest(evt, aci);
    }

    @Override
    public void onDialogDelimiter(DialogDelimiter evt, ActivityContextInterface aci) {
        super.onDialogDelimiter(evt, aci);
        try {
            this.onSriFullResponse();
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogDelimiter (home routing) when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogClose(DialogClose evt, ActivityContextInterface aci) {
        try {
            super.onDialogClose(evt, aci);
            this.onSriFullResponse();
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogClose (home routing) when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        super.onRejectComponent(event, aci);
        String reason = this.getRejectComponentReason(event);
        CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
        if (correlationIdValue == null) {
            this.logger.severe("CorrelationIdValue CMP missed");
            return;
        }
        this.returnSriFailure(correlationIdValue, null, "Home routing: onRejectComponent after SRI Request: " + reason != null ? reason.toString() : "");
    }

    @Override
    public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
        super.onDialogReject(evt, aci);
        try {
            MAPRefuseReason mapRefuseReason = evt.getRefuseReason();
            CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
            if (correlationIdValue == null) {
                this.logger.severe("CorrelationIdValue CMP missed");
                return;
            }
            if (mapRefuseReason == MAPRefuseReason.PotentialVersionIncompatibility && evt.getMAPDialog().getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1) {
                if (this.logger.isWarningEnabled()) {
                    this.logger.warning("Rx : Sri (home routing) onDialogReject / PotentialVersionIncompatibility=" + evt);
                }
                this.sendSRI(correlationIdValue.getMsisdn().getAddress(), correlationIdValue.getMsisdn().getAddressNature().getIndicator(), correlationIdValue.getMsisdn().getNumberingPlan().getIndicator(), this.getSRIMAPApplicationContext(MAPApplicationContextVersion.version1), correlationIdValue);
                return;
            }
            if (mapRefuseReason == MAPRefuseReason.ApplicationContextNotSupported) {
                if (this.logger.isWarningEnabled()) {
                    this.logger.warning("Rx : Sri (home routing) onDialogReject / ApplicationContextNotSupported=" + evt);
                }
                ApplicationContextName tcapApplicationContextName = evt.getAlternativeApplicationContext();
                MAPApplicationContext supportedMAPApplicationContext = MAPApplicationContext.getInstance((long[])tcapApplicationContextName.getOid());
                this.sendSRI(correlationIdValue.getMsisdn().getAddress(), correlationIdValue.getMsisdn().getAddressNature().getIndicator(), correlationIdValue.getMsisdn().getNumberingPlan().getIndicator(), this.getSRIMAPApplicationContext(supportedMAPApplicationContext.getApplicationContextVersion()), correlationIdValue);
                return;
            }
            this.returnSriFailure(correlationIdValue, null, "Home routing: onDialogReject after SRI Request: " + mapRefuseReason != null ? mapRefuseReason.toString() : "");
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogReject() (home routing) when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogUserAbort(DialogUserAbort evt, ActivityContextInterface aci) {
        try {
            super.onDialogUserAbort(evt, aci);
            String reason = this.getUserAbortReason(evt);
            CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
            if (correlationIdValue == null) {
                this.logger.severe("CorrelationIdValue CMP missed");
                return;
            }
            this.returnSriFailure(correlationIdValue, null, "(home routing) onDialogUserAbort after SRI Request: " + reason != null ? reason.toString() : "");
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogUserAbort() (home routing) when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogProviderAbort(DialogProviderAbort evt, ActivityContextInterface aci) {
        try {
            super.onDialogProviderAbort(evt, aci);
            MAPAbortProviderReason abortProviderReason = evt.getAbortProviderReason();
            CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
            if (correlationIdValue == null) {
                this.logger.severe("CorrelationIdValue CMP missed");
                return;
            }
            this.returnSriFailure(correlationIdValue, null, "(home routing) onDialogProviderAbort after SRI Request: " + abortProviderReason != null ? abortProviderReason.toString() : "");
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogProviderAbort() (home routing) when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogNotice(DialogNotice evt, ActivityContextInterface aci) {
        super.onDialogNotice(evt, aci);
    }

    @Override
    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        try {
            super.onDialogTimeout(evt, aci);
            CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
            if (correlationIdValue == null) {
                this.logger.severe("CorrelationIdValue CMP missed");
                return;
            }
            this.returnSriFailure(correlationIdValue, null, "(home routing) onDialogTimeout after SRI Request");
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogTimeout() (home routing) when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest evt, ActivityContextInterface aci) {
        this.logger.severe("Received SEND_ROUTING_INFO_FOR_SM_REQUEST = " + evt);
    }

    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived SEND_ROUTING_INFO_FOR_SM_RESPONSE = " + evt + " Dialog=" + evt.getMAPDialog());
        }
        if (evt.getMAPDialog().getApplicationContext().getApplicationContextVersion() == MAPApplicationContextVersion.version1 && evt.getMwdSet() != null && evt.getMwdSet().booleanValue()) {
            MWStatus mwStatus = evt.getMAPDialog().getService().getMAPProvider().getMAPParameterFactory().createMWStatus(false, true, false, false);
            CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
            if (correlationIdValue != null) {
                correlationIdValue.setMwStatus(mwStatus);
                correlationIdValue.setSriMapVersion(evt.getMAPDialog().getApplicationContext().getApplicationContextVersion().getVersion());
                this.setCorrelationIdValue(correlationIdValue);
            }
        }
        this.setSendRoutingInfoForSMResponse(evt);
    }

    public void onInformServiceCentreRequest(InformServiceCentreRequest evt, ActivityContextInterface aci) {
        CorrelationIdValue correlationIdValue;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\nReceived INFORM_SERVICE_CENTER_REQUEST = " + evt + " Dialog=" + evt.getMAPDialog());
        }
        if ((correlationIdValue = this.getCorrelationIdValue()) != null) {
            correlationIdValue.setMwStatus(evt.getMwStatus());
            correlationIdValue.setInformServiceCentreRequest(evt);
            this.setCorrelationIdValue(correlationIdValue);
        }
    }

    @Override
    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        super.onErrorComponent(event, aci);
        try {
            MAPErrorMessageAbsentSubscriber errAs;
            Boolean mwdSet;
            MAPErrorMessage mapErrorMessage = event.getMAPErrorMessage();
            this.setErrorResponse(mapErrorMessage);
            if (mapErrorMessage.isEmAbsentSubscriber() && (mwdSet = (errAs = mapErrorMessage.getEmAbsentSubscriber()).getMwdSet()) != null && mwdSet.booleanValue()) {
                MWStatus mwStatus = event.getMAPDialog().getService().getMAPProvider().getMAPParameterFactory().createMWStatus(false, true, false, false);
                CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
                if (correlationIdValue != null) {
                    correlationIdValue.setMwStatus(mwStatus);
                    this.setCorrelationIdValue(correlationIdValue);
                }
            }
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onErrorComponent when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    public abstract void setCorrelationIdValue(CorrelationIdValue var1);

    public abstract CorrelationIdValue getCorrelationIdValue();

    public abstract void setSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse var1);

    public abstract SendRoutingInfoForSMResponse getSendRoutingInfoForSMResponse();

    public abstract void setErrorResponse(MAPErrorMessage var1);

    public abstract MAPErrorMessage getErrorResponse();

    public abstract void setSriMapVersion(int var1);

    public abstract int getSriMapVersion();

    public abstract void setInProcess(int var1);

    public abstract int getInProcess();

    @Override
    public void setSbbContext(SbbContext sbbContext) {
        super.setSbbContext(sbbContext);
        this.maxMAPApplicationContextVersion = MAPApplicationContextVersion.getInstance((long)smscPropertiesManagement.getMaxMapVersion());
    }

    @Override
    public void setupSriRequest(CorrelationIdValue correlationIdValue) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived SriRequest: event= " + correlationIdValue);
        }
        this.setCorrelationIdValue(correlationIdValue);
        this.setInProcess(1);
        this.sendSRI(correlationIdValue.getMsisdn().getAddress(), correlationIdValue.getMsisdn().getAddressNature().getIndicator(), correlationIdValue.getMsisdn().getNumberingPlan().getIndicator(), this.getSRIMAPApplicationContext(this.maxMAPApplicationContextVersion), correlationIdValue);
    }

    private void sendSRI(String destinationAddress, int ton, int npi, MAPApplicationContext mapApplicationContext, CorrelationIdValue correlationIdValue) {
        MAPDialogSms mapDialogSms = null;
        try {
            mapDialogSms = this.setupRoutingInfoForSMRequestIndication(destinationAddress, ton, npi, mapApplicationContext, correlationIdValue.getNetworkId());
            ActivityContextInterface sriDialogACI = this.mapAcif.getActivityContextInterface((MAPDialog)mapDialogSms);
            sriDialogACI.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            mapDialogSms.send();
        }
        catch (MAPException e) {
            if (mapDialogSms != null) {
                mapDialogSms.release();
            }
            String reason = "MAPException when sending SRI from sendSRI() (home routing): " + e.toString();
            this.logger.severe(reason, (Throwable)e);
            this.returnSriFailure(correlationIdValue, null, reason);
        }
    }

    private MAPDialogSms setupRoutingInfoForSMRequestIndication(String destinationAddress, int ton, int npi, MAPApplicationContext mapApplicationContext, int networkId) throws MAPException {
        String hlrAddress = destinationAddress;
        String hrHlrNumber = smscPropertiesManagement.getHrHlrNumber(networkId);
        if (hrHlrNumber != null && hrHlrNumber.length() > 0) {
            hlrAddress = hrHlrNumber;
        }
        SccpAddress destinationAddr = this.convertAddressFieldToSCCPAddress(hlrAddress, ton, npi);
        MAPDialogSms mapDialogSms = this.mapProvider.getMAPServiceSms().createNewDialog(mapApplicationContext, this.getServiceCenterSccpAddress(networkId), null, destinationAddr, null);
        mapDialogSms.setNetworkId(networkId);
        ISDNAddressString isdn = this.getCalledPartyISDNAddressString(destinationAddress, ton, npi);
        AddressString serviceCenterAddress = this.getServiceCenterAddressString(networkId);
        boolean sm_RP_PRI = true;
        mapDialogSms.addSendRoutingInfoForSMRequest(isdn, sm_RP_PRI, serviceCenterAddress, null, false, null, null, null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\nSending: SendRoutingInfoForSMRequest (home routing): isdn=" + isdn + ", serviceCenterAddress=" + serviceCenterAddress + ", sm_RP_PRI=" + sm_RP_PRI);
        }
        return mapDialogSms;
    }

    private void onSriFullResponse() {
        SendRoutingInfoForSMResponse sendRoutingInfoForSMResponse = this.getSendRoutingInfoForSMResponse();
        MAPErrorMessage errorMessage = this.getErrorResponse();
        CorrelationIdValue correlationIdValue = this.getCorrelationIdValue();
        if (correlationIdValue == null) {
            this.logger.severe("CorrelationIdValue CMP missed");
            return;
        }
        if (sendRoutingInfoForSMResponse != null) {
            correlationIdValue.setImsi(sendRoutingInfoForSMResponse.getIMSI().getData());
            correlationIdValue.setLocationInfoWithLMSI(sendRoutingInfoForSMResponse.getLocationInfoWithLMSI());
            correlationIdValue.setSendRoutingInfoForSMResponse(sendRoutingInfoForSMResponse);
            MProcResult mProcResult = MProcManagement.getInstance().applyMProcHrSri(correlationIdValue);
            if (mProcResult.isHrIsByPassed()) {
                this.returnSriHrByPass(correlationIdValue);
            } else {
                this.returnSriSuccess(correlationIdValue);
            }
            return;
        }
        if (errorMessage != null) {
            this.returnSriFailure(correlationIdValue, errorMessage, "MAP ErrorMessage received: " + errorMessage);
        } else {
            this.returnSriFailure(correlationIdValue, null, "Empty response after SRI Request");
        }
    }

    private void returnSriSuccess(CorrelationIdValue correlationIdValue) {
        int inProcess = this.getInProcess();
        if (inProcess == 0) {
            return;
        }
        HrSriClientSbbLocalObject local = (HrSriClientSbbLocalObject)this.sbbContext.getSbbLocalObject();
        HrSriResultInterface parent = (HrSriResultInterface)local.getParent();
        parent.onSriSuccess(correlationIdValue, false);
    }

    private void returnSriHrByPass(CorrelationIdValue correlationIdValue) {
        int inProcess = this.getInProcess();
        if (inProcess == 0) {
            return;
        }
        HrSriClientSbbLocalObject local = (HrSriClientSbbLocalObject)this.sbbContext.getSbbLocalObject();
        HrSriResultInterface parent = (HrSriResultInterface)local.getParent();
        parent.onSriHrByPass(correlationIdValue);
    }

    private void returnSriFailure(CorrelationIdValue correlationIdValue, MAPErrorMessage errorResponse, String cause) {
        int inProcess = this.getInProcess();
        if (inProcess == 0) {
            return;
        }
        this.setInProcess(0);
        HrSriClientSbbLocalObject local = (HrSriClientSbbLocalObject)this.sbbContext.getSbbLocalObject();
        HrSriResultInterface parent = (HrSriResultInterface)local.getParent();
        parent.onSriFailure(correlationIdValue, errorResponse, cause);
    }

    private SccpAddress convertAddressFieldToSCCPAddress(String address, int ton, int npi) {
        return MessageUtil.getSccpAddress((ParameterFactory)this.sccpParameterFact, (String)address, (int)ton, (int)npi, (int)smscPropertiesManagement.getHlrSsn(), (GlobalTitleIndicator)smscPropertiesManagement.getGlobalTitleIndicator(), (int)smscPropertiesManagement.getTranslationType());
    }

    private MAPApplicationContext getSRIMAPApplicationContext(MAPApplicationContextVersion applicationContextVersion) {
        MAPApplicationContext mapApplicationContext = MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgGatewayContext, (MAPApplicationContextVersion)applicationContextVersion);
        this.setSriMapVersion(applicationContextVersion.getVersion());
        return mapApplicationContext;
    }
}

