/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.hr;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.ProcedureCancellationReason;
import org.mobicents.protocols.ss7.map.api.dialog.ResourceUnavailableReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFactory;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.resource.map.MAPContextInterfaceFactory;
import org.mobicents.slee.resource.map.events.DialogAccept;
import org.mobicents.slee.resource.map.events.DialogClose;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogNotice;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogRelease;
import org.mobicents.slee.resource.map.events.DialogRequest;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.InvokeTimeout;
import org.mobicents.slee.resource.map.events.RejectComponent;
import org.mobicents.smsc.domain.HomeRoutingManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.smpp.server.SmppSessions;

public abstract class HomeRoutingCommonSbb
implements Sbb {
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final String PERSISTENCE_LINK = "PersistenceResourceAdaptor";
    protected static final SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    protected static final HomeRoutingManagement homeRoutingManagement = HomeRoutingManagement.getInstance();
    private final String className;
    protected Tracer logger;
    protected SbbContextExt sbbContext;
    protected MAPContextInterfaceFactory mapAcif;
    protected MAPProvider mapProvider;
    protected MAPParameterFactory mapParameterFactory;
    protected MAPErrorMessageFactory mapErrorMessageFactory;
    protected SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    protected PersistenceRAInterface persistence;
    protected SmppSessions smppServerSessions = null;
    protected ParameterFactory sccpParameterFact;
    private SccpAddress serviceCenterSCCPAddress = null;
    private AddressString serviceCenterAddress;
    private ISDNAddressString networkNodeNumber;
    protected static final String MAP_USER_ABORT_CHOICE_USER_SPECIFIC_REASON = "userSpecificReason";
    protected static final String MAP_USER_ABORT_CHOICE_USER_RESOURCE_LIMITATION = "userResourceLimitation";
    protected static final String MAP_USER_ABORT_CHOICE_UNKNOWN = "DialogUserAbort_Unknown";

    public HomeRoutingCommonSbb(String className) {
        this.className = className;
    }

    public void onInvokeTimeout(InvokeTimeout evt, ActivityContextInterface aci) {
        this.logger.severe("\nHome routing: Rx :  onInvokeTimeout" + evt);
    }

    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        this.logger.severe("\nHome routing: Rx :  onErrorComponent " + event + " Dialog=" + event.getMAPDialog());
    }

    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        this.logger.severe("\nHome routing: Rx :  onRejectComponent" + event);
    }

    protected String getRejectComponentReason(RejectComponent event) {
        Problem problem = event.getProblem();
        String reason = null;
        switch (problem.getType()) {
            case General: {
                reason = problem.getGeneralProblemType().toString();
                break;
            }
            case Invoke: {
                reason = problem.getInvokeProblemType().toString();
                break;
            }
            case ReturnResult: {
                reason = problem.getReturnResultProblemType().toString();
                break;
            }
            case ReturnError: {
                reason = problem.getReturnErrorProblemType().toString();
                break;
            }
            default: {
                reason = "RejectComponent_unknown_" + problem.getType();
            }
        }
        try {
            event.getMAPDialog().close(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        return reason;
    }

    protected String getUserAbortReason(DialogUserAbort evt) {
        MAPUserAbortChoice userReason = evt.getUserReason();
        String reason = null;
        if (userReason.isUserSpecificReason()) {
            reason = MAP_USER_ABORT_CHOICE_USER_SPECIFIC_REASON;
        } else if (userReason.isUserResourceLimitation()) {
            reason = MAP_USER_ABORT_CHOICE_USER_RESOURCE_LIMITATION;
        } else if (userReason.isResourceUnavailableReason()) {
            ResourceUnavailableReason resourceUnavailableReason = userReason.getResourceUnavailableReason();
            reason = resourceUnavailableReason.toString();
        } else if (userReason.isProcedureCancellationReason()) {
            ProcedureCancellationReason procedureCancellationReason = userReason.getProcedureCancellationReason();
            reason = procedureCancellationReason.toString();
        } else {
            reason = MAP_USER_ABORT_CHOICE_UNKNOWN;
        }
        return reason;
    }

    public void onDialogDelimiter(DialogDelimiter evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nHome routing: Rx :  onDialogDelimiter=" + evt);
        }
    }

    public void onDialogAccept(DialogAccept evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nHome routing: Rx :  onDialogAccept=" + evt);
        }
    }

    public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
        this.logger.severe("\nHome routing: Rx :  onDialogReject=" + evt);
    }

    public void onDialogUserAbort(DialogUserAbort evt, ActivityContextInterface aci) {
        this.logger.severe("\nHome routing: Rx :  onDialogUserAbort=" + evt);
    }

    public void onDialogProviderAbort(DialogProviderAbort evt, ActivityContextInterface aci) {
        this.logger.severe("\nHome routing: Rx :  onDialogProviderAbort=" + evt);
    }

    public void onDialogClose(DialogClose evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nHome routing: Rx :  onDialogClose" + evt);
        }
    }

    public void onDialogNotice(DialogNotice evt, ActivityContextInterface aci) {
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nHome routing: Rx :  onDialogNotice" + evt);
        }
    }

    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nHome routing: Rx :  onDialogTimeout" + evt);
        }
    }

    public void onDialogRequest(DialogRequest evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nHome routing: Rx :  onDialogRequest" + evt);
        }
    }

    public void onDialogRelease(DialogRelease evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nHome routing: Rx :  DialogRelease" + evt);
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.mapAcif = (MAPContextInterfaceFactory)ctx.lookup("slee/resources/map/2.0/acifactory");
            this.mapProvider = (MAPProvider)ctx.lookup("slee/resources/map/2.0/provider");
            this.mapParameterFactory = this.mapProvider.getMAPParameterFactory();
            this.mapErrorMessageFactory = this.mapProvider.getMAPErrorMessageFactory();
            this.sccpParameterFact = new ParameterFactoryImpl();
            this.smppServerSessions = (SmppSessions)ctx.lookup("slee/resources/smpp/server/1.0/provider");
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, PERSISTENCE_LINK);
            this.logger = this.sbbContext.getTracer(this.className);
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    protected SccpAddress getServiceCenterSccpAddress(int networkId) {
        if (networkId == 0) {
            if (this.serviceCenterSCCPAddress == null) {
                this.serviceCenterSCCPAddress = MessageUtil.getSccpAddress((ParameterFactory)this.sccpParameterFact, (String)smscPropertiesManagement.getServiceCenterGt(), (int)NatureOfAddress.INTERNATIONAL.getValue(), (int)org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY.getValue(), (int)smscPropertiesManagement.getServiceCenterSsn(), (GlobalTitleIndicator)smscPropertiesManagement.getGlobalTitleIndicator(), (int)smscPropertiesManagement.getTranslationType());
            }
            return this.serviceCenterSCCPAddress;
        }
        return MessageUtil.getSccpAddress((ParameterFactory)this.sccpParameterFact, (String)smscPropertiesManagement.getServiceCenterGt(networkId), (int)NatureOfAddress.INTERNATIONAL.getValue(), (int)org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY.getValue(), (int)smscPropertiesManagement.getServiceCenterSsn(), (GlobalTitleIndicator)smscPropertiesManagement.getGlobalTitleIndicator(), (int)smscPropertiesManagement.getTranslationType());
    }

    protected ISDNAddressString getCalledPartyISDNAddressString(String destinationAddress, int ton, int npi) {
        return this.mapParameterFactory.createISDNAddressString(AddressNature.getInstance((int)ton), NumberingPlan.getInstance((int)npi), destinationAddress);
    }

    protected AddressString getServiceCenterAddressString(int networkId) {
        if (networkId == 0) {
            if (this.serviceCenterAddress == null) {
                this.serviceCenterAddress = this.mapParameterFactory.createAddressString(AddressNature.international_number, NumberingPlan.ISDN, smscPropertiesManagement.getServiceCenterGt());
            }
            return this.serviceCenterAddress;
        }
        return this.mapParameterFactory.createAddressString(AddressNature.international_number, NumberingPlan.ISDN, smscPropertiesManagement.getServiceCenterGt(networkId));
    }

    protected ISDNAddressString getNetworkNodeNumber(int networkId) {
        if (networkId == 0) {
            if (this.networkNodeNumber == null) {
                this.networkNodeNumber = this.mapParameterFactory.createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, smscPropertiesManagement.getServiceCenterGt());
            }
            return this.networkNodeNumber;
        }
        return this.mapParameterFactory.createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, smscPropertiesManagement.getServiceCenterGt(networkId));
    }
}

