/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.hr;

import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.ServiceID;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFacilityNotSup;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NetworkResource;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MWStatus;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogNotice;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogRequest;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.RejectComponent;
import org.mobicents.smsc.domain.MoChargingType;
import org.mobicents.smsc.domain.NextCorrelationIdResult;
import org.mobicents.smsc.library.CdrGenerator;
import org.mobicents.smsc.library.CorrelationIdValue;
import org.mobicents.smsc.library.OriginationType;
import org.mobicents.smsc.library.SbbStates;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.slee.services.hr.HomeRoutingCommonSbb;
import org.mobicents.smsc.slee.services.hr.HrSriClientSbbLocalObject;
import org.mobicents.smsc.slee.services.hr.HrSriResultInterface;

public abstract class HrSriServerSbb
extends HomeRoutingCommonSbb
implements HrSriResultInterface {
    private static final String className = HrSriServerSbb.class.getSimpleName();

    public HrSriServerSbb() {
        super(className);
    }

    @Override
    public void onDialogRequest(DialogRequest evt, ActivityContextInterface aci) {
        super.onDialogRequest(evt, aci);
    }

    @Override
    public void onDialogDelimiter(DialogDelimiter evt, ActivityContextInterface aci) {
        super.onDialogDelimiter(evt, aci);
    }

    @Override
    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        super.onErrorComponent(event, aci);
    }

    @Override
    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        super.onRejectComponent(event, aci);
    }

    @Override
    public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
        super.onDialogReject(evt, aci);
    }

    @Override
    public void onDialogUserAbort(DialogUserAbort evt, ActivityContextInterface aci) {
        super.onDialogUserAbort(evt, aci);
    }

    @Override
    public void onDialogProviderAbort(DialogProviderAbort evt, ActivityContextInterface aci) {
        super.onDialogProviderAbort(evt, aci);
    }

    @Override
    public void onDialogNotice(DialogNotice evt, ActivityContextInterface aci) {
        super.onDialogNotice(evt, aci);
    }

    @Override
    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        super.onDialogTimeout(evt, aci);
    }

    public InitialEventSelector initialEventSelect(InitialEventSelector ies) {
        Object event = ies.getEvent();
        DialogRequest dialogRequest = null;
        if (event instanceof DialogRequest) {
            dialogRequest = (DialogRequest)event;
            if (MAPApplicationContextName.shortMsgGatewayContext == dialogRequest.getMAPDialog().getApplicationContext().getApplicationContextName()) {
                ies.setInitialEvent(true);
                ies.setActivityContextSelected(true);
            } else {
                ies.setInitialEvent(false);
            }
        }
        return ies;
    }

    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest evt, ActivityContextInterface aci) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\nHome routing: HrSriServerSbb: Received SEND_ROUTING_INFO_FOR_SM_REQUEST = " + evt + " Dialog=" + evt.getMAPDialog());
        }
        this.setInvokeId(evt.getInvokeId());
        MAPDialogSms dialog = evt.getMAPDialog();
        SccpAddress locAddr = dialog.getLocalAddress();
        SccpAddress locAddr2 = this.sccpParameterFact.createSccpAddress(locAddr.getAddressIndicator().getRoutingIndicator(), locAddr.getGlobalTitle(), locAddr.getSignalingPointCode(), smscPropertiesManagement.getHlrSsn());
        dialog.setLocalAddress(locAddr2);
        if (smscPropertiesManagement.getHrCharging() == MoChargingType.reject) {
            try {
                MAPErrorMessageFacilityNotSup errorMessage = this.mapProvider.getMAPErrorMessageFactory().createMAPErrorMessageFacilityNotSup(null, null, null);
                dialog.sendErrorComponent(Long.valueOf(evt.getInvokeId()), (MAPErrorMessage)errorMessage);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("\nHome routing: Sent ErrorComponent = " + errorMessage);
                }
                if (smscPropertiesManagement.isGenerateRejectionCdr()) {
                    this.generateCDR(dialog.getNetworkId(), "submit_failed_hr", errorMessage.toString(), true);
                }
                dialog.close(false);
                return;
            }
            catch (Throwable e) {
                this.logger.severe("Home routing: Error while sending Error message", e);
                return;
            }
        }
        this.setupSriRequest(evt.getMsisdn(), evt.getServiceCentreAddress(), dialog.getNetworkId(), dialog.getRemoteAddress());
    }

    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse evt, ActivityContextInterface aci) {
        this.logger.severe("Home routing: Received SEND_ROUTING_INFO_FOR_SM_RESPONSE = " + evt);
    }

    private void setupSriRequest(ISDNAddressString msisdn, AddressString serviceCentreAddress, int networkId, SccpAddress originatorSccpAddress) {
        this.smscStatAggregator.updateMsgInHrSriReq();
        HrSriClientSbbLocalObject hrSriClientSbbLocalObject = this.getHrSriClientSbbLocalObject();
        if (hrSriClientSbbLocalObject != null) {
            String sca = msisdn.getAddress();
            NextCorrelationIdResult correlationIDRes = homeRoutingManagement.getNextCorrelationId(sca);
            if (correlationIDRes.getSmscAddress() != null && !correlationIDRes.getSmscAddress().equals("")) {
                this.setSmscAddressForCountryCode(correlationIDRes.getSmscAddress());
            }
            String correlationID = correlationIDRes.getCorrelationId();
            CorrelationIdValue correlationIdValue = new CorrelationIdValue(correlationID, msisdn, serviceCentreAddress, networkId, originatorSccpAddress);
            boolean sriBypass = smscPropertiesManagement.getHrSriBypass(networkId);
            if (sriBypass) {
                this.onSriSuccess(correlationIdValue, true);
            } else {
                hrSriClientSbbLocalObject.setupSriRequest(correlationIdValue);
            }
            if (this.logger.isFineEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Home routing: Created correlationId=");
                sb.append(correlationID);
                sb.append(" for received ServiceCentedAddress=");
                sb.append(sca);
                sb.append(" sriBypass: ");
                sb.append(sriBypass);
                this.logger.fine(sb.toString());
            }
        }
    }

    public abstract void setInvokeId(long var1);

    public abstract long getInvokeId();

    public abstract void setSmscAddressForCountryCode(String var1);

    public abstract String getSmscAddressForCountryCode();

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci, EventContext eventContext) {
        ServiceID serviceID = event.getService();
        this.logger.info("Rx: onServiceStartedEvent: event=" + event + ", serviceID=" + serviceID);
        SbbStates.setHomeRoutingServiceState((boolean)true);
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci, EventContext eventContext) {
        boolean isServiceActivity = aci.getActivity() instanceof ServiceActivity;
        if (isServiceActivity) {
            this.logger.info("Rx: onActivityEndEvent: event=" + event + ", isServiceActivity=" + isServiceActivity);
            SbbStates.setHomeRoutingServiceState((boolean)false);
        }
    }

    public abstract ChildRelationExt getHrSriClientSbb();

    private HrSriClientSbbLocalObject getHrSriClientSbbLocalObject() {
        HrSriClientSbbLocalObject ret;
        block3: {
            ChildRelationExt relation = this.getHrSriClientSbb();
            ret = (HrSriClientSbbLocalObject)relation.get("0");
            if (ret == null) {
                try {
                    ret = (HrSriClientSbbLocalObject)relation.create("0");
                }
                catch (Exception e) {
                    if (!this.logger.isSevereEnabled()) break block3;
                    this.logger.severe("Exception while trying to creat HrSriClientSbb child", (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void onSriSuccess(CorrelationIdValue correlationIdValue, boolean sriBypass) {
        MAPDialogSms dlg = this.getActivity();
        if (dlg == null) {
            this.logger.severe("Home routing: can not get MAPDialog for sending SRI positive Response");
            return;
        }
        if (!sriBypass) {
            this.smscStatAggregator.updateMsgInHrSriPosReq();
            StringBuilder sb = new StringBuilder();
            sb.append("Home routing: positive SRI response from HLR: transaction: ");
            sb.append(correlationIdValue);
            if (this.logger.isInfoEnabled()) {
                this.logger.info(sb.toString());
            }
        }
        try {
            SmsSetCache.getInstance().putCorrelationIdCacheElement(correlationIdValue, smscPropertiesManagement.getCorrelationIdLiveTime());
        }
        catch (Exception e1) {
            if (dlg != null) {
                dlg.release();
            }
            String reason = "Home routing: Exception when ImsiCacheElement : " + e1.toString();
            this.logger.severe(reason, (Throwable)e1);
            return;
        }
        try {
            String smscAddressForCountryCode = this.getSmscAddressForCountryCode();
            ISDNAddressString networkNodeNumber = smscAddressForCountryCode != null ? this.mapParameterFactory.createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, smscAddressForCountryCode) : this.getNetworkNodeNumber(correlationIdValue.getNetworkId());
            LocationInfoWithLMSI li = this.mapParameterFactory.createLocationInfoWithLMSI(networkNodeNumber, null, null, false, null);
            this.doSendResponse(correlationIdValue, dlg, correlationIdValue.getCorrelationID(), li);
        }
        catch (MAPException e) {
            if (dlg != null) {
                dlg.release();
            }
            String reason = "Home routing: MAPException when sending SRI positive Response : " + e.toString();
            this.logger.severe(reason, (Throwable)e);
        }
    }

    private void doSendResponse(CorrelationIdValue correlationIdValue, MAPDialogSms dlg, String imsiValue, LocationInfoWithLMSI li) throws MAPException {
        long invokeId = this.getInvokeId();
        IMSI imsi = this.mapParameterFactory.createIMSI(imsiValue);
        MWStatus mwStatus = correlationIdValue.getMwStatus();
        Boolean mwdSet = null;
        if (dlg.getApplicationContext().getApplicationContextVersion() == MAPApplicationContextVersion.version1 && mwStatus != null) {
            if (mwStatus.getMnrfSet()) {
                mwdSet = true;
            }
            mwStatus = null;
        }
        dlg.addSendRoutingInfoForSMResponse(invokeId, imsi, li, null, mwdSet);
        InformServiceCentreRequest isc = correlationIdValue.getInformServiceCentreRequest();
        if (mwStatus != null && isc != null) {
            dlg.addInformServiceCentreRequest(isc.getStoredMSISDN(), isc.getMwStatus(), null, isc.getAbsentSubscriberDiagnosticSM(), isc.getAdditionalAbsentSubscriberDiagnosticSM());
        }
        dlg.close(false);
    }

    @Override
    public void onSriHrByPass(CorrelationIdValue correlationIdValue) {
        MAPDialogSms dlg = this.getActivity();
        if (dlg == null) {
            this.logger.severe("Home routing: can not get MAPDialog for sending SRI hrByPass Response");
            return;
        }
        this.smscStatAggregator.updateMsgInHrSriHrByPass();
        StringBuilder sb = new StringBuilder();
        sb.append("Home routing: bypassing of Home routing: procedure: transaction: ");
        sb.append(correlationIdValue);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(sb.toString());
        }
        try {
            SendRoutingInfoForSMResponse sendRoutingInfoForSMResponse = correlationIdValue.getSendRoutingInfoForSMResponse();
            this.doSendResponse(correlationIdValue, dlg, sendRoutingInfoForSMResponse.getIMSI().getData(), sendRoutingInfoForSMResponse.getLocationInfoWithLMSI());
        }
        catch (MAPException e) {
            if (dlg != null) {
                dlg.release();
            }
            String reason = "Home routing: MAPException when sending SRI bypassing of Home routing: " + e.toString();
            this.logger.severe(reason, (Throwable)e);
        }
    }

    @Override
    public void onSriFailure(CorrelationIdValue correlationIdValue, MAPErrorMessage errorResponse, String cause) {
        MAPDialogSms dlg = this.getActivity();
        if (dlg == null) {
            this.logger.severe("Home routing: can not get MAPDialog for sending SRI negative Response");
            return;
        }
        this.smscStatAggregator.updateMsgInHrSriNegReq();
        StringBuilder sb = new StringBuilder();
        sb.append("Home routing: negative SRI response from HLR: transaction: ");
        sb.append(correlationIdValue);
        sb.append(",\n cause=");
        sb.append(cause);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(sb.toString());
        }
        try {
            if (errorResponse == null) {
                errorResponse = this.mapErrorMessageFactory.createMAPErrorMessageSystemFailure((long)dlg.getApplicationContext().getApplicationContextVersion().getVersion(), NetworkResource.hlr, null, null);
            }
            long invokeId = this.getInvokeId();
            dlg.sendErrorComponent(Long.valueOf(invokeId), errorResponse);
            dlg.close(false);
        }
        catch (MAPException e) {
            if (dlg != null) {
                dlg.release();
            }
            String reason = "Home routing: MAPException when sending SRI negative Response: " + e.toString();
            this.logger.severe(reason, (Throwable)e);
        }
    }

    private MAPDialogSms getActivity() {
        for (ActivityContextInterface aci : this.sbbContext.getActivities()) {
            Object act = aci.getActivity();
            if (!(act instanceof MAPDialogSms)) continue;
            MAPDialogSms dlg = (MAPDialogSms)act;
            return dlg;
        }
        return null;
    }

    private void generateCDR(int networkId, String status, String reason, boolean lastSegment) {
        CdrGenerator.generateCdr(null, (int)0, (int)0, null, (int)0, (int)0, (OriginationType)OriginationType.SS7_HR, null, null, null, (int)networkId, (int)0, null, (int)0, null, (String)status, (String)reason, (boolean)true, (boolean)true, (boolean)lastSegment, (boolean)smscPropertiesManagement.getCalculateMsgPartsLenCdr(), (boolean)smscPropertiesManagement.getDelayParametersInCdr());
    }
}

