/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.mt;

import java.util.ArrayList;
import java.util.Date;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import javolution.util.FastList;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.MAPSmsTpduParameterFactory;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.ProcedureCancellationReason;
import org.mobicents.protocols.ss7.map.api.dialog.ResourceUnavailableReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.service.sms.SMDeliveryOutcome;
import org.mobicents.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.resource.map.MAPContextInterfaceFactory;
import org.mobicents.slee.resource.map.events.DialogAccept;
import org.mobicents.slee.resource.map.events.DialogClose;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogNotice;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogRelease;
import org.mobicents.slee.resource.map.events.DialogRequest;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.InvokeTimeout;
import org.mobicents.slee.resource.map.events.RejectComponent;
import org.mobicents.smsc.cassandra.DatabaseType;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.CdrGenerator;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageDeliveryResultResponseInterface;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.persistence.SmsSubmitData;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerActivity;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;
import org.mobicents.smsc.slee.services.mt.InformServiceCenterContainer;
import org.mobicents.smsc.slee.services.mt.ReportSMDeliveryStatusInterface2;
import org.mobicents.smsc.smpp.GenerateType;

public abstract class MtCommonSbb
implements Sbb,
ReportSMDeliveryStatusInterface2 {
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final ResourceAdaptorTypeID SCHEDULE_ID = new ResourceAdaptorTypeID("SchedulerResourceAdaptorType", "org.mobicents", "1.0");
    private static final String PERSISTENCE_LINK = "PersistenceResourceAdaptor";
    private static final String SCHEDULE_LINK = "SchedulerResourceAdaptor";
    protected static final String MAP_USER_ABORT_CHOICE_USER_SPECIFIC_REASON = "userSpecificReason";
    protected static final String MAP_USER_ABORT_CHOICE_USER_RESOURCE_LIMITATION = "userResourceLimitation";
    protected static final String MAP_USER_ABORT_CHOICE_UNKNOWN = "DialogUserAbort_Unknown";
    protected static final SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    private final String className;
    protected Tracer logger;
    protected SbbContextExt sbbContext;
    protected MAPContextInterfaceFactory mapAcif;
    protected MAPProvider mapProvider;
    protected MAPParameterFactory mapParameterFactory;
    protected MAPSmsTpduParameterFactory mapSmsTpduParameterFactory;
    protected ParameterFactory sccpParameterFact;
    private AddressString serviceCenterAddress;
    private SccpAddress serviceCenterSCCPAddress = null;
    protected PersistenceRAInterface persistence;
    protected SchedulerRaSbbInterface scheduler;
    protected SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();

    public MtCommonSbb(String className) {
        this.className = className;
    }

    public PersistenceRAInterface getStore() {
        return this.persistence;
    }

    public SchedulerRaSbbInterface getScheduler() {
        return this.scheduler;
    }

    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\nRx :  onErrorComponent " + event + " targetId=" + targetId + ", Dialog=" + event.getMAPDialog());
        }
    }

    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        this.logger.severe("\nRx :  onRejectComponent targetId=" + targetId + ", " + event);
    }

    protected String getRejectComponentReason(RejectComponent event) {
        Problem problem = event.getProblem();
        String reason = null;
        switch (problem.getType()) {
            case General: {
                reason = problem.getGeneralProblemType().toString();
                break;
            }
            case Invoke: {
                reason = problem.getInvokeProblemType().toString();
                break;
            }
            case ReturnResult: {
                reason = problem.getReturnResultProblemType().toString();
                break;
            }
            case ReturnError: {
                reason = problem.getReturnErrorProblemType().toString();
                break;
            }
            default: {
                reason = "RejectComponent_unknown_" + problem.getType();
            }
        }
        try {
            event.getMAPDialog().close(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        return reason;
    }

    public void onInvokeTimeout(InvokeTimeout evt, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nRx : onInvokeTimeout targetId=" + targetId + ", " + evt);
        }
    }

    public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nRx : onDialogReject targetId=" + targetId + ", " + evt);
        }
    }

    public void onDialogProviderAbort(DialogProviderAbort evt, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nRx :  onDialogProviderAbort targetId=" + targetId + ", " + evt);
        }
    }

    public void onDialogUserAbort(DialogUserAbort evt, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nRx :  onDialogUserAbort targetId=" + targetId + ", " + evt);
        }
    }

    protected String getUserAbortReason(DialogUserAbort evt) {
        MAPUserAbortChoice userReason = evt.getUserReason();
        String reason = null;
        if (userReason.isUserSpecificReason()) {
            reason = MAP_USER_ABORT_CHOICE_USER_SPECIFIC_REASON;
        } else if (userReason.isUserResourceLimitation()) {
            reason = MAP_USER_ABORT_CHOICE_USER_RESOURCE_LIMITATION;
        } else if (userReason.isResourceUnavailableReason()) {
            ResourceUnavailableReason resourceUnavailableReason = userReason.getResourceUnavailableReason();
            reason = resourceUnavailableReason.toString();
        } else if (userReason.isProcedureCancellationReason()) {
            ProcedureCancellationReason procedureCancellationReason = userReason.getProcedureCancellationReason();
            reason = procedureCancellationReason.toString();
        } else {
            reason = MAP_USER_ABORT_CHOICE_UNKNOWN;
        }
        return reason;
    }

    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nRx :  onDialogTimeout targetId=" + targetId + ", " + evt);
        }
    }

    public void onDialogDelimiter(DialogDelimiter evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogDelimiter " + evt);
        }
    }

    public void onDialogAccept(DialogAccept evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogAccept=" + evt);
        }
    }

    public void onDialogClose(DialogClose evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogClose=" + evt);
        }
    }

    public void onDialogNotice(DialogNotice evt, ActivityContextInterface aci) {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        String targetId = null;
        if (smsDeliveryData != null) {
            targetId = smsDeliveryData.getTargetId();
        }
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nRx :  onDialogNotice targetId=" + targetId + ", " + evt);
        }
    }

    public void onDialogRequest(DialogRequest evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogRequest=" + evt);
        }
    }

    public void onDialogRelease(DialogRelease evt, ActivityContextInterface aci) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\nRx :  DialogRelease=" + evt);
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.mapAcif = (MAPContextInterfaceFactory)ctx.lookup("slee/resources/map/2.0/acifactory");
            this.mapProvider = (MAPProvider)ctx.lookup("slee/resources/map/2.0/provider");
            this.mapParameterFactory = this.mapProvider.getMAPParameterFactory();
            this.mapSmsTpduParameterFactory = this.mapProvider.getMAPSmsTpduParameterFactory();
            this.sccpParameterFact = new ParameterFactoryImpl();
            this.logger = this.sbbContext.getTracer(this.className);
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, PERSISTENCE_LINK);
            this.scheduler = (SchedulerRaSbbInterface)this.sbbContext.getResourceAdaptorInterface(SCHEDULE_ID, SCHEDULE_LINK);
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    protected AddressString getServiceCenterAddressString(int networkId) {
        if (networkId == 0) {
            if (this.serviceCenterAddress == null) {
                this.serviceCenterAddress = this.mapParameterFactory.createAddressString(AddressNature.international_number, NumberingPlan.ISDN, smscPropertiesManagement.getServiceCenterGt());
            }
            return this.serviceCenterAddress;
        }
        return this.mapParameterFactory.createAddressString(AddressNature.international_number, NumberingPlan.ISDN, smscPropertiesManagement.getServiceCenterGt(networkId));
    }

    protected SccpAddress getServiceCenterSccpAddress(int networkId) {
        if (networkId == 0) {
            if (this.serviceCenterSCCPAddress == null) {
                this.serviceCenterSCCPAddress = MessageUtil.getSccpAddress((ParameterFactory)this.sccpParameterFact, (String)smscPropertiesManagement.getServiceCenterGt(), (int)NatureOfAddress.INTERNATIONAL.getValue(), (int)org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY.getValue(), (int)smscPropertiesManagement.getServiceCenterSsn(), (GlobalTitleIndicator)smscPropertiesManagement.getGlobalTitleIndicator(), (int)smscPropertiesManagement.getTranslationType());
            }
            return this.serviceCenterSCCPAddress;
        }
        return MessageUtil.getSccpAddress((ParameterFactory)this.sccpParameterFact, (String)smscPropertiesManagement.getServiceCenterGt(networkId), (int)NatureOfAddress.INTERNATIONAL.getValue(), (int)org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY.getValue(), (int)smscPropertiesManagement.getServiceCenterSsn(), (GlobalTitleIndicator)smscPropertiesManagement.getGlobalTitleIndicator(), (int)smscPropertiesManagement.getTranslationType());
    }

    protected ISDNAddressString getCalledPartyISDNAddressString(String destinationAddress, int ton, int npi) {
        return this.mapParameterFactory.createISDNAddressString(AddressNature.getInstance((int)ton), NumberingPlan.getInstance((int)npi), destinationAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDeliveryError(SmsSet smsSet, ErrorAction errorAction, ErrorCode smStatus, String reason, boolean removeSmsSet, MAPErrorMessage errMessage, boolean isImsiVlrReject) {
        TargetAddress lock;
        this.smscStatAggregator.updateMsgOutFailedAll();
        PersistenceRAInterface pers = this.getStore();
        long currentMsgNum = this.doGetCurrentMsgNum();
        Sms smsa = smsSet.getSms(currentMsgNum);
        if (smsa != null) {
            CdrGenerator.generateCdr((Sms)smsa, (String)"temp_failed", (String)reason, (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)smsa, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("onDeliveryError: errorAction=");
        sb.append((Object)errorAction);
        sb.append(", smStatus=");
        sb.append(smStatus);
        sb.append(", targetId=");
        sb.append(smsSet.getTargetId());
        sb.append(", smsSet=");
        sb.append(smsSet);
        sb.append(", reason=");
        sb.append(reason);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(sb.toString());
        }
        MessageDeliveryResultResponseInterface.DeliveryFailureReason delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.destinationUnavalable;
        if (errorAction == ErrorAction.temporaryFailure) {
            delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.temporaryNetworkError;
        }
        if (errorAction == ErrorAction.permanentFailure) {
            delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.permanentNetworkError;
        }
        for (long i1 = currentMsgNum; i1 < smsSet.getSmsCount(); ++i1) {
            Sms sms = smsSet.getSms(i1);
            if (sms == null || sms.getMessageDeliveryResultResponse() == null) continue;
            sms.getMessageDeliveryResultResponse().responseDeliveryFailure(delReason, errMessage);
            sms.setMessageDeliveryResultResponse(null);
        }
        ArrayList<Sms> lstFailured = new ArrayList<Sms>();
        SMDeliveryOutcome smDeliveryOutcome = null;
        TargetAddress targetAddress = lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
        synchronized (targetAddress) {
            try {
                Date curDate = new Date();
                try {
                    long smsCnt;
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.setDeliveryFailure(smsSet, smStatus, curDate);
                    } else {
                        smsSet.setStatus(smStatus);
                        if (removeSmsSet) {
                            SmsSetCache.getInstance().removeProcessingSmsSet(smsSet.getTargetId());
                        }
                    }
                    this.decrementDeliveryActivityCount();
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        smsCnt = smsSet.getSmsCount();
                        int goodMsgCnt = 0;
                        int removedMsgCnt = 0;
                        for (long i1 = currentMsgNum; i1 < smsCnt; ++i1) {
                            Sms sms = smsSet.getSms(i1);
                            if (sms == null) continue;
                            if (sms.getValidityPeriod().before(curDate)) {
                                pers.archiveFailuredSms(sms);
                                lstFailured.add(sms);
                                ++removedMsgCnt;
                                continue;
                            }
                            ++goodMsgCnt;
                        }
                        if (goodMsgCnt == 0 || removedMsgCnt > 0) {
                            pers.fetchSchedulableSms(smsSet, false);
                            if (smsSet.getSmsCount() == 0L) {
                                errorAction = ErrorAction.permanentFailure;
                            }
                        }
                    }
                    switch (errorAction) {
                        case subscriberBusy: {
                            this.rescheduleSmsSet(smsSet, true, pers, currentMsgNum, lstFailured);
                            break;
                        }
                        case memoryCapacityExceededFlag: {
                            smDeliveryOutcome = SMDeliveryOutcome.memoryCapacityExceeded;
                            this.rescheduleSmsSet(smsSet, false, pers, currentMsgNum, lstFailured);
                            break;
                        }
                        case mobileNotReachableFlag: {
                            smDeliveryOutcome = SMDeliveryOutcome.absentSubscriber;
                            this.rescheduleSmsSet(smsSet, false, pers, currentMsgNum, lstFailured);
                            break;
                        }
                        case notReachableForGprs: {
                            smDeliveryOutcome = SMDeliveryOutcome.absentSubscriber;
                            this.rescheduleSmsSet(smsSet, false, pers, currentMsgNum, lstFailured);
                            break;
                        }
                        case temporaryFailure: {
                            this.rescheduleSmsSet(smsSet, false, pers, currentMsgNum, lstFailured);
                            break;
                        }
                        case permanentFailure: {
                            smsCnt = smsSet.getSmsCount();
                            for (long i1 = currentMsgNum; i1 < smsCnt; ++i1) {
                                Sms sms = smsSet.getSms(i1);
                                if (sms == null) continue;
                                lstFailured.add(sms);
                            }
                            this.freeSmsSetFailured(smsSet, pers, currentMsgNum);
                        }
                    }
                }
                catch (PersistenceException e) {
                    this.logger.severe("PersistenceException when onDeliveryError()" + e.getMessage(), (Throwable)e);
                }
            }
            finally {
                pers.releaseSynchroObject(lock);
            }
        }
        for (Sms sms : lstFailured) {
            CdrGenerator.generateCdr((Sms)sms, (String)(isImsiVlrReject ? "failed_imsi" : "failed"), (String)reason, (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
            if (smscPropertiesManagement.getDatabaseType() != DatabaseType.Cassandra_1) {
                sms.setDeliveryDate(new Date());
                try {
                    if (MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateArchiveTable())) {
                        pers.c2_createRecordArchive(sms);
                    }
                }
                catch (PersistenceException e) {
                    this.logger.severe("PersistenceException when freeSmsSetFailured(SmsSet smsSet) - c2_createRecordArchive(sms)" + e.getMessage(), (Throwable)e);
                }
            }
            MProcResult mProcResult = MProcManagement.getInstance().applyMProcDelivery(sms, true);
            FastList addedMessages = mProcResult.getMessageList();
            if (addedMessages != null) {
                FastList.Node n = addedMessages.head();
                FastList.Node end = addedMessages.tail();
                while ((n = n.getNext()) != end) {
                    Sms smst = (Sms)n.getValue();
                    TargetAddress ta = new TargetAddress(smst.getSmsSet().getDestAddrTon(), smst.getSmsSet().getDestAddrNpi(), smst.getSmsSet().getDestAddr(), smst.getSmsSet().getNetworkId());
                    TargetAddress lock2 = SmsSetCache.getInstance().addSmsSet(ta);
                    try {
                        TargetAddress targetAddress2 = lock2;
                        synchronized (targetAddress2) {
                            if (smscPropertiesManagement.getDatabaseType() != DatabaseType.Cassandra_1) {
                                boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)smst);
                                if (!storeAndForwMode) {
                                    try {
                                        this.scheduler.injectSmsOnFly(smst.getSmsSet());
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages in onDeliveryError(): " + e.getMessage(), (Throwable)e);
                                    }
                                } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                    try {
                                        smst.setStoringAfterFailure(true);
                                        this.scheduler.injectSmsOnFly(smst.getSmsSet());
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages in onDeliveryError(): " + e.getMessage(), (Throwable)e);
                                    }
                                } else {
                                    smst.setStored(true);
                                    this.scheduler.setDestCluster(smst.getSmsSet());
                                    try {
                                        pers.c2_scheduleMessage_ReschedDueSlot(smst, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                    }
                                    catch (PersistenceException e) {
                                        this.logger.severe("PersistenceException when onDeliveryError(SmsSet smsSet) - adding applyMProcDelivery created messages" + e.getMessage(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    finally {
                        SmsSetCache.getInstance().removeSmsSet(lock2);
                    }
                }
            }
            int registeredDelivery = sms.getRegisteredDelivery();
            if (smscPropertiesManagement.getReceiptsDisabling() || !MessageUtil.isReceiptOnFailure((int)registeredDelivery)) continue;
            TargetAddress ta = new TargetAddress(sms.getSourceAddrTon(), sms.getSourceAddrNpi(), sms.getSourceAddr(), smsSet.getNetworkId());
            lock = SmsSetCache.getInstance().addSmsSet(ta);
            try {
                TargetAddress targetAddress3 = lock;
                synchronized (targetAddress3) {
                    try {
                        Sms receipt;
                        if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                            receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)false);
                            SmsSet backSmsSet = pers.obtainSmsSet(ta);
                            receipt.setSmsSet(backSmsSet);
                            receipt.setStored(true);
                            pers.createLiveSms(receipt);
                            pers.setNewMessageScheduled(receipt.getSmsSet(), MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)smscPropertiesManagement.getFirstDueDelay())));
                        } else {
                            receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)false, (TargetAddress)ta, (boolean)smscPropertiesManagement.getOrigNetworkIdForReceipts());
                            boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                            if (!storeAndForwMode) {
                                try {
                                    this.scheduler.injectSmsOnFly(receipt.getSmsSet());
                                }
                                catch (Exception e) {
                                    this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in onDeliveryError(): " + e.getMessage(), (Throwable)e);
                                }
                            } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                try {
                                    receipt.setStoringAfterFailure(true);
                                    this.scheduler.injectSmsOnFly(receipt.getSmsSet());
                                }
                                catch (Exception e) {
                                    this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in onDeliveryError(): " + e.getMessage(), (Throwable)e);
                                }
                            } else {
                                receipt.setStored(true);
                                this.scheduler.setDestCluster(receipt.getSmsSet());
                                pers.c2_scheduleMessage_ReschedDueSlot(receipt, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                            }
                        }
                        this.logger.info("Adding an error receipt: source=" + receipt.getSourceAddr() + ", dest=" + receipt.getSmsSet().getDestAddr());
                    }
                    catch (PersistenceException e) {
                        this.logger.severe("PersistenceException when freeSmsSetFailured(SmsSet smsSet) - adding delivery receipt" + e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                SmsSetCache.getInstance().removeSmsSet(lock);
            }
        }
        if (smDeliveryOutcome != null && smsSet.getSmsCount() > (long)lstFailured.size()) {
            this.setupReportSMDeliveryStatusRequest(smsSet.getDestAddr(), smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), smDeliveryOutcome, smsSet.getTargetId(), smsSet.getNetworkId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onImsiDrop(Sms sms, String imsi, ISDNAddressString nnn) {
        PersistenceRAInterface pers = this.getStore();
        StringBuilder sb = new StringBuilder();
        sb.append("onImsiDrop: targetId=");
        sb.append(sms.getSmsSet().getTargetId());
        sb.append(", sms=");
        sb.append(sms);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(sb.toString());
        }
        MessageDeliveryResultResponseInterface.DeliveryFailureReason delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.destinationUnavalable;
        if (sms.getMessageDeliveryResultResponse() != null) {
            sms.getMessageDeliveryResultResponse().responseDeliveryFailure(delReason, null);
            sms.setMessageDeliveryResultResponse(null);
        }
        CdrGenerator.generateCdr((Sms)sms, (String)"failed_imsi", (String)"Sri-ImsiRequest: incoming messages are dropped by mProc rules", (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
        try {
            pers.c2_updateInSystem(sms, 2, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
            sms.getSmsSet().setStatus(ErrorCode.MPROC_SRI_REQUEST_DROP);
            sms.setDeliveryDate(new Date());
            if (MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateArchiveTable())) {
                pers.c2_createRecordArchive(sms);
            }
        }
        catch (PersistenceException e) {
            this.logger.severe("PersistenceException when onImsiDrop() - c2_createRecordArchive" + e.getMessage(), (Throwable)e);
        }
        int registeredDelivery = sms.getRegisteredDelivery();
        if (!smscPropertiesManagement.getReceiptsDisabling() && MessageUtil.isReceiptOnFailure((int)registeredDelivery)) {
            TargetAddress ta = new TargetAddress(sms.getSourceAddrTon(), sms.getSourceAddrNpi(), sms.getSourceAddr(), sms.getSmsSet().getNetworkId());
            TargetAddress lock = SmsSetCache.getInstance().addSmsSet(ta);
            try {
                TargetAddress targetAddress = lock;
                synchronized (targetAddress) {
                    try {
                        Sms receipt;
                        StringBuilder extraString = new StringBuilder();
                        extraString.append(" imsi:");
                        extraString.append(imsi);
                        extraString.append(" nnn_digits:");
                        extraString.append(nnn.getAddress());
                        extraString.append(" nnn_an:");
                        extraString.append(nnn.getAddressNature().getIndicator());
                        extraString.append(" nnn_np:");
                        extraString.append(nnn.getNumberingPlan().getIndicator());
                        if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                            receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)false);
                            SmsSet backSmsSet = pers.obtainSmsSet(ta);
                            receipt.setSmsSet(backSmsSet);
                            receipt.setStored(true);
                            pers.createLiveSms(receipt);
                            pers.setNewMessageScheduled(receipt.getSmsSet(), MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)smscPropertiesManagement.getFirstDueDelay())));
                        } else {
                            receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)false, (TargetAddress)ta, (boolean)smscPropertiesManagement.getOrigNetworkIdForReceipts(), (String)extraString.toString());
                            boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                            if (!storeAndForwMode) {
                                try {
                                    this.scheduler.injectSmsOnFly(receipt.getSmsSet());
                                }
                                catch (Exception e) {
                                    this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in onImsiDrop(): " + e.getMessage(), (Throwable)e);
                                }
                            } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                try {
                                    receipt.setStoringAfterFailure(true);
                                    this.scheduler.injectSmsOnFly(receipt.getSmsSet());
                                }
                                catch (Exception e) {
                                    this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in onImsiDrop(): " + e.getMessage(), (Throwable)e);
                                }
                            } else {
                                receipt.setStored(true);
                                this.scheduler.setDestCluster(receipt.getSmsSet());
                                pers.c2_scheduleMessage_ReschedDueSlot(receipt, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                            }
                        }
                        this.logger.info("Adding an error receipt: source=" + receipt.getSourceAddr() + ", dest=" + receipt.getSmsSet().getDestAddr());
                    }
                    catch (PersistenceException e) {
                        this.logger.severe("PersistenceException when onImsiDrop(Set) - adding delivery receipt" + e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                SmsSetCache.getInstance().removeSmsSet(lock);
            }
        }
    }

    public abstract void doSetSmsSubmitData(SmsSubmitData var1);

    public abstract SmsSubmitData doGetSmsSubmitData();

    public abstract void doSetCurrentMsgNum(long var1);

    public abstract long doGetCurrentMsgNum();

    public abstract void doSetInformServiceCenterContainer(InformServiceCenterContainer var1);

    public abstract InformServiceCenterContainer doGetInformServiceCenterContainer();

    protected void startMessageDelivery(Sms sms) {
        try {
            this.getStore().setDeliveryStart(sms);
        }
        catch (PersistenceException e) {
            this.logger.severe("PersistenceException when setDeliveryStart(sms)" + e.getMessage(), (Throwable)e);
        }
    }

    protected void freeSmsSetSucceded(SmsSet smsSet, PersistenceRAInterface pers) {
        try {
            this.decrementDeliveryActivityCount();
            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                Date lastDelivery = new Date();
                pers.setDeliverySuccess(smsSet, lastDelivery);
                if (!pers.deleteSmsSet(smsSet)) {
                    Date newDueDate = MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)smscPropertiesManagement.getFirstDueDelay()));
                    pers.fetchSchedulableSms(smsSet, false);
                    newDueDate = MessageUtil.checkScheduleDeliveryTime((SmsSet)smsSet, (Date)newDueDate);
                    pers.setNewMessageScheduled(smsSet, newDueDate);
                }
            } else {
                smsSet.setStatus(ErrorCode.SUCCESS);
                SmsSetCache.getInstance().removeProcessingSmsSet(smsSet.getTargetId());
            }
        }
        catch (PersistenceException e) {
            this.logger.severe("PersistenceException when freeSmsSetSucceded(SmsSet smsSet)" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeSmsSetFailured(SmsSet smsSet, PersistenceRAInterface pers, long currentMsgNum) {
        TargetAddress lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                try {
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.fetchSchedulableSms(smsSet, false);
                        long cnt = smsSet.getSmsCount();
                        int i1 = 0;
                        while ((long)i1 < cnt) {
                            Sms sms = smsSet.getSms((long)i1);
                            pers.archiveFailuredSms(sms);
                            ++i1;
                        }
                        pers.deleteSmsSet(smsSet);
                    } else {
                        for (long i1 = currentMsgNum; i1 < smsSet.getSmsCount(); ++i1) {
                            Sms sms = smsSet.getSms(i1);
                            pers.c2_updateInSystem(sms, 2, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
                            sms.setDeliveryDate(new Date());
                            if (!MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateArchiveTable())) continue;
                            pers.c2_createRecordArchive(sms);
                        }
                    }
                }
                catch (PersistenceException e) {
                    this.logger.severe("PersistenceException when freeSmsSetFailured(SmsSet smsSet)" + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            pers.releaseSynchroObject(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rescheduleSmsSet(SmsSet smsSet, boolean busySuscriber, PersistenceRAInterface pers, long currentMsgNum, ArrayList<Sms> lstFailured) {
        TargetAddress lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                try {
                    int prevDueDelay = smsSet.getDueDelay();
                    int newDueDelay = busySuscriber ? MessageUtil.computeDueDelaySubscriberBusy((int)smscPropertiesManagement.getSubscriberBusyDueDelay()) : MessageUtil.computeNextDueDelay((int)prevDueDelay, (int)smscPropertiesManagement.getSecondDueDelay(), (int)smscPropertiesManagement.getDueDelayMultiplicator(), (int)smscPropertiesManagement.getMaxDueDelay());
                    Date newDueDate = new Date(new Date().getTime() + (long)(newDueDelay * 1000));
                    newDueDate = MessageUtil.checkScheduleDeliveryTime((SmsSet)smsSet, (Date)newDueDate);
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.setDeliveringProcessScheduled(smsSet, newDueDate, newDueDelay);
                    } else {
                        smsSet.setDueDate(newDueDate);
                        smsSet.setDueDelay(newDueDelay);
                        long dueSlot = this.getStore().c2_getDueSlotForTime(newDueDate);
                        for (long i1 = currentMsgNum; i1 < smsSet.getSmsCount(); ++i1) {
                            Sms sms = smsSet.getSms(i1);
                            pers.c2_scheduleMessage_NewDueSlot(sms, dueSlot, lstFailured, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
                        }
                    }
                }
                catch (PersistenceException e) {
                    this.logger.severe("PersistenceException when rescheduleSmsSet(SmsSet smsSet)" + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            pers.releaseSynchroObject(lock);
        }
    }

    protected ActivityContextInterface getSchedulerActivityContextInterface() {
        ActivityContextInterface[] acis = this.sbbContext.getActivities();
        for (int count = 0; count < acis.length; ++count) {
            ActivityContextInterface aci = acis[count];
            Object activity = aci.getActivity();
            if (!(activity instanceof SchedulerActivity)) continue;
            return aci;
        }
        return null;
    }

    private void decrementDeliveryActivityCount() {
        try {
            ActivityContextInterface schedulerActivityContextInterface = this.getSchedulerActivityContextInterface();
            SchedulerActivity schedulerActivity = (SchedulerActivity)schedulerActivityContextInterface.getActivity();
            schedulerActivity.endActivity();
        }
        catch (Exception e) {
            this.logger.severe("Error while decrementing DeliveryActivityCount", (Throwable)e);
        }
    }

    public static enum ErrorAction {
        subscriberBusy,
        memoryCapacityExceededFlag,
        mobileNotReachableFlag,
        notReachableForGprs,
        permanentFailure,
        temporaryFailure;

    }
}

