/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.mt;

import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.tlv.TlvConvertException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import javax.slee.ActivityContextInterface;
import javax.slee.SbbLocalObject;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.datacoding.NationalLanguageIdentifier;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriber;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriberSM;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageExtensionContainer;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageFacilityNotSup;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSMDeliveryFailure;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSubscriberBusyForMtSms;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageSystemFailure;
import org.mobicents.protocols.ss7.map.api.errors.SMEnumeratedDeliveryFailureCause;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SMDeliveryOutcome;
import org.mobicents.protocols.ss7.map.api.service.sms.SM_RP_DA;
import org.mobicents.protocols.ss7.map.api.service.sms.SM_RP_OA;
import org.mobicents.protocols.ss7.map.api.service.sms.SmsSignalInfo;
import org.mobicents.protocols.ss7.map.api.smstpdu.AbsoluteTimeStamp;
import org.mobicents.protocols.ss7.map.api.smstpdu.AddressField;
import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.api.smstpdu.ConcatenatedShortMessagesIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;
import org.mobicents.protocols.ss7.map.api.smstpdu.NationalLanguageLockingShiftIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.NationalLanguageSingleShiftIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.NumberingPlanIdentification;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsDeliverTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.TypeOfNumber;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserData;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeader;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeaderElement;
import org.mobicents.protocols.ss7.map.smstpdu.UserDataImpl;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.slee.SbbLocalObjectExt;
import org.mobicents.slee.resource.map.events.DialogAccept;
import org.mobicents.slee.resource.map.events.DialogClose;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.RejectComponent;
import org.mobicents.smsc.cassandra.DatabaseType;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.MapVersionCache;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.CdrGenerator;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.SmscProcessingException;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.persistence.SmsSubmitData;
import org.mobicents.smsc.slee.services.mt.InformServiceCenterContainer;
import org.mobicents.smsc.slee.services.mt.MtCommonSbb;
import org.mobicents.smsc.slee.services.mt.MtForwardSmsInterface;
import org.mobicents.smsc.slee.services.mt.ReportSMDeliveryStatusInterface2;
import org.mobicents.smsc.slee.services.mt.SriSbbLocalObject;
import org.mobicents.smsc.smpp.GenerateType;

public abstract class MtSbb
extends MtCommonSbb
implements MtForwardSmsInterface,
ReportSMDeliveryStatusInterface2 {
    private static final String className = MtSbb.class.getSimpleName();
    private MapVersionCache mapVersionCache = MapVersionCache.getInstance();
    private static final int MASK_MAP_VERSION_1 = 1;
    private static final int MASK_MAP_VERSION_2 = 2;
    private static final int MASK_MAP_VERSION_3 = 4;
    private static Charset isoCharset = Charset.forName("ISO-8859-1");

    public MtSbb() {
        super(className);
    }

    @Override
    public void onDialogAccept(DialogAccept event, ActivityContextInterface aci) {
        super.onDialogAccept(event, aci);
        if (!this.isNegotiatedMapVersionUsing()) {
            this.mapVersionCache.setMAPApplicationContextVersion(this.getNetworkNode().getGlobalTitle().getDigits(), event.getMAPDialog().getApplicationContext().getApplicationContextVersion());
        }
    }

    @Override
    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        try {
            super.onErrorComponent(event, aci);
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onErrorComponent()");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.onErrorComponent(), targetId=" + targetId);
                return;
            }
            MAPErrorMessage mapErrorMessage = event.getMAPErrorMessage();
            if (mapErrorMessage.isEmSubscriberBusyForMtSms()) {
                MAPErrorMessageSubscriberBusyForMtSms subscriberBusyForMtSms = mapErrorMessage.getEmSubscriberBusyForMtSms();
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.subscriberBusy, ErrorCode.USER_BUSY, "Error subscriberBusyForMtSms after MtForwardSM Request: " + subscriberBusyForMtSms.toString(), true, mapErrorMessage, false);
            } else if (mapErrorMessage.isEmAbsentSubscriber()) {
                MAPErrorMessageAbsentSubscriber absentSubscriber = mapErrorMessage.getEmAbsentSubscriber();
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.mobileNotReachableFlag, ErrorCode.ABSENT_SUBSCRIBER, "Error absentSubscriber after MtForwardSM Request: " + absentSubscriber.toString(), true, mapErrorMessage, false);
            } else if (mapErrorMessage.isEmAbsentSubscriberSM()) {
                MAPErrorMessageAbsentSubscriberSM absentSubscriber = mapErrorMessage.getEmAbsentSubscriberSM();
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.mobileNotReachableFlag, ErrorCode.ABSENT_SUBSCRIBER, "Error absentSubscriberSM after MtForwardSM Request: " + absentSubscriber.toString(), true, mapErrorMessage, false);
            } else if (mapErrorMessage.isEmSMDeliveryFailure()) {
                MAPErrorMessageSMDeliveryFailure smDeliveryFailure = mapErrorMessage.getEmSMDeliveryFailure();
                if (smDeliveryFailure.getSMEnumeratedDeliveryFailureCause() == SMEnumeratedDeliveryFailureCause.memoryCapacityExceeded) {
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.memoryCapacityExceededFlag, ErrorCode.MESSAGE_QUEUE_FULL, "Error smDeliveryFailure after MtForwardSM Request: " + smDeliveryFailure.toString(), true, mapErrorMessage, false);
                } else {
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.SENDING_SM_FAILED, "Error smDeliveryFailure after MtForwardSM Request: " + smDeliveryFailure.toString(), true, mapErrorMessage, false);
                }
            } else if (mapErrorMessage.isEmSystemFailure()) {
                MAPErrorMessageSystemFailure systemFailure = mapErrorMessage.getEmSystemFailure();
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.SYSTEM_FAILURE, "Error systemFailure after MtForwardSM Request: " + systemFailure.toString(), true, mapErrorMessage, false);
            } else if (mapErrorMessage.isEmFacilityNotSup()) {
                MAPErrorMessageFacilityNotSup facilityNotSup = mapErrorMessage.getEmFacilityNotSup();
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.FACILITY_NOT_SUPPORTED, "Error facilityNotSup after MtForwardSM Request: " + facilityNotSup.toString(), true, mapErrorMessage, false);
            } else if (mapErrorMessage.isEmExtensionContainer()) {
                MAPErrorMessageExtensionContainer extensionContainer = mapErrorMessage.getEmExtensionContainer();
                switch ((int)extensionContainer.getErrorCode().longValue()) {
                    case 35: {
                        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.DATA_MISSING, "Error dataMissing after MtForwardSM Request: " + extensionContainer.toString(), true, mapErrorMessage, false);
                        break;
                    }
                    case 36: {
                        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.UNEXPECTED_DATA, "Error unexpectedDataValue after MtForwardSM Request: " + extensionContainer.toString(), true, mapErrorMessage, false);
                        break;
                    }
                    case 5: {
                        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.UNDEFINED_SUBSCRIBER, "Error unidentifiedSubscriber after MtForwardSM Request: " + extensionContainer.toString(), true, mapErrorMessage, false);
                        break;
                    }
                    case 9: {
                        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.ILLEGAL_SUBSCRIBER, "Error illegalSubscriber after MtForwardSM Request: " + extensionContainer.toString(), true, mapErrorMessage, false);
                        break;
                    }
                    case 12: {
                        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.ILLEGAL_EQUIPMENT, "Error illegalEquipment after MtForwardSM Request: " + extensionContainer.toString(), true, mapErrorMessage, false);
                        break;
                    }
                    default: {
                        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.SYSTEM_FAILURE, "Error after MtForwardSM Request: " + extensionContainer.toString(), true, mapErrorMessage, false);
                        break;
                    }
                }
            } else {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.SYSTEM_FAILURE, "Error after MtForwardSM Request: " + mapErrorMessage, true, mapErrorMessage, false);
            }
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onErrorComponent() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        try {
            super.onRejectComponent(event, aci);
            String reason = this.getRejectComponentReason(event);
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onRejectComponent()");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.onRejectComponent(), targetId=" + targetId);
                return;
            }
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "onRejectComponent after MtForwardSM Request: " + reason != null ? reason.toString() : "", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onDialogProviderAbort() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
        try {
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onDialogReject()");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.onDialogReject(), targetId=" + targetId);
                return;
            }
            MAPRefuseReason mapRefuseReason = evt.getRefuseReason();
            if (mapRefuseReason == MAPRefuseReason.PotentialVersionIncompatibility && evt.getMAPDialog().getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1) {
                MAPApplicationContextVersion newMAPApplicationContextVersion;
                if (this.logger.isWarningEnabled()) {
                    this.logger.warning("Rx : Mt onDialogReject / PotentialVersionIncompatibility=" + evt);
                }
                if (this.isMAPVersionTested(newMAPApplicationContextVersion = MAPApplicationContextVersion.version1)) {
                    String reason = "Error condition when invoking sendMtSms() from onDialogReject()." + newMAPApplicationContextVersion + " already tried and DialogReject again suggests Version1";
                    this.logger.severe(reason);
                    ErrorCode smStatus = ErrorCode.MAP_SERVER_VERSION_ERROR;
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
                    return;
                }
                this.setNegotiatedMapVersionUsing(false);
                this.setMAPVersionTested(newMAPApplicationContextVersion);
                this.mapVersionCache.setMAPApplicationContextVersion(this.getNetworkNode().getGlobalTitle().getDigits(), newMAPApplicationContextVersion);
                try {
                    this.sendMtSms(this.getMtFoSMSMAPApplicationContext(MAPApplicationContextVersion.version1), MessageProcessingState.resendAfterMapProtocolNegotiation, null, smsSet.getNetworkId());
                    return;
                }
                catch (SmscProcessingException e) {
                    String reason = "SmscPocessingException when invoking sendMtSms() from onDialogReject()-resendAfterMapProtocolNegotiation: " + e.toString();
                    this.logger.severe(reason, (Throwable)e);
                    ErrorCode smStatus = ErrorCode.SC_SYSTEM_ERROR;
                    try {
                        smStatus = ErrorCode.fromInt((int)e.getSmppErrorCode());
                    }
                    catch (IllegalArgumentException e1) {
                        // empty catch block
                    }
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
                    return;
                }
                catch (Throwable e) {
                    String reason = "Exception when invoking sendMtSms() from onDialogReject()-resendAfterMapProtocolNegotiation: " + e.toString();
                    this.logger.severe(reason, e);
                    ErrorCode smStatus = ErrorCode.SC_SYSTEM_ERROR;
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
                    return;
                }
            }
            if (mapRefuseReason == MAPRefuseReason.ApplicationContextNotSupported) {
                ApplicationContextName tcapApplicationContextName;
                MAPApplicationContext supportedMAPApplicationContext;
                MAPApplicationContextVersion supportedMAPApplicationContextVersion;
                MAPApplicationContextVersion newMAPApplicationContextVersion;
                String nodeDigits = this.getNetworkNode().getGlobalTitle().getDigits();
                if (this.logger.isWarningEnabled()) {
                    this.logger.warning("Rx : Mt onDialogReject / ApplicationContextNotSupported for node " + nodeDigits + " Event=" + evt);
                }
                if (this.isMAPVersionTested(newMAPApplicationContextVersion = (supportedMAPApplicationContextVersion = (supportedMAPApplicationContext = MAPApplicationContext.getInstance((long[])(tcapApplicationContextName = evt.getAlternativeApplicationContext()).getOid())).getApplicationContextVersion())) && this.isMAPVersionTested(newMAPApplicationContextVersion = MAPApplicationContextVersion.version3) && this.isMAPVersionTested(newMAPApplicationContextVersion = MAPApplicationContextVersion.version2) && this.isMAPVersionTested(newMAPApplicationContextVersion = MAPApplicationContextVersion.version1)) {
                    String reason = "Error condition when invoking sendMtSms() from onDialogReject(). all MAP versions are already tried and DialogReject again suggests Version1";
                    this.logger.severe(reason);
                    ErrorCode smStatus = ErrorCode.MAP_SERVER_VERSION_ERROR;
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
                    return;
                }
                this.setNegotiatedMapVersionUsing(false);
                this.setMAPVersionTested(newMAPApplicationContextVersion);
                this.mapVersionCache.setMAPApplicationContextVersion(this.getNetworkNode().getGlobalTitle().getDigits(), newMAPApplicationContextVersion);
                try {
                    this.sendMtSms(this.getMtFoSMSMAPApplicationContext(newMAPApplicationContextVersion), MessageProcessingState.resendAfterMapProtocolNegotiation, null, smsSet.getNetworkId());
                    return;
                }
                catch (SmscProcessingException e) {
                    String reason = "SmscPocessingException when invoking sendMtSms() from onDialogReject()-resendAfterMapProtocolNegotiation: " + e.toString();
                    this.logger.severe(reason, (Throwable)e);
                    ErrorCode smStatus = ErrorCode.SC_SYSTEM_ERROR;
                    try {
                        smStatus = ErrorCode.fromInt((int)e.getSmppErrorCode());
                    }
                    catch (IllegalArgumentException e1) {
                        // empty catch block
                    }
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
                    return;
                }
                catch (Throwable e) {
                    String reason = "Exception when invoking sendMtSms() from onDialogReject()-resendAfterMapProtocolNegotiation: " + e.toString();
                    this.logger.severe(reason, e);
                    ErrorCode smStatus = ErrorCode.SC_SYSTEM_ERROR;
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
                    return;
                }
            }
            super.onDialogReject(evt, aci);
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.MSC_REFUSES_SM, "onDialogReject after MT Request: " + mapRefuseReason != null ? mapRefuseReason.toString() : "", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onDialogReject() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogProviderAbort(DialogProviderAbort evt, ActivityContextInterface aci) {
        try {
            super.onDialogProviderAbort(evt, aci);
            MAPAbortProviderReason abortProviderReason = evt.getAbortProviderReason();
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onDialogProviderAbort()");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.onDialogProviderAbort(), targetId=" + targetId);
                return;
            }
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.MSC_REFUSES_SM, "onDialogProviderAbort after MtForwardSM Request: " + abortProviderReason != null ? abortProviderReason.toString() : "", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onDialogProviderAbort() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogUserAbort(DialogUserAbort evt, ActivityContextInterface aci) {
        try {
            super.onDialogUserAbort(evt, aci);
            String reason = this.getUserAbortReason(evt);
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onDialogUserAbort()");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.onDialogUserAbort(), targetId=" + targetId);
                return;
            }
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.MSC_REFUSES_SM, "onDialogUserAbort after MtForwardSM Request: " + reason != null ? reason.toString() : "", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onDialogUserAbort() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        try {
            super.onDialogTimeout(evt, aci);
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onDialogTimeout()");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.onDialogTimeout(), targetId=" + targetId);
                return;
            }
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.temporaryFailure, ErrorCode.MSC_REFUSES_SM, "onDialogTimeout after MtForwardSM Request", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onDialogTimeout() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogDelimiter(DialogDelimiter evt, ActivityContextInterface aci) {
        try {
            super.onDialogDelimiter(evt, aci);
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onDialogDelimiter()");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.warning("In SmsDeliveryData CMP smsSet is missed - MtSbb.onDialogDelimiter(), targetId=" + targetId);
                return;
            }
            if (this.getTcEmptySent() != 0) {
                SmsSignalInfo si;
                this.setTcEmptySent(0);
                SmsSignalInfo[] segments = this.getSegments();
                int messageSegmentNumber = this.getMessageSegmentNumber();
                if (messageSegmentNumber >= 0 && segments != null && messageSegmentNumber < segments.length && (si = segments[messageSegmentNumber]) != null) {
                    try {
                        MAPDialogSms mapDialogSms = (MAPDialogSms)evt.getMAPDialog();
                        SM_RP_DA sm_RP_DA = this.getSmRpDa();
                        SM_RP_OA sm_RP_OA = this.getSmRpOa();
                        boolean moreMessagesToSend = false;
                        if (messageSegmentNumber < segments.length - 1) {
                            moreMessagesToSend = true;
                        }
                        if (this.doGetCurrentMsgNum() < smsSet.getSmsCount() - 1L) {
                            moreMessagesToSend = true;
                        }
                        switch (mapDialogSms.getApplicationContext().getApplicationContextVersion()) {
                            case version3: {
                                mapDialogSms.addMtForwardShortMessageRequest(sm_RP_DA, sm_RP_OA, si, moreMessagesToSend, null);
                                if (!this.logger.isInfoEnabled()) break;
                                this.logger.info("\nSending: MtForwardShortMessageRequest: sm_RP_DA=" + sm_RP_DA + ", sm_RP_OA=" + sm_RP_OA + ", si=" + si + ", moreMessagesToSend=" + moreMessagesToSend);
                                break;
                            }
                            case version2: 
                            case version1: {
                                mapDialogSms.addForwardShortMessageRequest(sm_RP_DA, sm_RP_OA, si, moreMessagesToSend);
                                if (!this.logger.isInfoEnabled()) break;
                                this.logger.info("\nSending: ForwardShortMessageRequest: sm_RP_DA=" + sm_RP_DA + ", sm_RP_OA=" + sm_RP_OA + ", si=" + si + ", moreMessagesToSend=" + moreMessagesToSend);
                                break;
                            }
                        }
                        mapDialogSms.send();
                    }
                    catch (MAPException e) {
                        this.logger.severe("Error while trying to send MtForwardShortMessageRequest", (Throwable)e);
                    }
                }
            } else if (this.getResponseReceived() == 1) {
                this.setResponseReceived(0);
                this.handleSmsResponse((MAPDialogSms)evt.getMAPDialog(), true);
            }
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onDialogDelimiter() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogClose(DialogClose evt, ActivityContextInterface aci) {
        try {
            super.onDialogClose(evt, aci);
            if (this.getResponseReceived() == 1) {
                this.setResponseReceived(0);
                this.handleSmsResponse((MAPDialogSms)evt.getMAPDialog(), false);
            } else {
                SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
                if (smsDeliveryData == null) {
                    this.logger.severe("smsDeliveryData CMP is missed - MtSbb.onDialogClose()");
                    return;
                }
                String targetId = smsDeliveryData.getTargetId();
                SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
                if (smsSet == null) {
                    this.logger.info("In SmsDeliveryData CMP smsSet is missed - MtSbb.onDialogClose(), targetId=" + targetId);
                    return;
                }
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "DialogClose after Mt Request", false, null, false);
            }
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in MtSbb.onDialogClose() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    public void onForwardShortMessageRequest(ForwardShortMessageRequest evt, ActivityContextInterface aci) {
        this.logger.severe("\nReceived FORWARD_SHORT_MESSAGE_REQUEST = " + evt);
    }

    public void onForwardShortMessageResponse(ForwardShortMessageResponse evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived FORWARD_SHORT_MESSAGE_RESPONSE = " + evt);
        }
        this.setResponseReceived(1);
    }

    public void onMtForwardShortMessageRequest(MtForwardShortMessageRequest evt, ActivityContextInterface aci) {
        this.logger.severe("\nReceived MT_FORWARD_SHORT_MESSAGE_REQUEST = " + evt);
    }

    public void onMtForwardShortMessageResponse(MtForwardShortMessageResponse evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived MT_FORWARD_SHORT_MESSAGE_RESPONSE = " + evt);
        }
        this.setResponseReceived(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupMtForwardShortMessageRequest(ISDNAddressString networkNode, String imsiData, LMSI lmsi, int networkId) {
        SmsSubmitData smsDeliveryData;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nmperforming setupMtForwardShortMessageRequest ISDNAddressString= " + networkNode);
        }
        if ((smsDeliveryData = this.doGetSmsSubmitData()) == null) {
            this.logger.severe("smsDeliveryData CMP is missed - MtSbb.setupMtForwardShortMessageRequest()");
            return;
        }
        String targetId = smsDeliveryData.getTargetId();
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.setupMtForwardShortMessageRequest(), targetId=" + targetId);
            return;
        }
        SccpAddress networkNodeSccpAddress = this.getMSCSccpAddress(networkNode);
        IMSI imsi = this.mapParameterFactory.createIMSI(imsiData);
        SM_RP_DA sm_RP_DA = this.mapParameterFactory.createSM_RP_DA(imsi);
        SM_RP_OA sm_RP_OA = this.mapParameterFactory.createSM_RP_OA_ServiceCentreAddressOA(this.getServiceCenterAddressString(networkId));
        this.setNnn(networkNode);
        this.setNetworkNode(networkNodeSccpAddress);
        this.setSmRpDa(sm_RP_DA);
        this.setSmRpOa(sm_RP_OA);
        MAPApplicationContextVersion mapApplicationContextVersion = this.mapVersionCache.getMAPApplicationContextVersion(networkNode.getAddress());
        if (mapApplicationContextVersion == null) {
            mapApplicationContextVersion = MAPApplicationContextVersion.getInstance((long)smscPropertiesManagement.getMaxMapVersion());
        } else {
            this.setNegotiatedMapVersionUsing(true);
        }
        this.setMAPVersionTested(mapApplicationContextVersion);
        boolean noMoreMessages = false;
        PersistenceRAInterface pers = this.getStore();
        TargetAddress lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                long currentMsgNum = this.doGetCurrentMsgNum();
                Sms sms = smsSet.getSms(currentMsgNum);
                if (sms != null) {
                    MProcResult mProcResult;
                    while ((mProcResult = MProcManagement.getInstance().applyMProcImsiRequest(sms, imsiData, networkNode.getAddress(), networkNode.getNumberingPlan().getIndicator(), networkNode.getAddressNature().getIndicator())).isMessageDropped()) {
                        this.onImsiDrop(sms, imsiData, networkNode);
                        if (currentMsgNum < smsSet.getSmsCount() - 1L) {
                            this.doSetCurrentMsgNum(++currentMsgNum);
                            sms = smsSet.getSms(currentMsgNum);
                            if (sms != null) continue;
                            break;
                        }
                        noMoreMessages = true;
                        this.freeSmsSetSucceded(smsSet, pers);
                        break;
                    }
                }
            }
        }
        finally {
            pers.releaseSynchroObject(lock);
        }
        if (noMoreMessages) {
            this.setupReportSMDeliveryStatusRequestSuccess(smsSet, true);
        } else {
            try {
                this.sendMtSms(this.getMtFoSMSMAPApplicationContext(mapApplicationContextVersion), MessageProcessingState.firstMessageSending, null, smsSet.getNetworkId());
            }
            catch (SmscProcessingException e) {
                String reason = "SmscPocessingException when invoking sendMtSms() from setupMtForwardShortMessageRequest()-firstMessageSending: " + e.toString();
                this.logger.severe(reason, (Throwable)e);
                ErrorCode smStatus = ErrorCode.SC_SYSTEM_ERROR;
                try {
                    smStatus = ErrorCode.fromInt((int)e.getSmppErrorCode());
                }
                catch (IllegalArgumentException e1) {
                    // empty catch block
                }
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
            }
            catch (Throwable e) {
                String reason = "Exception when invoking sendMtSms() from setupMtForwardShortMessageRequest()-firstMessageSending: " + e.toString();
                this.logger.severe(reason, e);
                ErrorCode smStatus = ErrorCode.SC_SYSTEM_ERROR;
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
            }
        }
    }

    @Override
    public void setupReportSMDeliveryStatusRequest(String destinationAddress, int ton, int npi, SMDeliveryOutcome sMDeliveryOutcome, String targetId, int networkId) {
        SbbLocalObjectExt sbbLocalObject = this.sbbContext.getSbbLocalObject().getParent();
        SriSbbLocalObject sriSbb = (SriSbbLocalObject)sbbLocalObject;
        sriSbb.setupReportSMDeliveryStatusRequest(destinationAddress, ton, npi, sMDeliveryOutcome, targetId, networkId);
    }

    public abstract void setSmsSubmitData(SmsSubmitData var1);

    public abstract SmsSubmitData getSmsSubmitData();

    public abstract void setCurrentMsgNum(long var1);

    public abstract long getCurrentMsgNum();

    public abstract void setInformServiceCenterContainer(InformServiceCenterContainer var1);

    public abstract InformServiceCenterContainer getInformServiceCenterContainer();

    public abstract void setTcEmptySent(int var1);

    public abstract int getTcEmptySent();

    public abstract void setResponseReceived(int var1);

    public abstract int getResponseReceived();

    public abstract int getMapApplicationContextVersionsUsed();

    public abstract void setMapApplicationContextVersionsUsed(int var1);

    @Override
    public void doSetSmsSubmitData(SmsSubmitData smsDeliveryData) {
        this.setSmsSubmitData(smsDeliveryData);
    }

    @Override
    public SmsSubmitData doGetSmsSubmitData() {
        return this.getSmsSubmitData();
    }

    @Override
    public void doSetCurrentMsgNum(long currentMsgNum) {
        this.setCurrentMsgNum(currentMsgNum);
    }

    @Override
    public long doGetCurrentMsgNum() {
        return this.getCurrentMsgNum();
    }

    @Override
    public void doSetInformServiceCenterContainer(InformServiceCenterContainer informServiceCenterContainer) {
        this.setInformServiceCenterContainer(informServiceCenterContainer);
    }

    @Override
    public InformServiceCenterContainer doGetInformServiceCenterContainer() {
        return this.getInformServiceCenterContainer();
    }

    public abstract void setNnn(ISDNAddressString var1);

    public abstract ISDNAddressString getNnn();

    public abstract void setMessageSegmentNumber(int var1);

    public abstract int getMessageSegmentNumber();

    public abstract void setSegments(SmsSignalInfo[] var1);

    public abstract SmsSignalInfo[] getSegments();

    public abstract void setSmRpDa(SM_RP_DA var1);

    public abstract SM_RP_DA getSmRpDa();

    public abstract void setSmRpOa(SM_RP_OA var1);

    public abstract SM_RP_OA getSmRpOa();

    public abstract void setNetworkNode(SccpAddress var1);

    public abstract SccpAddress getNetworkNode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleSmsResponse(MAPDialogSms mapDialogSms, boolean continueDialog) {
        block68: {
            block66: {
                smsDeliveryData = this.doGetSmsSubmitData();
                if (smsDeliveryData == null) {
                    this.logger.severe("SmsDeliveryData CMP missed");
                    return;
                }
                targetId = smsDeliveryData.getTargetId();
                smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
                if (smsSet == null) {
                    this.logger.severe("In SmsDeliveryData CMP smsSet is missed - MtSbb.handleSmsResponse(), targetId=" + targetId);
                    return;
                }
                this.smscStatAggregator.updateMsgOutSentAll();
                this.smscStatAggregator.updateMsgOutSentSs7();
                pers = this.getStore();
                currentMsgNum = this.doGetCurrentMsgNum();
                sms = smsSet.getSms(currentMsgNum);
                messageSegmentNumber = this.getMessageSegmentNumber();
                segments = this.getSegments();
                if (segments != null && messageSegmentNumber < segments.length - 1) {
                    CdrGenerator.generateCdr((Sms)sms, (String)"partial", (String)"", (boolean)MtSbb.smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)MtSbb.smscPropertiesManagement.getGenerateCdr()));
                    this.setMessageSegmentNumber(++messageSegmentNumber);
                    try {
                        this.smscStatAggregator.updateMsgOutTryAll();
                        this.smscStatAggregator.updateMsgOutTrySs7();
                        this.sendMtSms(mapDialogSms.getApplicationContext(), MessageProcessingState.nextSegmentSending, (MAPDialogSms)(continueDialog != false ? mapDialogSms : null), smsSet.getNetworkId());
                        return;
                    }
                    catch (SmscProcessingException e) {
                        this.logger.severe("SmscPocessingException when invoking sendMtSms() from handleSmsResponse()-nextSegmentSending: " + e.toString(), (Throwable)e);
                        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.temporaryFailure, ErrorCode.SYSTEM_FAILURE, "Error sendMtSms in handleSmsResponse(): ", true, null, false);
                        return;
                    }
                }
                if (sms.getMessageDeliveryResultResponse() != null) {
                    sms.getMessageDeliveryResultResponse().responseDeliverySuccess();
                    sms.setMessageDeliveryResultResponse(null);
                }
                deliveryDate = new Date();
                try {
                    isPartial = MessageUtil.isSmsNotLastSegment((Sms)sms);
                    CdrGenerator.generateCdr((Sms)sms, (String)(isPartial != false ? "partial" : "success"), (String)"", (boolean)MtSbb.smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)MtSbb.smscPropertiesManagement.getGenerateCdr()));
                    if (MtSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.archiveDeliveredSms(sms, deliveryDate);
                    } else {
                        pers.c2_updateInSystem(sms, 2, MtSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
                        sms.setDeliveryDate(deliveryDate);
                        sms.getSmsSet().setStatus(ErrorCode.SUCCESS);
                        if (MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)MtSbb.smscPropertiesManagement.getGenerateArchiveTable())) {
                            pers.c2_createRecordArchive(sms);
                        }
                    }
                    mProcResult = MProcManagement.getInstance().applyMProcDelivery(sms, false);
                    addedMessages = mProcResult.getMessageList();
                    if (addedMessages != null) {
                        n = addedMessages.head();
                        end = addedMessages.tail();
                        while ((n = n.getNext()) != end) {
                            smst = (Sms)n.getValue();
                            ta = new TargetAddress(smst.getSmsSet().getDestAddrTon(), smst.getSmsSet().getDestAddrNpi(), smst.getSmsSet().getDestAddr(), smst.getSmsSet().getNetworkId());
                            lock = SmsSetCache.getInstance().addSmsSet(ta);
                            try {
                                var21_30 = lock;
                                synchronized (var21_30) {
                                    if (MtSbb.smscPropertiesManagement.getDatabaseType() != DatabaseType.Cassandra_1) {
                                        storeAndForwMode = MessageUtil.isStoreAndForward((Sms)smst);
                                        if (!storeAndForwMode) {
                                            try {
                                                this.scheduler.injectSmsOnFly(smst.getSmsSet());
                                            }
                                            catch (Exception e) {
                                                this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages in handleSmsResponse(): " + e.getMessage(), (Throwable)e);
                                            }
                                        } else if (MtSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                            try {
                                                smst.setStoringAfterFailure(true);
                                                this.scheduler.injectSmsOnFly(smst.getSmsSet());
                                            }
                                            catch (Exception e) {
                                                this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages in handleSmsResponse(): " + e.getMessage(), (Throwable)e);
                                            }
                                        } else {
                                            smst.setStored(true);
                                            this.scheduler.setDestCluster(smst.getSmsSet());
                                            pers.c2_scheduleMessage_ReschedDueSlot(smst, MtSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                        }
                                    }
                                }
                            }
                            finally {
                                SmsSetCache.getInstance().removeSmsSet(lock);
                            }
                        }
                    }
                    registeredDelivery = sms.getRegisteredDelivery();
                    if (MtSbb.smscPropertiesManagement.getReceiptsDisabling() || !MessageUtil.isReceiptOnSuccess((int)registeredDelivery)) break block66;
                    ta = new TargetAddress(sms.getSourceAddrTon(), sms.getSourceAddrNpi(), sms.getSourceAddr(), smsSet.getNetworkId());
                    lock = SmsSetCache.getInstance().addSmsSet(ta);
                    try {
                        var19_28 = lock;
                        synchronized (var19_28) {
                            if (MtSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                                receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)true);
                                backSmsSet = pers.obtainSmsSet(ta);
                                receipt.setSmsSet(backSmsSet);
                                receipt.setStored(true);
                                pers.createLiveSms(receipt);
                                pers.setNewMessageScheduled(receipt.getSmsSet(), MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)MtSbb.smscPropertiesManagement.getFirstDueDelay())));
                            } else {
                                receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)true, (TargetAddress)ta, (boolean)MtSbb.smscPropertiesManagement.getOrigNetworkIdForReceipts());
                                storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                                if (!storeAndForwMode) {
                                    try {
                                        this.scheduler.injectSmsOnFly(receipt.getSmsSet());
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in handleSmsResponse(): " + e.getMessage(), (Throwable)e);
                                    }
                                } else if (MtSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                    try {
                                        receipt.setStoringAfterFailure(true);
                                        this.scheduler.injectSmsOnFly(receipt.getSmsSet());
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in handleSmsResponse(): " + e.getMessage(), (Throwable)e);
                                    }
                                } else {
                                    receipt.setStored(true);
                                    this.scheduler.setDestCluster(receipt.getSmsSet());
                                    pers.c2_scheduleMessage_ReschedDueSlot(receipt, MtSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                }
                            }
                            this.logger.info("Adding a delivery receipt: source=" + receipt.getSourceAddr() + ", dest=" + receipt.getSmsSet().getDestAddr());
                        }
                    }
                    finally {
                        SmsSetCache.getInstance().removeSmsSet(lock);
                    }
                }
                catch (PersistenceException e1) {
                    this.logger.severe("PersistenceException when archiveDeliveredSms() in handleSmsResponse(): " + e1.getMessage(), (Throwable)e1);
                }
            }
            lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
            var14_16 = lock;
            synchronized (var14_16) {
                smsSet.markSmsAsDelivered(currentMsgNum);
                moreMessages = false;
                if (currentMsgNum < smsSet.getSmsCount() - 1L) {
                    moreMessages = true;
                    this.doSetCurrentMsgNum(++currentMsgNum);
                    sms = smsSet.getSms(currentMsgNum);
                    if (sms != null) {
                        block67: {
                            while (true) {
                                da = this.getSmRpDa();
                                networkNodeNumber = this.getNnn();
                                mProcResult = MProcManagement.getInstance().applyMProcImsiRequest(sms, da.getIMSI().getData(), networkNodeNumber.getAddress(), networkNodeNumber.getNumberingPlan().getIndicator(), networkNodeNumber.getAddressNature().getIndicator());
                                if (!mProcResult.isMessageDropped()) break block67;
                                this.onImsiDrop(sms, da.getIMSI().getData(), networkNodeNumber);
                                if (currentMsgNum >= smsSet.getSmsCount() - 1L) break;
                                this.doSetCurrentMsgNum(++currentMsgNum);
                                sms = smsSet.getSms(currentMsgNum);
                                if (sms != null) {
                                    if (MtSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                                        this.startMessageDelivery(sms);
                                        continue;
                                    }
                                    sms.setDeliveryCount(sms.getDeliveryCount() + 1);
                                    continue;
                                }
                                break block67;
                                break;
                            }
                            moreMessages = false;
                        }
                        if (MtSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                            this.startMessageDelivery(sms);
                        } else {
                            sms.setDeliveryCount(sms.getDeliveryCount() + 1);
                        }
                    }
                }
                if (!moreMessages) ** GOTO lbl-1000
                try {
                    this.smscStatAggregator.updateMsgOutTryAll();
                    this.smscStatAggregator.updateMsgOutTrySs7();
                    this.sendMtSms(mapDialogSms.getApplicationContext(), MessageProcessingState.firstMessageSending, (MAPDialogSms)(continueDialog != false ? mapDialogSms : null), smsSet.getNetworkId());
                }
                catch (SmscProcessingException e) {
                    this.logger.severe("SmscPocessingException when invoking sendMtSms() from handleSmsResponse(): " + e.toString(), (Throwable)e);
                }
            }
            {
                catch (Throwable var29_40) {
                    throw var29_40;
                }
            }
            pers.releaseSynchroObject(lock);
            return;
lbl-1000:
            // 2 sources

            {
                if (MtSbb.smscPropertiesManagement.getDatabaseType() != DatabaseType.Cassandra_1) ** GOTO lbl186
                try {
                    pers.fetchSchedulableSms(smsSet, true);
                }
                catch (PersistenceException e1) {
                    this.logger.severe("PersistenceException when invoking fetchSchedulableSms(smsSet) from handleSmsResponse(): " + e1.toString(), (Throwable)e1);
                }
                if (smsSet.getSmsCount() <= 0L) ** GOTO lbl186
                currentMsgNum = 0L;
                this.doSetCurrentMsgNum(currentMsgNum);
                try {
                    this.smscStatAggregator.updateMsgOutTryAll();
                    this.smscStatAggregator.updateMsgOutTrySs7();
                    this.sendMtSms(mapDialogSms.getApplicationContext(), MessageProcessingState.firstMessageSending, (MAPDialogSms)(continueDialog != false ? mapDialogSms : null), smsSet.getNetworkId());
                }
                catch (SmscProcessingException e) {
                    try {
                        this.logger.severe("SmscPocessingException when invoking sendMtSms() from handleSmsResponse(): " + e.toString(), (Throwable)e);
lbl186:
                        // 3 sources

                        if (continueDialog) {
                            try {
                                mapDialogSms.close(false);
                            }
                            catch (MAPException e) {
                                this.logger.severe("MAPException when closing MAP dialog from handleSmsResponse(): " + e.toString(), (Throwable)e);
                            }
                        }
                        this.freeSmsSetSucceded(smsSet, pers);
                        break block68;
                    }
                    finally {
                        pers.releaseSynchroObject(lock);
                    }
                }
            }
            pers.releaseSynchroObject(lock);
            return;
        }
        this.setupReportSMDeliveryStatusRequestSuccess(smsSet, mapDialogSms.getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1);
    }

    private void setupReportSMDeliveryStatusRequestSuccess(SmsSet smsSet, boolean versionMore1) {
        InformServiceCenterContainer informServiceCenterContainer = this.getInformServiceCenterContainer();
        if (informServiceCenterContainer != null && informServiceCenterContainer.getMwStatus() != null && !informServiceCenterContainer.getMwStatus().getScAddressNotIncluded() && versionMore1) {
            this.setupReportSMDeliveryStatusRequest(smsSet.getDestAddr(), smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), SMDeliveryOutcome.successfulTransfer, smsSet.getTargetId(), smsSet.getNetworkId());
        }
    }

    private String[] sliceMessage(String msg, DataCodingScheme dataCodingScheme, int nationalLanguageLockingShift, int nationalLanguageSingleShift) {
        int lenSolid = MessageUtil.getMaxSolidMessageCharsLength((DataCodingScheme)dataCodingScheme);
        int lenSegmented = MessageUtil.getMaxSegmentedMessageCharsLength((DataCodingScheme)dataCodingScheme);
        UserDataHeader udh = null;
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7 && (nationalLanguageLockingShift > 0 || nationalLanguageSingleShift > 0)) {
            udh = MessageUtil.getNationalLanguageIdentifierUdh((int)nationalLanguageLockingShift, (int)nationalLanguageSingleShift);
            if (nationalLanguageLockingShift > 0) {
                lenSolid -= 3;
                lenSegmented -= 3;
            }
            if (nationalLanguageSingleShift > 0) {
                lenSolid -= 3;
                lenSegmented -= 3;
            }
        }
        int msgLenInChars = msg.length();
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7 && msgLenInChars * 2 > lenSolid) {
            msgLenInChars = UserDataImpl.checkEncodedDataLengthInChars((String)msg, (UserDataHeader)udh);
        }
        if (msgLenInChars <= lenSolid) {
            String[] res = new String[]{msg};
            return res;
        }
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
            String[] res = UserDataImpl.sliceString((String)msg, (int)lenSegmented, (UserDataHeader)udh);
            return res;
        }
        ArrayList<String> res = new ArrayList<String>();
        int segmCnt = (msg.length() - 1) / lenSegmented + 1;
        for (int i1 = 0; i1 < segmCnt; ++i1) {
            if (i1 == segmCnt - 1) {
                res.add(msg.substring(i1 * lenSegmented, msg.length()));
                continue;
            }
            res.add(msg.substring(i1 * lenSegmented, (i1 + 1) * lenSegmented));
        }
        String[] ress = new String[res.size()];
        res.toArray(ress);
        return ress;
    }

    protected SmsSignalInfo createSignalInfo(Sms sms, String msg, byte[] udhData, boolean moreMessagesToSend, int messageReferenceNumber, int messageSegmentCount, int messageSegmentNumber, DataCodingScheme dataCodingScheme, int nationalLanguageLockingShift, int nationalLanguageSingleShift) throws MAPException {
        UserDataHeader userDataHeader;
        if (udhData != null) {
            userDataHeader = this.mapSmsTpduParameterFactory.createUserDataHeader(udhData);
        } else {
            NationalLanguageIdentifier nationalLanguageIdentifier;
            userDataHeader = this.mapSmsTpduParameterFactory.createUserDataHeader();
            if (messageSegmentCount > 1) {
                ConcatenatedShortMessagesIdentifier concatenatedShortMessagesIdentifier = this.mapSmsTpduParameterFactory.createConcatenatedShortMessagesIdentifier(messageReferenceNumber > 255, messageReferenceNumber, messageSegmentCount, messageSegmentNumber);
                userDataHeader.addInformationElement((UserDataHeaderElement)concatenatedShortMessagesIdentifier);
            }
            if (nationalLanguageLockingShift > 0 && (nationalLanguageIdentifier = NationalLanguageIdentifier.getInstance((int)nationalLanguageLockingShift)) != null) {
                NationalLanguageLockingShiftIdentifier nationalLanguageLockingShiftEl = this.mapSmsTpduParameterFactory.createNationalLanguageLockingShiftIdentifier(nationalLanguageIdentifier);
                userDataHeader.addInformationElement((UserDataHeaderElement)nationalLanguageLockingShiftEl);
            }
            if (nationalLanguageSingleShift > 0 && (nationalLanguageIdentifier = NationalLanguageIdentifier.getInstance((int)nationalLanguageSingleShift)) != null) {
                NationalLanguageSingleShiftIdentifier nationalLanguageSingleShiftEl = this.mapSmsTpduParameterFactory.createNationalLanguageSingleShiftIdentifier(nationalLanguageIdentifier);
                userDataHeader.addInformationElement((UserDataHeaderElement)nationalLanguageSingleShiftEl);
            }
        }
        UserData ud = this.mapSmsTpduParameterFactory.createUserData(msg, dataCodingScheme, userDataHeader, isoCharset);
        Date submitDate = sms.getSubmitDate();
        AbsoluteTimeStamp serviceCentreTimeStamp = this.mapSmsTpduParameterFactory.createAbsoluteTimeStamp(submitDate.getYear() % 100, submitDate.getMonth() + 1, submitDate.getDate(), submitDate.getHours(), submitDate.getMinutes(), submitDate.getSeconds(), submitDate.getTimezoneOffset() / 15);
        SmsDeliverTpdu smsDeliverTpdu = this.mapSmsTpduParameterFactory.createSmsDeliverTpdu(moreMessagesToSend, false, (sms.getEsmClass() & 0xFFFFFF80) != 0, false, this.getSmsTpduOriginatingAddress(sms.getSourceAddrTon(), sms.getSourceAddrNpi(), sms.getSourceAddr()), this.mapSmsTpduParameterFactory.createProtocolIdentifier(sms.getProtocolId()), serviceCentreTimeStamp, ud);
        SmsSignalInfo smsSignalInfo = this.mapParameterFactory.createSmsSignalInfo((SmsTpdu)smsDeliverTpdu, isoCharset);
        return smsSignalInfo;
    }

    private void sendMtSms(MAPApplicationContext mapApplicationContext, MessageProcessingState messageProcessingState, MAPDialogSms mapDialogSms, int networkId) throws SmscProcessingException {
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        if (smsDeliveryData == null) {
            throw new SmscProcessingException("SmsDeliveryData CMP missed", -1, -1, null);
        }
        String targetId = smsDeliveryData.getTargetId();
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            throw new SmscProcessingException("SmsSet is missed in ProcessingSmsSet cashe", -1, -1, null);
        }
        long msgNum = this.doGetCurrentMsgNum();
        Sms sms = smsSet.getSms(msgNum);
        if (sms == null) {
            throw new SmscProcessingException("SmsDeliveryData-sms is missed in CMP", -1, -1, null);
        }
        boolean moreMessagesToSend = false;
        if (msgNum < smsSet.getSmsCount() - 1L) {
            moreMessagesToSend = true;
        }
        try {
            SmsSignalInfo smsSignalInfo;
            boolean newDialog = false;
            if (mapDialogSms == null) {
                newDialog = true;
                mapDialogSms = this.mapProvider.getMAPServiceSms().createNewDialog(mapApplicationContext, this.getServiceCenterSccpAddress(networkId), null, this.getNetworkNode(), null);
                mapDialogSms.setNetworkId(networkId);
                ActivityContextInterface mtFOSmsDialogACI = this.mapAcif.getActivityContextInterface((MAPDialog)mapDialogSms);
                mtFOSmsDialogACI.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            }
            SM_RP_DA sm_RP_DA = this.getSmRpDa();
            SM_RP_OA sm_RP_OA = this.getSmRpOa();
            if (messageProcessingState == MessageProcessingState.firstMessageSending) {
                SmsSignalInfo[] segments;
                DataCodingScheme dataCodingScheme = this.mapSmsTpduParameterFactory.createDataCodingScheme(sms.getDataCoding());
                Tlv sarMsgRefNum = sms.getTlvSet().getOptionalParameter((short)524);
                Tlv sarTotalSegments = sms.getTlvSet().getOptionalParameter((short)526);
                Tlv sarSegmentSeqnum = sms.getTlvSet().getOptionalParameter((short)527);
                if ((sms.getEsmClass() & 0x40) != 0) {
                    segments = new SmsSignalInfo[]{this.createSignalInfo(sms, sms.getShortMessageText(), sms.getShortMessageBin(), moreMessagesToSend, 0, 1, 1, dataCodingScheme, 0, 0)};
                } else if (sarMsgRefNum != null && sarTotalSegments != null && sarSegmentSeqnum != null) {
                    short messageSegmentCount = sarTotalSegments.getValueAsUnsignedByte();
                    short messageSegmentNumber = sarSegmentSeqnum.getValueAsUnsignedByte();
                    int messageReferenceNumber = sarMsgRefNum.getValueAsUnsignedShort();
                    segments = new SmsSignalInfo[]{this.createSignalInfo(sms, sms.getShortMessageText(), null, moreMessagesToSend, messageReferenceNumber, messageSegmentCount, messageSegmentNumber, dataCodingScheme, sms.getNationalLanguageLockingShift(), sms.getNationalLanguageSingleShift())};
                } else {
                    String[] segmentsByte = this.sliceMessage(sms.getShortMessageText(), dataCodingScheme, sms.getNationalLanguageLockingShift(), sms.getNationalLanguageSingleShift());
                    segments = new SmsSignalInfo[segmentsByte.length];
                    int messageReferenceNumber = (int)(msgNum + 1L);
                    for (int i1 = 0; i1 < segmentsByte.length; ++i1) {
                        segments[i1] = this.createSignalInfo(sms, segmentsByte[i1], null, i1 < segmentsByte.length - 1 ? true : moreMessagesToSend, messageReferenceNumber, segmentsByte.length, i1 + 1, dataCodingScheme, sms.getNationalLanguageLockingShift(), sms.getNationalLanguageSingleShift());
                    }
                }
                this.setSegments(segments);
                smsSignalInfo = segments[0];
                this.setMessageSegmentNumber(0);
                if (segments.length > 1) {
                    moreMessagesToSend = true;
                }
            } else {
                int messageSegmentNumber = this.getMessageSegmentNumber();
                SmsSignalInfo[] segments = this.getSegments();
                smsSignalInfo = segments[messageSegmentNumber];
                if (messageSegmentNumber < segments.length - 1) {
                    moreMessagesToSend = true;
                }
            }
            long invokeId = 0L;
            switch (mapDialogSms.getApplicationContext().getApplicationContextVersion()) {
                case version3: {
                    invokeId = mapDialogSms.addMtForwardShortMessageRequest(sm_RP_DA, sm_RP_OA, smsSignalInfo, moreMessagesToSend, null);
                    if (!this.logger.isInfoEnabled()) break;
                    this.logger.info("\nSending: MtForwardShortMessageRequest: sm_RP_DA=" + sm_RP_DA + ", sm_RP_OA=" + sm_RP_OA + ", si=" + smsSignalInfo + ", moreMessagesToSend=" + moreMessagesToSend);
                    break;
                }
                case version2: 
                case version1: {
                    invokeId = mapDialogSms.addForwardShortMessageRequest(sm_RP_DA, sm_RP_OA, smsSignalInfo, moreMessagesToSend);
                    if (!this.logger.isInfoEnabled()) break;
                    this.logger.info("\nSending: ForwardShortMessageRequest: sm_RP_DA=" + sm_RP_DA + ", sm_RP_OA=" + sm_RP_OA + ", si=" + smsSignalInfo + ", moreMessagesToSend=" + moreMessagesToSend);
                    break;
                }
            }
            int messageUserDataLengthOnSend = mapDialogSms.getMessageUserDataLengthOnSend();
            int maxUserDataLength = mapDialogSms.getMaxUserDataLength();
            if (mapDialogSms.getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1 && newDialog && messageUserDataLengthOnSend >= maxUserDataLength - SmscPropertiesManagement.getInstance().getMaxMessageLengthReducer()) {
                mapDialogSms.cancelInvocation(Long.valueOf(invokeId));
                this.setTcEmptySent(1);
            } else {
                this.setTcEmptySent(0);
            }
            mapDialogSms.send();
        }
        catch (MAPException e) {
            if (mapDialogSms != null) {
                mapDialogSms.release();
            }
            throw new SmscProcessingException("MAPException when sending MtForwardSM. \nSms=" + sms, -1, -1, null, (Throwable)e);
        }
        catch (TlvConvertException e) {
            if (mapDialogSms != null) {
                mapDialogSms.release();
            }
            throw new SmscProcessingException("TlvConvertException when sending MtForwardSM", -1, -1, null, (Throwable)e);
        }
    }

    private MAPApplicationContext getMtFoSMSMAPApplicationContext(MAPApplicationContextVersion mapApplicationContextVersion) {
        if (mapApplicationContextVersion == MAPApplicationContextVersion.version1) {
            return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgMORelayContext, (MAPApplicationContextVersion)mapApplicationContextVersion);
        }
        return MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgMTRelayContext, (MAPApplicationContextVersion)mapApplicationContextVersion);
    }

    private SccpAddress getMSCSccpAddress(ISDNAddressString networkNodeNumber) {
        return MessageUtil.getSccpAddress((ParameterFactory)this.sccpParameterFact, (String)networkNodeNumber.getAddress(), (int)networkNodeNumber.getAddressNature().getIndicator(), (int)networkNodeNumber.getNumberingPlan().getIndicator(), (int)smscPropertiesManagement.getMscSsn(), (GlobalTitleIndicator)smscPropertiesManagement.getGlobalTitleIndicator(), (int)smscPropertiesManagement.getTranslationType());
    }

    private AddressField getSmsTpduOriginatingAddress(int ton, int npi, String address) {
        return this.mapSmsTpduParameterFactory.createAddressField(TypeOfNumber.getInstance((int)ton), NumberingPlanIdentification.getInstance((int)npi), address);
    }

    protected boolean isNegotiatedMapVersionUsing() {
        int existingVersionsTried = this.getMapApplicationContextVersionsUsed();
        return (existingVersionsTried & 0x80) != 0;
    }

    protected void setNegotiatedMapVersionUsing(boolean val) {
        int existingVersionsTried = this.getMapApplicationContextVersionsUsed();
        existingVersionsTried = val ? (existingVersionsTried |= 0x80) : (existingVersionsTried &= 0x7F);
        this.setMapApplicationContextVersionsUsed(existingVersionsTried);
    }

    protected boolean isMAPVersionTested(MAPApplicationContextVersion vers) {
        if (vers == null) {
            return false;
        }
        int existingVersionsTried = this.getMapApplicationContextVersionsUsed();
        switch (vers.getVersion()) {
            case 1: {
                return (existingVersionsTried & 1) != 0;
            }
            case 2: {
                return (existingVersionsTried & 2) != 0;
            }
            case 3: {
                return (existingVersionsTried & 4) != 0;
            }
        }
        return false;
    }

    protected void setMAPVersionTested(MAPApplicationContextVersion vers) {
        int existingVersionsTried = this.getMapApplicationContextVersionsUsed();
        switch (vers.getVersion()) {
            case 1: {
                existingVersionsTried |= 1;
                break;
            }
            case 2: {
                existingVersionsTried |= 2;
                break;
            }
            case 3: {
                existingVersionsTried |= 4;
            }
        }
        this.setMapApplicationContextVersionsUsed(existingVersionsTried);
    }

    public static enum MessageProcessingState {
        firstMessageSending,
        nextSegmentSending,
        resendAfterMapProtocolNegotiation;

    }
}

