/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.mt;

import javax.slee.ActivityContextInterface;
import javax.slee.EventContext;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessageAbsentSubscriber;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.protocols.ss7.map.api.service.sms.MWStatus;
import org.mobicents.protocols.ss7.map.api.service.sms.SMDeliveryOutcome;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.slee.ChildRelationExt;
import org.mobicents.slee.resource.map.events.DialogClose;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.RejectComponent;
import org.mobicents.smsc.cassandra.DatabaseType;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.library.CorrelationIdValue;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.SriResponseValue;
import org.mobicents.smsc.slee.resources.persistence.SmsSubmitData;
import org.mobicents.smsc.slee.services.mt.InformServiceCenterContainer;
import org.mobicents.smsc.slee.services.mt.MtCommonSbb;
import org.mobicents.smsc.slee.services.mt.MtSbbLocalObject;
import org.mobicents.smsc.slee.services.mt.ReportSMDeliveryStatusInterface2;
import org.mobicents.smsc.slee.services.mt.RsdsSbbLocalObject;
import org.mobicents.smsc.slee.services.smpp.server.events.SmsSetEvent;

public abstract class SriSbb
extends MtCommonSbb
implements ReportSMDeliveryStatusInterface2 {
    private static final String className = SriSbb.class.getSimpleName();
    protected MAPApplicationContextVersion maxMAPApplicationContextVersion = null;

    public SriSbb() {
        super(className);
    }

    public void onSms(SmsSetEvent event, ActivityContextInterface aci, EventContext eventContext) {
        try {
            if (this.logger.isFineEnabled()) {
                this.logger.fine("\nReceived Submit SMS. event= " + event + "this=" + this);
            }
            this.smscStatAggregator.updateMsgOutTryAll();
            this.smscStatAggregator.updateMsgOutTrySs7();
            SmsSet smsSet = event.getSmsSet();
            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                try {
                    this.getStore().fetchSchedulableSms(smsSet, true);
                }
                catch (PersistenceException e) {
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.temporaryFailure, ErrorCode.SC_SYSTEM_ERROR, "PersistenceException when fetchSchedulableSms(): " + e.getMessage(), true, null, false);
                    return;
                }
            }
            if (smsSet.getDestAddrTon() == 5) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.BAD_TYPE_OF_NUMBER, "TON \"alhpanumerical\" is not supported for as a destination address", true, null, false);
                return;
            }
            int curMsg = 0;
            Sms sms = smsSet.getSms((long)curMsg);
            if (sms == null) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.temporaryFailure, ErrorCode.SUCCESS, "No messages for sending now", true, null, false);
                return;
            }
            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                this.startMessageDelivery(sms);
            } else {
                sms.setDeliveryCount(sms.getDeliveryCount() + 1);
            }
            this.doSetCurrentMsgNum(curMsg);
            SmsSubmitData smsDeliveryData = new SmsSubmitData();
            smsDeliveryData.setTargetId(smsSet.getTargetId());
            this.doSetSmsSubmitData(smsDeliveryData);
            String correlationID = smsSet.getCorrelationId();
            CorrelationIdValue civ = null;
            if (correlationID != null) {
                civ = SmsSetCache.getInstance().getCorrelationIdCacheElement(correlationID);
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("HomeRouting: correlationID=" + correlationID + ", found CorrelationIdValue=" + civ);
                }
            }
            if (civ != null) {
                MWStatus mwStatus = civ.getMwStatus();
                if (mwStatus != null) {
                    InformServiceCenterContainer informServiceCenterContainer = new InformServiceCenterContainer();
                    informServiceCenterContainer.setMwStatus(mwStatus);
                    this.doSetInformServiceCenterContainer(informServiceCenterContainer);
                }
                this.setSriMapVersion(civ.getSriMapVersion());
                this.executeForwardSM(smsSet, civ.getLocationInfoWithLMSI(), civ.getImsi(), smsSet.getNetworkId());
                return;
            }
            String targetID = smsSet.getTargetId();
            SriResponseValue srv = null;
            srv = SmsSetCache.getInstance().getSriResponseValue(targetID);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("SRI requesting: targetID=" + targetID + ", found cached SriResponseValue=" + srv);
            }
            if (srv != null) {
                this.setSriMapVersion(3);
                this.executeForwardSM(smsSet, srv.getLocationInfoWithLMSI(), srv.getImsi(), smsSet.getNetworkId());
                return;
            }
            this.sendSRI(smsSet, smsSet.getDestAddr(), smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), this.getSRIMAPApplicationContext(this.maxMAPApplicationContextVersion));
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onSms when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        super.onErrorComponent(event, aci);
        try {
            MAPErrorMessageAbsentSubscriber errAs;
            Boolean mwdSet;
            MAPErrorMessage mapErrorMessage = event.getMAPErrorMessage();
            this.setErrorResponse(mapErrorMessage);
            if (mapErrorMessage.isEmAbsentSubscriber() && (mwdSet = (errAs = mapErrorMessage.getEmAbsentSubscriber()).getMwdSet()) != null && mwdSet.booleanValue()) {
                InformServiceCenterContainer informServiceCenterContainer = new InformServiceCenterContainer();
                MWStatus mwStatus = event.getMAPDialog().getService().getMAPProvider().getMAPParameterFactory().createMWStatus(false, true, false, false);
                informServiceCenterContainer.setMwStatus(mwStatus);
                this.doSetInformServiceCenterContainer(informServiceCenterContainer);
            }
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onErrorComponent when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        super.onRejectComponent(event, aci);
        String reason = this.getRejectComponentReason(event);
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        if (smsDeliveryData == null) {
            this.logger.severe("SmsDeliveryData CMP missed");
            return;
        }
        String targetId = smsDeliveryData.getTargetId();
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            this.logger.severe("In SmsDeliveryData CMP smsSet is missed - SriSbb.onRejectComponent(), targetId=" + targetId);
            return;
        }
        this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "onRejectComponent after SRI Request: " + reason != null ? reason.toString() : "", true, null, false);
    }

    @Override
    public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
        try {
            MAPRefuseReason mapRefuseReason = evt.getRefuseReason();
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("SmsDeliveryData CMP missed");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - SriSbb.onDialogReject(), targetId=" + targetId);
                return;
            }
            if (mapRefuseReason == MAPRefuseReason.PotentialVersionIncompatibility && evt.getMAPDialog().getApplicationContext().getApplicationContextVersion() != MAPApplicationContextVersion.version1) {
                if (this.logger.isWarningEnabled()) {
                    this.logger.warning("Rx : Sri onDialogReject / PotentialVersionIncompatibility=" + evt);
                }
                this.sendSRI(smsSet, smsSet.getDestAddr(), smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), this.getSRIMAPApplicationContext(MAPApplicationContextVersion.version1));
                return;
            }
            if (mapRefuseReason == MAPRefuseReason.ApplicationContextNotSupported) {
                if (this.logger.isWarningEnabled()) {
                    this.logger.warning("Rx : Sri onDialogReject / ApplicationContextNotSupported=" + evt);
                }
                ApplicationContextName tcapApplicationContextName = evt.getAlternativeApplicationContext();
                MAPApplicationContext supportedMAPApplicationContext = MAPApplicationContext.getInstance((long[])tcapApplicationContextName.getOid());
                this.sendSRI(smsSet, smsSet.getDestAddr(), smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), this.getSRIMAPApplicationContext(supportedMAPApplicationContext.getApplicationContextVersion()));
                return;
            }
            super.onDialogReject(evt, aci);
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "onDialogReject after SRI Request: " + mapRefuseReason != null ? mapRefuseReason.toString() : "", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogReject() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogProviderAbort(DialogProviderAbort evt, ActivityContextInterface aci) {
        try {
            super.onDialogProviderAbort(evt, aci);
            MAPAbortProviderReason abortProviderReason = evt.getAbortProviderReason();
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("SmsDeliveryData CMP missed");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - SriSbb.onDialogProviderAbort(), targetId=" + targetId);
                return;
            }
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "onDialogProviderAbort after SRI Request: " + abortProviderReason != null ? abortProviderReason.toString() : "", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogProviderAbort() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogUserAbort(DialogUserAbort evt, ActivityContextInterface aci) {
        try {
            super.onDialogUserAbort(evt, aci);
            String reason = this.getUserAbortReason(evt);
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("SmsDeliveryData CMP missed");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - SriSbb.onDialogUserAbort(), targetId=" + targetId);
                return;
            }
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "onDialogUserAbort after SRI Request: " + reason != null ? reason.toString() : "", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogUserAbort() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        try {
            super.onDialogTimeout(evt, aci);
            SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
            if (smsDeliveryData == null) {
                this.logger.severe("SmsDeliveryData CMP missed");
                return;
            }
            String targetId = smsDeliveryData.getTargetId();
            SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
            if (smsSet == null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - SriSbb.onDialogTimeout(), targetId=" + targetId);
                return;
            }
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.temporaryFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "onDialogTimeout after SRI Request", true, null, false);
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogTimeout() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest evt, ActivityContextInterface aci) {
        this.logger.severe("Received SEND_ROUTING_INFO_FOR_SM_REQUEST = " + evt);
    }

    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived SEND_ROUTING_INFO_FOR_SM_RESPONSE = " + evt + " Dialog=" + evt.getMAPDialog());
        }
        if (evt.getMAPDialog().getApplicationContext().getApplicationContextVersion() == MAPApplicationContextVersion.version1 && evt.getMwdSet() != null && evt.getMwdSet().booleanValue()) {
            InformServiceCenterContainer informServiceCenterContainer = new InformServiceCenterContainer();
            MWStatus mwStatus = evt.getMAPDialog().getService().getMAPProvider().getMAPParameterFactory().createMWStatus(false, true, false, false);
            informServiceCenterContainer.setMwStatus(mwStatus);
            this.doSetInformServiceCenterContainer(informServiceCenterContainer);
        }
        this.setSendRoutingInfoForSMResponse(evt);
    }

    public void onInformServiceCentreRequest(InformServiceCentreRequest evt, ActivityContextInterface aci) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\nReceived INFORM_SERVICE_CENTER_REQUEST = " + evt + " Dialog=" + evt.getMAPDialog());
        }
        InformServiceCenterContainer informServiceCenterContainer = new InformServiceCenterContainer();
        informServiceCenterContainer.setMwStatus(evt.getMwStatus());
        this.doSetInformServiceCenterContainer(informServiceCenterContainer);
    }

    @Override
    public void onDialogDelimiter(DialogDelimiter evt, ActivityContextInterface aci) {
        super.onDialogDelimiter(evt, aci);
        try {
            this.onSriFullResponse();
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogDelimiter when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void onDialogClose(DialogClose evt, ActivityContextInterface aci) {
        try {
            super.onDialogClose(evt, aci);
            this.onSriFullResponse();
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in SriSbb.onDialogClose when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    @Override
    public void setupReportSMDeliveryStatusRequest(String destinationAddress, int ton, int npi, SMDeliveryOutcome sMDeliveryOutcome, String targetId, int networkId) {
        RsdsSbbLocalObject rsdsSbbLocalObject = this.getRsdsSbbObject();
        if (rsdsSbbLocalObject != null) {
            ISDNAddressString isdn = this.getCalledPartyISDNAddressString(destinationAddress, ton, npi);
            AddressString serviceCentreAddress = this.getServiceCenterAddressString(networkId);
            SccpAddress destAddress = this.convertAddressFieldToSCCPAddress(destinationAddress, ton, npi);
            rsdsSbbLocalObject.setupReportSMDeliveryStatusRequest(isdn, serviceCentreAddress, sMDeliveryOutcome, destAddress, this.getSRIMAPApplicationContext(MAPApplicationContextVersion.getInstance((long)this.getSriMapVersion())), targetId, networkId);
        }
    }

    public abstract void setSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse var1);

    public abstract SendRoutingInfoForSMResponse getSendRoutingInfoForSMResponse();

    public abstract void setErrorResponse(MAPErrorMessage var1);

    public abstract MAPErrorMessage getErrorResponse();

    public abstract void setSriMapVersion(int var1);

    public abstract int getSriMapVersion();

    public abstract ChildRelationExt getMtSbb();

    public abstract ChildRelationExt getRsdsSbb();

    private MtSbbLocalObject getMtSbbObject() {
        MtSbbLocalObject ret;
        block3: {
            ChildRelationExt relation = this.getMtSbb();
            ret = (MtSbbLocalObject)relation.get("0");
            if (ret == null) {
                try {
                    ret = (MtSbbLocalObject)relation.create("0");
                }
                catch (Exception e) {
                    if (!this.logger.isSevereEnabled()) break block3;
                    this.logger.severe("Exception while trying to creat MtSbb child", (Throwable)e);
                }
            }
        }
        return ret;
    }

    private RsdsSbbLocalObject getRsdsSbbObject() {
        RsdsSbbLocalObject ret;
        block3: {
            ChildRelationExt relation = this.getRsdsSbb();
            ret = (RsdsSbbLocalObject)relation.get("0");
            if (ret == null) {
                try {
                    ret = (RsdsSbbLocalObject)relation.create("0");
                }
                catch (Exception e) {
                    if (!this.logger.isSevereEnabled()) break block3;
                    this.logger.severe("Exception while trying to creat RsdsSbb child", (Throwable)e);
                }
            }
        }
        return ret;
    }

    @Override
    public void doSetSmsSubmitData(SmsSubmitData smsDeliveryData) {
        MtSbbLocalObject mtSbbLocalObject = this.getMtSbbObject();
        if (mtSbbLocalObject != null) {
            mtSbbLocalObject.doSetSmsSubmitData(smsDeliveryData);
        }
    }

    @Override
    public SmsSubmitData doGetSmsSubmitData() {
        MtSbbLocalObject mtSbbLocalObject = this.getMtSbbObject();
        if (mtSbbLocalObject != null) {
            return mtSbbLocalObject.doGetSmsSubmitData();
        }
        return null;
    }

    @Override
    public void doSetCurrentMsgNum(long currentMsgNum) {
        MtSbbLocalObject mtSbbLocalObject = this.getMtSbbObject();
        if (mtSbbLocalObject != null) {
            mtSbbLocalObject.doSetCurrentMsgNum(currentMsgNum);
        }
    }

    @Override
    public long doGetCurrentMsgNum() {
        MtSbbLocalObject mtSbbLocalObject = this.getMtSbbObject();
        if (mtSbbLocalObject != null) {
            return mtSbbLocalObject.doGetCurrentMsgNum();
        }
        return 0L;
    }

    @Override
    public void doSetInformServiceCenterContainer(InformServiceCenterContainer informServiceCenterContainer) {
        MtSbbLocalObject mtSbbLocalObject = this.getMtSbbObject();
        if (mtSbbLocalObject != null) {
            mtSbbLocalObject.doSetInformServiceCenterContainer(informServiceCenterContainer);
        }
    }

    @Override
    public InformServiceCenterContainer doGetInformServiceCenterContainer() {
        MtSbbLocalObject mtSbbLocalObject = this.getMtSbbObject();
        if (mtSbbLocalObject != null) {
            return mtSbbLocalObject.doGetInformServiceCenterContainer();
        }
        return null;
    }

    @Override
    public void setSbbContext(SbbContext sbbContext) {
        super.setSbbContext(sbbContext);
        this.maxMAPApplicationContextVersion = MAPApplicationContextVersion.getInstance((long)smscPropertiesManagement.getMaxMapVersion());
    }

    private void sendSRI(SmsSet smsSet, String destinationAddress, int ton, int npi, MAPApplicationContext mapApplicationContext) {
        MAPDialogSms mapDialogSms = null;
        try {
            mapDialogSms = this.setupRoutingInfoForSMRequestIndication(destinationAddress, ton, npi, mapApplicationContext, smsSet.getNetworkId());
            ActivityContextInterface sriDialogACI = this.mapAcif.getActivityContextInterface((MAPDialog)mapDialogSms);
            sriDialogACI.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            mapDialogSms.send();
        }
        catch (MAPException e) {
            if (mapDialogSms != null) {
                mapDialogSms.release();
            }
            String reason = "MAPException when sending SRI from sendSRI(): " + e.toString();
            this.logger.severe(reason, (Throwable)e);
            ErrorCode smStatus = ErrorCode.SC_SYSTEM_ERROR;
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, smStatus, reason, true, null, false);
        }
    }

    private MAPDialogSms setupRoutingInfoForSMRequestIndication(String destinationAddress, int ton, int npi, MAPApplicationContext mapApplicationContext, int networkId) throws MAPException {
        String hlrAddress = destinationAddress;
        if (smscPropertiesManagement.getHrHlrNumber() != null && smscPropertiesManagement.getHrHlrNumber().length() > 0) {
            hlrAddress = smscPropertiesManagement.getHrHlrNumber();
        }
        SccpAddress destinationAddr = this.convertAddressFieldToSCCPAddress(hlrAddress, ton, npi);
        MAPDialogSms mapDialogSms = this.mapProvider.getMAPServiceSms().createNewDialog(mapApplicationContext, this.getServiceCenterSccpAddress(networkId), null, destinationAddr, null);
        mapDialogSms.setNetworkId(networkId);
        ISDNAddressString isdn = this.getCalledPartyISDNAddressString(destinationAddress, ton, npi);
        AddressString serviceCenterAddress = this.getServiceCenterAddressString(networkId);
        boolean sm_RP_PRI = true;
        mapDialogSms.addSendRoutingInfoForSMRequest(isdn, sm_RP_PRI, serviceCenterAddress, null, false, null, null, null);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("\nSending: SendRoutingInfoForSMRequest: isdn=" + isdn + ", serviceCenterAddress=" + serviceCenterAddress + ", sm_RP_PRI=" + sm_RP_PRI);
        }
        return mapDialogSms;
    }

    private void onSriFullResponse() {
        SendRoutingInfoForSMResponse sendRoutingInfoForSMResponse = this.getSendRoutingInfoForSMResponse();
        MAPErrorMessage errorMessage = this.getErrorResponse();
        SmsSubmitData smsDeliveryData = this.doGetSmsSubmitData();
        if (smsDeliveryData == null) {
            this.logger.severe("smsDeliveryData CMP is missed - SriSbb.onSriFullResponse()");
            return;
        }
        String targetId = smsDeliveryData.getTargetId();
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            if (sendRoutingInfoForSMResponse != null || errorMessage != null) {
                this.logger.severe("In SmsDeliveryData CMP smsSet is missed - SriSbb.onSriFullResponse(), targetId=" + targetId);
            } else {
                this.logger.info("In SmsDeliveryData CMP smsSet is missed - SriSbb.onSriFullResponse(), targetId=" + targetId);
            }
            return;
        }
        if (sendRoutingInfoForSMResponse != null) {
            SriResponseValue sriResponseValue = new SriResponseValue(smsSet.getTargetId(), smsSet.getNetworkId(), smsSet.getDestAddr(), smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), sendRoutingInfoForSMResponse.getLocationInfoWithLMSI(), sendRoutingInfoForSMResponse.getIMSI().getData());
            try {
                SmsSetCache.getInstance().putSriResponseValue(sriResponseValue, smscPropertiesManagement.getSriResponseLiveTime());
            }
            catch (Exception e1) {
                // empty catch block
            }
            this.executeForwardSM(smsSet, sendRoutingInfoForSMResponse.getLocationInfoWithLMSI(), sendRoutingInfoForSMResponse.getIMSI().getData(), smsSet.getNetworkId());
            return;
        }
        if (errorMessage != null) {
            if (errorMessage.isEmAbsentSubscriber()) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.mobileNotReachableFlag, ErrorCode.ABSENT_SUBSCRIBER, "AbsentSubscriber response from HLR: " + errorMessage.toString(), true, errorMessage, false);
            } else if (errorMessage.isEmAbsentSubscriberSM()) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.mobileNotReachableFlag, ErrorCode.ABSENT_SUBSCRIBER, "AbsentSubscriberSM response from HLR: " + errorMessage.toString(), true, errorMessage, false);
            } else if (errorMessage.isEmCallBarred()) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.CALL_BARRED, "CallBarred response from HLR: " + errorMessage.toString(), true, errorMessage, false);
            } else if (errorMessage.isEmFacilityNotSup()) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.FACILITY_NOT_SUPPORTED, "FacilityNotSuppored response from HLR: " + errorMessage.toString(), true, errorMessage, false);
            } else if (errorMessage.isEmSystemFailure()) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.SYSTEM_FAILURE, "SystemFailure response from HLR: " + errorMessage.toString(), true, errorMessage, false);
            } else if (errorMessage.isEmUnknownSubscriber()) {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.UNKNOWN_SUBSCRIBER, "UnknownSubscriber response from HLR: " + errorMessage.toString(), true, errorMessage, false);
            } else if (errorMessage.isEmExtensionContainer()) {
                if (errorMessage.getEmExtensionContainer().getErrorCode() == 35L) {
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.DATA_MISSING, "DataMissing response from HLR", true, errorMessage, false);
                } else if (errorMessage.getEmExtensionContainer().getErrorCode() == 36L) {
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.UNEXPECTED_DATA, "UnexpectedDataValue response from HLR", true, errorMessage, false);
                } else if (errorMessage.getEmExtensionContainer().getErrorCode() == 11L) {
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.TELESERVICE_NOT_PROVISIONED, "TeleserviceNotProvisioned response from HLR", true, errorMessage, false);
                } else {
                    this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.UNEXPECTED_DATA_FROM_HLR, "Error response from HLR: " + errorMessage.toString(), true, errorMessage, false);
                }
            } else {
                this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.UNEXPECTED_DATA_FROM_HLR, "Error response from HLR: " + errorMessage.toString(), true, errorMessage, false);
            }
        } else {
            this.onDeliveryError(smsSet, MtCommonSbb.ErrorAction.permanentFailure, ErrorCode.HLR_REJECT_AFTER_ROUTING_INFO, "Empty response after SRI Request", false, null, false);
        }
    }

    private void executeForwardSM(SmsSet smsSet, LocationInfoWithLMSI locationInfoWithLMSI, String imsi, int networkId) {
        smsSet.setImsi(imsi);
        smsSet.setLocationInfoWithLMSI(locationInfoWithLMSI);
        ISDNAddressString networkNodeNumber = locationInfoWithLMSI.getNetworkNodeNumber();
        MtSbbLocalObject mtSbbLocalObject = this.getMtSbbObject();
        if (mtSbbLocalObject != null) {
            ActivityContextInterface schedulerActivityContextInterface = this.getSchedulerActivityContextInterface();
            schedulerActivityContextInterface.attach((SbbLocalObject)mtSbbLocalObject);
            mtSbbLocalObject.setupMtForwardShortMessageRequest(networkNodeNumber, imsi, locationInfoWithLMSI.getLMSI(), networkId);
        }
    }

    private SccpAddress convertAddressFieldToSCCPAddress(String address, int ton, int npi) {
        return MessageUtil.getSccpAddress((ParameterFactory)this.sccpParameterFact, (String)address, (int)ton, (int)npi, (int)smscPropertiesManagement.getHlrSsn(), (GlobalTitleIndicator)smscPropertiesManagement.getGlobalTitleIndicator(), (int)smscPropertiesManagement.getTranslationType());
    }

    private MAPApplicationContext getSRIMAPApplicationContext(MAPApplicationContextVersion applicationContextVersion) {
        MAPApplicationContext mapApplicationContext = MAPApplicationContext.getInstance((MAPApplicationContextName)MAPApplicationContextName.shortMsgGatewayContext, (MAPApplicationContextVersion)applicationContextVersion);
        this.setSriMapVersion(applicationContextVersion.getVersion());
        return mapApplicationContext;
    }
}

