/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.slee.Address;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.smsc.cassandra.DBOperations_C1;
import org.mobicents.smsc.cassandra.DBOperations_C2;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.cassandra.PreparedStatementCollection_C3;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.SmType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;

public class PersistenceResourceAdaptor
implements ResourceAdaptor {
    private static final String CONF_CLUSTER_NAME = "cluster.name";
    private static final String CONF_CLUSTER_HOSTS = "cluster.hosts";
    private static final String CONF_CLUSTER_KEYSPACE = "cluster.keyspace";
    private Tracer tracer = null;
    private ResourceAdaptorContext raContext = null;
    private DBOperations_C1 dbOperations_C1 = null;
    private DBOperations_C2 dbOperations_C2 = null;
    private PersistenceRAInterface raSbbInterface = new PersistenceRAInterface(){

        public TargetAddress obtainSynchroObject(TargetAddress ta) {
            return SmsSetCache.getInstance().addSmsSet(ta);
        }

        public void releaseSynchroObject(TargetAddress ta) {
            SmsSetCache.getInstance().removeSmsSet(ta);
        }

        public boolean isDatabaseAvailable() {
            return PersistenceResourceAdaptor.this.dbOperations_C2.isDatabaseAvailable();
        }

        public boolean checkSmsSetExists(TargetAddress ta) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C1.checkSmsSetExists(ta);
        }

        public SmsSet obtainSmsSet(TargetAddress ta) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C1.obtainSmsSet(ta);
        }

        public void setNewMessageScheduled(SmsSet smsSet, Date newDueDate) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.setNewMessageScheduled(smsSet, newDueDate);
        }

        public void setDeliveringProcessScheduled(SmsSet smsSet, Date newDueDate, int newDueDelay) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.setDeliveringProcessScheduled(smsSet, newDueDate, newDueDelay);
        }

        public void setDestination(SmsSet smsSet, String destClusterName, String destSystemId, String destEsmeId, SmType type) {
            PersistenceResourceAdaptor.this.dbOperations_C1.setDestination(smsSet, destClusterName, destSystemId, destEsmeId, type);
        }

        public void setRoutingInfo(SmsSet smsSet, IMSI imsi, LocationInfoWithLMSI locationInfoWithLMSI) {
            PersistenceResourceAdaptor.this.dbOperations_C1.setRoutingInfo(smsSet, imsi, locationInfoWithLMSI);
        }

        public void setDeliveryStart(SmsSet smsSet, Date inSystemDate) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.setDeliveryStart(smsSet, inSystemDate);
        }

        public void setDeliveryStart(Sms sms) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.setDeliveryStart(sms);
        }

        public void setDeliverySuccess(SmsSet smsSet, Date lastDelivery) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.setDeliverySuccess(smsSet, lastDelivery);
        }

        public void setDeliveryFailure(SmsSet smsSet, ErrorCode smStatus, Date lastDelivery) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.setDeliveryFailure(smsSet, smStatus, lastDelivery);
        }

        public void setAlertingSupported(String targetId, boolean alertingSupported) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.setAlertingSupported(targetId, alertingSupported);
        }

        public boolean deleteSmsSet(SmsSet smsSet) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C1.deleteSmsSet(smsSet);
        }

        public void createLiveSms(Sms sms) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.createLiveSms(sms);
        }

        public Sms obtainLiveSms(UUID dbId) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C1.obtainLiveSms(dbId);
        }

        public Sms obtainLiveSms(long messageId) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C1.obtainLiveSms(messageId);
        }

        public void updateLiveSms(Sms sms) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.updateLiveSms(sms);
        }

        public void archiveDeliveredSms(Sms sms, Date deliveryDate) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.archiveDeliveredSms(sms, deliveryDate);
        }

        public void archiveFailuredSms(Sms sms) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.archiveFailuredSms(sms);
        }

        public List<SmsSet> fetchSchedulableSmsSets(int maxRecordCount, Tracer tracer) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C1.fetchSchedulableSmsSets(maxRecordCount, tracer);
        }

        public void fetchSchedulableSms(SmsSet smsSet, boolean excludeNonScheduleDeliveryTime) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C1.fetchSchedulableSms(smsSet, excludeNonScheduleDeliveryTime);
        }

        public long c2_getDueSlotForTime(Date time) {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getDueSlotForTime(time);
        }

        public Date c2_getTimeForDueSlot(long dueSlot) {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getTimeForDueSlot(dueSlot);
        }

        public long c2_getCurrentDueSlot() {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getCurrentDueSlot();
        }

        public void c2_setCurrentDueSlot(long newDueSlot) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_setCurrentDueSlot(newDueSlot);
        }

        public long c2_getNextMessageId() {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getNextMessageId();
        }

        public long c2_getIntimeDueSlot() {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getIntimeDueSlot();
        }

        public long c2_getDueSlotForNewSms() {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getDueSlotForNewSms();
        }

        public void c2_registerDueSlotWriting(long dueSlot) {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_registerDueSlotWriting(dueSlot);
        }

        public void c2_unregisterDueSlotWriting(long dueSlot) {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_unregisterDueSlotWriting(dueSlot);
        }

        public boolean c2_checkDueSlotNotWriting(long dueSlot) {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_checkDueSlotNotWriting(dueSlot);
        }

        public long c2_getDueSlotForTargetId(String targetId) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getDueSlotForTargetId(targetId);
        }

        public long c2_getDueSlotForTargetId(PreparedStatementCollection_C3 psc, String targetId) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getDueSlotForTargetId(psc, targetId);
        }

        public void c2_updateDueSlotForTargetId(String targetId, long newDueSlot) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_updateDueSlotForTargetId(targetId, newDueSlot);
        }

        public void c2_updateDueSlotForTargetId_WithTableCleaning(String targetId, long newDueSlot) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_updateDueSlotForTargetId_WithTableCleaning(targetId, newDueSlot);
        }

        public void c2_createRecordCurrent(Sms sms) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_createRecordCurrent(sms);
        }

        public void c2_createRecordArchive(Sms sms) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_createRecordArchive(sms);
        }

        public ArrayList<SmsSet> c2_getRecordList(long dueSlot) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getRecordList(dueSlot);
        }

        public SmsSet c2_getRecordListForTargeId(long dueSlot, String targetId) throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getRecordListForTargeId(dueSlot, targetId);
        }

        public ArrayList<SmsSet> c2_sortRecordList(ArrayList<SmsSet> sourceLst) {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_sortRecordList(sourceLst);
        }

        public void c2_updateInSystem(Sms sms, int isSystemStatus, boolean fastStoreAndForwordMode) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_updateInSystem(sms, isSystemStatus, fastStoreAndForwordMode);
        }

        public void c2_updateAlertingSupport(long dueSlot, String targetId, UUID dbId) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_updateAlertingSupport(dueSlot, targetId, dbId);
        }

        public PreparedStatementCollection_C3[] c2_getPscList() throws PersistenceException {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_getPscList();
        }

        public void c2_scheduleMessage_ReschedDueSlot(Sms sms, boolean fastStoreAndForwordMode, boolean removeExpiredValidityPeriod) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_scheduleMessage_ReschedDueSlot(sms, fastStoreAndForwordMode, removeExpiredValidityPeriod);
        }

        public void c2_scheduleMessage_NewDueSlot(Sms sms, long dueSlot, ArrayList<Sms> lstFailured, boolean fastStoreAndForwordMode) throws PersistenceException {
            PersistenceResourceAdaptor.this.dbOperations_C2.c2_scheduleMessage_NewDueSlot(sms, dueSlot, lstFailured, fastStoreAndForwordMode);
        }

        public long c2_checkDueSlotWritingPossibility(long dueSlot) {
            return PersistenceResourceAdaptor.this.dbOperations_C2.c2_checkDueSlotWritingPossibility(dueSlot);
        }
    };

    public void activityEnded(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity with handle " + activityHandle + " ended.");
        }
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity unreferenced with handle " + activityHandle + ".");
        }
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity administrative remove with handle " + activityHandle + ".");
        }
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event processing failed on activity with handle " + activityHandle + ".");
        }
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event processing succeeded on activity with handle " + activityHandle + ".");
        }
    }

    public void eventUnreferenced(ActivityHandle activityHandle, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event unreferenced on activity with handle " + activityHandle + ".");
        }
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return null;
    }

    public ActivityHandle getActivityHandle(Object activity) {
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.raSbbInterface;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public void raActive() {
        this.dbOperations_C2 = DBOperations_C2.getInstance();
        if (!this.dbOperations_C2.isStarted()) {
            throw new RuntimeException("DBOperations_2 not started yet!");
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("PersistenceResourceAdaptor " + this.raContext.getEntityName() + " Activated");
        }
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
        throw new UnsupportedOperationException();
    }

    public void raConfigure(ConfigProperties properties) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Configuring RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raInactive() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Inactivated RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raStopping() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Stopping RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raUnconfigure() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Unconfigure RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Verify configuration in RA Entity " + this.raContext.getEntityName());
        }
    }

    public void serviceActive(ReceivableService arg0) {
    }

    public void serviceInactive(ReceivableService arg0) {
    }

    public void serviceStopping(ReceivableService arg0) {
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.tracer = raContext.getTracer(this.getClass().getSimpleName());
        this.raContext = raContext;
    }

    public void unsetResourceAdaptorContext() {
        this.raContext = null;
    }
}

