/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.persistence;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.mobicents.smsc.cassandra.DBOperations_C1;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.cassandra.PreparedStatementCollection_C3;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.persistence.SmsProxy;

public class PersistenceRAInterfaceProxy
extends DBOperations_C1
implements PersistenceRAInterface {
    private static final Logger logger = Logger.getLogger(PersistenceRAInterfaceProxy.class);

    public Session getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testCassandraAccess() {
        boolean bl;
        String ip = "127.0.0.1";
        String keyspace = "RestCommSMSC";
        Cluster cluster = Cluster.builder().addContactPoint(ip).build();
        try {
            Metadata metadata = cluster.getMetadata();
            for (Host host : metadata.getAllHosts()) {
                logger.info((Object)String.format("Datacenter: %s; Host: %s; Rack: %s\n", host.getDatacenter(), host.getAddress(), host.getRack()));
            }
            Session session = cluster.connect();
            session.execute("USE \"" + keyspace + "\"");
            PreparedStatement ps = session.prepare("select * from \"LIVE\" limit 1;");
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            session.execute((Statement)boundStatement);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                cluster.close();
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        cluster.close();
        return bl;
    }

    public void deleteLiveSms(UUID id) throws PersistenceException {
        Sms sms = new Sms();
        sms.setDbId(id);
        super.deleteLiveSms(sms);
    }

    public void deleteArchiveSms(UUID id) throws PersistenceException {
        PreparedStatement ps = this.session.prepare("delete from \"ARCHIVE\" where \"ID\"=?;");
        BoundStatement boundStatement = new BoundStatement(ps);
        boundStatement.bind(new Object[]{id});
        this.session.execute((Statement)boundStatement);
    }

    public SmsProxy obtainArchiveSms(UUID dbId) throws PersistenceException, IOException {
        PreparedStatement ps = this.session.prepare("select * from \"ARCHIVE\" where \"ID\"=?;");
        BoundStatement boundStatement = new BoundStatement(ps);
        boundStatement.bind(new Object[]{dbId});
        ResultSet result = this.session.execute((Statement)boundStatement);
        Row row = result.one();
        Sms sms = this.createSms(row, new SmsSet(), dbId);
        if (sms == null) {
            return null;
        }
        SmsProxy res = new SmsProxy();
        res.sms = sms;
        res.addrDstDigits = row.getString("ADDR_DST_DIGITS");
        res.addrDstTon = row.getInt("ADDR_DST_TON");
        res.addrDstNpi = row.getInt("ADDR_DST_NPI");
        res.destClusterName = row.getString("DEST_CLUSTER_NAME");
        res.destEsmeName = row.getString("DEST_ESME_NAME");
        res.destSystemId = row.getString("DEST_SYSTEM_ID");
        res.imsi = row.getString("IMSI");
        res.nnnDigits = row.getString("NNN_DIGITS");
        res.smStatus = row.getInt("SM_STATUS");
        res.smType = row.getInt("SM_TYPE");
        res.deliveryCount = row.getInt("DELIVERY_COUNT");
        res.deliveryDate = row.getDate("DELIVERY_DATE");
        return res;
    }

    public boolean isDatabaseAvailable() {
        return true;
    }

    public TargetAddress obtainSynchroObject(TargetAddress ta) {
        return SmsSetCache.getInstance().addSmsSet(ta);
    }

    public void releaseSynchroObject(TargetAddress ta) {
        SmsSetCache.getInstance().removeSmsSet(ta);
    }

    public long c2_getDueSlotForTime(Date time) {
        return 0L;
    }

    public Date c2_getTimeForDueSlot(long dueSlot) {
        return null;
    }

    public long c2_getCurrentDueSlot() {
        return 0L;
    }

    public void c2_setCurrentDueSlot(long newDueSlot) throws PersistenceException {
    }

    public long c2_getIntimeDueSlot() {
        return 0L;
    }

    public long c2_getDueSlotForNewSms() {
        return 0L;
    }

    public void c2_registerDueSlotWriting(long dueSlot) {
    }

    public void c2_unregisterDueSlotWriting(long dueSlot) {
    }

    public boolean c2_checkDueSlotNotWriting(long dueSlot) {
        return false;
    }

    public PreparedStatementCollection_C3[] c2_getPscList() throws PersistenceException {
        return null;
    }

    public long c2_getDueSlotForTargetId(PreparedStatementCollection_C3 psc, String targetId) throws PersistenceException {
        return 0L;
    }

    public void c2_updateDueSlotForTargetId(String targetId, long newDueSlot) throws PersistenceException {
    }

    public void c2_createRecordCurrent(Sms sms) throws PersistenceException {
    }

    public void c2_createRecordArchive(Sms sms) throws PersistenceException {
    }

    public void c2_scheduleMessage_ReschedDueSlot(Sms sms, boolean fastStoreAndForwordMode, boolean removeExpiredValidityPeriod) throws PersistenceException {
    }

    public void c2_scheduleMessage_NewDueSlot(Sms sms, long dueSlot, ArrayList<Sms> lstFailured, boolean fastStoreAndForwordMode) throws PersistenceException {
    }

    public ArrayList<SmsSet> c2_getRecordList(long dueSlot) throws PersistenceException {
        return null;
    }

    public SmsSet c2_getRecordListForTargeId(long dueSlot, String targetId) throws PersistenceException {
        return null;
    }

    public ArrayList<SmsSet> c2_sortRecordList(ArrayList<SmsSet> sourceLst) {
        return null;
    }

    public void c2_updateInSystem(Sms sms, int isSystemStatus, boolean fastStoreAndForwordMode) throws PersistenceException {
    }

    public long c2_getDueSlotForTargetId(String targetId) throws PersistenceException {
        return 0L;
    }

    public void c2_updateDueSlotForTargetId_WithTableCleaning(String targetId, long newDueSlot) throws PersistenceException {
    }

    public long c2_getNextMessageId() {
        return 0L;
    }

    public void c2_updateAlertingSupport(long dueSlot, String targetId, UUID dbId) throws PersistenceException {
    }

    public long c2_checkDueSlotWritingPossibility(long dueSlot) {
        return 0L;
    }
}

