/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.persistence;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.mobicents.smsc.cassandra.DBOperations;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.cassandra.PreparedStatementCollection;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.persistence.SmsProxy;

public class PersistenceRAInterfaceProxy
extends DBOperations
implements PersistenceRAInterface {
    private static final Logger logger = Logger.getLogger(PersistenceRAInterfaceProxy.class);
    private String ip = "127.0.0.1";
    private String keyspace = "RestCommSMSC";
    private boolean oldShortMessageDbFormat = false;

    public Session getSession() {
        return this.session;
    }

    public String getKeyspaceName() {
        return this.keyspace;
    }

    public void start() throws Exception {
        super.start(this.ip, 9042, this.keyspace, 60, 60, 600);
    }

    public void setOldShortMessageDbFormat(boolean val) {
        this.oldShortMessageDbFormat = val;
    }

    public boolean do_scheduleMessage(Sms sms, long dueSlot, ArrayList<Sms> lstFailured, boolean fastStoreAndForwordMode, boolean removeExpiredValidityPeriod) throws PersistenceException {
        return super.do_scheduleMessage(sms, dueSlot, lstFailured, fastStoreAndForwordMode, removeExpiredValidityPeriod);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testCassandraAccess() {
        boolean bl;
        Cluster cluster = Cluster.builder().addContactPoint(this.ip).build();
        try {
            int g1;
            BoundStatement boundStatement;
            PreparedStatement ps;
            Metadata metadata = cluster.getMetadata();
            for (Host host : metadata.getAllHosts()) {
                logger.info((Object)String.format("Datacenter: %s; Host: %s; Rack: %s\n", host.getDatacenter(), host.getAddress(), host.getRack()));
            }
            Session session = cluster.connect();
            session.execute("USE \"" + this.keyspace + "\"");
            boolean tstRes = false;
            try {
                ps = session.prepare("SELECT * from \"TEST_TABLE\";");
                boundStatement = new BoundStatement(ps);
                boundStatement.bind(new Object[0]);
                session.execute((Statement)boundStatement);
                tstRes = true;
            }
            catch (Exception e) {
                int g12 = 0;
                ++g12;
            }
            ProtocolVersion protVersion = DBOperations.getProtocolVersion((Cluster)cluster);
            if (protVersion == ProtocolVersion.V1) {
                throw new Exception("We do not support cassandra databse 1.2 more");
            }
            if (!tstRes) {
                ps = session.prepare("CREATE TABLE \"TEST_TABLE\" (id uuid primary key);");
                boundStatement = new BoundStatement(ps);
                boundStatement.bind(new Object[0]);
                session.execute((Statement)boundStatement);
            }
            ps = session.prepare("TRUNCATE \"CURRENT_SLOT_TABLE\";");
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            try {
                session.execute((Statement)boundStatement);
            }
            catch (Exception e) {
                int g13 = 0;
                ++g13;
            }
            Date dt = new Date();
            String tName = this.getTableName(dt);
            ps = session.prepare("TRUNCATE \"DST_SLOT_TABLE" + tName + "\";");
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            try {
                session.execute((Statement)boundStatement);
            }
            catch (Exception e) {
                g1 = 0;
                ++g1;
            }
            ps = session.prepare("TRUNCATE \"SLOT_MESSAGES_TABLE" + tName + "\";");
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            try {
                session.execute((Statement)boundStatement);
            }
            catch (Exception e) {
                g1 = 0;
                ++g1;
            }
            ps = session.prepare("TRUNCATE \"MESSAGES" + tName + "\";");
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            try {
                session.execute((Statement)boundStatement);
            }
            catch (Exception e) {
                g1 = 0;
                ++g1;
            }
            dt = new Date(new Date().getTime() + 86400000L);
            tName = this.getTableName(dt);
            ps = session.prepare("TRUNCATE \"DST_SLOT_TABLE" + tName + "\";");
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            try {
                session.execute((Statement)boundStatement);
            }
            catch (Exception e) {
                g1 = 0;
                ++g1;
            }
            ps = session.prepare("TRUNCATE \"SLOT_MESSAGES_TABLE" + tName + "\";");
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            try {
                session.execute((Statement)boundStatement);
            }
            catch (Exception e) {
                g1 = 0;
                ++g1;
            }
            ps = session.prepare("TRUNCATE \"MESSAGES" + tName + "\";");
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[0]);
            try {
                session.execute((Statement)boundStatement);
            }
            catch (Exception e) {
                g1 = 0;
                ++g1;
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                cluster.close();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        cluster.close();
        return bl;
    }

    public SmsProxy obtainArchiveSms(long dueSlot, String dstDigits, UUID dbId) throws PersistenceException, IOException {
        PreparedStatement ps = this.session.prepare("select * from \"MESSAGES" + this.getTableName(dueSlot) + "\" where \"" + "ADDR_DST_DIGITS" + "\"=? and \"" + "ID" + "\"=?;");
        BoundStatement boundStatement = new BoundStatement(ps);
        boundStatement.bind(new Object[]{dstDigits, dbId});
        ResultSet result = this.session.execute((Statement)boundStatement);
        Row row = result.one();
        SmsSet smsSet = this.createSms(row, null, true, true, true, true, true);
        if (smsSet == null) {
            return null;
        }
        SmsProxy res = new SmsProxy();
        res.sms = smsSet.getSms(0L);
        res.addrDstDigits = row.getString("ADDR_DST_DIGITS");
        res.addrDstTon = row.getInt("ADDR_DST_TON");
        res.addrDstNpi = row.getInt("ADDR_DST_NPI");
        res.destClusterName = row.getString("DEST_CLUSTER_NAME");
        res.destEsmeName = row.getString("DEST_ESME_NAME");
        res.destSystemId = row.getString("DEST_SYSTEM_ID");
        res.imsi = row.getString("IMSI");
        res.corrId = row.getString("CORR_ID");
        res.networkId = row.getInt("NETWORK_ID");
        res.nnnDigits = row.getString("NNN_DIGITS");
        res.smStatus = row.getInt("SM_STATUS");
        res.smType = row.getInt("SM_TYPE");
        res.deliveryCount = row.getInt("DELIVERY_COUNT");
        res.deliveryDate = DBOperations.getRowDate((Row)row, (String)"DELIVERY_DATE");
        return res;
    }

    public PreparedStatementCollection getStatementCollection(Date dt) throws PersistenceException {
        return super.getStatementCollection(dt);
    }

    public TargetAddress obtainSynchroObject(TargetAddress ta) {
        return SmsSetCache.getInstance().addSmsSet(ta);
    }

    public void releaseSynchroObject(TargetAddress ta) {
        SmsSetCache.getInstance().removeSmsSet(ta);
    }

    public int checkSmsExists(long dueSlot, String targetId) throws PersistenceException {
        try {
            String s1 = "select \"ID\" from \"SLOT_MESSAGES_TABLE" + this.getTableName(dueSlot) + "\" where \"DUE_SLOT\"=? and \"TARGET_ID\"=?;";
            PreparedStatement ps = this.session.prepare(s1);
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{dueSlot, targetId});
            ResultSet rs = this.session.execute((Statement)boundStatement);
            return rs.all().size();
        }
        catch (Exception e) {
            boolean ggg = false;
            ggg = false;
            return -1;
        }
    }

    public Sms obtainLiveSms(long dueSlot, String targetId, UUID id) throws PersistenceException {
        try {
            String s1 = "select * from \"SLOT_MESSAGES_TABLE" + this.getTableName(dueSlot) + "\" where \"DUE_SLOT\"=? and \"TARGET_ID\"=? and \"ID\"=?;";
            PreparedStatement ps = this.session.prepare(s1);
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{dueSlot, targetId, id});
            ResultSet rs = this.session.execute((Statement)boundStatement);
            SmsSet smsSet = null;
            Row row2 = null;
            Iterator i$ = rs.iterator();
            if (i$.hasNext()) {
                Row row = (Row)i$.next();
                smsSet = this.createSms(row, null, true, true, true, true, true);
                row2 = row;
            }
            if (smsSet == null || smsSet.getSmsCount() == 0L) {
                return null;
            }
            smsSet.setAlertingSupported(row2.getBool("ALERTING_SUPPORTED"));
            smsSet.setStatus(ErrorCode.fromInt((int)row2.getInt("SM_STATUS")));
            return smsSet.getSms(0L);
        }
        catch (Exception e) {
            boolean ggg = false;
            ggg = false;
            return null;
        }
    }

    protected long c2_getCurrentSlotTable(int key) throws PersistenceException {
        return super.c2_getCurrentSlotTable(key);
    }

    protected void addSmsFields(StringBuilder sb) {
        this.appendField(sb, "ID", "uuid");
        this.appendField(sb, "TARGET_ID", "ascii");
        if (!this.oldShortMessageDbFormat) {
            this.appendField(sb, "NETWORK_ID", "int");
        }
        this.appendField(sb, "DUE_SLOT", "bigint");
        this.appendField(sb, "IN_SYSTEM", "int");
        this.appendField(sb, "SMSC_UUID", "uuid");
        this.appendField(sb, "ADDR_DST_DIGITS", "ascii");
        this.appendField(sb, "ADDR_DST_TON", "int");
        this.appendField(sb, "ADDR_DST_NPI", "int");
        this.appendField(sb, "ADDR_SRC_DIGITS", "ascii");
        this.appendField(sb, "ADDR_SRC_TON", "int");
        this.appendField(sb, "ADDR_SRC_NPI", "int");
        if (!this.oldShortMessageDbFormat) {
            this.appendField(sb, "ORIG_NETWORK_ID", "int");
        }
        this.appendField(sb, "DUE_DELAY", "int");
        this.appendField(sb, "ALERTING_SUPPORTED", "boolean");
        this.appendField(sb, "MESSAGE_ID", "bigint");
        this.appendField(sb, "MO_MESSAGE_REF", "int");
        this.appendField(sb, "ORIG_ESME_NAME", "text");
        this.appendField(sb, "ORIG_SYSTEM_ID", "text");
        this.appendField(sb, "DEST_CLUSTER_NAME", "text");
        this.appendField(sb, "DEST_ESME_NAME", "text");
        this.appendField(sb, "DEST_SYSTEM_ID", "text");
        this.appendField(sb, "SUBMIT_DATE", "timestamp");
        this.appendField(sb, "DELIVERY_DATE", "timestamp");
        this.appendField(sb, "SERVICE_TYPE", "text");
        this.appendField(sb, "ESM_CLASS", "int");
        this.appendField(sb, "PROTOCOL_ID", "int");
        this.appendField(sb, "PRIORITY", "int");
        this.appendField(sb, "REGISTERED_DELIVERY", "int");
        this.appendField(sb, "REPLACE", "int");
        this.appendField(sb, "DATA_CODING", "int");
        this.appendField(sb, "DEFAULT_MSG_ID", "int");
        this.appendField(sb, "MESSAGE", "blob");
        if (!this.oldShortMessageDbFormat) {
            this.appendField(sb, "MESSAGE_TEXT", "text");
            this.appendField(sb, "MESSAGE_BIN", "blob");
        }
        this.appendField(sb, "OPTIONAL_PARAMETERS", "text");
        this.appendField(sb, "SCHEDULE_DELIVERY_TIME", "timestamp");
        this.appendField(sb, "VALIDITY_PERIOD", "timestamp");
        this.appendField(sb, "IMSI", "ascii");
        if (!this.oldShortMessageDbFormat) {
            this.appendField(sb, "CORR_ID", "ascii");
        }
        this.appendField(sb, "NNN_DIGITS", "ascii");
        this.appendField(sb, "NNN_AN", "int");
        this.appendField(sb, "NNN_NP", "int");
        this.appendField(sb, "SM_STATUS", "int");
        this.appendField(sb, "SM_TYPE", "int");
        this.appendField(sb, "DELIVERY_COUNT", "int");
        if (!this.oldShortMessageDbFormat) {
            this.appendField(sb, "ORIGINATOR_SCCP_ADDRESS", "ascii");
            this.appendField(sb, "STATUS_REPORT_REQUEST", "boolean");
            this.appendField(sb, "DELIVERY_ATTEMPT", "int");
            this.appendField(sb, "USER_DATA", "text");
            this.appendField(sb, "EXTRA_DATA", "text");
            this.appendField(sb, "EXTRA_DATA_2", "text");
            this.appendField(sb, "EXTRA_DATA_3", "text");
            this.appendField(sb, "EXTRA_DATA_4", "text");
        }
    }

    protected String[] getLiveTableListAsNames(String keyspace) {
        return super.getLiveTableListAsNames(keyspace);
    }
}

