/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.persistence;

import com.cloudhopper.smpp.tlv.Tlv;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeader;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeaderElement;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.service.sms.LocationInfoWithLMSIImpl;
import org.mobicents.protocols.ss7.map.smstpdu.ConcatenatedShortMessagesIdentifierImpl;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.smstpdu.UserDataHeaderImpl;
import org.mobicents.smsc.cassandra.PreparedStatementCollection;
import org.mobicents.smsc.library.SmType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterfaceProxy;
import org.mobicents.smsc.slee.resources.persistence.SmsProxy;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CassandraTest {
    private PersistenceRAInterfaceProxy sbb;
    private boolean cassandraDbInited;
    private UUID id1 = UUID.fromString("59e815dc-49ad-4539-8cff-beb710a7de03");
    private UUID id2 = UUID.fromString("be26d2e9-1ba0-490c-bd5b-f04848127220");
    private UUID id3 = UUID.fromString("8bf7279f-3d4a-4494-8acd-cb9572c7ab33");
    private UUID id4 = UUID.fromString("c3bd98c2-355d-4572-8915-c6d0c767cae1");
    private UUID id5 = UUID.fromString("59e815dc-49ad-4539-8cff-beb710a7de04");
    private TargetAddress ta1 = new TargetAddress(5, 1, "1111", 9);
    private TargetAddress ta2 = new TargetAddress(5, 1, "1112", 9);

    @BeforeMethod
    public void setUpClass() throws Exception {
        System.out.println("setUpClass");
        this.sbb = new PersistenceRAInterfaceProxy();
        this.cassandraDbInited = this.sbb.testCassandraAccess();
        if (!this.cassandraDbInited) {
            return;
        }
        this.sbb.start();
    }

    @AfterMethod
    public void tearDownClass() throws Exception {
        System.out.println("tearDownClass");
        this.sbb.stop();
    }

    @Test(groups={"cassandra"})
    public void testingDueSlotForTime() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        Date dt = new Date();
        long dueSlot = this.sbb.c2_getDueSlotForTime(dt);
        Date dt2 = this.sbb.c2_getTimeForDueSlot(dueSlot);
        long dueSlot2 = this.sbb.c2_getDueSlotForTime(dt2);
        Date dt3 = this.sbb.c2_getTimeForDueSlot(dueSlot);
        Assert.assertEquals((long)dueSlot, (long)dueSlot2);
        Assert.assertTrue((boolean)dt2.equals(dt3));
        long l1 = this.sbb.c2_getNextMessageId();
        Assert.assertEquals((long)l1, (long)1001L);
    }

    @Test(groups={"cassandra"})
    public void testingProcessingDueSlot() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        Date dt = new Date();
        long l0 = this.sbb.c2_getDueSlotForTime(dt);
        long l1 = this.sbb.c2_getCurrentDueSlot();
        long l2 = 222999L;
        this.sbb.c2_setCurrentDueSlot(l2);
        long l3 = this.sbb.c2_getCurrentDueSlot();
        if (l1 > l0 || l1 < l0 - 100L) {
            Assert.fail((String)"l1 value is bad");
        }
        Assert.assertEquals((long)l2, (long)l3);
        int len = 1500;
        long lx = 0L;
        for (int i1 = 0; i1 < len; ++i1) {
            lx = this.sbb.c2_getNextMessageId();
        }
        Assert.assertEquals((long)lx, (long)(1000L + (long)len));
        long ly = this.sbb.c2_getCurrentSlotTable(1);
        Assert.assertEquals((long)ly, (long)2000L);
        this.sbb.stop();
        this.sbb.start();
        long l4 = this.sbb.c2_getCurrentDueSlot();
        Assert.assertEquals((long)l2, (long)(l4 + 60L));
        lx = this.sbb.c2_getNextMessageId();
        Assert.assertEquals((long)lx, (long)3001L);
    }

    @Test(groups={"cassandra"})
    public void testingDueSlotWriting() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        long dueSlot = 101L;
        long dueSlot2 = 102L;
        boolean b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        boolean b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertTrue((boolean)b1);
        Assert.assertTrue((boolean)b2);
        this.sbb.c2_registerDueSlotWriting(dueSlot);
        b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertFalse((boolean)b1);
        Assert.assertTrue((boolean)b2);
        this.sbb.c2_registerDueSlotWriting(dueSlot);
        b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertFalse((boolean)b1);
        Assert.assertTrue((boolean)b2);
        this.sbb.c2_registerDueSlotWriting(dueSlot2);
        b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertFalse((boolean)b1);
        Assert.assertFalse((boolean)b2);
        this.sbb.c2_unregisterDueSlotWriting(dueSlot);
        b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertFalse((boolean)b1);
        Assert.assertFalse((boolean)b2);
        this.sbb.c2_unregisterDueSlotWriting(dueSlot);
        b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertTrue((boolean)b1);
        Assert.assertFalse((boolean)b2);
        this.sbb.c2_unregisterDueSlotWriting(dueSlot);
        b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertTrue((boolean)b1);
        Assert.assertFalse((boolean)b2);
        this.sbb.c2_unregisterDueSlotWriting(dueSlot2);
        b1 = this.sbb.c2_checkDueSlotNotWriting(dueSlot);
        b2 = this.sbb.c2_checkDueSlotNotWriting(dueSlot2);
        Assert.assertTrue((boolean)b1);
        Assert.assertTrue((boolean)b2);
    }

    @Test(groups={"cassandra"})
    public void testingDueSlotForTargetId() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        Date dt = new Date();
        String targetId = "111333";
        String targetId2 = "111444";
        PreparedStatementCollection psc = this.sbb.getStatementCollection(dt);
        long l1 = this.sbb.c2_getDueSlotForTargetId(psc, targetId);
        long l2 = this.sbb.c2_getDueSlotForTargetId(psc, targetId2);
        Assert.assertEquals((long)l1, (long)0L);
        Assert.assertEquals((long)l2, (long)0L);
        long newDueSlot = this.sbb.c2_getDueSlotForNewSms();
        this.sbb.c2_updateDueSlotForTargetId(targetId, newDueSlot);
        l1 = this.sbb.c2_getDueSlotForTargetId(psc, targetId);
        l2 = this.sbb.c2_getDueSlotForTargetId(psc, targetId2);
        Assert.assertEquals((long)l1, (long)newDueSlot);
        Assert.assertEquals((long)l2, (long)0L);
    }

    @Test(groups={"cassandra"})
    public void testingDueSlotForTargetId2() throws Exception {
        long dueSlotLen = this.sbb.getSlotMSecondsTimeArea();
        if (!this.cassandraDbInited) {
            return;
        }
        Date dt = new Date();
        String targetId = this.ta1.getTargetId();
        Sms sms = this.createTestSms(1, this.ta1.getAddr(), this.id1);
        sms.setStored(true);
        sms.setValidityPeriod(null);
        long l1 = this.sbb.c2_getDueSlotForTargetId(targetId);
        Assert.assertEquals((long)l1, (long)0L);
        this.sbb.c2_scheduleMessage_ReschedDueSlot(sms, false, true);
        long newDueSlot = sms.getDueSlot();
        boolean b1 = this.sbb.do_scheduleMessage(sms, newDueSlot, null, false, true);
        Assert.assertTrue((boolean)b1);
        l1 = this.sbb.c2_getDueSlotForTargetId(targetId);
        Assert.assertEquals((long)l1, (long)newDueSlot);
        Assert.assertEquals((long)sms.getDueSlot(), (long)newDueSlot);
        this.sbb.c2_scheduleMessage_ReschedDueSlot(sms, false, true);
        Assert.assertEquals((long)sms.getDueSlot(), (long)newDueSlot);
        b1 = this.sbb.do_scheduleMessage(sms, newDueSlot, null, false, true);
        Assert.assertTrue((boolean)b1);
        Assert.assertEquals((long)sms.getDueSlot(), (long)newDueSlot);
        l1 = this.sbb.c2_getDueSlotForTargetId(targetId);
        Assert.assertEquals((long)l1, (long)newDueSlot);
        long newCurSlot = newDueSlot + 10L;
        this.sbb.c2_setCurrentDueSlot(newCurSlot);
        l1 = this.sbb.c2_getDueSlotForTargetId(targetId);
        Assert.assertEquals((long)l1, (long)newDueSlot);
        b1 = this.sbb.do_scheduleMessage(sms, newDueSlot, null, false, true);
        Assert.assertFalse((boolean)b1);
        this.sbb.c2_scheduleMessage_ReschedDueSlot(sms, false, true);
        long newDueSlot2 = sms.getDueSlot();
        b1 = this.sbb.do_scheduleMessage(sms, newDueSlot2, null, false, true);
        l1 = this.sbb.c2_getDueSlotForTargetId(targetId);
        Assert.assertEquals((long)l1, (long)newDueSlot2);
        long newCurSlot2 = newCurSlot + 86400000L / dueSlotLen;
        this.sbb.c2_setCurrentDueSlot(newCurSlot2);
        l1 = this.sbb.c2_getDueSlotForTargetId(targetId);
        Assert.assertEquals((long)l1, (long)newDueSlot2);
        b1 = this.sbb.do_scheduleMessage(sms, newDueSlot2, null, false, true);
        Assert.assertFalse((boolean)b1);
        long newDueSlot3 = newCurSlot2 + 10L;
        b1 = this.sbb.do_scheduleMessage(sms, newDueSlot3, null, false, true);
        this.sbb.c2_updateDueSlotForTargetId_WithTableCleaning(targetId, newDueSlot3);
        l1 = this.sbb.c2_getDueSlotForTargetId(targetId);
        Assert.assertEquals((long)l1, (long)newDueSlot3);
    }

    @Test(groups={"cassandra"})
    public void testingLifeCycle() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        long dueSlot = this.addingNewMessages();
        this.readAlertMessage();
        SmsSet smsSet = this.readDueSlotMessage(dueSlot, 1);
        this.archiveMessage(smsSet);
        this.addingNewMessages2(dueSlot + 1L);
        smsSet = this.readDueSlotMessage(dueSlot + 1L, 2);
        SmsSetCache.getInstance().clearProcessingSmsSet();
        smsSet = this.readDueSlotMessage(dueSlot, 1);
        Sms sms = smsSet.getSms(0L);
        Assert.assertFalse((boolean)smsSet.isAlertingSupported());
        this.sbb.c2_updateAlertingSupport(sms.getDueSlot(), sms.getSmsSet().getTargetId(), sms.getDbId());
        SmsSetCache.getInstance().clearProcessingSmsSet();
        smsSet = this.readDueSlotMessage(dueSlot, 1);
        Assert.assertTrue((boolean)smsSet.isAlertingSupported());
    }

    @Test(groups={"cassandra"})
    public void testingMsgIsArchive() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        Sms sms_a1 = this.createTestSms(1, this.ta1.getAddr(), this.id1);
        SmsSet smsSet = sms_a1.getSmsSet();
        this.archiveMessage2(smsSet);
    }

    @Test(groups={"cassandra"})
    public void testingOldTimeEncoding() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        this.sbb.setOldShortMessageDbFormat(true);
        DataCodingSchemeImpl dcsGsm7 = new DataCodingSchemeImpl(0);
        DataCodingSchemeImpl dcsUcs2 = new DataCodingSchemeImpl(8);
        DataCodingSchemeImpl dcsGsm8 = new DataCodingSchemeImpl(4);
        UserDataHeaderImpl udh = new UserDataHeaderImpl();
        ConcatenatedShortMessagesIdentifierImpl informationElement = new ConcatenatedShortMessagesIdentifierImpl(false, 20, 5, 2);
        udh.addInformationElement((UserDataHeaderElement)informationElement);
        TargetAddress ta = new TargetAddress(1, 1, "1111", 9);
        this.testOldFormatMessage(ta, (DataCodingScheme)dcsGsm7, "Test eng", (UserDataHeader)udh);
        this.testOldFormatMessage(ta, (DataCodingScheme)dcsGsm7, "Test eng", null);
        this.testOldFormatMessage(ta, (DataCodingScheme)dcsUcs2, "Test rus \u00ef\u00f0\u00e8\u00e2\u00e5\u00f2", (UserDataHeader)udh);
        this.testOldFormatMessage(ta, (DataCodingScheme)dcsUcs2, "Test rus \u00ef\u00f0\u00e8\u00e2\u00e5\u00f2", null);
        this.testOldFormatMessage(ta, (DataCodingScheme)dcsGsm8, null, (UserDataHeader)udh);
    }

    @Test(groups={"cassandra"})
    public void testingTableDeleting() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        Date dt0 = new Date();
        Date dt = new Date(dt0.getTime() - 259200000L);
        PreparedStatementCollection psc = this.sbb.getStatementCollection(dt);
        long newDueSlot = this.sbb.c2_getDueSlotForTime(dt);
        this.sbb.c2_updateDueSlotForTargetId("222222_1_11", newDueSlot);
        this.sbb.c2_deleteLiveTablesForDate(dt);
        this.sbb.c2_deleteArchiveTablesForDate(dt);
    }

    @Test(groups={"cassandra"})
    public void testingTableList() throws Exception {
        if (!this.cassandraDbInited) {
            return;
        }
        Date[] ss = this.sbb.c2_getArchiveTableList(this.sbb.getKeyspaceName());
        boolean i1 = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOldFormatMessage(TargetAddress ta, DataCodingScheme dcs, String msg, UserDataHeader udh) throws Exception {
        long dueSlot;
        Sms sms;
        TargetAddress targetAddress;
        Date dt = new Date();
        PreparedStatementCollection psc = this.sbb.getStatementCollection(dt);
        TargetAddress lock = this.sbb.obtainSynchroObject(ta);
        try {
            targetAddress = lock;
            synchronized (targetAddress) {
                SmsSet smsSet = new SmsSet();
                smsSet.setDestAddr(ta.getAddr());
                smsSet.setDestAddrNpi(ta.getAddrNpi());
                smsSet.setDestAddrTon(ta.getAddrTon());
                smsSet.setCorrelationId("CI=0000");
                smsSet.setNetworkId(9);
                sms = new Sms();
                sms.setSmsSet(smsSet);
                sms.setDbId(UUID.randomUUID());
                sms.setSourceAddr("11112");
                sms.setSourceAddrTon(1);
                sms.setSourceAddrNpi(1);
                sms.setMessageId(8888888L);
                sms.setOrigNetworkId(49);
                sms.setDataCoding(dcs.getCode());
                sms.setShortMessageText(msg);
                if (udh != null) {
                    sms.setEsmClass(64);
                    sms.setShortMessageBin(udh.getEncodedData());
                }
                if ((dueSlot = this.sbb.c2_getDueSlotForTargetId(psc, ta.getTargetId())) == 0L || dueSlot <= this.sbb.c2_getCurrentDueSlot()) {
                    dueSlot = this.sbb.c2_getDueSlotForNewSms();
                    this.sbb.c2_updateDueSlotForTargetId(ta.getTargetId(), dueSlot);
                }
                sms.setDueSlot(dueSlot);
                this.sbb.c2_registerDueSlotWriting(dueSlot);
                try {
                    this.sbb.c2_createRecordCurrent(sms);
                }
                finally {
                    this.sbb.c2_unregisterDueSlotWriting(dueSlot);
                }
            }
        }
        finally {
            this.sbb.obtainSynchroObject(lock);
        }
        lock = this.sbb.obtainSynchroObject(ta);
        try {
            targetAddress = lock;
            synchronized (targetAddress) {
                ArrayList lst;
                this.sbb.c2_registerDueSlotWriting(dueSlot);
                try {
                    ArrayList lst0 = this.sbb.c2_getRecordList(dueSlot);
                    lst = this.sbb.c2_sortRecordList(lst0);
                }
                finally {
                    this.sbb.c2_unregisterDueSlotWriting(dueSlot);
                }
                Assert.assertEquals((int)lst.size(), (int)1);
                SmsSet smsSet = (SmsSet)lst.get(0);
                Assert.assertEquals((int)smsSet.getNetworkId(), (int)9);
                Assert.assertEquals((int)sms.getOrigNetworkId(), (int)49);
                for (Sms sms1 : smsSet.getRawListLastSegment()) {
                    if (!sms1.getDbId().equals(sms.getDbId())) continue;
                    Assert.assertEquals((int)sms1.getDataCoding(), (int)dcs.getCode());
                    if (msg != null) {
                        Assert.assertEquals((String)sms1.getShortMessageText(), (String)msg);
                    } else {
                        Assert.assertNull((Object)sms1.getShortMessageText());
                    }
                    if (udh != null) {
                        Assert.assertEquals((byte[])sms1.getShortMessageBin(), (byte[])udh.getEncodedData());
                    } else {
                        Assert.assertNull((Object)sms1.getShortMessageBin());
                    }
                    Assert.assertEquals((String)smsSet.getCorrelationId(), (String)"CI=0000");
                }
            }
        }
        finally {
            this.sbb.obtainSynchroObject(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addingNewMessages() throws Exception {
        long dueSlot;
        Sms sms_a1;
        TargetAddress targetAddress;
        Date dt = new Date();
        PreparedStatementCollection psc = this.sbb.getStatementCollection(dt);
        TargetAddress lock = this.sbb.obtainSynchroObject(this.ta1);
        try {
            targetAddress = lock;
            synchronized (targetAddress) {
                sms_a1 = this.createTestSms(1, this.ta1.getAddr(), this.id1);
                Sms sms_a2 = this.createTestSms(2, this.ta1.getAddr(), this.id2);
                Sms sms_a3 = this.createTestSms(3, this.ta1.getAddr(), this.id3);
                dueSlot = this.sbb.c2_getDueSlotForTargetId(psc, this.ta1.getTargetId());
                if (dueSlot == 0L || dueSlot <= this.sbb.c2_getCurrentDueSlot()) {
                    dueSlot = this.sbb.c2_getDueSlotForNewSms();
                    this.sbb.c2_updateDueSlotForTargetId(this.ta1.getTargetId(), dueSlot);
                }
                sms_a1.setDueSlot(dueSlot);
                sms_a2.setDueSlot(dueSlot);
                sms_a3.setDueSlot(dueSlot);
                this.sbb.c2_registerDueSlotWriting(dueSlot);
                try {
                    this.sbb.c2_createRecordCurrent(sms_a1);
                    this.sbb.c2_createRecordCurrent(sms_a2);
                    this.sbb.c2_createRecordCurrent(sms_a3);
                }
                finally {
                    this.sbb.c2_unregisterDueSlotWriting(dueSlot);
                }
            }
        }
        finally {
            this.sbb.obtainSynchroObject(lock);
        }
        lock = this.sbb.obtainSynchroObject(this.ta2);
        try {
            targetAddress = lock;
            synchronized (targetAddress) {
                sms_a1 = this.createTestSms(4, this.ta2.getAddr(), this.id4);
                this.sbb.c2_updateDueSlotForTargetId(this.ta2.getTargetId(), dueSlot);
                sms_a1.setDueSlot(dueSlot);
                this.sbb.c2_registerDueSlotWriting(dueSlot);
                try {
                    this.sbb.c2_createRecordCurrent(sms_a1);
                }
                finally {
                    this.sbb.c2_unregisterDueSlotWriting(dueSlot);
                }
            }
        }
        finally {
            this.sbb.obtainSynchroObject(lock);
        }
        return dueSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addingNewMessages2(long dueSlot) throws Exception {
        Date dt = new Date();
        PreparedStatementCollection psc = this.sbb.getStatementCollection(dt);
        TargetAddress lock = this.sbb.obtainSynchroObject(this.ta1);
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                Sms sms_a5 = this.createTestSms(5, this.ta1.getAddr(), this.id5);
                sms_a5.setDueSlot(dueSlot);
                this.sbb.c2_registerDueSlotWriting(dueSlot);
                try {
                    this.sbb.c2_createRecordCurrent(sms_a5);
                }
                finally {
                    this.sbb.c2_unregisterDueSlotWriting(dueSlot);
                }
            }
        }
        finally {
            this.sbb.obtainSynchroObject(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAlertMessage() throws Exception {
        Date dt = new Date();
        PreparedStatementCollection psc = this.sbb.getStatementCollection(dt);
        TargetAddress lock = this.sbb.obtainSynchroObject(this.ta2);
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                SmsSet smsSet;
                long dueSlot = this.sbb.c2_getDueSlotForTargetId(psc, this.ta2.getTargetId());
                if (dueSlot == 0L) {
                    Assert.fail((String)"Bad dueSlot for reading of ta2");
                }
                this.sbb.c2_registerDueSlotWriting(dueSlot);
                try {
                    smsSet = this.sbb.c2_getRecordListForTargeId(dueSlot, this.ta2.getTargetId());
                    ArrayList<SmsSet> lst0 = new ArrayList<SmsSet>();
                    lst0.add(smsSet);
                    ArrayList lst = this.sbb.c2_sortRecordList(lst0);
                }
                finally {
                    this.sbb.c2_unregisterDueSlotWriting(dueSlot);
                }
                Assert.assertEquals((long)smsSet.getSmsCount(), (long)1L);
                Sms sms = smsSet.getSms(0L);
                Assert.assertEquals((long)sms.getDueSlot(), (long)dueSlot);
                this.checkTestSms(4, sms, this.id4, false);
                this.sbb.c2_updateInSystem(sms, 1, false);
            }
        }
        finally {
            this.sbb.obtainSynchroObject(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmsSet readDueSlotMessage(long dueSlot, int opt) throws Exception {
        TargetAddress lock = this.sbb.obtainSynchroObject(this.ta2);
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                Sms sms1;
                ArrayList lst;
                this.sbb.c2_registerDueSlotWriting(dueSlot);
                try {
                    ArrayList lst0 = this.sbb.c2_getRecordList(dueSlot);
                    lst = this.sbb.c2_sortRecordList(lst0);
                }
                finally {
                    this.sbb.c2_unregisterDueSlotWriting(dueSlot);
                }
                Assert.assertEquals((int)lst.size(), (int)1);
                SmsSet smsSet = (SmsSet)lst.get(0);
                if (opt == 1) {
                    Assert.assertEquals((long)smsSet.getSmsCount(), (long)3L);
                    sms1 = smsSet.getSms(0L);
                    Sms sms2 = smsSet.getSms(1L);
                    Sms sms3 = smsSet.getSms(2L);
                    Assert.assertEquals((long)sms1.getDueSlot(), (long)dueSlot);
                    Assert.assertEquals((long)sms2.getDueSlot(), (long)dueSlot);
                    Assert.assertEquals((long)sms3.getDueSlot(), (long)dueSlot);
                    this.checkTestSms(1, sms1, this.id1, false);
                    this.checkTestSms(2, sms2, this.id2, false);
                    this.checkTestSms(3, sms3, this.id3, false);
                    Assert.assertEquals((String)smsSet.getCorrelationId(), (String)"CI=100001000022222");
                } else {
                    Assert.assertEquals((long)smsSet.getSmsCount(), (long)4L);
                    sms1 = smsSet.getSms(0L);
                    Sms sms2 = smsSet.getSms(1L);
                    Sms sms3 = smsSet.getSms(2L);
                    Assert.assertEquals((long)sms1.getDueSlot(), (long)(dueSlot - 1L));
                    Assert.assertEquals((long)sms2.getDueSlot(), (long)(dueSlot - 1L));
                    Assert.assertEquals((long)sms3.getDueSlot(), (long)(dueSlot - 1L));
                    this.checkTestSms(1, sms1, this.id1, false);
                    this.checkTestSms(2, sms2, this.id2, false);
                    this.checkTestSms(3, sms3, this.id3, false);
                    Sms sms5 = smsSet.getSms(3L);
                    Assert.assertEquals((long)sms5.getDueSlot(), (long)dueSlot);
                    this.checkTestSms(5, sms5, this.id5, false);
                }
                SmsSet smsSet2 = smsSet;
                return smsSet2;
            }
        }
        finally {
            this.sbb.obtainSynchroObject(lock);
        }
    }

    public void archiveMessage(SmsSet smsSet) throws Exception {
        for (int i1 = 0; i1 < 3; ++i1) {
            Sms sms = smsSet.getSms((long)i1);
            sms.getSmsSet().setType(SmType.SMS_FOR_SS7);
            sms.getSmsSet().setImsi("12345678900000");
            ISDNAddressStringImpl networkNodeNumber = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, "2223334444");
            LocationInfoWithLMSIImpl locationInfoWithLMSI = new LocationInfoWithLMSIImpl((ISDNAddressString)networkNodeNumber, null, null, false, null);
            sms.getSmsSet().setLocationInfoWithLMSI((LocationInfoWithLMSI)locationInfoWithLMSI);
            this.sbb.c2_createRecordArchive(sms);
        }
        Sms sms = smsSet.getSms(0L);
        SmsProxy smsx = this.sbb.obtainArchiveSms(sms.getDueSlot(), sms.getSmsSet().getDestAddr(), sms.getDbId());
        this.checkTestSms(1, smsx.sms, sms.getDbId(), true);
        Sms smsy = this.sbb.c2_getRecordArchiveForMessageId(sms.getMessageId());
        this.checkTestSms(1, smsy, sms.getDbId(), true);
    }

    public void archiveMessage2(SmsSet smsSet) throws Exception {
        Sms sms = smsSet.getSms(0L);
        Date date = new Date();
        Date date2 = new Date(date.getTime() - 86400000L);
        sms.setDeliveryDate(date2);
        sms.getSmsSet().setType(SmType.SMS_FOR_SS7);
        sms.getSmsSet().setImsi("12345678900000");
        ISDNAddressStringImpl networkNodeNumber = new ISDNAddressStringImpl(AddressNature.international_number, NumberingPlan.ISDN, "2223334444");
        LocationInfoWithLMSIImpl locationInfoWithLMSI = new LocationInfoWithLMSIImpl((ISDNAddressString)networkNodeNumber, null, null, false, null);
        sms.getSmsSet().setLocationInfoWithLMSI((LocationInfoWithLMSI)locationInfoWithLMSI);
        this.sbb.c2_createRecordArchive(sms);
        Sms smsy = this.sbb.c2_getRecordArchiveForMessageId(sms.getMessageId());
        this.checkTestSms(1, smsy, sms.getDbId(), true);
        smsy = this.sbb.c2_getRecordArchiveForMessageId(sms.getMessageId() + 1234124124L);
        Assert.assertNull((Object)smsy);
    }

    private Sms createTestSms(int num, String number, UUID id) throws Exception {
        PreparedStatementCollection psc = this.sbb.getStatementCollection(new Date());
        SmsSet smsSet = new SmsSet();
        smsSet.setDestAddr(number);
        smsSet.setDestAddrNpi(1);
        smsSet.setDestAddrTon(5);
        smsSet.setNetworkId(9);
        if (num == 1) {
            smsSet.setCorrelationId("CI=100001000022222");
        }
        Sms sms = new Sms();
        smsSet.addSms(sms);
        sms.setDbId(id);
        sms.setSourceAddr("11112_" + num);
        sms.setSourceAddrTon(14 + num);
        sms.setSourceAddrNpi(11 + num);
        sms.setMessageId((long)(8888888 + num));
        sms.setMoMessageRef(102 + num);
        sms.setOrigNetworkId(49);
        sms.setOrigEsmeName("esme_" + num);
        sms.setOrigSystemId("sys_" + num);
        sms.setSubmitDate(new GregorianCalendar(2013, 1, 15, 12, 0 + num).getTime());
        sms.setDeliveryDate(new GregorianCalendar(2013, 1, 15, 12, 15 + num).getTime());
        sms.setServiceType("serv_type__" + num);
        sms.setEsmClass(11 + num);
        sms.setProtocolId(12 + num);
        sms.setPriority(13 + num);
        sms.setRegisteredDelivery(14 + num);
        sms.setReplaceIfPresent(15 + num);
        sms.setDataCoding(16 + num);
        sms.setDefaultMsgId(17 + num);
        if (num != 2) {
            sms.setShortMessageText("Mes text" + num);
        }
        if (num != 3) {
            sms.setShortMessageBin(new byte[]{(byte)(21 + num), 23, 25, 27, 29});
        }
        sms.setScheduleDeliveryTime(new GregorianCalendar(2013, 1, 20, 10, 0 + num).getTime());
        sms.setValidityPeriod(new GregorianCalendar(2013, 1, 23, 13, 33 + num).getTime());
        Tlv tlv = new Tlv(5, new byte[]{(byte)(1 + num), 2, 3, 4, 5});
        sms.getTlvSet().addOptionalParameter(tlv);
        tlv = new Tlv(6, new byte[]{(byte)(6 + num), 7, 8});
        sms.getTlvSet().addOptionalParameter(tlv);
        smsSet.setDueDelay(510);
        sms.setDeliveryCount(9);
        sms.setOriginatorSccpAddress("11224455");
        sms.setStatusReportRequest(true);
        sms.setDeliveryAttempt(321);
        sms.setUserData("userdata");
        sms.setExtraData("extradata_1");
        sms.setExtraData_2("extradata_2");
        sms.setExtraData_3("extradata_3");
        sms.setExtraData_4("extradata_4");
        return sms;
    }

    private void checkTestSms(int num, Sms sms, UUID id, boolean isArchive) {
        Assert.assertTrue((boolean)sms.getDbId().equals(id));
        Assert.assertEquals((int)sms.getSmsSet().getDueDelay(), (int)510);
        Assert.assertEquals((int)sms.getSmsSet().getNetworkId(), (int)9);
        Assert.assertEquals((int)sms.getDeliveryCount(), (int)9);
        Assert.assertEquals((String)sms.getSourceAddr(), (String)("11112_" + num));
        Assert.assertEquals((int)sms.getSourceAddrTon(), (int)(14 + num));
        Assert.assertEquals((int)sms.getSourceAddrNpi(), (int)(11 + num));
        Assert.assertEquals((int)sms.getOrigNetworkId(), (int)49);
        Assert.assertEquals((long)sms.getMessageId(), (long)(8888888 + num));
        Assert.assertEquals((int)sms.getMoMessageRef(), (int)(102 + num));
        Assert.assertEquals((String)sms.getOrigEsmeName(), (String)("esme_" + num));
        Assert.assertEquals((String)sms.getOrigSystemId(), (String)("sys_" + num));
        Assert.assertTrue((boolean)sms.getSubmitDate().equals(new GregorianCalendar(2013, 1, 15, 12, 0 + num).getTime()));
        Assert.assertEquals((String)sms.getServiceType(), (String)("serv_type__" + num));
        Assert.assertEquals((int)sms.getEsmClass(), (int)(11 + num));
        Assert.assertEquals((int)sms.getProtocolId(), (int)(12 + num));
        Assert.assertEquals((int)sms.getPriority(), (int)(13 + num));
        Assert.assertEquals((int)sms.getRegisteredDelivery(), (int)(14 + num));
        Assert.assertEquals((int)sms.getReplaceIfPresent(), (int)(15 + num));
        Assert.assertEquals((int)sms.getDataCoding(), (int)(16 + num));
        Assert.assertEquals((int)sms.getDefaultMsgId(), (int)(17 + num));
        if (num != 2) {
            Assert.assertEquals((String)sms.getShortMessageText(), (String)("Mes text" + num));
        } else {
            Assert.assertNull((Object)sms.getShortMessageText());
        }
        if (num != 3) {
            Assert.assertEquals((byte[])sms.getShortMessageBin(), (byte[])new byte[]{(byte)(21 + num), 23, 25, 27, 29});
        } else {
            Assert.assertNull((Object)sms.getShortMessageBin());
        }
        Assert.assertEquals((Object)sms.getScheduleDeliveryTime(), (Object)new GregorianCalendar(2013, 1, 20, 10, 0 + num).getTime());
        Assert.assertEquals((Object)sms.getValidityPeriod(), (Object)new GregorianCalendar(2013, 1, 23, 13, 33 + num).getTime());
        Assert.assertEquals((int)sms.getTlvSet().getOptionalParameterCount(), (int)2);
        Assert.assertEquals((byte[])sms.getTlvSet().getOptionalParameter((short)5).getValue(), (byte[])new byte[]{(byte)(1 + num), 2, 3, 4, 5});
        Assert.assertEquals((byte[])sms.getTlvSet().getOptionalParameter((short)6).getValue(), (byte[])new byte[]{(byte)(6 + num), 7, 8});
        Assert.assertEquals((String)sms.getOriginatorSccpAddress(), (String)"11224455");
        Assert.assertTrue((boolean)sms.isStatusReportRequest());
        Assert.assertEquals((int)sms.getDeliveryAttempt(), (int)321);
        Assert.assertEquals((String)sms.getUserData(), (String)"userdata");
        Assert.assertEquals((String)sms.getExtraData(), (String)"extradata_1");
        Assert.assertEquals((String)sms.getExtraData_2(), (String)"extradata_2");
        Assert.assertEquals((String)sms.getExtraData_3(), (String)"extradata_3");
        Assert.assertEquals((String)sms.getExtraData_4(), (String)"extradata_4");
    }
}

