/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.persistence;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.library.MessageUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TimeProcessingTest {
    private String getTimeA1() {
        return "020615103429512+";
    }

    private String getTimeA2() {
        return "020615103429512-";
    }

    private String getTimeA3() {
        return "020615123429512+";
    }

    private String getTimeRel() {
        return "000000013000000R";
    }

    @Test(groups={"timeProcessing"})
    public void testDateDecoding() throws Exception {
        Date curDate = new Date(2013, 7, 1);
        int i1 = curDate.getTimezoneOffset();
        Date d1 = MessageUtil.parseSmppDate((String)this.getTimeA1());
        Date d11 = new GregorianCalendar(2002, 5, 15, 10, 34, 29).getTime();
        Date d111 = new Date(d11.getTime() - 10800000L - (long)(i1 * 60 * 1000) + 500L);
        Assert.assertTrue((boolean)d1.equals(d111));
        Date d2 = MessageUtil.parseSmppDate((String)this.getTimeA2());
        Date d22 = new GregorianCalendar(2002, 5, 15, 10, 34, 29).getTime();
        Date d222 = new Date(d22.getTime() + 10800000L - (long)(i1 * 60 * 1000) + 500L);
        Assert.assertTrue((boolean)d2.equals(d222));
        d2 = MessageUtil.parseSmppDate((String)this.getTimeA3());
        d22 = new GregorianCalendar(2002, 5, 15, 12, 34, 29).getTime();
        d222 = new Date(d22.getTime() - 10800000L - (long)(i1 * 60 * 1000) + 500L);
        Assert.assertTrue((boolean)d2.equals(d222));
        curDate = new Date();
        Date d3 = MessageUtil.parseSmppDate((String)this.getTimeRel());
        Date d333 = new Date(curDate.getTime() + 5400000L);
        this.testDateEq(d3, d333);
    }

    @Test(groups={"timeProcessing"})
    public void testDateEncoding() throws Exception {
        GregorianCalendar c1 = new GregorianCalendar(2002, 5, 15, 10, 34, 29);
        ((Calendar)c1).add(14, 500);
        Date d1 = c1.getTime();
        String s1 = MessageUtil.printSmppAbsoluteDate((Date)d1, (int)180);
        Assert.assertEquals((String)s1, (String)this.getTimeA1());
        String s2 = MessageUtil.printSmppAbsoluteDate((Date)d1, (int)-180);
        Assert.assertEquals((String)s2, (String)this.getTimeA2());
        c1 = new GregorianCalendar(2002, 5, 15, 12, 34, 29);
        ((Calendar)c1).add(14, 500);
        d1 = c1.getTime();
        s1 = MessageUtil.printSmppAbsoluteDate((Date)d1, (int)180);
        Assert.assertEquals((String)s1, (String)this.getTimeA3());
        String s3 = MessageUtil.printSmppRelativeDate((int)0, (int)0, (int)0, (int)1, (int)30, (int)0);
        Assert.assertEquals((String)s3, (String)this.getTimeRel());
    }

    @Test(groups={"timeProcessing"})
    public void testScheduleDeliveryTime_ValidityPeriod() throws Exception {
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance((String)"TestSmscPropertiesManagement");
    }

    private void testDateEq(Date d1, Date d2) {
        long tm = d2.getTime();
        Date d3 = new Date(tm -= 120000L);
        tm = d2.getTime();
        Date d4 = new Date(tm += 120000L);
        Assert.assertTrue((boolean)d1.after(d3));
        Assert.assertTrue((boolean)d1.before(d4));
    }
}

