/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.sip.server.rx;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import javax.sip.ClientTransaction;
import javax.sip.ListeningPoint;
import javax.sip.ResponseEvent;
import javax.sip.TimeoutEvent;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.EventContext;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.ServiceID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javolution.util.FastList;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncodingData;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.smsc.cassandra.DatabaseType;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.Sip;
import org.mobicents.smsc.domain.SipManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.CdrGenerator;
import org.mobicents.smsc.library.ErrorAction;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageDeliveryResultResponseInterface;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.SbbStates;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.SmscProcessingException;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerActivity;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;
import org.mobicents.smsc.slee.services.smpp.server.events.SmsSetEvent;
import org.mobicents.smsc.smpp.GenerateType;
import org.mobicents.smsc.smpp.SmppEncoding;

public abstract class RxSipServerSbb
implements Sbb {
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    protected static SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final ResourceAdaptorTypeID SCHEDULE_ID = new ResourceAdaptorTypeID("SchedulerResourceAdaptorType", "org.mobicents", "1.0");
    private static final String PERSISTENCE_LINK = "PersistenceResourceAdaptor";
    private static final String SCHEDULE_LINK = "SchedulerResourceAdaptor";
    private static final ResourceAdaptorTypeID SIP_RA_TYPE_ID = new ResourceAdaptorTypeID("JAIN SIP", "javax.sip", "1.2");
    private static final String SIP_RA_LINK = "SipRA";
    private SleeSipProvider sipRA;
    private MessageFactory messageFactory;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private SipActivityContextInterfaceFactory sipACIFactory = null;
    private Tracer logger;
    private SbbContextExt sbbContext;
    private PersistenceRAInterface persistence;
    private SchedulerRaSbbInterface scheduler;
    private SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    private static final SipManagement sipManagement = SipManagement.getInstance();
    private static Charset ucs2Charset = Charset.forName("UTF-16BE");
    private static Charset utf8Charset = Charset.forName("UTF-8");
    private static Charset isoCharset = Charset.forName("ISO-8859-1");
    private static Charset gsm7Charset = new GSMCharset("GSM", new String[0]);

    public PersistenceRAInterface getStore() {
        return this.persistence;
    }

    public SchedulerRaSbbInterface getScheduler() {
        return this.scheduler;
    }

    public void onSipSm(SmsSetEvent event, ActivityContextInterface aci, EventContext eventContext) {
        try {
            int curMsg;
            Sms sms;
            if (this.logger.isFineEnabled()) {
                this.logger.fine("\nReceived SIP SMS. event= " + event + "this=" + this);
            }
            SmsSet smsSet = event.getSmsSet();
            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                try {
                    this.getStore().fetchSchedulableSms(smsSet, false);
                }
                catch (PersistenceException e) {
                    this.onDeliveryError(smsSet, ErrorAction.temporaryFailure, ErrorCode.SC_SYSTEM_ERROR, "PersistenceException when fetchSchedulableSms(): " + e.getMessage());
                    return;
                }
            }
            if ((sms = smsSet.getSms((long)(curMsg = 0))) != null) {
                if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                    this.startMessageDelivery(sms);
                } else {
                    sms.setDeliveryCount(sms.getDeliveryCount() + 1);
                }
            }
            this.setCurrentMsgNum(curMsg);
            this.setTargetId(smsSet.getTargetId());
            try {
                this.sendMessage(smsSet);
            }
            catch (SmscProcessingException e) {
                String s = "SmscProcessingException when sending SIP MESSAGE=" + e.getMessage() + ", Message=" + sms;
                this.logger.severe(s, (Throwable)e);
                this.onDeliveryError(smsSet, ErrorAction.temporaryFailure, ErrorCode.SC_SYSTEM_ERROR, s);
            }
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in RxSmppServerSbb.onDeliverSm() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    public void onCLIENT_ERROR(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.warning("onCLIENT_ERROR " + event);
        String targetId = this.getTargetId();
        if (targetId == null) {
            this.logger.severe("onCLIENT_ERROR but there is no TargetId CMP!");
            return;
        }
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            this.logger.severe("onCLIENT_ERROR but CMP smsSet is missed, targetId=" + targetId);
            return;
        }
        this.onDeliveryError(smsSet, ErrorAction.temporaryFailure, ErrorCode.SC_SYSTEM_ERROR, "SIP Exception CLIENT_ERROR received. Reason : " + event.getResponse().getReasonPhrase() + " Status Code : " + event.getResponse().getStatusCode());
    }

    public void onSERVER_ERROR(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.severe("onSERVER_ERROR " + event);
        String targetId = this.getTargetId();
        if (targetId == null) {
            this.logger.severe("onSERVER_ERROR but there is no TargetId CMP!");
            return;
        }
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            this.logger.severe("onSERVER_ERROR but CMP smsSet is missed, targetId=" + targetId);
            return;
        }
        this.onDeliveryError(smsSet, ErrorAction.permanentFailure, ErrorCode.SC_SYSTEM_ERROR, "SIP Exception SERVER_ERROR received. Reason : " + event.getResponse().getReasonPhrase() + " Status Code : " + event.getResponse().getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onSUCCESS(ResponseEvent event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onSUCCESS " + event);
        }
        try {
            block63: {
                targetId = this.getTargetId();
                if (targetId == null) {
                    this.logger.severe("RxSmppServerSbb.sendDeliverSm(): onDeliverSmResp CMP missed");
                    return;
                }
                smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
                if (smsSet == null) {
                    this.logger.severe("RxSmppServerSbb.sendDeliverSm(): In onDeliverSmResp CMP smsSet is missed, targetId=" + targetId);
                    return;
                }
                this.smscStatAggregator.updateMsgOutSentAll();
                this.smscStatAggregator.updateMsgOutSentSip();
                currentMsgNum = this.getCurrentMsgNum();
                sms = smsSet.getSms(currentMsgNum);
                if (sms.getMessageDeliveryResultResponse() != null) {
                    sms.getMessageDeliveryResultResponse().responseDeliverySuccess();
                    sms.setMessageDeliveryResultResponse(null);
                }
                pers = this.getStore();
                deliveryDate = new Date();
                try {
                    isPartial = MessageUtil.isSmsNotLastSegment((Sms)sms);
                    CdrGenerator.generateCdr((Sms)sms, (String)(isPartial != false ? "partial_sip" : "success_sip"), (String)"", (boolean)RxSipServerSbb.smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)RxSipServerSbb.smscPropertiesManagement.getGenerateCdr()));
                    if (RxSipServerSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.archiveDeliveredSms(sms, deliveryDate);
                    } else {
                        pers.c2_updateInSystem(sms, 2, RxSipServerSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
                        sms.setDeliveryDate(deliveryDate);
                        sms.getSmsSet().setStatus(ErrorCode.SUCCESS);
                        if (MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)RxSipServerSbb.smscPropertiesManagement.getGenerateArchiveTable())) {
                            pers.c2_createRecordArchive(sms);
                        }
                    }
                    mProcResult = MProcManagement.getInstance().applyMProcDelivery(sms, false);
                    addedMessages = mProcResult.getMessageList();
                    if (addedMessages != null) {
                        n = addedMessages.head();
                        end = addedMessages.tail();
                        while ((n = n.getNext()) != end) {
                            smst = (Sms)n.getValue();
                            ta = new TargetAddress(smst.getSmsSet().getDestAddrTon(), smst.getSmsSet().getDestAddrNpi(), smst.getSmsSet().getDestAddr(), smst.getSmsSet().getNetworkId());
                            lock2 = SmsSetCache.getInstance().addSmsSet(ta);
                            try {
                                var18_26 = lock2;
                                synchronized (var18_26) {
                                    if (RxSipServerSbb.smscPropertiesManagement.getDatabaseType() != DatabaseType.Cassandra_1) {
                                        storeAndForwMode = MessageUtil.isStoreAndForward((Sms)smst);
                                        if (!storeAndForwMode) {
                                            try {
                                                this.scheduler.injectSmsOnFly(smst.getSmsSet(), true);
                                            }
                                            catch (Exception e) {
                                                this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages: " + e.getMessage(), (Throwable)e);
                                            }
                                        } else if (RxSipServerSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                            try {
                                                smst.setStoringAfterFailure(true);
                                                this.scheduler.injectSmsOnFly(smst.getSmsSet(), true);
                                            }
                                            catch (Exception e) {
                                                this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages: " + e.getMessage(), (Throwable)e);
                                            }
                                        } else {
                                            smst.setStored(true);
                                            this.scheduler.setDestCluster(smst.getSmsSet());
                                            try {
                                                pers.c2_scheduleMessage_ReschedDueSlot(smst, RxSipServerSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                            }
                                            catch (PersistenceException e) {
                                                this.logger.severe("PersistenceException when adding applyMProcDelivery created messages" + e.getMessage(), (Throwable)e);
                                            }
                                        }
                                    }
                                }
                            }
                            finally {
                                SmsSetCache.getInstance().removeSmsSet(lock2);
                            }
                        }
                    }
                    registeredDelivery = sms.getRegisteredDelivery();
                    if (RxSipServerSbb.smscPropertiesManagement.getReceiptsDisabling() || !MessageUtil.isReceiptOnSuccess((int)registeredDelivery)) break block63;
                    ta = new TargetAddress(sms.getSourceAddrTon(), sms.getSourceAddrNpi(), sms.getSourceAddr(), smsSet.getNetworkId());
                    lock = SmsSetCache.getInstance().addSmsSet(ta);
                    try {
                        var16_24 = lock;
                        synchronized (var16_24) {
                            if (RxSipServerSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                                receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)true);
                                backSmsSet = pers.obtainSmsSet(ta);
                                receipt.setSmsSet(backSmsSet);
                                receipt.setStored(true);
                                pers.createLiveSms(receipt);
                                pers.setNewMessageScheduled(receipt.getSmsSet(), MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)RxSipServerSbb.smscPropertiesManagement.getFirstDueDelay())));
                                this.logger.info("Adding a delivery receipt: source=" + receipt.getSourceAddr() + ", dest=" + receipt.getSmsSet().getDestAddr());
                            } else {
                                receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)true, (TargetAddress)ta, (boolean)RxSipServerSbb.smscPropertiesManagement.getOrigNetworkIdForReceipts());
                                storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                                if (!storeAndForwMode) {
                                    try {
                                        this.scheduler.injectSmsOnFly(receipt.getSmsSet(), true);
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in handleSmsResponse(): " + e.getMessage(), (Throwable)e);
                                    }
                                } else if (RxSipServerSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                    try {
                                        receipt.setStoringAfterFailure(true);
                                        this.scheduler.injectSmsOnFly(receipt.getSmsSet(), true);
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in handleSmsResponse(): " + e.getMessage(), (Throwable)e);
                                    }
                                } else {
                                    receipt.setStored(true);
                                    this.scheduler.setDestCluster(receipt.getSmsSet());
                                    pers.c2_scheduleMessage_ReschedDueSlot(receipt, RxSipServerSbb.smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                }
                            }
                        }
                    }
                    finally {
                        SmsSetCache.getInstance().removeSmsSet(lock);
                    }
                }
                catch (PersistenceException e1) {
                    this.logger.severe("PersistenceException when archiveDeliveredSms() in RxSmppServerSbb.onDeliverSmResp(): " + e1.getMessage(), (Throwable)e1);
                }
            }
            lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
            var11_13 = lock;
            synchronized (var11_13) {
                smsSet.markSmsAsDelivered(currentMsgNum);
                if (currentMsgNum >= smsSet.getSmsCount() - 1L) ** GOTO lbl-1000
                this.setCurrentMsgNum(++currentMsgNum);
                sms = smsSet.getSms(currentMsgNum);
                if (sms != null) {
                    if (RxSipServerSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        this.startMessageDelivery(sms);
                    } else {
                        sms.setDeliveryCount(sms.getDeliveryCount() + 1);
                    }
                }
                try {
                    this.sendMessage(smsSet);
                    ** GOTO lbl137
                }
                catch (SmscProcessingException e) {
                    s = "SmscProcessingException when sending initial sendDeliverSm()=" + e.getMessage() + ", Message=" + sms;
                    this.logger.severe(s, (Throwable)e);
                    ** GOTO lbl-1000
                }
            }
            {
                catch (Throwable var26_37) {
                    throw var26_37;
                }
lbl137:
                // 1 sources

                pers.releaseSynchroObject(lock);
                return;
lbl-1000:
                // 2 sources

                {
                    if (RxSipServerSbb.smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        try {
                            pers.fetchSchedulableSms(smsSet, false);
                        }
                        catch (PersistenceException e1) {
                            this.logger.severe("PersistenceException when invoking fetchSchedulableSms(smsSet) from RxSmppServerSbb.onDeliverSmResp(): " + e1.toString(), (Throwable)e1);
                        }
                        if (smsSet.getSmsCount() > 0L) {
                            currentMsgNum = 0L;
                            this.setCurrentMsgNum(currentMsgNum);
                            try {
                                this.sendMessage(smsSet);
                            }
                            catch (SmscProcessingException e) {}
                            ** try [egrp 17[TRYBLOCK] [23 : 1464->1536)] { 
lbl153:
                            // 1 sources

                            s = "SmscProcessingException when sending initial sendDeliverSm()=" + e.getMessage() + ", Message=" + sms;
                            this.logger.severe(s, (Throwable)e);
                        }
                    }
                    this.freeSmsSetSucceded(smsSet, pers);
                    return;
lbl157:
                    // 1 sources

                    finally {
                        pers.releaseSynchroObject(lock);
                    }
                }
            }
            pers.releaseSynchroObject(lock);
            return;
        }
        catch (Throwable e1) {
            this.logger.severe("Exception in RxSmppServerSbb.onDeliverSmResp() when fetching records and issuing events: " + e1.getMessage(), e1);
        }
    }

    public void onTRYING(ResponseEvent event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onTRYING " + event);
        }
    }

    public void onPROVISIONAL(ResponseEvent event, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("onPROVISIONAL " + event);
        }
    }

    public void onREDIRECT(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.warning("onREDIRECT " + event);
    }

    public void onGLOBAL_FAILURE(ResponseEvent event, ActivityContextInterface aci) {
        this.logger.severe("onGLOBAL_FAILURE " + event);
        String targetId = this.getTargetId();
        if (targetId == null) {
            this.logger.severe("onGLOBAL_FAILURE but there is no TargetId CMP!");
            return;
        }
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            this.logger.severe("onGLOBAL_FAILURE but CMP smsSet is missed, targetId=" + targetId);
            return;
        }
        this.onDeliveryError(smsSet, ErrorAction.permanentFailure, ErrorCode.SC_SYSTEM_ERROR, "SIP Exception GLOBAL_FAILURE received. Reason : " + event.getResponse().getReasonPhrase() + " Status Code : " + event.getResponse().getStatusCode());
    }

    public void onTRANSACTION_TIMEOUT(TimeoutEvent event, ActivityContextInterface aci) {
        this.logger.warning("onTRANSACTION_TIMEOUT " + event);
        String targetId = this.getTargetId();
        if (targetId == null) {
            this.logger.severe("onTRANSACTION_TIMEOUT but there is no TargetId CMP!");
            return;
        }
        SmsSet smsSet = SmsSetCache.getInstance().getProcessingSmsSet(targetId);
        if (smsSet == null) {
            this.logger.severe("onTRANSACTION_TIMEOUT but CMP smsSet is missed, targetId=" + targetId);
            return;
        }
        this.onDeliveryError(smsSet, ErrorAction.temporaryFailure, ErrorCode.SC_SYSTEM_ERROR, "SIP Exception TRANSACTION_TIMEOUT received.");
    }

    public abstract void setTargetId(String var1);

    public abstract String getTargetId();

    public abstract void setCurrentMsgNum(long var1);

    public abstract long getCurrentMsgNum();

    private void sendMessage(SmsSet smsSet) throws SmscProcessingException {
        this.smscStatAggregator.updateMsgOutTryAll();
        this.smscStatAggregator.updateMsgOutTrySip();
        long currentMsgNum = this.getCurrentMsgNum();
        Sms sms = smsSet.getSms(currentMsgNum);
        if (sms == null) {
            this.onDeliveryError(smsSet, ErrorAction.temporaryFailure, ErrorCode.SUCCESS, "No messages for sending now");
            return;
        }
        try {
            Date validityPeriod;
            String fromAddressStr = sms.getSourceAddr();
            String toAddressStr = smsSet.getDestAddr();
            Sip sip = sipManagement.getSipByName("SIP");
            ListeningPoint listeningPoint = this.sipRA.getListeningPoints()[0];
            SipURI fromAddressUri = this.addressFactory.createSipURI(fromAddressStr, listeningPoint.getIPAddress() + ":" + listeningPoint.getPort());
            Address fromAddress = this.addressFactory.createAddress((URI)fromAddressUri);
            FromHeader fromHeader = this.headerFactory.createFromHeader(fromAddress, null);
            SipURI toAddressUri = this.addressFactory.createSipURI(toAddressStr, sip.getSipAddress());
            Address toAddress = this.addressFactory.createAddress((URI)toAddressUri);
            ToHeader toHeader = this.headerFactory.createToHeader(toAddress, null);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>(1);
            ViaHeader viaHeader = this.headerFactory.createViaHeader(listeningPoint.getIPAddress(), listeningPoint.getPort(), listeningPoint.getTransport(), null);
            viaHeaders.add(viaHeader);
            ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader("text", "plain");
            CSeqHeader cSeqHeader = this.headerFactory.createCSeqHeader(2L, "MESSAGE");
            MaxForwardsHeader maxForwardsHeader = this.headerFactory.createMaxForwardsHeader(70);
            CallIdHeader callId = this.sipRA.getNewCallId();
            String msgStr = sms.getShortMessageText();
            byte[] msgUdh = sms.getShortMessageBin();
            byte[] msg = this.recodeShortMessage(sms.getDataCoding(), msgStr, msgUdh);
            Request request = this.messageFactory.createRequest((URI)toAddressUri, "MESSAGE", callId, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader, contentTypeHeader, msg);
            String originEsmeName = sms.getOrigEsmeName();
            if (originEsmeName != null) {
                Header smsIdHeader = this.headerFactory.createHeader("X-SMSC-ID", originEsmeName);
                request.addHeader(smsIdHeader);
            }
            DataCodingSchemeImpl dataCodingScheme = new DataCodingSchemeImpl(sms.getDataCoding());
            Header smsIdHeader = this.headerFactory.createHeader("X-SMS-CODING", Integer.toString(dataCodingScheme.getCharacterSet().getCode()));
            request.addHeader(smsIdHeader);
            Date submitDate = sms.getSubmitDate();
            if (submitDate != null) {
                String submitDateStr = MessageUtil.formatDate((Date)submitDate);
                Header submitDateHeader = this.headerFactory.createHeader("X-DELIVERY_TIME", submitDateStr);
                request.addHeader(submitDateHeader);
            }
            if ((validityPeriod = sms.getValidityPeriod()) != null) {
                String validityPeriodStr = MessageUtil.formatDate((Date)validityPeriod);
                Header validityHeader = this.headerFactory.createHeader("X-SMS-VALIDITY", validityPeriodStr);
                request.addHeader(validityHeader);
            }
            if (msgUdh != null) {
                String udhString = this.hexStringToByteArray(msgUdh);
                Header udhHeader = this.headerFactory.createHeader("X-SMS-UDH", udhString);
                request.addHeader(udhHeader);
            }
            ClientTransaction clientTransaction = this.sipRA.getNewClientTransaction(request);
            ActivityContextInterface sipClientTxaci = this.sipACIFactory.getActivityContextInterface(clientTransaction);
            sipClientTxaci.attach((SbbLocalObject)this.sbbContext.getSbbLocalObject());
            clientTransaction.sendRequest();
        }
        catch (Exception e) {
            throw new SmscProcessingException("RxSipServerSbb.sendMessage(): Exception while trying to send SIP Message =" + e.getMessage() + "\nMessage: " + sms, 0, 0, null, (Throwable)e);
        }
    }

    private byte[] recodeShortMessage(int dataCoding, String msg, byte[] udhPart) {
        byte[] textPart;
        DataCodingSchemeImpl dataCodingScheme = new DataCodingSchemeImpl(dataCoding);
        if (msg != null) {
            if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM8) {
                textPart = msg.getBytes(isoCharset);
            } else {
                SmppEncoding enc = dataCodingScheme.getCharacterSet() == CharacterSet.GSM7 ? smscPropertiesManagement.getSmppEncodingForGsm7() : smscPropertiesManagement.getSmppEncodingForUCS2();
                if (enc == SmppEncoding.Utf8) {
                    textPart = msg.getBytes(utf8Charset);
                } else if (enc == SmppEncoding.Unicode) {
                    textPart = msg.getBytes(ucs2Charset);
                } else {
                    GSMCharsetEncoder encoder = (GSMCharsetEncoder)gsm7Charset.newEncoder();
                    encoder.setGSMCharsetEncodingData(new GSMCharsetEncodingData(Gsm7EncodingStyle.bit8_smpp_style, null));
                    ByteBuffer bb = null;
                    try {
                        bb = encoder.encode(CharBuffer.wrap(msg));
                    }
                    catch (CharacterCodingException e) {
                        e.printStackTrace();
                    }
                    textPart = new byte[bb.limit()];
                    bb.get(textPart);
                }
            }
        } else {
            textPart = new byte[]{};
        }
        return textPart;
    }

    private void freeSmsSetSucceded(SmsSet smsSet, PersistenceRAInterface pers) {
        try {
            if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                Date lastDelivery = new Date();
                pers.setDeliverySuccess(smsSet, lastDelivery);
                if (!pers.deleteSmsSet(smsSet)) {
                    pers.setNewMessageScheduled(smsSet, MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)smscPropertiesManagement.getFirstDueDelay())));
                }
            } else {
                smsSet.setStatus(ErrorCode.SUCCESS);
                SmsSetCache.getInstance().removeProcessingSmsSet(smsSet.getTargetId());
            }
        }
        catch (PersistenceException e) {
            this.logger.severe("PersistenceException when freeSmsSetSucceded(SmsSet smsSet)" + e.getMessage(), (Throwable)e);
        }
        this.decrementDeliveryActivityCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDeliveryError(SmsSet smsSet, ErrorAction errorAction, ErrorCode smStatus, String reason) {
        TargetAddress lock;
        this.smscStatAggregator.updateMsgInFailedAll();
        long currentMsgNum = this.getCurrentMsgNum();
        Sms smsa = smsSet.getSms(currentMsgNum);
        if (smsa != null) {
            String s1 = reason.replace("\n", "\t");
            CdrGenerator.generateCdr((Sms)smsa, (String)"temp_failed_sip", (String)s1, (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)smsa, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
        }
        MessageDeliveryResultResponseInterface.DeliveryFailureReason delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.destinationUnavalable;
        if (errorAction == ErrorAction.temporaryFailure) {
            delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.temporaryNetworkError;
        }
        if (errorAction == ErrorAction.permanentFailure) {
            delReason = MessageDeliveryResultResponseInterface.DeliveryFailureReason.permanentNetworkError;
        }
        for (long i1 = currentMsgNum; i1 < smsSet.getSmsCount(); ++i1) {
            Sms sms = smsSet.getSms(i1);
            if (sms == null || sms.getMessageDeliveryResultResponse() == null) continue;
            sms.getMessageDeliveryResultResponse().responseDeliveryFailure(delReason, null);
            sms.setMessageDeliveryResultResponse(null);
        }
        PersistenceRAInterface pers = this.getStore();
        ArrayList<Sms> lstFailured = new ArrayList<Sms>();
        TargetAddress targetAddress = lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
        synchronized (targetAddress) {
            try {
                Date curDate = new Date();
                try {
                    long smsCnt;
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.setDeliveryFailure(smsSet, smStatus, curDate);
                    } else {
                        smsSet.setStatus(smStatus);
                        SmsSetCache.getInstance().removeProcessingSmsSet(smsSet.getTargetId());
                    }
                    this.decrementDeliveryActivityCount();
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        smsCnt = smsSet.getSmsCount();
                        int goodMsgCnt = 0;
                        for (long i1 = currentMsgNum; i1 < smsCnt; ++i1) {
                            Sms sms = smsSet.getSms(currentMsgNum);
                            if (sms == null) continue;
                            if (sms.getValidityPeriod().before(curDate)) {
                                pers.archiveFailuredSms(sms);
                                continue;
                            }
                            ++goodMsgCnt;
                        }
                        if (goodMsgCnt == 0) {
                            pers.fetchSchedulableSms(smsSet, false);
                            if (smsSet.getSmsCount() == 0L) {
                                errorAction = ErrorAction.permanentFailure;
                            }
                        }
                    }
                    switch (errorAction) {
                        case temporaryFailure: {
                            this.rescheduleSmsSet(smsSet, pers, currentMsgNum, lstFailured);
                            break;
                        }
                        case permanentFailure: {
                            smsCnt = smsSet.getSmsCount();
                            for (long i1 = currentMsgNum; i1 < smsCnt; ++i1) {
                                Sms sms = smsSet.getSms(i1);
                                if (sms == null) continue;
                                lstFailured.add(sms);
                            }
                            this.freeSmsSetFailured(smsSet, pers, currentMsgNum);
                        }
                    }
                }
                catch (PersistenceException e) {
                    this.logger.severe("PersistenceException when RxSmppServerSbb.onDeliveryError()" + e.getMessage(), (Throwable)e);
                }
            }
            finally {
                pers.releaseSynchroObject(lock);
            }
        }
        for (Sms sms : lstFailured) {
            CdrGenerator.generateCdr((Sms)sms, (String)"failed_sip", (String)reason, (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
            MProcResult mProcResult = MProcManagement.getInstance().applyMProcDelivery(sms, true);
            FastList addedMessages = mProcResult.getMessageList();
            if (addedMessages != null) {
                FastList.Node n = addedMessages.head();
                FastList.Node end = addedMessages.tail();
                while ((n = n.getNext()) != end) {
                    Sms smst = (Sms)n.getValue();
                    TargetAddress ta = new TargetAddress(smst.getSmsSet().getDestAddrTon(), smst.getSmsSet().getDestAddrNpi(), smst.getSmsSet().getDestAddr(), smst.getSmsSet().getNetworkId());
                    TargetAddress lock2 = SmsSetCache.getInstance().addSmsSet(ta);
                    try {
                        TargetAddress targetAddress2 = lock2;
                        synchronized (targetAddress2) {
                            if (smscPropertiesManagement.getDatabaseType() != DatabaseType.Cassandra_1) {
                                boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)smst);
                                if (!storeAndForwMode) {
                                    try {
                                        this.scheduler.injectSmsOnFly(smst.getSmsSet(), true);
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages: " + e.getMessage(), (Throwable)e);
                                    }
                                } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                    try {
                                        smst.setStoringAfterFailure(true);
                                        this.scheduler.injectSmsOnFly(smst.getSmsSet(), true);
                                    }
                                    catch (Exception e) {
                                        this.logger.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages: " + e.getMessage(), (Throwable)e);
                                    }
                                } else {
                                    smst.setStored(true);
                                    this.scheduler.setDestCluster(smst.getSmsSet());
                                    try {
                                        pers.c2_scheduleMessage_ReschedDueSlot(smst, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                    }
                                    catch (PersistenceException e) {
                                        this.logger.severe("PersistenceException when adding applyMProcDelivery created messages" + e.getMessage(), (Throwable)e);
                                    }
                                }
                            }
                        }
                    }
                    finally {
                        SmsSetCache.getInstance().removeSmsSet(lock2);
                    }
                }
            }
            int registeredDelivery = sms.getRegisteredDelivery();
            if (smscPropertiesManagement.getReceiptsDisabling() || !MessageUtil.isReceiptOnFailure((int)registeredDelivery)) continue;
            TargetAddress ta = new TargetAddress(sms.getSourceAddrTon(), sms.getSourceAddrNpi(), sms.getSourceAddr(), smsSet.getNetworkId());
            lock = SmsSetCache.getInstance().addSmsSet(ta);
            try {
                TargetAddress targetAddress3 = lock;
                synchronized (targetAddress3) {
                    try {
                        Sms receipt;
                        if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                            receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)false);
                            SmsSet backSmsSet = pers.obtainSmsSet(ta);
                            receipt.setSmsSet(backSmsSet);
                            receipt.setStored(true);
                            pers.createLiveSms(receipt);
                            pers.setNewMessageScheduled(receipt.getSmsSet(), MessageUtil.computeDueDate((int)MessageUtil.computeFirstDueDelay((int)smscPropertiesManagement.getFirstDueDelay())));
                        } else {
                            receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)false, (TargetAddress)ta, (boolean)smscPropertiesManagement.getOrigNetworkIdForReceipts());
                            boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                            if (!storeAndForwMode) {
                                try {
                                    this.scheduler.injectSmsOnFly(receipt.getSmsSet(), true);
                                }
                                catch (Exception e) {
                                    this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in onDeliveryError(): " + e.getMessage(), (Throwable)e);
                                }
                            } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                try {
                                    receipt.setStoringAfterFailure(true);
                                    this.scheduler.injectSmsOnFly(receipt.getSmsSet(), true);
                                }
                                catch (Exception e) {
                                    this.logger.severe("Exception when runnung injectSmsOnFly() for receipt in onDeliveryError(): " + e.getMessage(), (Throwable)e);
                                }
                            } else {
                                receipt.setStored(true);
                                this.scheduler.setDestCluster(receipt.getSmsSet());
                                pers.c2_scheduleMessage_ReschedDueSlot(receipt, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                            }
                        }
                        this.logger.info("Adding an error receipt: source=" + receipt.getSourceAddr() + ", dest=" + receipt.getSmsSet().getDestAddr());
                    }
                    catch (PersistenceException e) {
                        this.logger.severe("PersistenceException when freeSmsSetFailured(SmsSet smsSet) - adding delivery receipt" + e.getMessage(), (Throwable)e);
                    }
                }
            }
            finally {
                SmsSetCache.getInstance().removeSmsSet(lock);
            }
        }
    }

    private void startMessageDelivery(Sms sms) {
        try {
            this.getStore().setDeliveryStart(sms);
        }
        catch (PersistenceException e) {
            this.logger.severe("PersistenceException when RxSmppServerSbb.setDeliveryStart(sms)" + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeSmsSetFailured(SmsSet smsSet, PersistenceRAInterface pers, long currentMsgNum) {
        TargetAddress lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                try {
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.fetchSchedulableSms(smsSet, false);
                        long cnt = smsSet.getSmsCount();
                        int i1 = 0;
                        while ((long)i1 < cnt) {
                            Sms sms = smsSet.getSms((long)i1);
                            pers.archiveFailuredSms(sms);
                            ++i1;
                        }
                        pers.deleteSmsSet(smsSet);
                    } else {
                        for (long i1 = currentMsgNum; i1 < smsSet.getSmsCount(); ++i1) {
                            Sms sms = smsSet.getSms(i1);
                            pers.c2_updateInSystem(sms, 2, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
                            sms.setDeliveryDate(new Date());
                            if (!MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateArchiveTable())) continue;
                            pers.c2_createRecordArchive(sms);
                        }
                    }
                }
                catch (PersistenceException e) {
                    this.logger.severe("PersistenceException when RxSmppServerSbb.freeSmsSetFailured(SmsSet smsSet)" + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            pers.releaseSynchroObject(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleSmsSet(SmsSet smsSet, PersistenceRAInterface pers, long currentMsgNum, ArrayList<Sms> lstFailured) {
        TargetAddress lock = pers.obtainSynchroObject(new TargetAddress(smsSet));
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                try {
                    int prevDueDelay = smsSet.getDueDelay();
                    int newDueDelay = MessageUtil.computeNextDueDelay((int)prevDueDelay, (int)smscPropertiesManagement.getSecondDueDelay(), (int)smscPropertiesManagement.getDueDelayMultiplicator(), (int)smscPropertiesManagement.getMaxDueDelay());
                    Date newDueDate = new Date(new Date().getTime() + (long)(newDueDelay * 1000));
                    if (smscPropertiesManagement.getDatabaseType() == DatabaseType.Cassandra_1) {
                        pers.setDeliveringProcessScheduled(smsSet, newDueDate, newDueDelay);
                    } else {
                        smsSet.setDueDate(newDueDate);
                        smsSet.setDueDelay(newDueDelay);
                        long dueSlot = this.getStore().c2_getDueSlotForTime(newDueDate);
                        for (long i1 = currentMsgNum; i1 < smsSet.getSmsCount(); ++i1) {
                            Sms sms = smsSet.getSms(i1);
                            pers.c2_scheduleMessage_NewDueSlot(sms, dueSlot, lstFailured, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
                        }
                    }
                }
                catch (PersistenceException e) {
                    this.logger.severe("PersistenceException when RxSmppServerSbb.rescheduleSmsSet(SmsSet smsSet)" + e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            pers.releaseSynchroObject(lock);
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            this.logger = this.sbbContext.getTracer(this.getClass().getSimpleName());
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, PERSISTENCE_LINK);
            this.scheduler = (SchedulerRaSbbInterface)this.sbbContext.getResourceAdaptorInterface(SCHEDULE_ID, SCHEDULE_LINK);
            this.sipRA = (SleeSipProvider)this.sbbContext.getResourceAdaptorInterface(SIP_RA_TYPE_ID, SIP_RA_LINK);
            this.sipACIFactory = (SipActivityContextInterfaceFactory)this.sbbContext.getActivityContextInterfaceFactory(SIP_RA_TYPE_ID);
            this.messageFactory = this.sipRA.getMessageFactory();
            this.headerFactory = this.sipRA.getHeaderFactory();
            this.addressFactory = this.sipRA.getAddressFactory();
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci, EventContext eventContext) {
        ServiceID serviceID = event.getService();
        this.logger.info("Rx: onServiceStartedEvent: event=" + event + ", serviceID=" + serviceID);
        SbbStates.setSmscRxSipServerServiceState((boolean)true);
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci, EventContext eventContext) {
        boolean isServiceActivity = aci.getActivity() instanceof ServiceActivity;
        if (isServiceActivity) {
            this.logger.info("Rx: onActivityEndEvent: event=" + event + ", isServiceActivity=" + isServiceActivity);
            SbbStates.setSmscRxSipServerServiceState((boolean)false);
        }
    }

    private void decrementDeliveryActivityCount() {
        try {
            this.getSchedulerActivity().endActivity();
        }
        catch (Exception e) {
            this.logger.severe("Error while decrementing DeliveryActivityCount", (Throwable)e);
        }
    }

    private SchedulerActivity getSchedulerActivity() {
        ActivityContextInterface[] acis = this.sbbContext.getActivities();
        for (int count = 0; count < acis.length; ++count) {
            ActivityContextInterface aci = acis[count];
            Object activity = aci.getActivity();
            if (!(activity instanceof SchedulerActivity)) continue;
            return (SchedulerActivity)activity;
        }
        return null;
    }

    private String hexStringToByteArray(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

