/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.resources.scheduler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.slee.Address;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityFlags;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.EventFlags;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.transaction.SleeTransaction;
import javax.slee.transaction.SleeTransactionManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javolution.util.FastList;
import org.mobicents.smsc.cassandra.DBOperations;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.MProcManagement;
import org.mobicents.smsc.domain.SmsRouteManagement;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.domain.SmscStatAggregator;
import org.mobicents.smsc.domain.SmscStatProvider;
import org.mobicents.smsc.domain.StoreAndForwordMode;
import org.mobicents.smsc.library.CdrGenerator;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.SbbStates;
import org.mobicents.smsc.library.SmType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.impl.MProcResult;
import org.mobicents.smsc.slee.common.ra.EventIDCache;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerActivityHandle;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerActivityImpl;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaUsageParameters;
import org.mobicents.smsc.slee.services.smpp.server.events.SmsSetEvent;
import org.mobicents.smsc.smpp.GenerateType;

public class SchedulerResourceAdaptor
implements ResourceAdaptor {
    private static final int ACTIVITY_FLAGS = ActivityFlags.setRequestEndedCallback((int)2);
    private static final int EVENT_FLAGS = EventFlags.setRequestProcessingSuccessfulCallback((int)EventFlags.setRequestProcessingFailedCallback((int)128));
    private static final String EVENT_VENDOR = "org.mobicents";
    private static final String EVENT_VERSION = "1.0";
    private static final String EVENT_SMPP_SM = "org.mobicents.smsc.slee.services.smpp.server.events.SMPP_SM";
    private static final String EVENT_SS7_SM = "org.mobicents.smsc.slee.services.smpp.server.events.SS7_SM";
    private static final String EVENT_SIP_SM = "org.mobicents.smsc.slee.services.smpp.server.events.SIP_SM";
    protected Tracer tracer = null;
    private ResourceAdaptorContext raContext = null;
    private SleeTransactionManager sleeTransactionManager = null;
    private SleeEndpoint sleeEndpoint = null;
    private EventIDCache eventIdCache;
    private ScheduledExecutorService scheduler = null;
    private SchedulerRaSbbInterface schedulerRaSbbInterface = null;
    private SchedulerRaUsageParameters usageParameters;
    protected DBOperations dbOperations_C2 = null;
    private Date garbageCollectionTime = new Date();
    private SmscStatAggregator smscStatAggregator = SmscStatAggregator.getInstance();
    private OneWaySmsSetCollection savedOneWaySmsSetCollection = null;
    private String shownServicesDownList = null;
    private long shownServicesDownTime = 0L;

    public SchedulerResourceAdaptor() {
        this.schedulerRaSbbInterface = new SchedulerRaSbbInterface(){

            public void injectSmsOnFly(SmsSet smsSet, boolean callFromSbb) throws Exception {
                SchedulerResourceAdaptor.this.doInjectSmsOnFly(smsSet, callFromSbb);
            }

            public void injectSmsDatabase(SmsSet smsSet) throws Exception {
                SchedulerResourceAdaptor.this.doInjectSmsDatabase(smsSet);
            }

            public void setDestCluster(SmsSet smsSet) {
                SchedulerResourceAdaptor.this.doSetDestCluster(smsSet);
            }
        };
    }

    public void activityEnded(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity with handle " + activityHandle + " ended.");
        }
    }

    public void activityUnreferenced(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity unreferenced with handle " + activityHandle + ".");
        }
    }

    public void administrativeRemove(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity administrative remove with handle " + activityHandle + ".");
        }
    }

    public void eventProcessingFailed(ActivityHandle activityHandle, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event processing failed on activity with handle " + activityHandle + ".");
        }
        this.sleeEndpoint.endActivity(activityHandle);
    }

    public void eventProcessingSuccessful(ActivityHandle activityHandle, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event processing succeeded on activity with handle " + activityHandle + ".");
        }
        if (EventFlags.hasSbbProcessedEvent((int)flags)) {
            // empty if block
        }
        this.sleeEndpoint.endActivity(activityHandle);
    }

    public void eventUnreferenced(ActivityHandle activityHandle, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Event unreferenced on activity with handle " + activityHandle + ".");
        }
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return ((SchedulerActivityHandle)activityHandle).getActivity();
    }

    public ActivityHandle getActivityHandle(Object activity) {
        if (activity instanceof SchedulerActivityImpl) {
            SchedulerActivityImpl wrapper = (SchedulerActivityImpl)activity;
            return wrapper.getActivityHandle();
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.schedulerRaSbbInterface;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
    }

    public void raActive() {
        long maxTimerDur;
        this.clearActivityCount();
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
        this.dbOperations_C2 = DBOperations.getInstance();
        if (!this.dbOperations_C2.isStarted()) {
            throw new RuntimeException("DBOperations_2 not started yet!");
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        long timerDur = smscPropertiesManagement.getFetchPeriod();
        if (timerDur > (maxTimerDur = this.dbOperations_C2.getSlotMSecondsTimeArea() * 2L / 3L)) {
            timerDur = maxTimerDur;
        }
        this.scheduler.scheduleAtFixedRate(new TickTimerTask(), 500L, timerDur, TimeUnit.MILLISECONDS);
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("SchedulerResourceAdaptor " + this.raContext.getEntityName() + " Activated");
        }
        smscPropertiesManagement.setSmscStopped(false);
    }

    public void raInactive() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Starting of inactivating SchedulerResourceAdaptor RA Entity " + this.raContext.getEntityName());
        }
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
        smscPropertiesManagement.setSmscStopped(true);
        for (int i1 = 0; i1 < 60; ++i1) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (SmsSetCache.getInstance().getProcessingSmsSetSize() == 0) break;
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Finishing of inactivating SchedulerResourceAdaptor RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
        throw new UnsupportedOperationException();
    }

    public void raConfigure(ConfigProperties properties) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Configuring RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raStopping() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Stopping Scheduler RA Entity " + this.raContext.getEntityName());
        }
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.tracer.severe("InterruptedException while awaiting termination of tasks", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Stopped Scheduler RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raUnconfigure() {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Unconfigure RA Entity " + this.raContext.getEntityName());
        }
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("Verify configuration in RA Entity " + this.raContext.getEntityName());
        }
    }

    public void serviceActive(ReceivableService arg0) {
    }

    public void serviceInactive(ReceivableService arg0) {
    }

    public void serviceStopping(ReceivableService arg0) {
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.tracer = raContext.getTracer(this.getClass().getSimpleName());
        this.raContext = raContext;
        this.eventIdCache = new EventIDCache(this.raContext, EVENT_VENDOR, EVENT_VERSION);
        this.sleeTransactionManager = this.raContext.getSleeTransactionManager();
        this.sleeEndpoint = this.raContext.getSleeEndpoint();
        this.usageParameters = (SchedulerRaUsageParameters)this.raContext.getDefaultUsageParameterSet();
    }

    public void unsetResourceAdaptorContext() {
        this.tracer = null;
        this.eventIdCache = null;
        this.raContext = null;
        this.sleeTransactionManager = null;
        this.sleeEndpoint = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTimerTick() {
        block34: {
            if (!SbbStates.isAllServicesUp()) {
                String s1 = SbbStates.getServicesDownList();
                if (!s1.equals(this.shownServicesDownList) || System.currentTimeMillis() - this.shownServicesDownTime > 10000L) {
                    this.tracer.info("Not all SBB are running now: " + s1);
                    this.shownServicesDownList = s1;
                    this.shownServicesDownTime = System.currentTimeMillis();
                }
                return;
            }
            try {
                OneWaySmsSetCollection schedulableSms;
                SmsRouteManagement smsRouteManagement;
                Date current = new Date(new Date().getTime() - 60000L);
                if (this.garbageCollectionTime.before(current)) {
                    this.garbageCollectionTime = new Date();
                    SmsSetCache.getInstance().garbadeCollectProcessingSmsSet();
                }
                if (!this.dbOperations_C2.isDatabaseAvailable()) {
                    return;
                }
                SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
                int val = smscPropertiesManagement.getSkipUnsentMessages();
                if (val >= 0) {
                    smscPropertiesManagement.setSkipUnsentMessages(-1);
                    long processedDueSlot = this.dbOperations_C2.c2_getCurrentDueSlot();
                    Date processedTime = this.dbOperations_C2.c2_getTimeForDueSlot(processedDueSlot);
                    long possibleDueSlot = this.dbOperations_C2.c2_getIntimeDueSlot();
                    Date possibleTime = new Date(this.dbOperations_C2.c2_getTimeForDueSlot(possibleDueSlot).getTime() - 10000L);
                    Date newTime = new Date(possibleTime.getTime() - (long)(val * 1000));
                    if (newTime.getTime() > processedTime.getTime()) {
                        long newDueSlot = this.dbOperations_C2.c2_getDueSlotForTime(newTime);
                        this.dbOperations_C2.c2_setCurrentDueSlot(newDueSlot);
                        this.tracer.warning("currentDueSlot has been changed after a user request: from " + processedTime + " to " + newTime);
                    } else {
                        this.tracer.warning("There was a user request to change currentDueSlot: from " + processedTime + " to " + newTime + ". But the new time must be after the current one and the request was rejected.");
                    }
                }
                if ((smsRouteManagement = SmsRouteManagement.getInstance()).getSmsRoutingRule() == null) {
                    return;
                }
                int fetchMaxRows = smscPropertiesManagement.getFetchMaxRows();
                int activityCount = SmsSetCache.getInstance().getProcessingSmsSetSize();
                int fetchAvailRows = smscPropertiesManagement.getMaxActivityCount() - activityCount;
                int maxCnt = Math.min(fetchMaxRows, fetchAvailRows);
                if (this.savedOneWaySmsSetCollection != null && this.savedOneWaySmsSetCollection.size() > 0) {
                    schedulableSms = this.savedOneWaySmsSetCollection;
                } else {
                    if (smscPropertiesManagement.isSmscStopped()) {
                        return;
                    }
                    if (smscPropertiesManagement.isDeliveryPause()) {
                        return;
                    }
                    try {
                        int cnt;
                        if (this.tracer.isFineEnabled()) {
                            this.tracer.fine("Fetching: Starting fetching messages from database: fetchMaxRows=" + fetchMaxRows + ", activityCount=" + activityCount + ", fetchAvailRows=" + fetchAvailRows);
                        }
                        if (maxCnt <= 0) {
                            return;
                        }
                        int readTryCount = 0;
                        do {
                            schedulableSms = this.fetchSchedulable(maxCnt);
                            cnt = 0;
                            if (schedulableSms == null) continue;
                            cnt = schedulableSms.size();
                        } while (cnt == 0 && ++readTryCount < 100);
                        if (this.tracer.isFineEnabled()) {
                            String s1 = "Fetching: Fetched " + cnt + " messages (max requested messages=" + maxCnt + ", fetched messages=" + cnt + ")";
                            this.tracer.fine(s1);
                        }
                    }
                    catch (PersistenceException e1) {
                        this.tracer.severe("PersistenceException when fetching SmsSet list from a database: " + e1.getMessage(), (Throwable)e1);
                        return;
                    }
                }
                int count = 0;
                Date curDate = new Date();
                try {
                    do {
                        SmsSet smsSet;
                        if ((smsSet = schedulableSms.next()) == null) {
                            break block34;
                        }
                        try {
                            if (!smsSet.isProcessingStarted()) {
                                smsSet.setProcessingStarted();
                                if (!this.doInjectSmsDatabase(smsSet, curDate, false)) {
                                    return;
                                }
                            }
                        }
                        catch (Exception e) {
                            this.tracer.severe("Exception when injectSms: " + e.getMessage(), (Throwable)e);
                        }
                    } while (++count < maxCnt);
                    this.savedOneWaySmsSetCollection = schedulableSms;
                }
                finally {
                    if (count > 0) {
                        SmscStatProvider smscStatProvider = SmscStatProvider.getInstance();
                        smscStatProvider.setMessageScheduledTotal(smscStatProvider.getMessageScheduledTotal() + (long)count);
                        if (this.tracer.isInfoEnabled()) {
                            String s2 = "Fetching: Scheduled '" + count + "' out of '" + schedulableSms.size() + ", fetchMaxRows=" + fetchMaxRows + ", activityCount=" + activityCount + ", fetchAvailRows=" + fetchAvailRows + "'.";
                            this.tracer.info(s2);
                        }
                    } else if (this.tracer.isFineEnabled()) {
                        String s2 = "Fetching: Scheduled '" + count + "' out of '" + schedulableSms.size() + ", fetchMaxRows=" + fetchMaxRows + ", activityCount=" + activityCount + ", fetchAvailRows=" + fetchAvailRows + "'.";
                        this.tracer.fine(s2);
                    }
                }
            }
            catch (Throwable e1) {
                this.tracer.severe("Exception in SchedulerResourceAdaptor when fetching records and issuing events: " + e1.getMessage(), e1);
            }
        }
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
        long processedDueSlot = this.dbOperations_C2.c2_getCurrentDueSlot();
        long possibleDueSlot = this.dbOperations_C2.c2_getIntimeDueSlot();
        Date processedDate = this.dbOperations_C2.c2_getTimeForDueSlot(processedDueSlot);
        Date possibleDate = this.dbOperations_C2.c2_getTimeForDueSlot(possibleDueSlot);
        int lag = (int)((possibleDate.getTime() - processedDate.getTime()) / 1000L);
        this.smscStatAggregator.updateSmscDeliveringLag(lag);
    }

    protected void endAcitivity(SchedulerActivityHandle activityHandle) throws Exception {
        this.sleeEndpoint.endActivity((ActivityHandle)activityHandle);
        this.decrementActivityCount();
    }

    public void doInjectSmsOnFly(SmsSet smsSet, boolean callFromSbb) throws Exception {
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
        if (!this.dbOperations_C2.c2_checkProcessingSmsSet(smsSet)) {
            return;
        }
        this.doInjectSms(smsSet, callFromSbb);
    }

    public void doInjectSmsDatabase(SmsSet smsSet) throws Exception {
        this.doInjectSmsDatabase(smsSet, new Date(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean doInjectSmsDatabase(SmsSet smsSet, Date curDate, boolean callFromSbb) throws Exception {
        boolean withValidityTimeout = false;
        int i1 = 0;
        while ((long)i1 < smsSet.getSmsCount()) {
            Sms sms = smsSet.getSms((long)i1);
            if (sms.getValidityPeriod() != null && sms.getValidityPeriod().before(curDate)) {
                withValidityTimeout = true;
                break;
            }
            ++i1;
        }
        if (withValidityTimeout) {
            TargetAddress lock;
            SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
            ArrayList<Sms> good = new ArrayList<Sms>();
            ArrayList<Sms> expired = new ArrayList<Sms>();
            TargetAddress targetAddress = lock = SmsSetCache.getInstance().addSmsSet(new TargetAddress(smsSet));
            synchronized (targetAddress) {
                try {
                    int i12 = 0;
                    while ((long)i12 < smsSet.getSmsCount()) {
                        Sms sms = smsSet.getSms((long)i12);
                        if (sms.getValidityPeriod() != null && sms.getValidityPeriod().before(curDate)) {
                            expired.add(sms);
                        } else {
                            good.add(sms);
                        }
                        ++i12;
                    }
                    ErrorCode smStatus = ErrorCode.RESERVED_127;
                    String reason = "Validity period is expired";
                    if (expired.size() > 0) {
                        smsSet.setStatus(smStatus);
                    }
                    if (good.size() == 0) {
                        SmsSetCache.getInstance().removeProcessingSmsSet(smsSet.getTargetId());
                    }
                    for (Sms sms : expired) {
                        MProcResult mProcResult;
                        FastList addedMessages;
                        StringBuilder sb = new StringBuilder();
                        sb.append("onDeliveryError: errorAction=validityExpired");
                        sb.append(", smStatus=");
                        sb.append(smStatus);
                        sb.append(", targetId=");
                        sb.append(smsSet.getTargetId());
                        sb.append(", smsSet=");
                        sb.append(smsSet);
                        sb.append(", reason=");
                        sb.append(reason);
                        if (this.tracer.isInfoEnabled()) {
                            this.tracer.info(sb.toString());
                        }
                        CdrGenerator.generateCdr((Sms)sms, (String)"failed", (String)reason, (boolean)smscPropertiesManagement.getGenerateReceiptCdr(), (boolean)MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateCdr()));
                        if (sms.getStored() && sms.getStored()) {
                            this.dbOperations_C2.c2_updateInSystem(sms, 2, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast);
                            sms.setDeliveryDate(curDate);
                            if (MessageUtil.isNeedWriteArchiveMessage((Sms)sms, (GenerateType)smscPropertiesManagement.getGenerateArchiveTable())) {
                                this.dbOperations_C2.c2_createRecordArchive(sms);
                            }
                        }
                        if ((addedMessages = (mProcResult = MProcManagement.getInstance().applyMProcDelivery(sms, true, null)).getMessageList()) != null) {
                            FastList.Node n = addedMessages.head();
                            FastList.Node end = addedMessages.tail();
                            while ((n = n.getNext()) != end) {
                                Sms smst = (Sms)n.getValue();
                                TargetAddress ta = new TargetAddress(smst.getSmsSet().getDestAddrTon(), smst.getSmsSet().getDestAddrNpi(), smst.getSmsSet().getDestAddr(), smst.getSmsSet().getNetworkId());
                                TargetAddress lock2 = SmsSetCache.getInstance().addSmsSet(ta);
                                try {
                                    TargetAddress targetAddress2 = lock2;
                                    synchronized (targetAddress2) {
                                        boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)smst);
                                        if (!storeAndForwMode) {
                                            try {
                                                this.schedulerRaSbbInterface.injectSmsOnFly(smst.getSmsSet(), false);
                                            }
                                            catch (Exception e) {
                                                this.tracer.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages: " + e.getMessage(), (Throwable)e);
                                            }
                                        } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                            try {
                                                smst.setStoringAfterFailure(true);
                                                this.schedulerRaSbbInterface.injectSmsOnFly(smst.getSmsSet(), false);
                                            }
                                            catch (Exception e) {
                                                this.tracer.severe("Exception when runnung injectSmsOnFly() for applyMProcDelivery created messages: " + e.getMessage(), (Throwable)e);
                                            }
                                        } else {
                                            smst.setStored(true);
                                            this.schedulerRaSbbInterface.setDestCluster(smst.getSmsSet());
                                            try {
                                                this.dbOperations_C2.c2_scheduleMessage_ReschedDueSlot(smst, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                            }
                                            catch (PersistenceException e) {
                                                this.tracer.severe("PersistenceException when adding applyMProcDelivery created messages" + e.getMessage(), (Throwable)e);
                                            }
                                        }
                                    }
                                }
                                finally {
                                    SmsSetCache.getInstance().removeSmsSet(lock2);
                                }
                            }
                        }
                        int registeredDelivery = sms.getRegisteredDelivery();
                        if (smscPropertiesManagement.getReceiptsDisabling() || !MessageUtil.isReceiptOnFailure((int)registeredDelivery)) continue;
                        TargetAddress ta = new TargetAddress(sms.getSourceAddrTon(), sms.getSourceAddrNpi(), sms.getSourceAddr(), smsSet.getNetworkId());
                        TargetAddress lock2 = SmsSetCache.getInstance().addSmsSet(ta);
                        try {
                            TargetAddress targetAddress3 = lock2;
                            synchronized (targetAddress3) {
                                try {
                                    Sms receipt = MessageUtil.createReceiptSms((Sms)sms, (boolean)false, (TargetAddress)ta, (boolean)smscPropertiesManagement.getOrigNetworkIdForReceipts());
                                    boolean storeAndForwMode = MessageUtil.isStoreAndForward((Sms)sms);
                                    if (!storeAndForwMode) {
                                        try {
                                            this.schedulerRaSbbInterface.injectSmsOnFly(receipt.getSmsSet(), false);
                                        }
                                        catch (Exception e) {
                                            this.tracer.severe("Exception when runnung injectSmsOnFly() for receipt in doInjectSmsDatabase(): " + e.getMessage(), (Throwable)e);
                                        }
                                    } else if (smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast) {
                                        try {
                                            receipt.setStoringAfterFailure(true);
                                            this.schedulerRaSbbInterface.injectSmsOnFly(receipt.getSmsSet(), false);
                                        }
                                        catch (Exception e) {
                                            this.tracer.severe("Exception when runnung injectSmsOnFly() for receipt in doInjectSmsDatabase(): " + e.getMessage(), (Throwable)e);
                                        }
                                    } else {
                                        receipt.setStored(true);
                                        this.setDestCluster(receipt.getSmsSet());
                                        this.dbOperations_C2.c2_scheduleMessage_ReschedDueSlot(receipt, smscPropertiesManagement.getStoreAndForwordMode() == StoreAndForwordMode.fast, true);
                                    }
                                    this.tracer.info("Adding an error receipt: source=" + receipt.getSourceAddr() + ", dest=" + receipt.getSmsSet().getDestAddr());
                                }
                                catch (PersistenceException e) {
                                    this.tracer.severe("PersistenceException when freeSmsSetFailured(SmsSet smsSet) - adding delivery receipt" + e.getMessage(), (Throwable)e);
                                }
                            }
                        }
                        finally {
                            SmsSetCache.getInstance().removeSmsSet(lock2);
                        }
                    }
                    if (good.size() == 0) {
                        boolean i$ = true;
                        return i$;
                    }
                    smsSet.clearSmsList();
                    for (Sms sms : good) {
                        smsSet.addSms(sms);
                    }
                }
                finally {
                    SmsSetCache.getInstance().removeSmsSet(lock);
                }
            }
        }
        return this.doInjectSms(smsSet, callFromSbb);
    }

    private boolean doInjectSms(SmsSet smsSet, boolean callFromSbb) throws NotSupportedException, SystemException, Exception, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        if (!callFromSbb) {
            SleeTransaction sleeTx = this.sleeTransactionManager.beginSleeTransaction();
        }
        try {
            this.doSetDestCluster(smsSet);
            String eventName = null;
            switch (smsSet.getType()) {
                case SMS_FOR_ESME: {
                    eventName = EVENT_SMPP_SM;
                    break;
                }
                case SMS_FOR_SS7: {
                    eventName = EVENT_SS7_SM;
                    break;
                }
                case SMS_FOR_SIP: {
                    eventName = EVENT_SIP_SM;
                }
            }
            FireableEventType eventTypeId = this.eventIdCache.getEventId(eventName);
            SmsSetEvent event = new SmsSetEvent();
            event.setSmsSet(smsSet);
            SchedulerActivityImpl activity = new SchedulerActivityImpl(this);
            this.sleeEndpoint.startActivityTransacted((ActivityHandle)activity.getActivityHandle(), (Object)activity, ACTIVITY_FLAGS);
            try {
                this.sleeEndpoint.fireEventTransacted((ActivityHandle)activity.getActivityHandle(), eventTypeId, (Object)event, null, null);
            }
            catch (Exception e) {
                if (this.tracer.isSevereEnabled()) {
                    this.tracer.severe("Failed to fire SmsSet event Class=: " + eventTypeId.getEventClassName(), (Throwable)e);
                }
                try {
                    this.sleeEndpoint.endActivityTransacted((ActivityHandle)activity.getActivityHandle());
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            this.markAsInSystem(smsSet);
        }
        catch (Exception e) {
            if (!callFromSbb) {
                this.sleeTransactionManager.rollback();
            }
            throw e;
        }
        if (!callFromSbb) {
            this.sleeTransactionManager.commit();
        }
        this.incrementActivityCount();
        return true;
    }

    public void setDestCluster(SmsSet smsSet) {
        this.doSetDestCluster(smsSet);
    }

    private void doSetDestCluster(SmsSet smsSet) {
        SmsRouteManagement smsRouteManagement = SmsRouteManagement.getInstance();
        String orignatingEsmeName = smsSet.getSms(0L).getOrigEsmeName();
        String destClusterName = smsRouteManagement.getEsmeClusterName(smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), smsSet.getDestAddr(), orignatingEsmeName, smsSet.getNetworkId());
        if (destClusterName == null) {
            destClusterName = smsRouteManagement.getSipClusterName(smsSet.getDestAddrTon(), smsSet.getDestAddrNpi(), smsSet.getDestAddr(), smsSet.getNetworkId());
            if (destClusterName == null) {
                smsSet.setType(SmType.SMS_FOR_SS7);
            } else {
                smsSet.setType(SmType.SMS_FOR_SIP);
            }
        } else {
            smsSet.setType(SmType.SMS_FOR_ESME);
        }
        smsSet.setDestClusterName(destClusterName);
    }

    protected OneWaySmsSetCollection fetchSchedulable(int maxRecordCount) throws PersistenceException {
        long possibleDueSlot;
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
        long processedDueSlot = this.dbOperations_C2.c2_getCurrentDueSlot();
        if (processedDueSlot >= (possibleDueSlot = this.dbOperations_C2.c2_getIntimeDueSlot())) {
            return new OneWaySmsSetCollection();
        }
        if (!this.dbOperations_C2.c2_checkDueSlotNotWriting(++processedDueSlot)) {
            return new OneWaySmsSetCollection();
        }
        ArrayList lstS = this.dbOperations_C2.c2_getRecordList(processedDueSlot);
        ArrayList lst = this.dbOperations_C2.c2_sortRecordList(lstS);
        OneWaySmsSetCollection res = new OneWaySmsSetCollection();
        res.setListSmsSet(lst);
        this.dbOperations_C2.c2_setCurrentDueSlot(processedDueSlot);
        return res;
    }

    protected void markAsInSystem(SmsSet smsSet) throws PersistenceException {
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
    }

    private void clearActivityCount() {
        long cnt = this.getActivityCount();
        this.usageParameters.incrementActivityCount(-cnt);
    }

    private void incrementActivityCount() {
        this.usageParameters.incrementActivityCount(1L);
    }

    private void decrementActivityCount() {
        this.usageParameters.incrementActivityCount(-1L);
    }

    private long getActivityCount() {
        return this.usageParameters.getActivityCount();
    }

    public class OneWaySmsSetCollection {
        private List<SmsSet> lst = new ArrayList<SmsSet>();
        private int uploadedCount;

        public void setListSmsSet(List<SmsSet> val) {
            this.lst = val;
            this.uploadedCount = 0;
        }

        public void add(SmsSet smsSet) {
            this.lst.add(smsSet);
        }

        public SmsSet next() {
            if (this.uploadedCount >= this.lst.size()) {
                return null;
            }
            return this.lst.get(this.uploadedCount++);
        }

        public int size() {
            return this.lst.size() - this.uploadedCount;
        }
    }

    protected class TickTimerTask
    implements Runnable {
        protected TickTimerTask() {
        }

        @Override
        public void run() {
            SchedulerResourceAdaptor.this.onTimerTick();
        }
    }
}

