/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.tools.smppsimulator.bootstrap;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.mobicents.smsc.tools.smppsimulator.SmppSimulatorForm;

public class Main {
    private static final String APP_NAME = "SMPP Simulator";
    private static final String HOME_DIR = "SIMULATOR_HOME";
    private static final String LOG4J_URL = "/conf/log4j.properties";
    private static final String LOG4J_URL_XML = "/conf/log4j.xml";
    public static final String SIMULATOR_HOME = "simulator.home.dir";
    public static final String SIMULATOR_DATA = "simulator.data.dir";
    private static int index = 0;
    private static Logger logger;
    private String command = null;
    private String appName = "main";
    private int rmiPort = -1;
    private int httpPort = -1;

    public static void main(String[] args) throws Throwable {
        String homeDir = Main.getHomeDir(args);
        System.setProperty(SIMULATOR_HOME, homeDir);
        System.setProperty(SIMULATOR_DATA, homeDir + File.separator + "data" + File.separator);
        if (!Main.initLOG4JProperties(homeDir) && !Main.initLOG4JXml(homeDir)) {
            System.err.println("Failed to initialize loggin, no configuration. Defaults are used.");
        }
        logger = Logger.getLogger(Main.class);
        logger.info((Object)"log4j configured");
        Main main = new Main();
        main.processCommandLine(args);
        main.boot();
    }

    private void processCommandLine(String[] args) {
    }

    private void genericHelp() {
        System.out.println("usage: SMPP Simulator<command> [options]");
        System.out.println();
        System.out.println("command:");
        System.out.println("    core      Start the SS7 simulator core");
        System.out.println("    gui       Start the SS7 simulator gui");
        System.out.println();
        System.out.println("see 'run <command> help' for more information on a specific command:");
        System.out.println();
        System.exit(0);
    }

    private void coreHelp() {
        System.out.println("core: Starts the simulator core");
        System.out.println();
        System.out.println("usage: SMPP Simulator core [options]");
        System.out.println();
        System.out.println("options:");
        System.out.println("    -n, --name=<simulator name>\t\tSimulator name. If not passed default is main");
        System.out.println("    -t, --http=<http port>\t\t\tHttp port for core");
        System.out.println("    -r, --rmi=<rmi port>\t\t\tRMI port for core");
        System.out.println();
        System.exit(0);
    }

    private void guiHelp() {
        System.out.println("gui: Starts the simulator gui");
        System.out.println();
        System.out.println("usage: SMPP Simulator gui [options]");
        System.out.println();
        System.out.println("options:");
        System.out.println("    -n, --name=<simulator name>   Simulator name. If not passed default is main");
        System.out.println();
        System.exit(0);
    }

    private static boolean initLOG4JProperties(String homeDir) {
        String Log4jURL = homeDir + LOG4J_URL;
        try {
            URL log4jurl = Main.getURL(Log4jURL);
            InputStream inStreamLog4j = log4jurl.openStream();
            Properties propertiesLog4j = new Properties();
            try {
                propertiesLog4j.load(inStreamLog4j);
                PropertyConfigurator.configure((Properties)propertiesLog4j);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to initialize LOG4J with properties file.");
            return false;
        }
        return true;
    }

    private static boolean initLOG4JXml(String homeDir) {
        String Log4jURL = homeDir + LOG4J_URL_XML;
        try {
            URL log4jurl = Main.getURL(Log4jURL);
            DOMConfigurator.configure((URL)log4jurl);
        }
        catch (Exception e) {
            System.err.println("Failed to initialize LOG4J with xml file.");
            return false;
        }
        return true;
    }

    private static String getHomeDir(String[] args) {
        if (System.getenv(HOME_DIR) == null) {
            if (args.length > index) {
                return args[index++];
            }
            return ".";
        }
        return System.getenv(HOME_DIR);
    }

    protected void boot() throws Throwable {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SmppSimulatorForm window = new SmppSimulatorForm();
                    window.getJFrame().setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static URL getURL(String url) throws Exception {
        File file = new File(url);
        if (!file.exists()) {
            throw new IllegalArgumentException("No such file: " + url);
        }
        return file.toURI().toURL();
    }

    protected void registerShutdownThread() {
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownThread()));
    }

    private class ShutdownThread
    implements Runnable {
        private ShutdownThread() {
        }

        @Override
        public void run() {
            System.out.println("Shutting down");
        }
    }
}

