/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.management.console.impl;

import org.mobicents.ss7.management.console.CommandContext;
import org.mobicents.ss7.management.console.CommandHandlerWithHelp;
import org.mobicents.ss7.management.console.Tree;

public class SmppCommandHandler
extends CommandHandlerWithHelp {
    static final Tree commandTree = new Tree("smpp");

    public SmppCommandHandler() {
        super(commandTree, 1);
    }

    public void handle(CommandContext ctx, String commandLine) {
        if (commandLine.contains("--help")) {
            this.printHelp(commandLine, ctx);
            return;
        }
        ctx.sendMessage(commandLine);
    }

    public boolean isAvailable(CommandContext ctx) {
        if (!ctx.isControllerConnected()) {
            ctx.printLine("The command is not available in the current context. Please connnect first");
            return false;
        }
        return true;
    }

    static {
        Tree.Node parent = commandTree.getTopNode();
        Tree.Node esme = parent.addChild("esme");
        esme.addChild("create");
        esme.addChild("modify");
        esme.addChild("delete");
        esme.addChild("start");
        esme.addChild("stop");
        esme.addChild("show");
        Tree.Node smppServer = parent.addChild("smppserver");
        Tree.Node smppServerSet = smppServer.addChild("set");
        smppServerSet.addChild("port");
        smppServerSet.addChild("bindtimeout");
        smppServerSet.addChild("systemid");
        smppServerSet.addChild("autonegotiateversion");
        smppServerSet.addChild("interfaceversion");
        smppServerSet.addChild("maxconnectionsize");
        smppServerSet.addChild("defaultwindowsize");
        smppServerSet.addChild("defaultwindowwaittimeout");
        smppServerSet.addChild("defaultrequestexpirytimeout");
        smppServerSet.addChild("defaultwindowmonitorinterval");
        smppServerSet.addChild("defaultsessioncountersenabled");
        Tree.Node smppServerGet = smppServer.addChild("get");
        smppServerGet.addChild("port");
        smppServerGet.addChild("bindtimeout");
        smppServerGet.addChild("systemid");
        smppServerGet.addChild("autonegotiateversion");
        smppServerGet.addChild("interfaceversion");
        smppServerGet.addChild("maxconnectionsize");
        smppServerGet.addChild("defaultwindowsize");
        smppServerGet.addChild("defaultwindowwaittimeout");
        smppServerGet.addChild("defaultrequestexpirytimeout");
        smppServerGet.addChild("defaultwindowmonitorinterval");
        smppServerGet.addChild("defaultsessioncountersenabled");
    }
}

