/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load;

import com.cloudhopper.smpp.SmppServerConfiguration;
import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.SmppServerSession;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.SmppProcessingException;
import java.lang.ref.WeakReference;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.protocols.smpp.load.TestHarness;

public class Server
extends TestHarness {
    private static Logger logger = Logger.getLogger(Server.class);
    private int port = 2775;
    private int maxConnectionSize = 10;
    private boolean nonBlockingSocketsEnabled = true;
    private int defaultRequestExpiryTimeout = 30000;
    private int defaultWindowMonitorInterval = 15000;
    private int defaultWindowSize = 5;
    private long defaultWindowWaitTimeout = -1L;
    private boolean defaultSessionCountersEnabled = true;
    private boolean jmxEnabled = true;

    public static void main(String[] args) throws Exception {
        Server server = new Server();
        server.test(args);
    }

    private void test(String[] args) throws Exception {
        this.port = Integer.parseInt(args[0]);
        this.maxConnectionSize = Integer.parseInt(args[1]);
        this.nonBlockingSocketsEnabled = Boolean.parseBoolean(args[2]);
        this.defaultRequestExpiryTimeout = Integer.parseInt(args[3]);
        this.defaultWindowMonitorInterval = Integer.parseInt(args[4]);
        this.defaultWindowSize = Integer.parseInt(args[5]);
        this.defaultWindowWaitTimeout = Long.parseLong(args[6]);
        this.defaultSessionCountersEnabled = Boolean.parseBoolean(args[7]);
        this.jmxEnabled = Boolean.parseBoolean(args[8]);
        if (this.port < 1) {
            throw new Exception("port cannot be less than 1");
        }
        if (this.maxConnectionSize < 1) {
            throw new Exception("maxConnectionSize cannot be less than 1");
        }
        if (this.defaultRequestExpiryTimeout < 1) {
            throw new Exception("defaultRequestExpiryTimeout to send cannot be less than 1");
        }
        if (this.defaultWindowMonitorInterval < 1) {
            throw new Exception("defaultWindowMonitorInterval cannot be less than 1");
        }
        if (this.defaultWindowSize < 1) {
            throw new Exception("defaultWindowSize cannot be less than 1");
        }
        logger.info((Object)("port=" + this.port));
        logger.info((Object)("maxConnectionSize=" + this.maxConnectionSize));
        logger.info((Object)("nonBlockingSocketsEnabled=" + this.nonBlockingSocketsEnabled));
        logger.info((Object)("defaultRequestExpiryTimeout=" + this.defaultRequestExpiryTimeout));
        logger.info((Object)("defaultWindowMonitorInterval=" + this.defaultWindowMonitorInterval));
        logger.info((Object)("defaultWindowSize=" + this.defaultWindowSize));
        logger.info((Object)("defaultWindowWaitTimeout=" + this.defaultWindowWaitTimeout));
        logger.info((Object)("defaultSessionCountersEnabled=" + this.defaultSessionCountersEnabled));
        logger.info((Object)("jmxEnabled=" + this.jmxEnabled));
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        ScheduledThreadPoolExecutor monitorExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private AtomicInteger sequence = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("SmppServerSessionWindowMonitorPool-" + this.sequence.getAndIncrement());
                return t;
            }
        });
        SmppServerConfiguration configuration = new SmppServerConfiguration();
        configuration.setPort(this.port);
        configuration.setMaxConnectionSize(this.maxConnectionSize);
        configuration.setNonBlockingSocketsEnabled(this.nonBlockingSocketsEnabled);
        configuration.setDefaultRequestExpiryTimeout((long)this.defaultRequestExpiryTimeout);
        configuration.setDefaultWindowMonitorInterval((long)this.defaultWindowMonitorInterval);
        configuration.setDefaultWindowSize(this.defaultWindowSize);
        configuration.setDefaultWindowWaitTimeout(this.defaultWindowWaitTimeout);
        configuration.setDefaultSessionCountersEnabled(this.defaultSessionCountersEnabled);
        configuration.setJmxEnabled(this.jmxEnabled);
        DefaultSmppServer smppServer = new DefaultSmppServer(configuration, (SmppServerHandler)new DefaultSmppServerHandler(), (ExecutorService)executor, (ScheduledExecutorService)monitorExecutor);
        logger.info((Object)"Starting SMPP server...");
        smppServer.start();
        logger.info((Object)"SMPP server started");
        System.out.println("Press any key to stop server");
        System.in.read();
        logger.info((Object)"Stopping SMPP server...");
        smppServer.stop();
        logger.info((Object)"SMPP server stopped");
        logger.info((Object)("Server counters: " + smppServer.getCounters()));
    }

    public static class TestSmppSessionHandler
    extends DefaultSmppSessionHandler {
        private WeakReference<SmppSession> sessionRef;

        public TestSmppSessionHandler(SmppSession session) {
            this.sessionRef = new WeakReference<SmppSession>(session);
        }

        public PduResponse firePduRequestReceived(PduRequest pduRequest) {
            SmppSession session = (SmppSession)this.sessionRef.get();
            return pduRequest.createResponse();
        }
    }

    public static class DefaultSmppServerHandler
    implements SmppServerHandler {
        public void sessionBindRequested(Long sessionId, SmppSessionConfiguration sessionConfiguration, BaseBind bindRequest) throws SmppProcessingException {
            sessionConfiguration.setName("Application.SMPP." + sessionConfiguration.getSystemId());
        }

        public void sessionCreated(Long sessionId, SmppServerSession session, BaseBindResp preparedBindResponse) throws SmppProcessingException {
            logger.info((Object)("Session created: " + session));
            session.serverReady((SmppSessionHandler)new TestSmppSessionHandler((SmppSession)session));
        }

        public void sessionDestroyed(Long sessionId, SmppServerSession session) {
            logger.info((Object)("Session destroyed: " + session));
            if (session.hasCounters()) {
                logger.info((Object)(" final session rx-submitSM: " + session.getCounters().getRxSubmitSM()));
            }
            session.destroy();
        }
    }
}

