/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load;

import com.cloudhopper.smpp.SmppServerConfiguration;
import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.SmppServerSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppServer;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.PduResponse;
import com.cloudhopper.smpp.type.SmppProcessingException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.smpp.load.TestHarness;

public class SlowServer
extends TestHarness {
    private static Logger logger = Logger.getLogger(SlowServer.class);
    private static final long DELAY_BEFORE_RESPONSE = 3000L;
    private int port = 2775;
    private int maxConnectionSize = 10;
    private boolean nonBlockingSocketsEnabled = true;
    private int defaultRequestExpiryTimeout = 30000;
    private int defaultWindowMonitorInterval = 15000;
    private int defaultWindowSize = 5;
    private long defaultWindowWaitTimeout = -1L;
    private boolean defaultSessionCountersEnabled = true;
    private boolean jmxEnabled = true;

    public static void main(String[] args) throws Exception {
        SlowServer ss = new SlowServer();
        ss.test(args);
    }

    private void test(String[] args) throws Exception {
        this.port = Integer.parseInt(args[0]);
        this.maxConnectionSize = Integer.parseInt(args[1]);
        this.nonBlockingSocketsEnabled = Boolean.parseBoolean(args[2]);
        this.defaultRequestExpiryTimeout = Integer.parseInt(args[3]);
        this.defaultWindowMonitorInterval = Integer.parseInt(args[4]);
        this.defaultWindowSize = Integer.parseInt(args[5]);
        this.defaultWindowWaitTimeout = Long.parseLong(args[6]);
        this.defaultSessionCountersEnabled = Boolean.parseBoolean(args[7]);
        this.jmxEnabled = Boolean.parseBoolean(args[8]);
        if (this.port < 1) {
            throw new Exception("port cannot be less than 1");
        }
        if (this.maxConnectionSize < 1) {
            throw new Exception("maxConnectionSize cannot be less than 1");
        }
        if (this.defaultRequestExpiryTimeout < 1) {
            throw new Exception("defaultRequestExpiryTimeout to send cannot be less than 1");
        }
        if (this.defaultWindowMonitorInterval < 1) {
            throw new Exception("defaultWindowMonitorInterval cannot be less than 1");
        }
        if (this.defaultWindowSize < 1) {
            throw new Exception("defaultWindowSize cannot be less than 1");
        }
        logger.info((Object)("port=" + this.port));
        logger.info((Object)("maxConnectionSize=" + this.maxConnectionSize));
        logger.info((Object)("nonBlockingSocketsEnabled=" + this.nonBlockingSocketsEnabled));
        logger.info((Object)("defaultRequestExpiryTimeout=" + this.defaultRequestExpiryTimeout));
        logger.info((Object)("defaultWindowMonitorInterval=" + this.defaultWindowMonitorInterval));
        logger.info((Object)("defaultWindowSize=" + this.defaultWindowSize));
        logger.info((Object)("defaultWindowWaitTimeout=" + this.defaultWindowWaitTimeout));
        logger.info((Object)("defaultSessionCountersEnabled=" + this.defaultSessionCountersEnabled));
        logger.info((Object)("jmxEnabled=" + this.jmxEnabled));
        SmppServerConfiguration configuration = new SmppServerConfiguration();
        configuration.setPort(this.port);
        configuration.setMaxConnectionSize(this.maxConnectionSize);
        configuration.setNonBlockingSocketsEnabled(this.nonBlockingSocketsEnabled);
        configuration.setDefaultRequestExpiryTimeout((long)this.defaultRequestExpiryTimeout);
        configuration.setDefaultWindowMonitorInterval((long)this.defaultWindowMonitorInterval);
        configuration.setDefaultWindowSize(this.defaultWindowSize);
        configuration.setDefaultWindowWaitTimeout(this.defaultWindowWaitTimeout);
        configuration.setDefaultSessionCountersEnabled(this.defaultSessionCountersEnabled);
        configuration.setJmxEnabled(this.jmxEnabled);
        DefaultSmppServer smppServer = new DefaultSmppServer(configuration, (SmppServerHandler)new DefaultSmppServerHandler());
        logger.info((Object)"About to start SMPP slow server");
        smppServer.start();
        logger.info((Object)"SMPP slow server started");
        System.out.println("Press any key to stop server");
        System.in.read();
        logger.info((Object)"SMPP server stopping");
        smppServer.stop();
        logger.info((Object)"SMPP server stopped");
    }

    public static class SlowSmppSessionHandler
    extends DefaultSmppSessionHandler {
        public PduResponse firePduRequestReceived(PduRequest pduRequest) {
            try {
                Thread.sleep(3000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return pduRequest.createResponse();
        }
    }

    public static class DefaultSmppServerHandler
    implements SmppServerHandler {
        public void sessionBindRequested(Long sessionId, SmppSessionConfiguration sessionConfiguration, BaseBind bindRequest) throws SmppProcessingException {
            sessionConfiguration.setName("Application.SMPP." + sessionId);
        }

        public void sessionCreated(Long sessionId, SmppServerSession session, BaseBindResp preparedBindResponse) throws SmppProcessingException {
            logger.info((Object)("Session created: " + session));
            session.serverReady((SmppSessionHandler)new SlowSmppSessionHandler());
        }

        public void sessionDestroyed(Long sessionId, SmppServerSession session) {
            logger.info((Object)("Session destroyed: " + session));
        }
    }
}

