/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load;

import com.cloudhopper.commons.charset.Charset;
import com.cloudhopper.commons.charset.CharsetUtil;
import com.cloudhopper.commons.util.DecimalUtil;
import com.cloudhopper.smpp.PduAsyncResponse;
import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.impl.DefaultSmppClient;
import com.cloudhopper.smpp.impl.DefaultSmppSessionHandler;
import com.cloudhopper.smpp.pdu.PduRequest;
import com.cloudhopper.smpp.pdu.SubmitSm;
import com.cloudhopper.smpp.type.Address;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import org.mobicents.protocols.smpp.load.TestHarness;

public class Client
extends TestHarness {
    private static final Logger logger = Logger.getLogger(Client.class);
    private int sessionCount = 5;
    private int windowSize = 50000;
    private int submitToSend = 100000;
    private volatile AtomicInteger submitSent = new AtomicInteger(0);
    private int rateLimiter = 100;
    private long startDestNumber = 9960200000L;
    private int destNumberDiff = 10000;
    private long endDestNumber = this.startDestNumber + (long)this.destNumberDiff;
    private String sourceNumber = "6666";
    private String peerAddress = "127.0.0.1";
    private int peerPort = 2775;
    private String systemId = "test";
    private String password = "test";
    private static String message = "Hello world!";
    private RateLimiter rateLimiterObj = null;
    private static int esmClass = 3;
    private static AtomicInteger throttledMessageCount = new AtomicInteger(0);
    public static final AtomicInteger SUBMIT_SENT = new AtomicInteger(0);
    public static final AtomicInteger SUBMIT_RESP = new AtomicInteger(0);
    static long min_dest_number = 9960200000L;
    static int dest_number_diff = 100000;
    static long max_dest_number = min_dest_number + (long)dest_number_diff;

    public static void main(String[] args) throws Exception {
        Client client = new Client();
        client.test(args);
    }

    private void test(String[] args) throws Exception {
        this.sessionCount = Integer.parseInt(args[0]);
        this.windowSize = Integer.parseInt(args[1]);
        this.submitToSend = Integer.parseInt(args[2]);
        this.rateLimiter = Integer.parseInt(args[3]);
        this.startDestNumber = Long.parseLong(args[4]);
        this.destNumberDiff = Integer.parseInt(args[5]);
        this.sourceNumber = args[6];
        this.peerAddress = args[7];
        this.peerPort = Integer.parseInt(args[8]);
        this.systemId = args[9];
        this.password = args[10];
        message = args[11];
        esmClass = Integer.parseInt(args[12]);
        if (this.sessionCount < 1) {
            throw new Exception("Session count cannot be less than 1");
        }
        if (this.windowSize < 1) {
            throw new Exception("Windows size cannot be less than 1");
        }
        if (this.submitToSend < 1) {
            throw new Exception("Submit to send cannot be less than 1");
        }
        if (this.startDestNumber < 1L) {
            throw new Exception("Start Destination Number cannot be less than 1");
        }
        if (this.destNumberDiff < 1) {
            throw new Exception("Destination Number difference cannot be less than 1");
        }
        if (this.sourceNumber == null || this.sourceNumber == "") {
            throw new Exception("Source Number cannot be null");
        }
        if (this.peerAddress == null || this.peerAddress == "") {
            throw new Exception("Peer address cannot be null");
        }
        if (this.peerPort < 1) {
            throw new Exception("Peer port cannot be less than 1");
        }
        if (message == null) {
            throw new Exception("Message cannot be less than 1");
        }
        this.endDestNumber = this.startDestNumber + (long)this.destNumberDiff;
        logger.info((Object)("sessionCount=" + this.sessionCount));
        logger.info((Object)("windowSize=" + this.windowSize));
        logger.info((Object)("submitToSend=" + this.submitToSend));
        logger.info((Object)("startDestNumber=" + this.startDestNumber));
        logger.info((Object)("destNumberDiff=" + this.destNumberDiff));
        logger.info((Object)("endDestNumber=" + this.endDestNumber));
        logger.info((Object)("sourceNumber=" + this.sourceNumber));
        logger.info((Object)("peerAddress=" + this.peerAddress));
        logger.info((Object)("peerPort=" + this.peerPort));
        logger.info((Object)("systemId=" + this.systemId));
        logger.info((Object)("password=" + this.password));
        logger.info((Object)("message=" + message));
        logger.info((Object)("rateLimiter=" + this.rateLimiter + " sms/sec"));
        this.rateLimiterObj = RateLimiter.create((double)this.rateLimiter);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        ScheduledThreadPoolExecutor monitorExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private AtomicInteger sequence = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("SmppClientSessionWindowMonitorPool-" + this.sequence.getAndIncrement());
                return t;
            }
        });
        DefaultSmppClient clientBootstrap = new DefaultSmppClient(Executors.newCachedThreadPool(), this.sessionCount, (ScheduledExecutorService)monitorExecutor);
        SmppSessionConfiguration config = new SmppSessionConfiguration();
        config.setWindowSize(this.windowSize);
        config.setName("Tester.Session.0");
        config.setType(SmppBindType.TRANSCEIVER);
        config.setHost(this.peerAddress);
        config.setPort(this.peerPort);
        config.setConnectTimeout(10000L);
        config.setSystemId(this.systemId);
        config.setPassword(this.password);
        config.getLoggingOptions().setLogBytes(false);
        config.setRequestExpiryTimeout(30000L);
        config.setWindowMonitorInterval(15000L);
        config.setCountersEnabled(true);
        CountDownLatch allSessionsBoundSignal = new CountDownLatch(this.sessionCount);
        CountDownLatch startSendingSignal = new CountDownLatch(1);
        ThreadPoolExecutor taskExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        ClientSessionTask[] tasks = new ClientSessionTask[this.sessionCount];
        for (int i = 0; i < this.sessionCount; ++i) {
            tasks[i] = new ClientSessionTask(allSessionsBoundSignal, startSendingSignal, clientBootstrap, config, this.submitToSend, this.rateLimiterObj);
            taskExecutor.submit(tasks[i]);
        }
        logger.info((Object)"Waiting up to 7 seconds for all sessions to bind...");
        if (!allSessionsBoundSignal.await(7000L, TimeUnit.MILLISECONDS)) {
            throw new Exception("One or more sessions were unable to bind, cancelling test");
        }
        logger.info((Object)"Sending signal to start test...");
        long startTimeMillis = System.currentTimeMillis();
        startSendingSignal.countDown();
        taskExecutor.shutdown();
        taskExecutor.awaitTermination(3L, TimeUnit.DAYS);
        long stopTimeMillis = System.currentTimeMillis();
        int actualSubmitSent = 0;
        int sessionFailures = 0;
        for (int i = 0; i < this.sessionCount; ++i) {
            if (tasks[i].getCause() != null) {
                ++sessionFailures;
                logger.error((Object)("Task #" + i + " failed with exception: " + tasks[i].getCause()));
                continue;
            }
            actualSubmitSent += tasks[i].getSubmitRequestSent();
        }
        logger.info((Object)"Performance client finished:");
        logger.info((Object)("       Sessions: " + this.sessionCount));
        logger.info((Object)("    Window Size: " + this.windowSize));
        logger.info((Object)("Sessions Failed: " + sessionFailures));
        logger.info((Object)("           Time: " + (stopTimeMillis - startTimeMillis) + " ms"));
        logger.info((Object)("  Target Submit: " + this.submitToSend));
        logger.info((Object)("  Actual Submit: " + actualSubmitSent));
        logger.info((Object)("  Throttled Message count: " + throttledMessageCount));
        double throughput = (double)actualSubmitSent / ((double)(stopTimeMillis - startTimeMillis) / 1000.0);
        logger.info((Object)("     Throughput: " + DecimalUtil.toString((double)throughput, (int)3) + " per sec"));
        for (int i = 0; i < this.sessionCount; ++i) {
            if (tasks[i].session == null || !tasks[i].session.hasCounters()) continue;
            logger.info((Object)(" Session " + i + ": submitSM " + tasks[i].session.getCounters().getTxSubmitSM()));
        }
        logger.info((Object)"Shutting down client bootstrap and executors...");
        clientBootstrap.destroy();
        executor.shutdownNow();
        monitorExecutor.shutdownNow();
        logger.info((Object)"Done. Exiting");
    }

    public static class ClientSessionTask
    implements Runnable {
        private SmppSession session;
        private CountDownLatch allSessionsBoundSignal;
        private CountDownLatch startSendingSignal;
        private DefaultSmppClient clientBootstrap;
        private SmppSessionConfiguration config;
        private int submitRequestSent;
        private int submitResponseReceived;
        private AtomicBoolean sendingDone;
        private Exception cause;
        private Random r = new Random();
        private int submitToSend;
        private CountDownLatch allSubmitResponseReceivedSignal;
        private RateLimiter rateLimiterObj;

        public ClientSessionTask(CountDownLatch allSessionsBoundSignal, CountDownLatch startSendingSignal, DefaultSmppClient clientBootstrap, SmppSessionConfiguration config, int submitToSend, RateLimiter rateLimiterObj) {
            this.allSessionsBoundSignal = allSessionsBoundSignal;
            this.startSendingSignal = startSendingSignal;
            this.clientBootstrap = clientBootstrap;
            this.config = config;
            this.submitRequestSent = 0;
            this.submitResponseReceived = 0;
            this.sendingDone = new AtomicBoolean(false);
            this.submitToSend = submitToSend;
            this.rateLimiterObj = rateLimiterObj;
        }

        public Exception getCause() {
            return this.cause;
        }

        public int getSubmitRequestSent() {
            return this.submitRequestSent;
        }

        @Override
        public void run() {
            this.allSubmitResponseReceivedSignal = new CountDownLatch(1);
            ClientSmppSessionHandler sessionHandler = new ClientSmppSessionHandler();
            String text160 = message;
            byte[] textBytes = CharsetUtil.encode((CharSequence)text160, (Charset)CharsetUtil.CHARSET_GSM);
            try {
                this.session = this.clientBootstrap.bind(this.config, (SmppSessionHandler)sessionHandler);
                this.allSessionsBoundSignal.countDown();
                this.startSendingSignal.await();
                while (true) {
                    if (SUBMIT_SENT.get() >= this.submitToSend) {
                        if (this.allSubmitResponseReceivedSignal.await(100L, TimeUnit.MILLISECONDS)) break;
                        if (SUBMIT_SENT.getAndIncrement() >= this.submitToSend) continue;
                    }
                    this.rateLimiterObj.acquire();
                    SubmitSm submit = new SubmitSm();
                    submit.setSourceAddress(new Address(1, 1, "6666"));
                    long destination = (long)this.r.nextInt(dest_number_diff) + min_dest_number;
                    submit.setDestAddress(new Address(1, 1, Long.toString(destination)));
                    submit.setShortMessage(textBytes);
                    submit.setEsmClass((byte)esmClass);
                    ++this.submitRequestSent;
                    this.sendingDone.set(true);
                    this.session.sendRequestPdu((PduRequest)submit, 30000L, false);
                    SUBMIT_SENT.getAndIncrement();
                }
                logger.info((Object)("before waiting sendWindow.size: " + this.session.getSendWindow().getSize()));
                logger.info((Object)("Final Session rx-submitSM" + this.session.getCounters().getRxSubmitSM()));
                logger.info((Object)("Final Session tx-submitSM" + this.session.getCounters().getTxSubmitSM()));
                logger.info((Object)("after waiting sendWindow.size: " + this.session.getSendWindow().getSize()));
                this.session.unbind(5000L);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                this.cause = e;
            }
        }

        class ClientSmppSessionHandler
        extends DefaultSmppSessionHandler {
            public void fireChannelUnexpectedlyClosed() {
                logger.error((Object)"Unexpected close occurred...");
                ClientSessionTask.this.allSubmitResponseReceivedSignal.countDown();
            }

            public void fireExpectedPduResponseReceived(PduAsyncResponse pduAsyncResponse) {
                if (pduAsyncResponse.getResponse().getCommandStatus() == 88) {
                    SUBMIT_SENT.decrementAndGet();
                    throttledMessageCount.incrementAndGet();
                    ClientSessionTask.this.submitRequestSent--;
                } else {
                    ClientSessionTask.this.submitResponseReceived++;
                    SUBMIT_RESP.incrementAndGet();
                    if (SUBMIT_SENT.get() >= ClientSessionTask.this.submitToSend && ClientSessionTask.this.submitResponseReceived >= ClientSessionTask.this.submitRequestSent) {
                        ClientSessionTask.this.allSubmitResponseReceivedSignal.countDown();
                    }
                }
            }
        }
    }
}

