/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.smpp.load.smppp;

import org.mobicents.protocols.smpp.load.smppp.IncrementCounterAction;
import org.mobicents.protocols.smpp.load.smppp.IsExpectedMsg;
import org.mobicents.protocols.smpp.load.smppp.IsScenarioStep;
import org.mobicents.protocols.smpp.load.smppp.PauseAction;
import org.mobicents.protocols.smpp.load.smppp.ProcessStep;
import org.mobicents.protocols.smpp.load.smppp.ReceiveAction;
import org.mobicents.protocols.smpp.load.smppp.ScenarioContext;
import org.mobicents.protocols.smpp.load.smppp.ScenarioEvent;
import org.mobicents.protocols.smpp.load.smppp.ScenarioState;
import org.mobicents.protocols.smpp.load.smppp.SendAction;
import org.mobicents.protocols.smpp.load.smppp.StartRTDAction;
import org.mobicents.protocols.smpp.load.smppp.StopRTDAction;
import org.squirrelframework.foundation.fsm.Action;
import org.squirrelframework.foundation.fsm.Condition;
import org.squirrelframework.foundation.fsm.StateMachineBuilder;
import org.squirrelframework.foundation.fsm.StateMachineBuilderFactory;
import org.squirrelframework.foundation.fsm.impl.AbstractStateMachine;

public class ScenarioFSM
extends AbstractStateMachine<ScenarioFSM, ScenarioState, ScenarioEvent, ScenarioContext> {
    private static final Action PAUSE_ACTION = new PauseAction();
    private static final Action SEND_ACTION = new SendAction();
    private static final Action START_RTD_ACTION = new StartRTDAction();
    private static final Action STOP_RTD_ACTION = new StopRTDAction();
    private static final Action RECV_ACTION = new ReceiveAction();
    private static final Condition PAUSE_COND = new IsScenarioStep("pause");
    private static final Condition SEND_COND = new IsScenarioStep("send");
    private static final Condition RECV_COND = new IsScenarioStep("receive");
    private static final Condition IS_MSG_COND = new IsExpectedMsg();
    private static final Action COMPL_COUNTER = new IncrementCounterAction("CompletedScenario");
    private static final Action FAILED_COUNTER = new IncrementCounterAction("FailedScenario");
    private static final Action PROCESS_STEP = new ProcessStep();
    private static final StateMachineBuilder<ScenarioFSM, ScenarioState, ScenarioEvent, ScenarioContext> BUILDER = StateMachineBuilderFactory.create(ScenarioFSM.class, ScenarioState.class, ScenarioEvent.class, ScenarioContext.class);

    static ScenarioFSM createNewInstance(ScenarioContext ctx) {
        ScenarioFSM fsm = (ScenarioFSM)BUILDER.newStateMachine((Object)ScenarioState.PROCESSING_STEP);
        return fsm;
    }

    protected void afterTransitionCausedException(ScenarioState fromState, ScenarioState toState, ScenarioEvent event, ScenarioContext context) {
        context.globalContext.incrementCounter("FailedScenario");
        super.afterTransitionCausedException((Object)fromState, (Object)toState, (Object)event, (Object)context);
    }

    static {
        BUILDER.onEntry((Object)ScenarioState.PROCESSING_STEP).perform(PROCESS_STEP);
        BUILDER.externalTransition().from((Object)ScenarioState.PROCESSING_STEP).to((Object)ScenarioState.FINISHED).on((Object)ScenarioEvent.SCENARIO_COMPLETED).perform(COMPL_COUNTER);
        BUILDER.externalTransition().from((Object)ScenarioState.CREATING_DIALOG).to((Object)ScenarioState.PROCESSING_STEP).on((Object)ScenarioEvent.DIALOG_CREATED);
        BUILDER.externalTransition().from((Object)ScenarioState.PROCESSING_STEP).to((Object)ScenarioState.PAUSED).on((Object)ScenarioEvent.SCENARIO_STEP).when(PAUSE_COND).perform(PAUSE_ACTION);
        BUILDER.onEntry((Object)ScenarioState.PAUSED).perform(STOP_RTD_ACTION);
        BUILDER.externalTransition().from((Object)ScenarioState.PAUSED).to((Object)ScenarioState.PROCESSING_STEP).on((Object)ScenarioEvent.PAUSE_FINISHED).perform(START_RTD_ACTION);
        BUILDER.externalTransition().from((Object)ScenarioState.PROCESSING_STEP).to((Object)ScenarioState.SENDING).on((Object)ScenarioEvent.SCENARIO_STEP).when(SEND_COND).perform(SEND_ACTION);
        BUILDER.onEntry((Object)ScenarioState.SENDING).perform(STOP_RTD_ACTION);
        BUILDER.externalTransition().from((Object)ScenarioState.SENDING).to((Object)ScenarioState.PROCESSING_STEP).on((Object)ScenarioEvent.MSG_SENT).perform(START_RTD_ACTION);
        BUILDER.externalTransition().from((Object)ScenarioState.PROCESSING_STEP).to((Object)ScenarioState.RECEIVING).on((Object)ScenarioEvent.SCENARIO_STEP).when(RECV_COND).perform(RECV_ACTION);
        BUILDER.onEntry((Object)ScenarioState.RECEIVING).perform(STOP_RTD_ACTION);
        BUILDER.externalTransition().from((Object)ScenarioState.RECEIVING).to((Object)ScenarioState.PROCESSING_STEP).on((Object)ScenarioEvent.MSG_RECEIVED).when(IS_MSG_COND).perform(START_RTD_ACTION);
        BUILDER.externalTransition().from((Object)ScenarioState.RECEIVING).to((Object)ScenarioState.FINISHED).on((Object)ScenarioEvent.RECV_TIMEOUT).perform(FAILED_COUNTER);
    }
}

